/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.system.controller;

import com.ruoyi.common.core.utils.poi.ExcelUtil;
import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.redis.service.RedisService;
import com.ruoyi.common.security.annotation.InnerAuth;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.system.api.domain.SysLogininfor;
import com.ruoyi.system.service.ISysLogininforService;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/logininfor"})
public class SysLogininforController
extends BaseController {
    @Autowired
    private ISysLogininforService logininforService;
    @Autowired
    private RedisService redisService;

    @RequiresPermissions(value={"system:logininfor:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysLogininfor logininfor) {
        this.startPage();
        List list = this.logininforService.selectLogininforList(logininfor);
        return this.getDataTable(list);
    }

    @Log(title="\u767b\u5f55\u65e5\u5fd7", businessType=BusinessType.EXPORT)
    @RequiresPermissions(value={"system:logininfor:export"})
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysLogininfor logininfor) {
        List list = this.logininforService.selectLogininforList(logininfor);
        ExcelUtil util = new ExcelUtil(SysLogininfor.class);
        util.exportExcel(response, list, "\u767b\u5f55\u65e5\u5fd7");
    }

    @RequiresPermissions(value={"system:logininfor:remove"})
    @Log(title="\u767b\u5f55\u65e5\u5fd7", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{infoIds}"})
    public AjaxResult remove(@PathVariable Long[] infoIds) {
        return this.toAjax(this.logininforService.deleteLogininforByIds(infoIds));
    }

    @RequiresPermissions(value={"system:logininfor:remove"})
    @Log(title="\u767b\u5f55\u65e5\u5fd7", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/clean"})
    public AjaxResult clean() {
        this.logininforService.cleanLogininfor();
        return this.success();
    }

    @RequiresPermissions(value={"system:logininfor:unlock"})
    @Log(title="\u8d26\u6237\u89e3\u9501", businessType=BusinessType.OTHER)
    @GetMapping(value={"/unlock/{userName}"})
    public AjaxResult unlock(@PathVariable(value="userName") String userName) {
        this.redisService.deleteObject("pwd_err_cnt:" + userName);
        return this.success();
    }

    @InnerAuth
    @PostMapping
    public AjaxResult add(@RequestBody SysLogininfor logininfor) {
        return this.toAjax(this.logininforService.insertLogininfor(logininfor));
    }
}

