/*
 * Decompiled with CFR 0.152.
 */
package com.windforce.framework.agent;

import com.windforce.framework.agent.InstrumentationUtil;
import com.windforce.framework.base.file.watch.BatchStrategy;
import com.windforce.framework.base.file.watch.FileMonitorListener;
import com.windforce.framework.base.file.watch.FileMonitorListeners;
import com.windforce.framework.base.file.watch.GlobalFileMonitor;
import java.io.File;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.objectweb.asm.ClassReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptHotLoadWatch {
    private static final Logger log = LoggerFactory.getLogger(ScriptHotLoadWatch.class);
    private final Instrumentation instrumentation;
    private static Consumer<Class<?>> reloadClassListener;

    private ScriptHotLoadWatch(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    public static void listenReloadClass(Consumer<Class<?>> listener) {
        reloadClassListener = reloadClassListener == null ? listener : reloadClassListener.andThen(listener);
    }

    public static void start(String libPathName, String scriptPath) throws Exception {
        if (!InstrumentationUtil.isInit()) {
            InstrumentationUtil.init(libPathName);
        }
        Instrumentation instrumentation = InstrumentationUtil.getInstrumentation();
        ScriptHotLoadWatch watch = new ScriptHotLoadWatch(instrumentation);
        watch.startWatch(scriptPath);
    }

    private void startWatch(String scriptPath) throws IllegalArgumentException {
        File dir = new File(scriptPath);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalArgumentException("[HotLoad] \u70ed\u66f4\u65b0\u6ca1\u6709\u627e\u5230\u6587\u4ef6\u5939\uff01" + dir.getAbsolutePath());
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("[HotLoad] \u4f20\u5165\u7684\u70ed\u66f4\u65b0\u76ee\u5f55\u4e0d\u662f\u4e00\u4e2a\u6587\u4ef6\u5939\uff01" + dir.getAbsolutePath());
        }
        GlobalFileMonitor.addWatch((File)dir, dirBuilder -> dirBuilder.fileOnly(true).watchCreate().watchModify().onAnyEvent((FileMonitorListener)FileMonitorListeners.batchMergedFile((String)"HotSwapFileListener", (BatchStrategy)BatchStrategy.afterNoEvent((int)3000), this::redefineClasses)));
        log.info("\u5f00\u59cb\u76d1\u542c\u70ed\u52a0\u8f7d\u76ee\u5f55\uff1a{}", (Object)dir.getAbsolutePath());
    }

    private void redefineClasses(Collection<File> files) {
        try {
            String className;
            HashMap<String, byte[]> classContentMap = new HashMap<String, byte[]>();
            for (File file : files) {
                if (!file.getName().endsWith(".class")) continue;
                byte[] bytes = Files.readAllBytes(file.toPath());
                ClassReader classReader = new ClassReader(bytes);
                className = classReader.getClassName().replace('/', '.');
                classContentMap.put(className, bytes);
            }
            ClassDefinition[] classDefinitions = new ClassDefinition[classContentMap.size()];
            int i = 0;
            for (Map.Entry entry : classContentMap.entrySet()) {
                className = (String)entry.getKey();
                byte[] bytes = (byte[])entry.getValue();
                classDefinitions[i++] = this.newClassDefinition(className, bytes);
            }
            this.instrumentation.redefineClasses(classDefinitions);
            for (ClassDefinition classDefinition : classDefinitions) {
                log.info("\u70ed\u66f4\u6210\u529f: %{}.class", (Object)classDefinition.getDefinitionClass().getName());
            }
            log.info("\u70ed\u66f4class\u5b8c\u6210!");
            if (reloadClassListener != null) {
                for (ClassDefinition classDefinition : classDefinitions) {
                    reloadClassListener.accept(classDefinition.getDefinitionClass());
                }
            }
        }
        catch (Throwable exception) {
            log.error("\u70ed\u66f4class\u5931\u8d25!", exception);
        }
    }

    private ClassDefinition newClassDefinition(String className, byte[] bytes) throws Exception {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            clazz = this.defineNewClass(className, bytes);
        }
        return new ClassDefinition(clazz, bytes);
    }

    private Class<?> defineNewClass(String name, byte[] bytes) throws Exception {
        ClassLoader appClassLoader = Thread.currentThread().getContextClassLoader();
        log.info("\u5f00\u59cb\u65b0\u589e\u7c7b: {}", (Object)name);
        log.info("\u4f7f\u7528\u7c7b\u52a0\u8f7d\u5668: {}", (Object)appClassLoader);
        try {
            Method defineClassMethod = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
            defineClassMethod.setAccessible(true);
            defineClassMethod.invoke((Object)appClassLoader, name, bytes, 0, bytes.length);
            Class<?> clazz = Class.forName(name);
            log.info("\u5b8c\u6210\u65b0\u589e\u7c7b: {}", (Object)name);
            return clazz;
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u7c7b\u5931\u8d25: {}", (Object)name);
            throw e;
        }
    }
}

