/*
 * Decompiled with CFR 0.152.
 */
package com.windforce.framework.agent;

import com.sun.tools.attach.VirtualMachine;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentationUtil {
    private static final Logger log = LoggerFactory.getLogger(InstrumentationUtil.class);
    private static final Pattern AGENT_JAR_NAME_PATTERN = Pattern.compile("^windforce-agent-[0-9.]*(-SNAPSHOT)?.jar$");
    private static String agentJarPath;
    private static Instrumentation instrumentation;

    public static void init(String libPathName) throws Exception {
        Validate.isTrue((agentJarPath == null ? 1 : 0) != 0, (String)"repeated call InstrumentationUtil#init", (Object[])new Object[0]);
        Path libPath = Paths.get(libPathName, new String[0]);
        Optional<Path> jarPath = InstrumentationUtil.getJarPath(libPath);
        if (!jarPath.isPresent()) {
            URL resource = InstrumentationUtil.class.getResource("");
            log.info("[agent] \u5728libPath[{}]\u4e0b\u65e0\u6cd5\u627e\u5230[{}]\uff0c\u5f00\u59cb\u5bfb\u627e\u5907\u7528\u8def\u5f84[{}]", new Object[]{libPath.toAbsolutePath(), AGENT_JAR_NAME_PATTERN, resource});
            assert (resource != null);
            if ("jar".equals(resource.toURI().getScheme())) {
                FileSystem fileSystem = FileSystems.newFileSystem(resource.toURI(), new HashMap());
                Optional<Path> path = InstrumentationUtil.getJarPath(Paths.get(resource.toURI()));
                if (path.isPresent()) {
                    Path fileInJarPath = path.get();
                    Path tempPath = Paths.get(libPathName, "temp", fileInJarPath.getFileName().toString()).toAbsolutePath();
                    log.info("[agent] \u5907\u7528\u8def\u5f84\u4e0b  agentJar \u5728Jar\u5305\u91cc\u9762, \u5c1d\u8bd5\u89e3\u538b\u5230\u4e34\u65f6\u76ee\u5f55 {}", (Object)tempPath);
                    Files.deleteIfExists(tempPath);
                    Files.createDirectories(tempPath.getParent(), new FileAttribute[0]);
                    Files.copy(fileInJarPath, tempPath, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                    Files.write(tempPath, Files.readAllBytes(fileInJarPath), new OpenOption[0]);
                    jarPath = Optional.of(tempPath);
                } else {
                    log.warn("[agent] \u5907\u7528\u8def\u5f84\u4e0b [{}] \u6ca1\u6709\u627e\u5230agentJar", (Object)resource);
                }
            } else {
                jarPath = InstrumentationUtil.getJarPath(Paths.get(resource.toURI()));
            }
        }
        if (!jarPath.isPresent()) {
            throw new NullPointerException(String.format("[agent] \u65e0\u6cd5\u5728libPath[%s]\u4e0b\u627e\u5230[%s]%n", libPath.toAbsolutePath(), AGENT_JAR_NAME_PATTERN));
        }
        Path agentJar = jarPath.get();
        agentJarPath = agentJar.toAbsolutePath().toString();
    }

    private static Optional<Path> getJarPath(Path libPath) throws IOException {
        Optional<Path> any;
        if (!Files.exists(libPath, new LinkOption[0])) {
            return Optional.empty();
        }
        try (Stream<Path> pathStream = Files.find(libPath, 1, (path, basicFileAttributes) -> {
            String fileName = path.getFileName().toString();
            return AGENT_JAR_NAME_PATTERN.matcher(fileName).find();
        }, new FileVisitOption[0]);){
            any = pathStream.findAny();
        }
        return any;
    }

    public static synchronized Instrumentation getInstrumentation() throws Exception {
        if (instrumentation == null) {
            VirtualMachine vm = null;
            try {
                String pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
                vm = VirtualMachine.attach(pid);
                vm.loadAgent(agentJarPath, null);
                instrumentation = InstrumentationUtil.doGetInstrumentation();
                Validate.notNull((Object)instrumentation, (String)"doGetInstrumentation \u672a\u83b7\u53d6\u5230 instrumentation", (Object[])new Object[0]);
            }
            finally {
                if (vm != null) {
                    try {
                        vm.detach();
                    }
                    catch (IOException e) {
                        log.error("", (Throwable)e);
                    }
                }
            }
        }
        return instrumentation;
    }

    private static Instrumentation doGetInstrumentation() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Class<?> agentClazz = Class.forName("com.windforce.framework.agent.MyAgent");
        Field instField = agentClazz.getDeclaredField("inst");
        return (Instrumentation)instField.get(null);
    }

    public static boolean isInit() {
        return agentJarPath != null;
    }
}

