/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.server.service.impl.server;

import com.ruoyi.server.domain.RearServerMiddle;
import com.ruoyi.server.domain.po.server.ServerDisposeSqlPO;
import com.ruoyi.server.domain.po.server.ServerRunStatePO;
import com.ruoyi.server.domain.po.server.ServerStateSetUpSqlPO;
import com.ruoyi.server.domain.vo.server.ServerDetailsVO;
import com.ruoyi.server.domain.vo.server.ServerRunStateVO;
import com.ruoyi.server.domain.vo.server.ServerStateSetUpVO;
import com.ruoyi.server.enums.ServerRunStateEnums;
import com.ruoyi.server.mapper.server.ServerMapper;
import com.ruoyi.server.service.server.IServerService;
import com.ruoyi.server.utils.IPUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ServerServiceImpl
implements IServerService {
    @Autowired
    private ServerMapper serverMapper;
    private static final Logger log = LoggerFactory.getLogger(ServerServiceImpl.class);

    @Transactional(rollbackFor={Exception.class})
    public int renewServerRunState(ServerRunStatePO serverRunStatePO, HttpServletRequest request) {
        String ipAddress = IPUtils.getIpAddr((HttpServletRequest)request);
        ServerStateSetUpVO serverStateSetUpVO = this.serverMapper.queryServerStateSetUp();
        if (serverStateSetUpVO == null) {
            log.info("\u65e0\u670d\u52a1\u5668\u72b6\u6001\u914d\u7f6e,\u670d\u52a1\u5668:{},\u65e0\u9700\u66f4\u65b0", (Object)serverRunStatePO.getServerId());
            return 1;
        }
        Integer serverRunState = ServerRunStateEnums.FLUENCY.getValue();
        if (serverRunStatePO.getNumberOfPeople() > serverStateSetUpVO.getBurstBig()) {
            serverRunState = ServerRunStateEnums.OVERCROWDING.getValue();
        } else if (serverRunStatePO.getNumberOfPeople() >= serverStateSetUpVO.getBurstSmall() && serverRunStatePO.getNumberOfPeople() <= serverStateSetUpVO.getBurstBig()) {
            serverRunState = ServerRunStateEnums.OVERCROWDING.getValue();
        } else if (serverRunStatePO.getNumberOfPeople() >= serverStateSetUpVO.getNormalSmall() && serverRunStatePO.getNumberOfPeople() <= serverStateSetUpVO.getNormalBig()) {
            serverRunState = ServerRunStateEnums.FLUENCY.getValue();
        }
        int state = 0;
        ServerRunStateVO serverRunStateVO = this.serverMapper.queryServerState(serverRunStatePO.getServerId());
        ServerStateSetUpSqlPO serverStateSetUpSqlPO = new ServerStateSetUpSqlPO();
        serverStateSetUpSqlPO.setServerId(serverRunStatePO.getServerId());
        serverStateSetUpSqlPO.setServerRunState(serverRunState);
        if (serverRunStateVO == null) {
            serverStateSetUpSqlPO.setCreateBy(ipAddress);
            serverStateSetUpSqlPO.setCreateTime(new Date());
            state = this.serverMapper.insertRearServerState(serverStateSetUpSqlPO);
        } else {
            serverStateSetUpSqlPO.setUpdateBy(ipAddress);
            serverStateSetUpSqlPO.setUpdateTime(new Date());
            state = this.serverMapper.updateRearServerState(serverStateSetUpSqlPO);
        }
        return state;
    }

    public List<String> serverIdExistList(List<String> serverIdList) {
        return this.serverMapper.serverIdExistList(serverIdList);
    }

    public int insertBatchServerDispose(List<ServerDisposeSqlPO> serverDisposeSqlPOList) {
        return this.serverMapper.insertBatchServerDispose(serverDisposeSqlPOList);
    }

    public List<String> disposeServerIdExistList(List<String> serverIdList) {
        return this.serverMapper.disposeServerIdExistList(serverIdList);
    }

    public List<String> testingRegionalServers() {
        return this.serverMapper.testingRegionalServers("99");
    }

    public Map<String, String> serverFormalList() {
        HashMap<String, String> tableMap = new HashMap<String, String>();
        List serverDetailsVOList = this.serverMapper.serverFormalList();
        for (ServerDetailsVO serverDetailsVO : serverDetailsVOList) {
            tableMap.put(serverDetailsVO.getServerId(), serverDetailsVO.getServerName());
        }
        return tableMap;
    }

    public List<RearServerMiddle> serverPidGid(String serverId) {
        return this.serverMapper.serverPidGid(serverId);
    }

    public Map<String, String> upToDateVersion() {
        String version = this.serverMapper.queryUpToDateVersion();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("version", version);
        return map;
    }
}

