/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.server.service.impl.player;

import com.alibaba.fastjson.JSON;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.server.domain.GameUserContent;
import com.ruoyi.server.domain.GameUserDuration;
import com.ruoyi.server.domain.GameUserExtend;
import com.ruoyi.server.domain.GameUserFootprint;
import com.ruoyi.server.domain.GameUserFootprintHistory;
import com.ruoyi.server.domain.po.player.GameUserFootprintAddPO;
import com.ruoyi.server.domain.po.player.GameUserFootprintQueryPO;
import com.ruoyi.server.domain.po.player.IpAnalysisPO;
import com.ruoyi.server.domain.po.player.UserExtendUpdateDataPO;
import com.ruoyi.server.domain.po.player.UserExtendUpdatePO;
import com.ruoyi.server.domain.vo.player.GameUserFootprintVO;
import com.ruoyi.server.domain.vo.player.IpAnalysisVO;
import com.ruoyi.server.enums.UserDurationMarkEnums;
import com.ruoyi.server.mapper.player.GameUserDurationMapper;
import com.ruoyi.server.mapper.player.GameUserFootprintMapper;
import com.ruoyi.server.service.impl.player.GameUserCorrelationServiceImpl;
import com.ruoyi.server.service.impl.player.GameUserExtendServiceImpl;
import com.ruoyi.server.service.impl.server.ServerServiceImpl;
import com.ruoyi.server.service.player.IGameUserFootprintService;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.lionsoul.ip2region.xdb.Searcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GameUserFootprintServiceImpl
implements IGameUserFootprintService {
    @Autowired
    private GameUserFootprintMapper gameUserFootprintMapper;
    @Autowired
    private GameUserCorrelationServiceImpl gameUserCorrelationServiceImpl;
    @Autowired
    private ServerServiceImpl serverServiceImpl;
    @Autowired
    private GameUserDurationMapper gameUserDurationMapper;
    @Autowired
    private GameUserExtendServiceImpl gameUserExtendServiceImpl;
    private static final Logger log = LoggerFactory.getLogger(GameUserFootprintServiceImpl.class);
    private static ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 12, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(1000), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());

    public int insertGameUserFootprint(GameUserFootprintAddPO gameUserFootprintAddPO) {
        log.info("\u7528\u6237\u65b0\u589e\u8db3\u8ff9: serverId={},userAccount={},userRoleId={}", new Object[]{gameUserFootprintAddPO.getServerId(), gameUserFootprintAddPO.getUserAccount(), gameUserFootprintAddPO.getUserRoleId()});
        this.userLogOn(gameUserFootprintAddPO);
        GameUserContent gameUserContent = new GameUserContent();
        BeanUtils.copyProperties((Object)gameUserFootprintAddPO, (Object)gameUserContent);
        this.gameUserCorrelationServiceImpl.userContentHandle(gameUserContent);
        List serverIdList = this.serverServiceImpl.testingRegionalServers();
        if (serverIdList.contains(gameUserFootprintAddPO.getServerId())) {
            log.info("\u6b64\u5927\u533a\u4e3a\u6d4b\u8bd5\u5927\u533a,\u6240\u4ee5\u8be5\u7528\u6237\u4e0d\u8bb0\u5f55\u8db3\u8ff9: serverId={},userAccount={},userRoleId={}", new Object[]{gameUserFootprintAddPO.getServerId(), gameUserFootprintAddPO.getUserAccount(), gameUserFootprintAddPO.getUserRoleId()});
            return 1;
        }
        this.clearUserFootprint(gameUserFootprintAddPO);
        GameUserFootprint gameUserFootprint = new GameUserFootprint();
        gameUserFootprint.setServerId(gameUserFootprintAddPO.getServerId());
        gameUserFootprint.setUserAccount(gameUserFootprintAddPO.getUserAccount());
        gameUserFootprint.setUserRoleId(gameUserFootprintAddPO.getUserRoleId());
        gameUserFootprint.setFootprintJson(gameUserFootprintAddPO.getFootprintJson());
        gameUserFootprint.setCreateTime(DateUtils.getNowDate());
        gameUserFootprint.setUserRoleName(gameUserFootprintAddPO.getUserRoleName());
        this.gameUserFootprintMapper.insertGameUserFootprint(gameUserFootprint);
        GameUserFootprintHistory gameUserFootprintHistory = new GameUserFootprintHistory();
        BeanUtils.copyProperties((Object)gameUserFootprint, (Object)gameUserFootprintHistory);
        gameUserFootprintHistory.setId(null);
        this.gameUserFootprintMapper.insertGameUserFootprintHistory(gameUserFootprintHistory);
        this.userExtendHandle(gameUserFootprintAddPO, Boolean.valueOf(true));
        return 1;
    }

    public GameUserFootprintVO queryGameUserFootprint(GameUserFootprintQueryPO gameUserFootprintQueryPO) {
        GameUserFootprintVO gameUserFootprintVO = new GameUserFootprintVO();
        GameUserFootprint gameUserFootprint = this.gameUserFootprintMapper.queryGameUserFootprint(gameUserFootprintQueryPO);
        gameUserFootprintVO.setServerId(gameUserFootprintQueryPO.getServerId());
        gameUserFootprintVO.setUserAccount(gameUserFootprintQueryPO.getUserAccount());
        if (gameUserFootprint != null) {
            gameUserFootprintVO.setFootprintJson(gameUserFootprint.getFootprintJson());
        }
        return gameUserFootprintVO;
    }

    public Future<Integer> clearUserFootprint(GameUserFootprintAddPO gameUserFootprintAddPO) {
        return executorService.submit(() -> {
            Integer state = 0;
            try {
                List gameUserFootprintList = this.gameUserFootprintMapper.queryGameUserFootprintList(gameUserFootprintAddPO);
                if (gameUserFootprintList == null || gameUserFootprintList.size() < 4) {
                    return 1;
                }
                ArrayList<Long> idList = new ArrayList<Long>();
                for (int i = 0; i < gameUserFootprintList.size(); ++i) {
                    if (i <= 2) continue;
                    idList.add(((GameUserFootprint)gameUserFootprintList.get(i)).getId());
                }
                state = this.gameUserFootprintMapper.idListDelete(idList);
            }
            catch (Exception e) {
                log.error("\u7528\u6237\u8db3\u8ff9\u5220\u9664\u5386\u53f2\u8db3\u8ff9\u5931\u8d25: \u5165\u53c2={}", (Object)gameUserFootprintAddPO);
                throw new ServiceException("\u7528\u6237\u8db3\u8ff9\u5f02\u5e38\u7ebf\u7a0b\u6c60: \u5220\u9664\u5386\u53f2\u8db3\u8ff9\u5f02\u5e38");
            }
            return state;
        });
    }

    public Boolean userLogOn(GameUserFootprintAddPO gameUserFootprintAddPO) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DateTimeFormatter formatterSpecific = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        try {
            GameUserDuration gameUserDuration = this.gameUserDurationMapper.queryUserDuration(gameUserFootprintAddPO.getUserRoleId());
            if (gameUserDuration == null || gameUserDuration.getLogOnTime() != null && gameUserDuration.getExitTime() != null) {
                GameUserDuration gameUserDurationAdd = new GameUserDuration();
                BeanUtils.copyProperties((Object)gameUserFootprintAddPO, (Object)gameUserDurationAdd);
                gameUserDurationAdd.setDurationTime(sdf.format(new Date()));
                gameUserDurationAdd.setLogOnTime(new Date());
                gameUserDurationAdd.setOperateMark(UserDurationMarkEnums.NORMAL.getValue());
                gameUserDurationAdd.setCreateTime(new Date());
                this.gameUserDurationMapper.insertUserDuration(gameUserDurationAdd);
            } else if (gameUserDuration.getLogOnTime() != null && gameUserDuration.getExitTime() == null) {
                if (sdf.format(gameUserDuration.getLogOnTime()).equals(sdf.format(new Date()))) {
                    LocalDateTime currentTime = LocalDateTime.now();
                    LocalDateTime previousTime = currentTime.minusSeconds(1L);
                    GameUserDuration gameUserDurationUpdate = new GameUserDuration();
                    BeanUtils.copyProperties((Object)gameUserDuration, (Object)gameUserDurationUpdate);
                    gameUserDurationUpdate.setExitTime(Date.from(previousTime.atZone(ZoneId.systemDefault()).toInstant()));
                    gameUserDurationUpdate.setOperateMark(UserDurationMarkEnums.SYSTEM_REPAIR_EXIT_TIME.getValue());
                    gameUserDurationUpdate.setUpdateTime(new Date());
                    this.gameUserDurationMapper.updateUserDuration(gameUserDurationUpdate);
                    GameUserDuration gameUserDurationAdd = new GameUserDuration();
                    BeanUtils.copyProperties((Object)gameUserFootprintAddPO, (Object)gameUserDurationAdd);
                    gameUserDurationAdd.setDurationTime(sdf.format(new Date()));
                    gameUserDurationAdd.setLogOnTime(new Date());
                    gameUserDurationAdd.setOperateMark(UserDurationMarkEnums.NORMAL.getValue());
                    gameUserDurationAdd.setCreateTime(new Date());
                    this.gameUserDurationMapper.insertUserDuration(gameUserDurationAdd);
                    return true;
                }
                LocalDateTime currentTime = LocalDateTime.now();
                LocalDate startDate = LocalDate.parse(sdfTime.format(gameUserDuration.getLogOnTime()), formatter);
                LocalDate endDate = currentTime.toLocalDate();
                ArrayList<String> timeSlotList = new ArrayList<String>();
                while (startDate.isBefore(endDate) || startDate.isEqual(endDate)) {
                    String add = startDate.format(formatterSpecific);
                    timeSlotList.add(add);
                    startDate = startDate.plusDays(1L);
                }
                ArrayList<GameUserDuration> gameUserDurationList = new ArrayList<GameUserDuration>();
                for (int i = 0; i < timeSlotList.size(); ++i) {
                    GameUserDuration gameUserDurationAdd = new GameUserDuration();
                    BeanUtils.copyProperties((Object)gameUserDuration, (Object)gameUserDurationAdd);
                    gameUserDurationAdd.setDurationTime((String)timeSlotList.get(i));
                    gameUserDurationAdd.setCreateTime(new Date());
                    if (sdf.format(gameUserDuration.getLogOnTime()).equals(timeSlotList.get(i))) {
                        GameUserDuration gameUserDurationUpdate = new GameUserDuration();
                        BeanUtils.copyProperties((Object)gameUserDuration, (Object)gameUserDurationUpdate);
                        gameUserDurationUpdate.setExitTime(sdfTime.parse((String)timeSlotList.get(i) + " 23:59:59"));
                        gameUserDurationUpdate.setOperateMark(UserDurationMarkEnums.SYSTEM_REPAIR_EXIT_TIME.getValue());
                        this.gameUserDurationMapper.updateUserDuration(gameUserDurationUpdate);
                        continue;
                    }
                    if (sdf.format(new Date()).equals(timeSlotList.get(i))) {
                        gameUserDurationAdd.setLogOnTime(new Date());
                        gameUserDurationAdd.setExitTime(null);
                        gameUserDurationAdd.setOperateMark(UserDurationMarkEnums.NORMAL.getValue());
                    } else {
                        gameUserDurationAdd.setLogOnTime(sdfTime.parse((String)timeSlotList.get(i) + " 00:00:00"));
                        gameUserDurationAdd.setExitTime(sdfTime.parse((String)timeSlotList.get(i) + " 23:59:59"));
                        gameUserDurationAdd.setOperateMark(UserDurationMarkEnums.SYSTEM_REPAIR_LOG_ON_AND_EXIT_TIME.getValue());
                    }
                    gameUserDurationList.add(gameUserDurationAdd);
                }
                if (gameUserDurationList != null && gameUserDurationList.size() > 0) {
                    this.gameUserDurationMapper.insertBatchUserDuration(gameUserDurationList);
                }
            } else if (gameUserDuration.getLogOnTime() == null && gameUserDuration.getExitTime() != null) {
                GameUserDuration gameUserDurationUpdate = new GameUserDuration();
                BeanUtils.copyProperties((Object)gameUserDuration, (Object)gameUserDurationUpdate);
                gameUserDurationUpdate.setLogOnTime(sdfTime.parse(gameUserDuration.getDurationTime() + " 00:00:00"));
                gameUserDurationUpdate.setOperateMark(UserDurationMarkEnums.SYSTEM_REPAIR_LOG_ON_TIME.getValue());
                gameUserDurationUpdate.setUpdateTime(new Date());
                this.gameUserDurationMapper.updateUserDuration(gameUserDurationUpdate);
                GameUserDuration gameUserDurationAdd = new GameUserDuration();
                BeanUtils.copyProperties((Object)gameUserFootprintAddPO, (Object)gameUserDurationAdd);
                gameUserDurationAdd.setDurationTime(sdf.format(new Date()));
                gameUserDurationAdd.setLogOnTime(sdfTime.parse(sdf.format(new Date()) + " 00:00:00"));
                gameUserDurationAdd.setExitTime(null);
                gameUserDurationAdd.setOperateMark(UserDurationMarkEnums.SYSTEM_REPAIR_LOG_ON_AND_EXIT_TIME.getValue());
                gameUserDurationAdd.setCreateTime(new Date());
                this.gameUserDurationMapper.insertUserDuration(gameUserDurationAdd);
            }
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u9000\u51fa\u8bb0\u5f55\u5f02\u5e38={}", (Throwable)e);
        }
        return true;
    }

    public Boolean userExit(GameUserFootprintAddPO gameUserFootprintAddPO) {
        log.info("\u7528\u6237\u9000\u51fa: serverId={},userAccount={},userRoleId={}", new Object[]{gameUserFootprintAddPO.getServerId(), gameUserFootprintAddPO.getUserAccount(), gameUserFootprintAddPO.getUserRoleId()});
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DateTimeFormatter formatterSpecific = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        SimpleDateFormat sdfTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        try {
            GameUserDuration gameUserDuration = this.gameUserDurationMapper.queryUserDuration(gameUserFootprintAddPO.getUserRoleId());
            if (gameUserDuration == null) {
                GameUserDuration gameUserDurationAdd = new GameUserDuration();
                BeanUtils.copyProperties((Object)gameUserFootprintAddPO, (Object)gameUserDurationAdd);
                gameUserDurationAdd.setDurationTime(sdf.format(new Date()));
                gameUserDurationAdd.setLogOnTime(sdfTime.parse(sdf.format(new Date()) + " 00:00:00"));
                gameUserDurationAdd.setExitTime(new Date());
                gameUserDurationAdd.setOperateMark(UserDurationMarkEnums.SYSTEM_REPAIR_LOG_ON_TIME.getValue());
                gameUserDurationAdd.setCreateTime(new Date());
                this.gameUserDurationMapper.insertUserDuration(gameUserDurationAdd);
            } else if (gameUserDuration.getLogOnTime() != null && gameUserDuration.getExitTime() == null) {
                if (sdf.format(gameUserDuration.getLogOnTime()).equals(sdf.format(new Date()))) {
                    GameUserDuration gameUserDurationUpdate = new GameUserDuration();
                    BeanUtils.copyProperties((Object)gameUserDuration, (Object)gameUserDurationUpdate);
                    gameUserDurationUpdate.setExitTime(new Date());
                    gameUserDurationUpdate.setOperateMark(UserDurationMarkEnums.NORMAL.getValue());
                    gameUserDurationUpdate.setUpdateTime(new Date());
                    this.gameUserDurationMapper.updateUserDuration(gameUserDurationUpdate);
                    return true;
                }
                LocalDateTime currentTime = LocalDateTime.now();
                LocalDate startDate = LocalDate.parse(sdfTime.format(gameUserDuration.getLogOnTime()), formatter);
                LocalDate endDate = currentTime.toLocalDate();
                ArrayList<String> timeSlotList = new ArrayList<String>();
                while (startDate.isBefore(endDate) || startDate.isEqual(endDate)) {
                    String add = startDate.format(formatterSpecific);
                    timeSlotList.add(add);
                    startDate = startDate.plusDays(1L);
                }
                ArrayList<GameUserDuration> gameUserDurationList = new ArrayList<GameUserDuration>();
                for (int i = 0; i < timeSlotList.size(); ++i) {
                    GameUserDuration gameUserDurationAdd = new GameUserDuration();
                    BeanUtils.copyProperties((Object)gameUserDuration, (Object)gameUserDurationAdd);
                    gameUserDurationAdd.setDurationTime((String)timeSlotList.get(i));
                    gameUserDurationAdd.setCreateTime(new Date());
                    if (sdf.format(gameUserDuration.getLogOnTime()).equals(timeSlotList.get(i))) {
                        GameUserDuration gameUserDurationUpdate = new GameUserDuration();
                        BeanUtils.copyProperties((Object)gameUserDuration, (Object)gameUserDurationUpdate);
                        gameUserDurationUpdate.setExitTime(sdfTime.parse((String)timeSlotList.get(i) + " 23:59:59"));
                        gameUserDurationUpdate.setOperateMark(UserDurationMarkEnums.SYSTEM_REPAIR_EXIT_TIME.getValue());
                        this.gameUserDurationMapper.updateUserDuration(gameUserDurationUpdate);
                        continue;
                    }
                    if (sdf.format(new Date()).equals(timeSlotList.get(i))) {
                        gameUserDurationAdd.setLogOnTime(sdfTime.parse((String)timeSlotList.get(i) + " 00:00:00"));
                        gameUserDurationAdd.setExitTime(new Date());
                        gameUserDurationAdd.setOperateMark(UserDurationMarkEnums.SYSTEM_REPAIR_LOG_ON_TIME.getValue());
                    } else {
                        gameUserDurationAdd.setLogOnTime(sdfTime.parse((String)timeSlotList.get(i) + " 00:00:00"));
                        gameUserDurationAdd.setExitTime(sdfTime.parse((String)timeSlotList.get(i) + " 23:59:59"));
                        gameUserDurationAdd.setOperateMark(UserDurationMarkEnums.SYSTEM_REPAIR_LOG_ON_AND_EXIT_TIME.getValue());
                    }
                    gameUserDurationList.add(gameUserDurationAdd);
                }
                this.gameUserDurationMapper.insertBatchUserDuration(gameUserDurationList);
            } else if (gameUserDuration.getLogOnTime() == null && gameUserDuration.getExitTime() != null) {
                GameUserDuration gameUserDurationUpdate = new GameUserDuration();
                BeanUtils.copyProperties((Object)gameUserDuration, (Object)gameUserDurationUpdate);
                gameUserDurationUpdate.setLogOnTime(sdfTime.parse(gameUserDuration.getDurationTime() + " 00:00:00"));
                gameUserDurationUpdate.setOperateMark(UserDurationMarkEnums.SYSTEM_REPAIR_LOG_ON_TIME.getValue());
                gameUserDurationUpdate.setUpdateTime(new Date());
                this.gameUserDurationMapper.updateUserDuration(gameUserDurationUpdate);
                GameUserDuration gameUserDurationAdd = new GameUserDuration();
                BeanUtils.copyProperties((Object)gameUserFootprintAddPO, (Object)gameUserDurationAdd);
                gameUserDurationAdd.setDurationTime(sdf.format(new Date()));
                gameUserDurationAdd.setLogOnTime(sdfTime.parse(sdf.format(new Date()) + " 00:00:00"));
                gameUserDurationAdd.setExitTime(new Date());
                gameUserDurationAdd.setOperateMark(UserDurationMarkEnums.SYSTEM_REPAIR_LOG_ON_AND_EXIT_TIME.getValue());
                gameUserDurationAdd.setCreateTime(new Date());
                this.gameUserDurationMapper.insertUserDuration(gameUserDurationAdd);
            }
        }
        catch (Exception e) {
            log.error("\u7528\u6237\u9000\u51fa\u8bb0\u5f55\u5f02\u5e38={}", (Throwable)e);
        }
        this.userExtendHandle(gameUserFootprintAddPO, Boolean.valueOf(false));
        return true;
    }

    public void userExtendHandle(GameUserFootprintAddPO gameUserFootprintAddPO, Boolean state) {
        String footprintJson = gameUserFootprintAddPO.getFootprintJson();
        if (StringUtils.isEmpty((String)footprintJson)) {
            return;
        }
        Map dataMap = (Map)JSON.parse((String)footprintJson);
        int count = this.gameUserExtendServiceImpl.queryUserExtendExist(gameUserFootprintAddPO.getUserRoleId());
        GameUserExtend gameUserExtend = new GameUserExtend();
        gameUserExtend.setServerId(gameUserFootprintAddPO.getServerId());
        gameUserExtend.setUserAccount(gameUserFootprintAddPO.getUserAccount());
        gameUserExtend.setUserRoleId(gameUserFootprintAddPO.getUserRoleId());
        gameUserExtend.setUserRoleName(gameUserFootprintAddPO.getUserRoleName());
        if (dataMap.get("moneyTotal") != null) {
            BigDecimal bigDecimal = new BigDecimal(Long.parseLong(dataMap.get("moneyTotal").toString()));
            gameUserExtend.setRechargeTotal(bigDecimal);
        }
        if (dataMap.get("topFightForce") != null) {
            gameUserExtend.setFightPrice(Long.valueOf(Long.parseLong(dataMap.get("topFightForce").toString())));
        }
        if (dataMap.get("level") != null) {
            gameUserExtend.setUserGrade(Integer.valueOf(dataMap.get("level").toString()));
        }
        if (dataMap.get("gold") != null) {
            gameUserExtend.setGoldCoin(Long.valueOf(Long.parseLong(dataMap.get("gold").toString())));
        }
        if (dataMap.get("diamond") != null) {
            gameUserExtend.setUserDiamond(Long.valueOf(Long.parseLong(dataMap.get("diamond").toString())));
        }
        if (dataMap.get("lastPayTimeMillis") != null) {
            long lastPayTimeMillis = Long.parseLong(dataMap.get("lastPayTimeMillis").toString());
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            gameUserExtend.setRecentlyRecharged(new Date(lastPayTimeMillis));
        }
        if (dataMap.get("totalOnlineTime") != null) {
            gameUserExtend.setTotalOnlineTime(Integer.valueOf(dataMap.get("totalOnlineTime").toString()));
        }
        if (state.booleanValue()) {
            gameUserExtend.setRecentlyLoggedInTime(new Date());
        } else {
            gameUserExtend.setRecentlyExited(new Date());
        }
        if (count == 0) {
            Date time = this.gameUserExtendServiceImpl.queryCreateUserTime(gameUserFootprintAddPO.getUserRoleId());
            gameUserExtend.setCreateUserTime(time);
            this.gameUserExtendServiceImpl.insertGameUserExtend(gameUserExtend);
        } else {
            this.gameUserExtendServiceImpl.updateGameUserExtend(gameUserExtend);
        }
    }

    public Boolean userExtendUpdate(UserExtendUpdateDataPO userExtendUpdateDataPO) {
        List userExtendUpdatePOList = userExtendUpdateDataPO.getData();
        if (userExtendUpdatePOList == null || userExtendUpdatePOList.size() <= 0) {
            return true;
        }
        for (UserExtendUpdatePO userExtendUpdatePO : userExtendUpdatePOList) {
            int count = this.gameUserExtendServiceImpl.queryUserExtendExist(userExtendUpdatePO.getUserRoleId());
            GameUserExtend gameUserExtend = new GameUserExtend();
            gameUserExtend.setServerId(userExtendUpdateDataPO.getServerId());
            gameUserExtend.setUserRoleId(userExtendUpdatePO.getUserRoleId());
            if (userExtendUpdatePO.getMoneyTotal() != null) {
                BigDecimal bigDecimal = new BigDecimal(userExtendUpdatePO.getMoneyTotal());
                gameUserExtend.setRechargeTotal(bigDecimal);
            }
            gameUserExtend.setFightPrice(userExtendUpdatePO.getTopFightForce());
            gameUserExtend.setUserGrade(userExtendUpdatePO.getLevel());
            gameUserExtend.setGoldCoin(userExtendUpdatePO.getGold());
            gameUserExtend.setUserDiamond(userExtendUpdatePO.getDiamond());
            if (userExtendUpdatePO.getLastPayTimeMillis() != null) {
                long lastPayTimeMillis = userExtendUpdatePO.getLastPayTimeMillis();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                gameUserExtend.setRecentlyRecharged(new Date(lastPayTimeMillis));
            }
            gameUserExtend.setTotalOnlineTime(userExtendUpdatePO.getTotalOnlineTime());
            if (count == 0) {
                Date time = this.gameUserExtendServiceImpl.queryCreateUserTime(userExtendUpdatePO.getUserRoleId());
                gameUserExtend.setCreateUserTime(time);
                this.gameUserExtendServiceImpl.insertGameUserExtend(gameUserExtend);
                continue;
            }
            this.gameUserExtendServiceImpl.updateGameUserExtend(gameUserExtend);
        }
        return true;
    }

    public IpAnalysisVO ipAnalysis(IpAnalysisPO ipAnalysisPO) {
        IpAnalysisVO ipAnalysisVO = new IpAnalysisVO();
        String dbPath = "C:\\Users\\ASUS\\Desktop\\ip2region.xdb";
        Searcher searcher = null;
        try {
            searcher = Searcher.newWithFileOnly((String)dbPath);
        }
        catch (IOException e) {
            log.error("ip.xdb\u5f02\u5e38,\u5165\u53c2={}", (Object)ipAnalysisPO);
            throw new ServiceException("ip.xdb\u5f02\u5e38");
        }
        try {
            String ip = ipAnalysisPO.getIpAddress();
            String region = searcher.search(ip);
            if (StringUtils.isEmpty((String)region)) {
                log.error("\u65e0\u6cd5\u627e\u5230\u8be5ip\u5f52\u5c5e\u5730,\u5165\u53c2={}", (Object)ipAnalysisPO);
                throw new ServiceException("\u65e0\u6cd5\u627e\u5230\u8be5ip\u5f52\u5c5e\u5730");
            }
            ipAnalysisVO.setIpDescribe(region);
            List<String> list = Arrays.asList(region.split("\\|"));
            ipAnalysisVO.setProvince(list.get(2));
            ipAnalysisVO.setMarket(list.get(3));
        }
        catch (Exception e) {
            log.error("ip\u89e3\u6790\u5f02\u5e38,\u5165\u53c2={}", (Object)ipAnalysisPO);
            throw new ServiceException("ip\u89e3\u6790\u5f02\u5e38");
        }
        try {
            searcher.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ipAnalysisVO;
    }
}

