/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.server.service.impl;

import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.server.domain.po.server.ServerDisposeSqlPO;
import com.ruoyi.server.domain.po.serverconfig.RearServerConfigAddPO;
import com.ruoyi.server.domain.po.serverconfig.ServerAddPO;
import com.ruoyi.server.domain.po.serverconfig.ServerConfigSqlPO;
import com.ruoyi.server.domain.po.serverconfig.ServerMiddleSqlAddPO;
import com.ruoyi.server.domain.po.serverconfig.ServerQueryPO;
import com.ruoyi.server.domain.po.serverconfig.ServerSqlAddPO;
import com.ruoyi.server.domain.po.serverconfig.ServerVersionSqlAddPO;
import com.ruoyi.server.domain.vo.ServerRegionVO;
import com.ruoyi.server.enums.BaseOperateEnums;
import com.ruoyi.server.enums.ServerTestIdEnums;
import com.ruoyi.server.mapper.RearServerConfigMapper;
import com.ruoyi.server.service.IRearServerConfigService;
import com.ruoyi.server.service.impl.server.ServerServiceImpl;
import com.ruoyi.server.utils.IPUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RearServerConfigServiceImpl
implements IRearServerConfigService {
    @Autowired
    private RearServerConfigMapper rearServerConfigMapper;
    @Autowired
    private ServerServiceImpl serverServiceImpl;
    private static final Logger log = LoggerFactory.getLogger(RearServerConfigServiceImpl.class);

    @Transactional(rollbackFor={Exception.class})
    public int insertRearServerConfig(RearServerConfigAddPO rearServerConfigAddPO, HttpServletRequest request) {
        String ipAddress = IPUtils.getIpAddr((HttpServletRequest)request);
        log.info("\u670d\u52a1\u5668\u7533\u62a5: \u8c03\u7528\u65b9ip={},serverIdList={}", (Object)ipAddress, (Object)rearServerConfigAddPO.getServerIp());
        this.insertRearServerConfigHandle(rearServerConfigAddPO);
        List serverIdList = rearServerConfigAddPO.getServerIdList();
        List serverIdExist = this.rearServerConfigMapper.serverIdExist(serverIdList);
        ArrayList<String> serverIdAddList = new ArrayList<String>();
        ArrayList<String> serverIdUpdateList = new ArrayList<String>();
        for (String element : serverIdList) {
            if (!serverIdExist.contains(element)) {
                serverIdAddList.add(element);
                continue;
            }
            serverIdUpdateList.add(element);
        }
        if (serverIdAddList.size() > 0) {
            ArrayList<ServerConfigSqlPO> serverConfigSqlPOList = new ArrayList<ServerConfigSqlPO>();
            for (int i = 0; i < serverIdAddList.size(); ++i) {
                ServerConfigSqlPO serverConfigSqlPO = new ServerConfigSqlPO();
                BeanUtils.copyProperties((Object)rearServerConfigAddPO, (Object)serverConfigSqlPO);
                serverConfigSqlPO.setServerId((String)serverIdAddList.get(i));
                serverConfigSqlPO.setServerIdList(null);
                serverConfigSqlPO.setCreateBy(ipAddress);
                serverConfigSqlPO.setCreateTime(DateUtils.getNowDate());
                serverConfigSqlPOList.add(serverConfigSqlPO);
            }
            this.rearServerConfigMapper.insertBatchServerConfig(serverConfigSqlPOList);
        }
        int state = 1;
        if (serverIdUpdateList.size() > 0) {
            ServerConfigSqlPO serverConfigSqlPO = new ServerConfigSqlPO();
            BeanUtils.copyProperties((Object)rearServerConfigAddPO, (Object)serverConfigSqlPO);
            serverConfigSqlPO.setServerIdList(serverIdUpdateList);
            serverConfigSqlPO.setUpdateBy(ipAddress);
            serverConfigSqlPO.setUpdateTime(DateUtils.getNowDate());
            state = this.rearServerConfigMapper.updateServerConfig(serverConfigSqlPO);
        }
        this.serverConfigHandle(serverIdList, ipAddress);
        return state;
    }

    @Transactional(rollbackFor={Exception.class})
    public int insertRearServerTestConfig(RearServerConfigAddPO rearServerConfigAddPO, HttpServletRequest request) {
        List serverIdList = rearServerConfigAddPO.getServerIdList();
        for (int i = 0; i < serverIdList.size(); ++i) {
            Integer serverId = Integer.valueOf((String)serverIdList.get(i));
            if (serverId >= ServerTestIdEnums.TEST_SERVER_ID_START.getValue() && serverId <= ServerTestIdEnums.TEST_SERVER_ID_END.getValue()) continue;
            log.error("\u670d\u52a1\u5668\u6d4b\u8bd5\u670d\u4e0a\u62a5\u63a5\u53e3\u975e\u6cd5: rearServerConfigAddPO={}", (Object)rearServerConfigAddPO);
            throw new ServiceException("\u4e0a\u62a5\u670d\u52a1\u5668\u975e\u6cd5: \u6d4b\u8bd5\u670d\u52a1\u5668ID\u53ea\u80fd\u4e3a90000-99999!");
        }
        int mark = this.insertRearServerConfig(rearServerConfigAddPO, request);
        return mark;
    }

    public void insertRearServerConfigHandle(RearServerConfigAddPO rearServerConfigAddPO) {
        if (StringUtils.isEmpty((String)rearServerConfigAddPO.getServerIp())) {
            log.error("\u7533\u62a5\u670d\u52a1\u5668ip\u5730\u5740\u4e3a\u7a7a: rearServerConfigAddPO={}", (Object)rearServerConfigAddPO);
            throw new ServiceException("\u670d\u52a1\u5668ip\u5730\u5740\u4e3a\u7a7a");
        }
        log.info("\u7533\u62a5\u670d\u52a1\u5668\u914d\u7f6e: serverIp={}", (Object)rearServerConfigAddPO.getServerIp());
        if (rearServerConfigAddPO.getServerIdList() == null && rearServerConfigAddPO.getServerIdList().size() <= 0) {
            log.error("\u7533\u62a5\u670d\u52a1\u5668id\u96c6\u5408\u4e3a\u7a7a: rearServerConfigAddPO={}", (Object)rearServerConfigAddPO);
            throw new ServiceException("\u670d\u52a1\u5668id\u96c6\u5408\u4e3a\u7a7a");
        }
        if (rearServerConfigAddPO.getServerPort() == null) {
            log.error("\u7533\u62a5\u670d\u52a1\u5668\u7aef\u53e3\u4e3a\u7a7a: rearServerConfigAddPO={}", (Object)rearServerConfigAddPO);
            throw new ServiceException("\u670d\u52a1\u5668\u7aef\u53e3\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)rearServerConfigAddPO.getGameIp())) {
            log.error("\u7533\u62a5\u6e38\u620f\u7aefip\u5730\u5740\u4e3a\u7a7a: rearServerConfigAddPO={}", (Object)rearServerConfigAddPO);
            throw new ServiceException("\u6e38\u620f\u7aefip\u5730\u5740\u4e3a\u7a7a");
        }
        if (rearServerConfigAddPO.getGamePort() == null) {
            log.error("\u7533\u62a5\u6e38\u620f\u7aef\u7aef\u53e3\u4e3a\u7a7a: rearServerConfigAddPO={}", (Object)rearServerConfigAddPO);
            throw new ServiceException("\u6e38\u620f\u7aef\u7aef\u53e3\u4e3a\u7a7a");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void serverConfigHandle(List<String> serverIdList, String ipAddress) {
        List serverIdExistList = this.serverServiceImpl.serverIdExistList(serverIdList);
        List disposeServerIdList = this.serverServiceImpl.disposeServerIdExistList(serverIdList);
        disposeServerIdList.addAll(serverIdExistList);
        ArrayList<String> excludeList = new ArrayList<String>();
        for (String element : serverIdList) {
            if (disposeServerIdList.contains(element)) continue;
            excludeList.add(element);
        }
        ArrayList<ServerDisposeSqlPO> serverDisposeSqlPOList = new ArrayList<ServerDisposeSqlPO>();
        for (int i = 0; i < excludeList.size(); ++i) {
            ServerDisposeSqlPO serverDisposeSqlPO = new ServerDisposeSqlPO();
            serverDisposeSqlPO.setServerId((String)excludeList.get(i));
            serverDisposeSqlPO.setCreateBy(ipAddress);
            serverDisposeSqlPO.setCreateTime(new Date());
            serverDisposeSqlPOList.add(serverDisposeSqlPO);
        }
        if (serverDisposeSqlPOList.size() > 0) {
            this.serverServiceImpl.insertBatchServerDispose(serverDisposeSqlPOList);
        }
    }

    public Map<String, Object> serverContentQuery(ServerQueryPO serverQueryPO) {
        HashMap<String, Object> tableMap = new HashMap<String, Object>();
        int pageNumPast = serverQueryPO.getPageNum();
        int pageNum = (serverQueryPO.getPageNum() - 1) * serverQueryPO.getPageSize();
        serverQueryPO.setPageNum(pageNum);
        List serverContentQueryVOList = this.rearServerConfigMapper.serverConfig(serverQueryPO);
        int total = this.rearServerConfigMapper.serverConfigTotal(serverQueryPO);
        tableMap.put("data", serverContentQueryVOList);
        tableMap.put("total", total);
        tableMap.put("currentPage", pageNumPast);
        return tableMap;
    }

    public List<ServerRegionVO> serverRegionQuery() {
        List serverRegionList = this.rearServerConfigMapper.serverRegionList();
        return serverRegionList;
    }

    @Transactional(rollbackFor={Exception.class})
    public int serverOperate(ServerAddPO serverAddPO, HttpServletRequest request) {
        if (BaseOperateEnums.ADD.getValue().equals(serverAddPO.getOperateState())) {
            this.serverAdd(serverAddPO, request);
        } else if (BaseOperateEnums.UPDATE.getValue().equals(serverAddPO.getOperateState())) {
            this.serverUpdate(serverAddPO, request);
        }
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public int serverAdd(ServerAddPO serverAddPO, HttpServletRequest request) {
        String ipAddress = IPUtils.getIpAddr((HttpServletRequest)request);
        int serverIdCount = this.rearServerConfigMapper.serverIdCount(serverAddPO.getServerId());
        if (serverIdCount > 0) {
            throw new ServiceException("\u6b64\u670d\u52a1\u5668id\u5df2\u7ecf\u5b58\u5728!");
        }
        ServerSqlAddPO serverSqlAddPO = new ServerSqlAddPO();
        BeanUtils.copyProperties((Object)serverAddPO, (Object)serverSqlAddPO);
        serverSqlAddPO.setServerStatus("0");
        serverSqlAddPO.setOpenServerTime(new Date());
        serverSqlAddPO.setServerSuggest("0");
        serverSqlAddPO.setServerMark("0");
        serverSqlAddPO.setServerTestMark(Integer.valueOf(0));
        serverSqlAddPO.setCreateBy(ipAddress);
        serverSqlAddPO.setCreateTime(new Date());
        this.rearServerConfigMapper.insertServer(serverSqlAddPO);
        ArrayList<ServerMiddleSqlAddPO> serverMiddleSqlAddPOList = new ArrayList<ServerMiddleSqlAddPO>();
        List channelAllList = this.rearServerConfigMapper.channelAllList();
        List gameWrapAllList = this.rearServerConfigMapper.gameWrapAllList();
        for (int i = 0; i < channelAllList.size(); ++i) {
            for (int j = 0; j < gameWrapAllList.size(); ++j) {
                ServerMiddleSqlAddPO serverMiddleSqlAddPO = new ServerMiddleSqlAddPO();
                serverMiddleSqlAddPO.setServerId(serverAddPO.getServerId());
                serverMiddleSqlAddPO.setChannelId((String)channelAllList.get(i));
                serverMiddleSqlAddPO.setGameWrapId((String)gameWrapAllList.get(j));
                serverMiddleSqlAddPO.setCreateBy(ipAddress);
                serverMiddleSqlAddPO.setCreateTime(new Date());
                serverMiddleSqlAddPOList.add(serverMiddleSqlAddPO);
            }
        }
        this.rearServerConfigMapper.insertBatchServerMiddle(serverMiddleSqlAddPOList);
        ArrayList<ServerVersionSqlAddPO> serverVersionSqlAddPOList = new ArrayList<ServerVersionSqlAddPO>();
        for (int i = 0; i < 2; ++i) {
            ServerVersionSqlAddPO serverVersionSqlAddPO = new ServerVersionSqlAddPO();
            serverVersionSqlAddPO.setServerId(serverAddPO.getServerId());
            serverVersionSqlAddPO.setServerVersion(Integer.valueOf(i));
            serverVersionSqlAddPO.setCreateBy(ipAddress);
            serverVersionSqlAddPO.setCreateTime(new Date());
            serverVersionSqlAddPOList.add(serverVersionSqlAddPO);
        }
        this.rearServerConfigMapper.insertBatchServerVersion(serverVersionSqlAddPOList);
        RearServerConfigAddPO rearServerConfigAddPO = new RearServerConfigAddPO();
        BeanUtils.copyProperties((Object)serverAddPO, (Object)rearServerConfigAddPO);
        ArrayList<String> serverIdList = new ArrayList<String>();
        serverIdList.add(serverAddPO.getServerId());
        rearServerConfigAddPO.setServerIdList(serverIdList);
        this.insertRearServerConfig(rearServerConfigAddPO, request);
        return 1;
    }

    @Transactional(rollbackFor={Exception.class})
    public int serverUpdate(ServerAddPO serverAddPO, HttpServletRequest request) {
        String ipAddress = IPUtils.getIpAddr((HttpServletRequest)request);
        ServerSqlAddPO serverSqlAddPO = new ServerSqlAddPO();
        BeanUtils.copyProperties((Object)serverAddPO, (Object)serverSqlAddPO);
        serverSqlAddPO.setCreateBy(ipAddress);
        serverSqlAddPO.setCreateTime(new Date());
        this.rearServerConfigMapper.updateServer(serverSqlAddPO);
        ServerConfigSqlPO serverConfigSqlPO = new ServerConfigSqlPO();
        BeanUtils.copyProperties((Object)serverAddPO, (Object)serverConfigSqlPO);
        ArrayList<String> serverIdUpdateList = new ArrayList<String>();
        serverIdUpdateList.add(serverAddPO.getServerId());
        serverConfigSqlPO.setServerIdList(serverIdUpdateList);
        serverConfigSqlPO.setUpdateBy(ipAddress);
        serverConfigSqlPO.setUpdateTime(DateUtils.getNowDate());
        this.rearServerConfigMapper.updateServerConfig(serverConfigSqlPO);
        return 1;
    }
}

