/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.gateway.filter;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.ruoyi.common.core.utils.ServletUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.gateway.config.properties.CaptchaProperties;
import com.ruoyi.gateway.service.ValidateCodeService;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;

@Component
public class ValidateCodeFilter
extends AbstractGatewayFilterFactory<Object> {
    private static final String[] VALIDATE_URL = new String[]{"/auth/login", "/auth/register"};
    @Autowired
    private ValidateCodeService validateCodeService;
    @Autowired
    private CaptchaProperties captchaProperties;
    private static final String CODE = "code";
    private static final String UUID = "uuid";

    public GatewayFilter apply(Object config) {
        return (exchange, chain) -> {
            ServerHttpRequest request = exchange.getRequest();
            if (!StringUtils.containsAnyIgnoreCase((CharSequence)request.getURI().getPath(), (CharSequence[])VALIDATE_URL) || !this.captchaProperties.getEnabled().booleanValue()) {
                return chain.filter(exchange);
            }
            try {
                String rspStr = this.resolveBodyFromRequest(request);
                JSONObject obj = JSON.parseObject((String)rspStr);
                this.validateCodeService.checkCaptcha(obj.getString(CODE), obj.getString(UUID));
            }
            catch (Exception e) {
                return ServletUtils.webFluxResponseWriter((ServerHttpResponse)exchange.getResponse(), (Object)e.getMessage());
            }
            return chain.filter(exchange);
        };
    }

    private String resolveBodyFromRequest(ServerHttpRequest serverHttpRequest) {
        Flux body = serverHttpRequest.getBody();
        AtomicReference bodyRef = new AtomicReference();
        body.subscribe(buffer -> {
            CharBuffer charBuffer = StandardCharsets.UTF_8.decode(buffer.asByteBuffer());
            DataBufferUtils.release((DataBuffer)buffer);
            bodyRef.set(charBuffer.toString());
        });
        return (String)bodyRef.get();
    }
}

