/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.gateway.config;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.config.GatewayProperties;
import org.springframework.cloud.gateway.route.RouteLocator;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.web.reactive.config.ResourceHandlerRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Component
public class SwaggerProvider
implements SwaggerResourcesProvider,
WebFluxConfigurer {
    public static final String SWAGGER2URL = "/v2/api-docs";
    @Lazy
    @Autowired
    private RouteLocator routeLocator;
    @Autowired
    private GatewayProperties gatewayProperties;

    public List<SwaggerResource> get() {
        ArrayList<SwaggerResource> resourceList = new ArrayList<SwaggerResource>();
        ArrayList routes = new ArrayList();
        this.routeLocator.getRoutes().subscribe(route -> routes.add(route.getId()));
        this.gatewayProperties.getRoutes().stream().filter(routeDefinition -> routes.contains(routeDefinition.getId())).forEach(routeDefinition -> routeDefinition.getPredicates().stream().filter(predicateDefinition -> "Path".equalsIgnoreCase(predicateDefinition.getName())).filter(predicateDefinition -> !"ruoyi-auth".equalsIgnoreCase(routeDefinition.getId())).forEach(predicateDefinition -> resourceList.add(this.swaggerResource(routeDefinition.getId(), ((String)predicateDefinition.getArgs().get("_genkey_0")).replace("/**", SWAGGER2URL)))));
        return resourceList;
    }

    private SwaggerResource swaggerResource(String name, String location) {
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(name);
        swaggerResource.setLocation(location);
        swaggerResource.setSwaggerVersion("2.0");
        return swaggerResource;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/swagger-ui/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/springfox-swagger-ui/"});
    }
}

