/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.system.service.impl;

import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.redis.service.RedisService;
import com.ruoyi.system.api.domain.SysUser;
import com.ruoyi.system.api.model.LoginUser;
import com.ruoyi.system.domain.SysUserOnline;
import com.ruoyi.system.domain.po.UserForeignPO;
import com.ruoyi.system.service.ISysUserForeignService;
import com.ruoyi.system.service.ISysUserOnlineService;
import com.ruoyi.system.service.impl.SysUserServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysUserForeignServiceImpl
implements ISysUserForeignService {
    @Autowired
    private SysUserServiceImpl sysUserServiceImpl;
    @Autowired
    private RedisService redisService;
    @Autowired
    private ISysUserOnlineService userOnlineService;
    private static final Logger log = LoggerFactory.getLogger(SysUserForeignServiceImpl.class);

    public Boolean userAdd(UserForeignPO userForeignPO) {
        log.info("\u6e38\u620f\u603b\u540e\u7aef\u65b0\u589e\u7528\u6237: sysUser={}", (Object)userForeignPO);
        SysUser sysUser = new SysUser();
        BeanUtils.copyProperties((Object)userForeignPO, (Object)sysUser);
        if (!this.sysUserServiceImpl.checkUserNameUnique(sysUser)) {
            log.error("\u65b0\u589e\u7528\u6237'" + sysUser.getUserName() + "'\u5931\u8d25\uff0c\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728");
            return false;
        }
        if (StringUtils.isNotEmpty((String)sysUser.getPhonenumber()) && !this.sysUserServiceImpl.checkPhoneUnique(sysUser)) {
            log.error("\u65b0\u589e\u7528\u6237'" + sysUser.getUserName() + "'\u5931\u8d25\uff0c\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728");
            return false;
        }
        if (StringUtils.isNotEmpty((String)sysUser.getEmail()) && !this.sysUserServiceImpl.checkEmailUnique(sysUser)) {
            log.error("\u65b0\u589e\u7528\u6237'" + sysUser.getUserName() + "'\u5931\u8d25\uff0c\u90ae\u7bb1\u8d26\u53f7\u5df2\u5b58\u5728");
            return false;
        }
        this.sysUserServiceImpl.insertUser(sysUser, Boolean.valueOf(false));
        return true;
    }

    public Boolean userUpdate(UserForeignPO userForeignPO) {
        SysUser sysUser = new SysUser();
        BeanUtils.copyProperties((Object)userForeignPO, (Object)sysUser);
        SysUser sysUserQuery = this.sysUserServiceImpl.selectUserByUserName(sysUser.getUserName());
        sysUser.setUserId(sysUserQuery.getUserId());
        if (!this.sysUserServiceImpl.checkUserNameUnique(sysUser)) {
            log.error("\u4fee\u6539\u7528\u6237'" + sysUser.getUserName() + "'\u5931\u8d25\uff0c\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728");
            return false;
        }
        if (StringUtils.isNotEmpty((String)sysUser.getPhonenumber()) && !this.sysUserServiceImpl.checkPhoneUnique(sysUser)) {
            log.error("\u4fee\u6539\u7528\u6237'" + sysUser.getUserName() + "'\u5931\u8d25\uff0c\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728");
            return false;
        }
        if (StringUtils.isNotEmpty((String)sysUser.getEmail()) && !this.sysUserServiceImpl.checkEmailUnique(sysUser)) {
            log.error("\u4fee\u6539\u7528\u6237'" + sysUser.getUserName() + "'\u5931\u8d25\uff0c\u90ae\u7bb1\u8d26\u53f7\u5df2\u5b58\u5728");
            return false;
        }
        log.info("\u6e38\u620f\u603b\u540e\u7aef\u4fee\u6539\u7528\u6237: sysUser={}", (Object)sysUser);
        this.sysUserServiceImpl.updateUser(sysUser, Boolean.valueOf(false));
        return true;
    }

    public Boolean userPasswordReset(UserForeignPO userForeignPO) {
        SysUser sysUser = new SysUser();
        BeanUtils.copyProperties((Object)userForeignPO, (Object)sysUser);
        SysUser sysUserQuery = this.sysUserServiceImpl.selectUserByUserName(sysUser.getUserName());
        sysUser.setUserId(sysUserQuery.getUserId());
        log.info("\u6e38\u620f\u603b\u540e\u7aef\u91cd\u7f6e\u7528\u6237\u5bc6\u7801: sysUser={}", (Object)sysUser);
        this.sysUserServiceImpl.resetPwd(sysUser, Boolean.valueOf(false));
        return true;
    }

    public Boolean userDelete(UserForeignPO userForeignPO) {
        SysUser sysUser = new SysUser();
        BeanUtils.copyProperties((Object)userForeignPO, (Object)sysUser);
        SysUser sysUserQuery = this.sysUserServiceImpl.selectUserByUserName(sysUser.getUserName());
        log.info("\u6e38\u620f\u603b\u540e\u7aef\u5220\u9664\u7528\u6237: userId={}", (Object)sysUserQuery.getUserId());
        this.sysUserServiceImpl.deleteUserById(sysUserQuery.getUserId(), Boolean.valueOf(false));
        return true;
    }

    public Boolean userExit(UserForeignPO userForeignPO) {
        String ipaddr = null;
        String userName = null;
        Collection keys = this.redisService.keys("login_tokens:*");
        ArrayList<SysUserOnline> userOnlineList = new ArrayList<SysUserOnline>();
        for (String key : keys) {
            LoginUser user = (LoginUser)this.redisService.getCacheObject(key);
            if (StringUtils.isNotEmpty(ipaddr) && StringUtils.isNotEmpty(userName)) {
                userOnlineList.add(this.userOnlineService.selectOnlineByInfo(ipaddr, userName, user));
                continue;
            }
            if (StringUtils.isNotEmpty(ipaddr)) {
                userOnlineList.add(this.userOnlineService.selectOnlineByIpaddr(ipaddr, user));
                continue;
            }
            if (StringUtils.isNotEmpty(userName)) {
                userOnlineList.add(this.userOnlineService.selectOnlineByUserName(userName, user));
                continue;
            }
            userOnlineList.add(this.userOnlineService.loginUserToUserOnline(user));
        }
        for (SysUserOnline sysUserOnline : userOnlineList) {
            if (!userForeignPO.getUserName().equals(sysUserOnline.getUserName())) continue;
            this.redisService.deleteObject("login_tokens:" + sysUserOnline.getTokenId());
        }
        return true;
    }
}

