/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.system.controller;

import com.ruoyi.common.core.utils.poi.ExcelUtil;
import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.RequiresPermissions;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.system.domain.SysConfig;
import com.ruoyi.system.service.ISysConfigService;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/config"})
public class SysConfigController
extends BaseController {
    @Autowired
    private ISysConfigService configService;
    private static final Logger log = LoggerFactory.getLogger(SysConfigController.class);

    @GetMapping(value={"/testAndVerify"})
    public String testAndVerify() {
        log.info("\u7cfb\u7edf\u6a21\u5757\u670d\u52a1\u6b63\u5e38,date={}", (Object)new Date());
        return "\u7cfb\u7edf\u6a21\u5757\u6b63\u5e38";
    }

    @RequiresPermissions(value={"system:config:list"})
    @GetMapping(value={"/list"})
    public TableDataInfo list(SysConfig config) {
        this.startPage();
        List list = this.configService.selectConfigList(config);
        return this.getDataTable(list);
    }

    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @RequiresPermissions(value={"system:config:export"})
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysConfig config) {
        List list = this.configService.selectConfigList(config);
        ExcelUtil util = new ExcelUtil(SysConfig.class);
        util.exportExcel(response, list, "\u53c2\u6570\u6570\u636e");
    }

    @GetMapping(value={"/{configId}"})
    public AjaxResult getInfo(@PathVariable Long configId) {
        return this.success((Object)this.configService.selectConfigById(configId));
    }

    @GetMapping(value={"/configKey/{configKey}"})
    public AjaxResult getConfigKey(@PathVariable String configKey) {
        return this.success(this.configService.selectConfigByKey(configKey));
    }

    @RequiresPermissions(value={"system:config:add"})
    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@Validated @RequestBody SysConfig config) {
        if (!this.configService.checkConfigKeyUnique(config)) {
            return this.error("\u65b0\u589e\u53c2\u6570'" + config.getConfigName() + "'\u5931\u8d25\uff0c\u53c2\u6570\u952e\u540d\u5df2\u5b58\u5728");
        }
        config.setCreateBy(SecurityUtils.getUsername());
        return this.toAjax(this.configService.insertConfig(config));
    }

    @RequiresPermissions(value={"system:config:edit"})
    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@Validated @RequestBody SysConfig config) {
        if (!this.configService.checkConfigKeyUnique(config)) {
            return this.error("\u4fee\u6539\u53c2\u6570'" + config.getConfigName() + "'\u5931\u8d25\uff0c\u53c2\u6570\u952e\u540d\u5df2\u5b58\u5728");
        }
        config.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.configService.updateConfig(config));
    }

    @RequiresPermissions(value={"system:config:remove"})
    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{configIds}"})
    public AjaxResult remove(@PathVariable Long[] configIds) {
        this.configService.deleteConfigByIds(configIds);
        return this.success();
    }

    @RequiresPermissions(value={"system:config:remove"})
    @Log(title="\u53c2\u6570\u7ba1\u7406", businessType=BusinessType.CLEAN)
    @DeleteMapping(value={"/refreshCache"})
    public AjaxResult refreshCache() {
        this.configService.resetConfigCache();
        return this.success();
    }
}

