/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.server.utils;

import org.apache.commons.lang3.Validate;

/*
 * Exception performing whole class analysis ignored.
 */
public class LongIdGenerator {
    private final long prefixMax;
    private final int prefixBitCount;
    private final long middleMax;
    private final int middleBitCount;
    private final long suffixMax;
    private final int suffixBitCount;

    private LongIdGenerator(long prefixMax, int prefixBitCount, long middleMax, int middleBitCount, long suffixMax, int suffixBitCount) {
        Validate.inclusiveBetween((long)0L, (long)32L, (long)prefixBitCount);
        Validate.inclusiveBetween((long)0L, (long)32L, (long)middleBitCount);
        Validate.inclusiveBetween((long)0L, (long)32L, (long)suffixBitCount);
        Validate.inclusiveBetween((long)0L, (long)63L, (long)((long)prefixBitCount + (long)middleBitCount + (long)suffixBitCount));
        Validate.inclusiveBetween((long)0L, (long)((1L << prefixBitCount) - 1L), (long)prefixMax);
        Validate.inclusiveBetween((long)0L, (long)((1L << middleBitCount) - 1L), (long)middleMax);
        Validate.inclusiveBetween((long)0L, (long)((1L << suffixBitCount) - 1L), (long)suffixMax);
        this.prefixMax = prefixMax;
        this.middleMax = middleMax;
        this.suffixMax = suffixMax;
        this.prefixBitCount = prefixBitCount;
        this.middleBitCount = middleBitCount;
        this.suffixBitCount = suffixBitCount;
    }

    public static LongIdGenerator valueOfMax(int prefixMax, int middleMax, int suffixMax) {
        int prefixBitCount = LongIdGenerator.bitLength((int)prefixMax);
        int middleBixCount = LongIdGenerator.bitLength((int)middleMax);
        int suffixBitCount = LongIdGenerator.bitLength((int)suffixMax);
        return new LongIdGenerator((long)prefixMax, prefixBitCount, (long)middleMax, middleBixCount, (long)suffixMax, suffixBitCount);
    }

    public static LongIdGenerator valueOfBitCount(int prefixBitCount, int middleBitCount, int suffixBitCount) {
        return new LongIdGenerator((1L << prefixBitCount) - 1L, prefixBitCount, (1L << middleBitCount) - 1L, middleBitCount, (1L << suffixBitCount) - 1L, suffixBitCount);
    }

    public static int bitLength(int value) {
        return 32 - Integer.numberOfLeadingZeros(value);
    }

    public long getId(int prefix, int middle, int suffix) {
        Validate.inclusiveBetween((long)0L, (long)this.prefixMax, (long)Integer.toUnsignedLong(prefix));
        Validate.inclusiveBetween((long)0L, (long)this.middleMax, (long)Integer.toUnsignedLong(middle));
        Validate.inclusiveBetween((long)0L, (long)this.suffixMax, (long)Integer.toUnsignedLong(suffix));
        long id = prefix;
        id = id << this.middleBitCount | (long)middle & (1L << this.middleBitCount) - 1L;
        id = id << this.suffixBitCount | (long)suffix & (1L << this.suffixBitCount) - 1L;
        return id;
    }

    public long removePrefix(long id) {
        long mask = (1L << this.suffixBitCount + this.middleBitCount) - 1L;
        return id & mask;
    }

    public long removeSuffix(long id) {
        long mask = (1L << this.suffixBitCount) - 1L;
        return id & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public long removeMiddle(long id) {
        long mask = (1L << this.middleBitCount) - 1L << this.suffixBitCount;
        return id & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public int getPrefix(long id) {
        long prefix = id >> this.middleBitCount + this.suffixBitCount;
        return (int)prefix;
    }

    public int getSuffix(long id) {
        return (int)(id & (1L << this.suffixBitCount) - 1L);
    }

    public int getMiddle(long id) {
        long v = id >> this.suffixBitCount & (1L << this.middleBitCount) - 1L;
        return (int)v;
    }

    public long getPrefixMax() {
        return this.prefixMax;
    }

    public int getPrefixBitCount() {
        return this.prefixBitCount;
    }

    public long getMiddleMax() {
        return this.middleMax;
    }

    public int getMiddleBitCount() {
        return this.middleBitCount;
    }

    public long getSuffixMax() {
        return this.suffixMax;
    }

    public int getSuffixBitCount() {
        return this.suffixBitCount;
    }
}

