/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.server.service.impl.recharge;

import com.ruoyi.common.core.exception.CustomServiceException;
import com.ruoyi.server.domain.po.RechargePO;
import com.ruoyi.server.domain.vo.RechargeVO;
import com.ruoyi.server.enums.SendOutGoodsRequestEnums;
import com.ruoyi.server.service.recharge.IRechargeService;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class RechargeServiceImpl
implements IRechargeService {
    private static final Logger log = LoggerFactory.getLogger(RechargeServiceImpl.class);

    public RechargeVO rechargeAdd(RechargePO rechargePO) {
        log.info("\u670d\u52a1\u7aef\u53d1\u8d27\u63a5\u53e3: serverId={},orderId={},orderNo={},playerId={},ip={}", new Object[]{rechargePO.getServerId(), rechargePO.getOrderId(), rechargePO.getOrderNo(), rechargePO.getPlayerId(), rechargePO.getServerIp()});
        RechargeVO rechargeVO = new RechargeVO();
        String serverIp = rechargePO.getServerIp();
        String serverPort = rechargePO.getServerPort();
        String visitUrl = "http://" + serverIp + ":" + serverPort + "/payReward";
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("serviceId", rechargePO.getServerId());
        requestMap.put("orderId", rechargePO.getOrderId());
        requestMap.put("orderNo", rechargePO.getOrderNo());
        requestMap.put("playerId", rechargePO.getPlayerId());
        requestMap.put("time", rechargePO.getTime());
        requestMap.put("ext", rechargePO.getExt());
        requestMap.put("force", rechargePO.getForce());
        requestMap.put("money", rechargePO.getMoney());
        try {
            log.info("\u670d\u52a1\u7aef\u53d1\u8d27\u63a5\u53e3: Map\u5165\u53c2={}", requestMap);
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity formEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
            rechargeVO = (RechargeVO)restTemplate.postForObject(visitUrl, (Object)formEntity, RechargeVO.class, new Object[0]);
            log.info("\u670d\u52a1\u7aef\u53d1\u8d27\u63a5\u53e3\u8fd4\u56de\u5bf9\u8c61: ", (Object)rechargeVO);
            rechargeVO.setCode(rechargeVO.getCode());
            rechargeVO.setMsg(rechargeVO.getMessage());
            rechargeVO.setMessage(rechargeVO.getMessage());
            log.info("\u670d\u52a1\u7aef\u53d1\u8d27\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c: orderNo={},code={},msg={}", new Object[]{rechargePO.getOrderNo(), rechargeVO.getCode(), rechargeVO.getMessage()});
        }
        catch (Exception e) {
            log.error("\u5145\u503c\u53d1\u8d27\u629b\u51fa\u5f02\u5e38===", (Throwable)e);
            log.error(String.format("\u670d\u52a1\u7aef\u53d1\u8d27\u63a5\u53e3\u5f02\u5e38: Map\u5165\u53c2=%s", requestMap), (Throwable)e);
            throw new CustomServiceException(SendOutGoodsRequestEnums.REQUEST_EXCEPTION.getDesc(), SendOutGoodsRequestEnums.REQUEST_EXCEPTION.getValue());
        }
        return rechargeVO;
    }

    public RechargeVO rechargeAdd37(RechargePO rechargePO) {
        log.info("37\u670d\u52a1\u7aef\u53d1\u8d27\u63a5\u53e3: serverId={},orderId={},orderNo={},playerId={},ip={}", new Object[]{rechargePO.getServerId(), rechargePO.getOrderId(), rechargePO.getOrderNo(), rechargePO.getPlayerId(), rechargePO.getServerIp()});
        RechargeVO rechargeVO = new RechargeVO();
        String serverIp = rechargePO.getServerIp();
        String serverPort = rechargePO.getServerPort();
        String visitUrl = "http://" + serverIp + ":" + serverPort + "/thirdPartyPayReward";
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("serviceId", rechargePO.getServerId());
        requestMap.put("orderId", rechargePO.getOrderId());
        requestMap.put("productId", rechargePO.getProductId());
        requestMap.put("playerId", rechargePO.getPlayerId());
        requestMap.put("time", rechargePO.getTime());
        requestMap.put("ext", rechargePO.getExt());
        requestMap.put("force", rechargePO.getForce());
        requestMap.put("money", rechargePO.getMoney());
        try {
            log.info("37\u670d\u52a1\u7aef\u53d1\u8d27\u63a5\u53e3: Map\u5165\u53c2={}", requestMap);
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity formEntity = new HttpEntity(requestMap, (MultiValueMap)headers);
            rechargeVO = (RechargeVO)restTemplate.postForObject(visitUrl, (Object)formEntity, RechargeVO.class, new Object[0]);
            log.info("37\u670d\u52a1\u7aef\u53d1\u8d27\u63a5\u53e3\u8fd4\u56de\u5bf9\u8c61: ", (Object)rechargeVO);
            rechargeVO.setCode(rechargeVO.getCode());
            rechargeVO.setMsg(rechargeVO.getMessage());
            rechargeVO.setMessage(rechargeVO.getMessage());
            log.info("37\u670d\u52a1\u7aef\u53d1\u8d27\u63a5\u53e3\u8fd4\u56de\u7ed3\u679c: orderNo={},code={},msg={}", new Object[]{rechargePO.getOrderNo(), rechargeVO.getCode(), rechargeVO.getMessage()});
        }
        catch (Exception e) {
            log.error("37\u5145\u503c\u53d1\u8d27\u629b\u51fa\u5f02\u5e38===", (Throwable)e);
            log.error(String.format("37\u670d\u52a1\u7aef\u53d1\u8d27\u63a5\u53e3\u5f02\u5e38: Map\u5165\u53c2=%s", requestMap), (Throwable)e);
            throw new CustomServiceException(SendOutGoodsRequestEnums.REQUEST_EXCEPTION.getDesc(), SendOutGoodsRequestEnums.REQUEST_EXCEPTION.getValue());
        }
        return rechargeVO;
    }
}

