/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.server.service.impl.player;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.alibaba.nacos.shaded.com.google.common.collect.Maps;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.server.domain.po.player.LogInoutPO;
import com.ruoyi.server.domain.vo.player.AuthResponseVO;
import com.ruoyi.server.enums.UserBehaviorReportEnums;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class GameIdCardAuthServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(GameIdCardAuthServiceImpl.class);
    private static final String CHECK_URL = "https://api.wlc.nppa.gov.cn/idcard/authentication/check";
    private static final String QUERY_URL = "http://api2.wlc.nppa.gov.cn/idcard/authentication/query";
    private static final String LOGINOUT_URL = "http://api2.wlc.nppa.gov.cn/behavior/collection/loginout";
    private String SECRET_KEY;
    private String APP_ID;
    private String BIZ_ID;

    public void authentication() {
        System.out.println("\u5b9e\u540d\u8ba4\u8bc1\u63a5\u53e3");
        LogInoutPO logInoutPO = new LogInoutPO();
        logInoutPO.setNo(Integer.valueOf(1)).setSi("1fffbl6st3fbp199i8zh5ggcp84fgo3rj7pn1y").setBt(UserBehaviorReportEnums.GO_ONLINE.getValue()).setOt(Long.valueOf(System.currentTimeMillis() / 1000L)).setCt(Integer.valueOf(LogInoutPO.ReportType.CERTIFIED_USER.getValue())).setDi("1fffbl6st3fbp199i8zh5ggcp84fgo3rj7pn1y").setPi("1fffbl6st3fbp199i8zh5ggcp84fgo3rj7pn1y");
        System.out.println(this.doPostLoginout((List)Lists.newArrayList((Object[])new LogInoutPO[]{logInoutPO})));
    }

    public AuthResponseVO<String> doPostLoginout(List<LogInoutPO> loginoutDOList) {
        String sign;
        long nowTime = System.currentTimeMillis();
        HashMap paramMap = Maps.newHashMap();
        paramMap.put("collections", loginoutDOList);
        String content = JSONObject.toJSONString((Object)paramMap);
        byte[] keyBytes = GameIdCardAuthServiceImpl.hexStringToByte((String)this.SECRET_KEY);
        String encryptStr = GameIdCardAuthServiceImpl.aesGcmEncrypt((String)content, (byte[])keyBytes);
        Map signMap = this.createSignMap(nowTime);
        try {
            sign = this.generateLoginoutSignature(signMap, "{\"data\":\"" + encryptStr + "\"}");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ServiceException("\u9632\u6c89\u8ff7loginoutDOList\u7b7e\u540d\u5f02\u5e38:{}" + e);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("appId", (String)signMap.get("appId"));
        headers.add("bizId", (String)signMap.get("bizId"));
        headers.add("timestamps", (String)signMap.get("timestamps"));
        headers.add("sign", sign);
        HttpEntity request = new HttpEntity((Object)("{\"data\":\"" + encryptStr + "\"}"), (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.postForEntity("http://api2.wlc.nppa.gov.cn/behavior/collection/loginout", (Object)request, String.class, new Object[0]);
        return (AuthResponseVO)JSONObject.parseObject((String)((String)response.getBody()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
    }

    private String generateLoginoutSignature(Map<String, String> signMap, String content) throws NoSuchAlgorithmException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.SECRET_KEY);
        for (Map.Entry<String, String> entry : signMap.entrySet()) {
            sb.append(entry.getKey()).append(entry.getValue());
        }
        sb.append(content);
        return this.sign(sb.toString());
    }

    private Map<String, String> createSignMap(long nowTime) {
        TreeMap<String, String> signMap = new TreeMap<String, String>();
        signMap.put("appId", this.APP_ID);
        signMap.put("bizId", this.BIZ_ID);
        signMap.put("timestamps", String.valueOf(nowTime));
        return signMap;
    }

    private String sign(String toBeSignStr) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        messageDigest.update(toBeSignStr.getBytes(StandardCharsets.UTF_8));
        return GameIdCardAuthServiceImpl.byteToHexString((byte[])messageDigest.digest());
    }

    private static String aesGcmEncrypt(String content, byte[] key) {
        try {
            Cipher cipher = Cipher.getInstance("AES/GCM/PKCS5Padding");
            SecretKeySpec skey = new SecretKeySpec(key, "AES");
            cipher.init(1, skey);
            byte[] ivb = cipher.getIV();
            byte[] encodedByteArray = cipher.doFinal(content.getBytes(StandardCharsets.UTF_8));
            byte[] message = new byte[ivb.length + encodedByteArray.length];
            System.arraycopy(ivb, 0, message, 0, ivb.length);
            System.arraycopy(encodedByteArray, 0, message, ivb.length, encodedByteArray.length);
            return Base64.getEncoder().encodeToString(message);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            return null;
        }
    }

    private static byte[] hexStringToByte(String str) {
        if (str == null || str.equals("")) {
            return null;
        }
        str = str.toUpperCase();
        int length = str.length() / 2;
        char[] hexChars = str.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(GameIdCardAuthServiceImpl.charToByte((char)hexChars[pos]) << 4 | GameIdCardAuthServiceImpl.charToByte((char)hexChars[pos + 1]));
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    private static String byteToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            int hex = b & 0xFF;
            String hexStr = Integer.toHexString(hex);
            if (hexStr.length() == 1) {
                hexStr = '0' + hexStr;
            }
            sb.append(hexStr);
        }
        return sb.toString();
    }
}

