/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.server.service.impl.exchange;

import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.server.domain.GameExchangeUse;
import com.ruoyi.server.domain.GameExchangeUseLog;
import com.ruoyi.server.domain.po.exchange.ExchangeUseConsumePO;
import com.ruoyi.server.domain.vo.exchange.ExchangeUseConsumeVO;
import com.ruoyi.server.domain.vo.exchange.ExchangeVO;
import com.ruoyi.server.enums.BaseSuccessFailEnums;
import com.ruoyi.server.mapper.exchange.GameExchangeUseMapper;
import com.ruoyi.server.service.exchange.IGameExchangeUseService;
import com.ruoyi.server.service.impl.exchange.ExchangeUseDetermineServiceImpl;
import com.ruoyi.server.service.impl.exchange.GameExchangeUseLogServiceImpl;
import com.ruoyi.server.utils.IPUtils;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GameExchangeUseServiceImpl
implements IGameExchangeUseService {
    @Autowired
    private GameExchangeUseMapper gameExchangeUseMapper;
    @Autowired
    private ExchangeUseDetermineServiceImpl exchangeUseDetermineServiceImpl;
    @Autowired
    private GameExchangeUseLogServiceImpl gameExchangeUseLogServiceImpl;
    private static final Logger log = LoggerFactory.getLogger(GameExchangeUseServiceImpl.class);

    @Transactional(rollbackFor={Exception.class})
    public ExchangeUseConsumeVO insertGameExchangeUse(ExchangeUseConsumePO exchangeUseConsumePO, HttpServletRequest request) {
        log.info("\u7528\u6237\u4f7f\u7528\u5151\u6362\u7801: actorId={},exchangeId={}", (Object)exchangeUseConsumePO.getActorId(), (Object)exchangeUseConsumePO.getExchangeId());
        ExchangeUseConsumeVO exchangeUseConsumeVO = new ExchangeUseConsumeVO();
        exchangeUseConsumeVO.setExchangeId(exchangeUseConsumePO.getExchangeId());
        ExchangeVO exchangeVO = this.exchangeUseDetermineServiceImpl.exchangeDetermine(exchangeUseConsumePO, request);
        exchangeUseConsumeVO.setExchangeJson(exchangeVO.getExchangeJson());
        GameExchangeUse gameExchangeUse = new GameExchangeUse();
        BeanUtils.copyProperties((Object)exchangeUseConsumePO, (Object)gameExchangeUse);
        String ipAddress = IPUtils.getIpAddr((HttpServletRequest)request);
        gameExchangeUse.setCallerIp(ipAddress);
        gameExchangeUse.setCreateBy(ipAddress);
        gameExchangeUse.setExchangeState(BaseSuccessFailEnums.SUCCESS.getValue().toString());
        gameExchangeUse.setCreateTime(DateUtils.getNowDate());
        Integer state = this.gameExchangeUseMapper.insertGameExchangeUse(gameExchangeUse);
        if (state == 1) {
            this.exchangeUseLog(exchangeUseConsumePO, request, BaseSuccessFailEnums.SUCCESS.getValue().toString(), BaseSuccessFailEnums.SUCCESS.getDesc());
        }
        log.info("\u73a9\u5bb6\u4f7f\u7528\u5151\u6362\u7801\u6210\u529f: \u5151\u6362\u7801={},\u89d2\u8272id={},\u670d\u52a1\u5668id={}", new Object[]{exchangeUseConsumePO.getExchangeId(), exchangeUseConsumePO.getActorId(), exchangeUseConsumePO.getServerId()});
        return exchangeUseConsumeVO;
    }

    public void exchangeUseLog(ExchangeUseConsumePO exchangeUseConsumePO, HttpServletRequest request, String state, String stateDescribe) {
        String ipAddress = IPUtils.getIpAddr((HttpServletRequest)request);
        GameExchangeUseLog gameExchangeUseLog = new GameExchangeUseLog();
        BeanUtils.copyProperties((Object)exchangeUseConsumePO, (Object)gameExchangeUseLog);
        gameExchangeUseLog.setCallerIp(ipAddress);
        gameExchangeUseLog.setCreateBy(ipAddress);
        gameExchangeUseLog.setExchangeState(state);
        gameExchangeUseLog.setExchangeStateDescribe(stateDescribe);
        this.gameExchangeUseLogServiceImpl.insertGameExchangeUseLog(gameExchangeUseLog);
    }
}

