/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.server.service.impl.exchange;

import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.server.domain.GameExchangeUseLog;
import com.ruoyi.server.domain.po.exchange.ExchangeUseConsumePO;
import com.ruoyi.server.domain.vo.exchange.ExchangeVO;
import com.ruoyi.server.enums.BaseStateEnums;
import com.ruoyi.server.enums.BaseSuccessFailEnums;
import com.ruoyi.server.mapper.exchange.GameExchangeUseMapper;
import com.ruoyi.server.service.impl.exchange.GameExchangeUseLogServiceImpl;
import com.ruoyi.server.utils.IPUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExchangeUseDetermineServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(ExchangeUseDetermineServiceImpl.class);
    @Autowired
    private GameExchangeUseMapper gameExchangeUseMapper;
    @Autowired
    private GameExchangeUseLogServiceImpl gameExchangeUseLogServiceImpl;

    public ExchangeVO exchangeDetermine(ExchangeUseConsumePO exchangeUseConsumePO, HttpServletRequest request) {
        Date expireTime;
        Date takeEffectTime;
        int compare;
        Date newDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ExchangeVO exchangeVO = this.gameExchangeUseMapper.exchangeDetails(exchangeUseConsumePO.getExchangeId());
        if (exchangeVO != null && !exchangeUseConsumePO.getExchangeId().equals(exchangeVO.getExchangeId())) {
            log.error("\u73a9\u5bb6\u4f7f\u7528\u5151\u6362\u7801\u5931\u8d25:\u5151\u6362\u7801\u5927\u5c0f\u5199\u4e0d\u5339\u914d; \u5151\u6362\u7801={},\u89d2\u8272id={},\u670d\u52a1\u5668id={}", new Object[]{exchangeUseConsumePO.getExchangeId(), exchangeUseConsumePO.getActorId(), exchangeUseConsumePO.getServerId()});
            this.exchangeUseLog(exchangeUseConsumePO, request, BaseSuccessFailEnums.FAIL.getValue().toString(), "\u5151\u6362\u5931\u8d25: \u5151\u6362\u7801\u8f93\u5165\u6709\u8bef");
            throw new ServiceException("\u5151\u6362\u5931\u8d25: \u5151\u6362\u7801\u8f93\u5165\u6709\u8bef,\u8bf7\u786e\u8ba4\u5151\u6362\u7801");
        }
        List exchangeMiddleNumberList = this.gameExchangeUseMapper.exchangeMiddleNumber(exchangeUseConsumePO.getExchangeId());
        Integer exchangeIdUseNumber = this.gameExchangeUseMapper.exchangeIdUseNumber(exchangeUseConsumePO.getExchangeId());
        Integer actorIdUseNumber = this.gameExchangeUseMapper.actorIdUseNumber(exchangeUseConsumePO.getExchangeId(), exchangeUseConsumePO.getActorId());
        if (exchangeVO == null) {
            log.error("\u73a9\u5bb6\u4f7f\u7528\u5151\u6362\u7801\u5931\u8d25:\u5151\u6362\u7801\u8f93\u5165\u6709\u8bef; \u5151\u6362\u7801={},\u89d2\u8272id={},\u670d\u52a1\u5668id={}", new Object[]{exchangeUseConsumePO.getExchangeId(), exchangeUseConsumePO.getActorId(), exchangeUseConsumePO.getServerId()});
            this.exchangeUseLog(exchangeUseConsumePO, request, BaseSuccessFailEnums.FAIL.getValue().toString(), "\u5151\u6362\u5931\u8d25: \u5151\u6362\u7801\u8f93\u5165\u6709\u8bef");
            throw new ServiceException("\u5151\u6362\u5931\u8d25: \u5151\u6362\u7801\u8f93\u5165\u6709\u8bef");
        }
        if (exchangeVO.getExchangeState() == BaseStateEnums.DEACTIVATE.getValue()) {
            log.error("\u73a9\u5bb6\u4f7f\u7528\u5151\u6362\u7801\u5931\u8d25:\u6b64\u5151\u6362\u7801\u5df2\u505c\u7528; \u5151\u6362\u7801={},\u89d2\u8272id={},\u670d\u52a1\u5668id={}", new Object[]{exchangeUseConsumePO.getExchangeId(), exchangeUseConsumePO.getActorId(), exchangeUseConsumePO.getServerId()});
            this.exchangeUseLog(exchangeUseConsumePO, request, BaseSuccessFailEnums.FAIL.getValue().toString(), "\u5151\u6362\u5931\u8d25: \u6b64\u5151\u6362\u7801\u5df2\u505c\u7528");
            throw new ServiceException("\u5151\u6362\u5931\u8d25: \u6b64\u5151\u6362\u7801\u5df2\u505c\u7528");
        }
        if (actorIdUseNumber != null && actorIdUseNumber > 0) {
            log.error("\u73a9\u5bb6\u4f7f\u7528\u5151\u6362\u7801\u5931\u8d25:\u8be5\u73a9\u5bb6\u5df2\u7ecf\u4f7f\u7528\u8fc7\u8be5\u5151\u6362\u7801; \u5151\u6362\u7801={},\u89d2\u8272id={},\u670d\u52a1\u5668id={}", new Object[]{exchangeUseConsumePO.getExchangeId(), exchangeUseConsumePO.getActorId(), exchangeUseConsumePO.getServerId()});
            this.exchangeUseLog(exchangeUseConsumePO, request, BaseSuccessFailEnums.FAIL.getValue().toString(), "\u5151\u6362\u5931\u8d25: \u4f60\u5df2\u7ecf\u4f7f\u7528\u8fc7\u5566");
            throw new ServiceException("\u5151\u6362\u5931\u8d25: \u4f60\u5df2\u7ecf\u4f7f\u7528\u8fc7\u5566");
        }
        if (exchangeMiddleNumberList != null && exchangeMiddleNumberList.size() > 0 && !exchangeMiddleNumberList.contains(exchangeUseConsumePO.getServerId())) {
            log.info("\u73a9\u5bb6\u4f7f\u7528\u5151\u6362\u7801\u5931\u8d25:\u6b64\u670d\u65e0\u6cd5\u5151\u6362\u8be5\u5956\u52b1; \u5151\u6362\u7801={},\u89d2\u8272id={},\u670d\u52a1\u5668id={},pid={},gid={}", new Object[]{exchangeUseConsumePO.getExchangeId(), exchangeUseConsumePO.getActorId(), exchangeUseConsumePO.getServerId(), exchangeUseConsumePO.getChannelId(), exchangeUseConsumePO.getGameWrapId()});
            this.exchangeUseLog(exchangeUseConsumePO, request, BaseSuccessFailEnums.FAIL.getValue().toString(), "\u5151\u6362\u5931\u8d25: \u6b64\u670d\u65e0\u6cd5\u5151\u6362\u8be5\u5956\u52b1");
            throw new ServiceException("\u5151\u6362\u5931\u8d25: \u6b64\u670d\u65e0\u6cd5\u5151\u6362\u8be5\u5956\u52b1");
        }
        if (exchangeVO.getApplyFrequency() != 0 && exchangeIdUseNumber >= exchangeVO.getApplyFrequency()) {
            log.error("\u73a9\u5bb6\u4f7f\u7528\u5151\u6362\u7801\u5931\u8d25:\u6b64\u5151\u6362\u7801\u5df2\u7ecf\u88ab\u5151\u6362\u5b8c\u4e86; \u5151\u6362\u7801={},\u89d2\u8272id={},\u670d\u52a1\u5668id={}", new Object[]{exchangeUseConsumePO.getExchangeId(), exchangeUseConsumePO.getActorId(), exchangeUseConsumePO.getServerId()});
            this.exchangeUseLog(exchangeUseConsumePO, request, BaseSuccessFailEnums.FAIL.getValue().toString(), "\u5151\u6362\u5931\u8d25: \u6b64\u5151\u6362\u7801\u5df2\u7ecf\u88ab\u5151\u6362\u5b8c\u4e86");
            throw new ServiceException("\u5151\u6362\u5931\u8d25: \u6b64\u5151\u6362\u7801\u5df2\u7ecf\u88ab\u5151\u6362\u5b8c\u4e86");
        }
        if (exchangeVO.getTakeEffectTime() != null && (compare = newDate.compareTo(takeEffectTime = exchangeVO.getTakeEffectTime())) == -1) {
            log.error("\u73a9\u5bb6\u4f7f\u7528\u5151\u6362\u7801\u5931\u8d25:\u6b64\u5151\u6362\u7801\u672a\u5230\u5151\u6362\u65f6\u95f4; \u5151\u6362\u7801={},\u89d2\u8272id={},\u670d\u52a1\u5668id={}", new Object[]{exchangeUseConsumePO.getExchangeId(), exchangeUseConsumePO.getActorId(), exchangeUseConsumePO.getServerId()});
            this.exchangeUseLog(exchangeUseConsumePO, request, BaseSuccessFailEnums.FAIL.getValue().toString(), "\u5151\u6362\u5931\u8d25: \u5f53\u524d\u65f6\u95f4\u672a\u5230\u5151\u6362\u65f6\u95f4");
            throw new ServiceException("\u5151\u6362\u5931\u8d25: \u6b64\u5151\u6362\u7801\u5151\u6362\u65f6\u95f4\u4e3a: " + sdf.format(takeEffectTime));
        }
        if (exchangeVO.getExpireTime() != null && (compare = (expireTime = exchangeVO.getExpireTime()).compareTo(newDate)) == -1) {
            log.error("\u73a9\u5bb6\u4f7f\u7528\u5151\u6362\u7801\u5931\u8d25:\u6b64\u5151\u6362\u7801\u5df2\u8fc7\u671f; \u5151\u6362\u7801={},\u89d2\u8272id={},\u670d\u52a1\u5668id={}", new Object[]{exchangeUseConsumePO.getExchangeId(), exchangeUseConsumePO.getActorId(), exchangeUseConsumePO.getServerId()});
            this.exchangeUseLog(exchangeUseConsumePO, request, BaseSuccessFailEnums.FAIL.getValue().toString(), "\u5151\u6362\u5931\u8d25: \u6b64\u5151\u6362\u7801\u5df2\u8fc7\u671f");
            throw new ServiceException("\u5151\u6362\u5931\u8d25: \u6b64\u5151\u6362\u7801\u5df2\u8fc7\u671f");
        }
        return exchangeVO;
    }

    public void exchangeUseLog(ExchangeUseConsumePO exchangeUseConsumePO, HttpServletRequest request, String state, String stateDescribe) {
        String ipAddress = IPUtils.getIpAddr((HttpServletRequest)request);
        GameExchangeUseLog gameExchangeUseLog = new GameExchangeUseLog();
        BeanUtils.copyProperties((Object)exchangeUseConsumePO, (Object)gameExchangeUseLog);
        gameExchangeUseLog.setCallerIp(ipAddress);
        gameExchangeUseLog.setCreateBy(ipAddress);
        gameExchangeUseLog.setExchangeState(state);
        gameExchangeUseLog.setExchangeStateDescribe(stateDescribe);
        this.gameExchangeUseLogServiceImpl.insertGameExchangeUseLog(gameExchangeUseLog);
    }
}

