/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.server.controller.player;

import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.server.domain.GameUserPeriod;
import com.ruoyi.server.domain.po.player.GameUserFootprintAddPO;
import com.ruoyi.server.domain.po.player.GameUserFootprintQueryPO;
import com.ruoyi.server.domain.po.player.UserBehaviorReportPO;
import com.ruoyi.server.domain.po.player.UserExitPO;
import com.ruoyi.server.domain.vo.player.GameUserFootprintVO;
import com.ruoyi.server.service.player.IGameUserCorrelationService;
import com.ruoyi.server.service.player.IGameUserFootprintService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/userFootprint"})
public class GameUserFootprintController
extends BaseController {
    @Autowired
    private IGameUserFootprintService gameUserFootprintService;
    @Autowired
    private IGameUserCorrelationService iGameUserCorrelationService;

    @PostMapping(value={"/add"})
    public AjaxResult add(@Valid @RequestBody GameUserFootprintAddPO gameUserFootprintAddPO) {
        return this.toAjax(this.gameUserFootprintService.insertGameUserFootprint(gameUserFootprintAddPO));
    }

    @PostMapping(value={"/query"})
    public AjaxResult query(@Valid @RequestBody GameUserFootprintQueryPO gameUserFootprintQueryPO) {
        GameUserFootprintVO gameUserFootprintVO = this.gameUserFootprintService.queryGameUserFootprint(gameUserFootprintQueryPO);
        return AjaxResult.success((Object)gameUserFootprintVO);
    }

    @PostMapping(value={"/userPeriod"})
    public AjaxResult userPeriod(@Valid @RequestBody GameUserPeriod gameUserPeriod) {
        Boolean mark = this.iGameUserCorrelationService.insertUserPeriod(gameUserPeriod);
        return AjaxResult.success((Object)mark);
    }

    @PostMapping(value={"/userExit"})
    public AjaxResult userExit(@Valid @RequestBody UserExitPO userExitPO) {
        Boolean mark = this.gameUserFootprintService.userExit(userExitPO);
        return AjaxResult.success((Object)mark);
    }

    @PostMapping(value={"/userBehaviorReport"})
    public AjaxResult userBehaviorReport(@Valid @RequestBody UserBehaviorReportPO userBehaviorReportPO, HttpServletRequest request) {
        Map userToken = this.gameUserFootprintService.userBehaviorReport(userBehaviorReportPO, request);
        return AjaxResult.success((Object)userToken);
    }
}

