/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.utils;

import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.rearend.domain.RearServerConfig;
import com.ruoyi.rearend.domain.po.InterfaceSendPO;
import com.ruoyi.rearend.domain.po.player.BatchPlayerQueryPO;
import com.ruoyi.rearend.domain.vo.InterfaceCallVO;
import com.ruoyi.rearend.domain.vo.InterfaceSendVO;
import com.ruoyi.rearend.enums.BaseSuccessFailEnums;
import com.ruoyi.rearend.enums.BaseYesNoEnums;
import com.ruoyi.rearend.service.impl.server.RearServerServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class InterfaceSendUtils {
    @Autowired
    private RearServerServiceImpl rearServerServiceImpl;
    private static final Logger log = LoggerFactory.getLogger(InterfaceSendUtils.class);

    public List<RearServerConfig> serverSlicing(String districtServer) {
        int i;
        String poleTail;
        String poleHead;
        if (districtServer.contains("-") && districtServer.contains(",")) {
            poleHead = districtServer.substring(0, districtServer.indexOf("-"));
            poleTail = districtServer.substring(poleHead.length() + 1, districtServer.length());
            String commaHead = poleTail.substring(0, poleTail.indexOf(","));
            String commaTail = poleTail.substring(commaHead.length() + 1, poleTail.length());
            String serverIdString = "";
            for (i = Integer.valueOf(poleHead).intValue(); i < Integer.valueOf(commaHead) + 1; ++i) {
                serverIdString = serverIdString + i + ",";
            }
            districtServer = serverIdString + commaTail;
        } else if (districtServer.contains("-")) {
            poleHead = districtServer.substring(0, districtServer.indexOf("-"));
            poleTail = districtServer.substring(poleHead.length() + 1, districtServer.length());
            String serverIdString = "";
            for (int i2 = Integer.valueOf(poleHead).intValue(); i2 < Integer.valueOf(poleTail) + 1; ++i2) {
                serverIdString = serverIdString + i2 + ",";
            }
            districtServer = serverIdString.substring(0, serverIdString.length() - 1);
        }
        List<String> PlayerIdStringList = Arrays.asList(districtServer.split(","));
        HashSet<String> stringSet = new HashSet<String>(PlayerIdStringList);
        if (PlayerIdStringList.size() != stringSet.size()) {
            throw new ServiceException("\u5b58\u5728\u91cd\u590d\u7684\u670d\u52a1\u5668id,\u8bf7\u786e\u8ba4\u540e\u63d0\u4ea4");
        }
        List rearServerConfigList = this.rearServerServiceImpl.serverIdQueryList(PlayerIdStringList);
        List rearServerConfigIdList = rearServerConfigList.stream().map(RearServerConfig::getServerId).collect(Collectors.toList());
        ArrayList<String> undeclaredList = new ArrayList<String>();
        for (i = 0; i < PlayerIdStringList.size(); ++i) {
            if (rearServerConfigIdList.contains(PlayerIdStringList.get(i))) continue;
            undeclaredList.add(PlayerIdStringList.get(i));
        }
        if (undeclaredList != null && undeclaredList.size() > 0) {
            throw new ServiceException("\u6b64\u670d\u52a1\u5668id: " + undeclaredList + " \u65e0ip\u4e0a\u62a5\u4fe1\u606f,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return rearServerConfigList;
    }

    public Map<String, List<String>> pidGidIntercept(String channelGame) {
        HashMap<String, List<String>> pidGidList = new HashMap<String, List<String>>();
        List<String> playerIdStringList = Arrays.asList(channelGame.split("\n"));
        String intercept = "|";
        for (int i = 0; i < playerIdStringList.size(); ++i) {
            String pid = "";
            if (!playerIdStringList.get(i).contains(intercept)) {
                throw new ServiceException("pid\u6709\u8bef,\u8bf7\u91cd\u65b0\u8f93\u5165\u540e\u518d\u8bd5");
            }
            pid = playerIdStringList.get(i).substring(0, playerIdStringList.get(i).indexOf(intercept));
            String gid = playerIdStringList.get(i).substring(pid.length() + 1, playerIdStringList.get(i).length());
            List<Object> gidList = new ArrayList();
            gidList = Arrays.asList(gid.split(","));
            pidGidList.put(pid, gidList);
        }
        return pidGidList;
    }

    public String serverUrlAddress(String serverId, String urlAddress) {
        Integer serviceId = Integer.valueOf(serverId);
        RearServerConfig RearServerConfig2 = this.rearServerServiceImpl.serverIdQuery(String.valueOf(serviceId));
        if (RearServerConfig2 == null || StringUtils.isEmpty((String)RearServerConfig2.getServerIp())) {
            throw new ServiceException("\u6b64\u670d\u52a1\u5668\u65e0ip\u4e0a\u62a5\u4fe1\u606f,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String serverIp = RearServerConfig2.getServerIp();
        Integer serverPort = RearServerConfig2.getServerPort();
        String visitUrl = "http://" + serverIp + ":" + serverPort + "/" + urlAddress;
        return visitUrl;
    }

    public InterfaceSendVO interfaceSend(InterfaceSendPO interfaceSendPO) {
        InterfaceSendVO interfaceSendVO = new InterfaceSendVO();
        String logDescribe = "\u8c03\u7528" + interfaceSendPO.getInterfaceDescribe() + "\u63a5\u53e3";
        try {
            log.info(logDescribe + ": \u5165\u53c2={}", (Object)interfaceSendPO.getPrintMap());
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity formEntity = new HttpEntity((Object)interfaceSendPO.getSuppliedMap(), (MultiValueMap)headers);
            interfaceSendVO = (InterfaceSendVO)restTemplate.postForObject(interfaceSendPO.getVisitUrl(), (Object)formEntity, InterfaceSendVO.class, new Object[0]);
            log.info(logDescribe + ": Api\u51fa\u53c2 code={},msg={}", (Object)interfaceSendVO.getCode(), (Object)interfaceSendVO.getMessage());
        }
        catch (Exception e) {
            log.error(logDescribe + "\u5f02\u5e38: e\u5f02\u5e38={}", (Throwable)e);
            log.error(logDescribe + "\u5f02\u5e38: \u5165\u53c2={}", (Object)interfaceSendPO.getPrintMap());
            interfaceSendVO.setState(Boolean.valueOf(BaseYesNoEnums.NO.getValue()));
            interfaceSendVO.setMsg(logDescribe + "\u5931\u8d25");
            return interfaceSendVO;
        }
        if (interfaceSendVO == null || interfaceSendVO.getCode() != BaseSuccessFailEnums.SUCCESS.getValue()) {
            log.error(logDescribe + "\u5931\u8d25: \u5165\u53c2={},\u51fa\u53c2={}", (Object)interfaceSendPO.getPrintMap(), (Object)interfaceSendVO);
            interfaceSendVO.setState(Boolean.valueOf(BaseYesNoEnums.NO.getValue()));
            interfaceSendVO.setMsg(logDescribe + "\u5931\u8d25");
            return interfaceSendVO;
        }
        interfaceSendVO.setState(Boolean.valueOf(BaseYesNoEnums.YES.getValue()));
        interfaceSendVO.setMsg(logDescribe + "\u6210\u529f");
        return interfaceSendVO;
    }

    public InterfaceCallVO interfaceCall(Integer successNumber, Integer errorNumber, List<InterfaceSendVO> interfaceSendVOList) {
        InterfaceCallVO interfaceCallVO = new InterfaceCallVO();
        interfaceCallVO.setSuccessNumber(successNumber);
        interfaceCallVO.setFailNumber(errorNumber);
        String describe = "";
        for (InterfaceSendVO interfaceSendVO : interfaceSendVOList) {
            describe = describe + "\u670d\u52a1\u5668id: " + interfaceSendVO.getServerId() + "; \u662f\u5426\u6210\u529f: " + interfaceSendVO.getState() + "; \u63cf\u8ff0: " + interfaceSendVO.getMsg() + ";\n";
        }
        interfaceCallVO.setDescribe(describe);
        return interfaceCallVO;
    }

    public List<BatchPlayerQueryPO> manyServerPlayerHandle(String userPlayerId) {
        List<Object> serverList = new ArrayList();
        ArrayList<BatchPlayerQueryPO> batchPlayerQueryPOList = new ArrayList<BatchPlayerQueryPO>();
        serverList = Arrays.asList(userPlayerId.split("\n"));
        for (int i = 0; i < serverList.size(); ++i) {
            BatchPlayerQueryPO batchPlayerQueryPOBatch = new BatchPlayerQueryPO();
            String userPlayerIdFor = "";
            List<Object> userList = new ArrayList();
            userList = Arrays.asList(((String)serverList.get(i)).split(","));
            for (int j = 0; j < userList.size(); ++j) {
                batchPlayerQueryPOBatch.setServerId((String)userList.get(0));
                if (j == 0) continue;
                userPlayerIdFor = userPlayerIdFor + (String)userList.get(j) + "\n";
            }
            batchPlayerQueryPOBatch.setUserPlayerId(userPlayerIdFor);
            batchPlayerQueryPOList.add(batchPlayerQueryPOBatch);
        }
        return batchPlayerQueryPOList;
    }
}

