/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.utils;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;

/*
 * Exception performing whole class analysis ignored.
 */
public class IdWorker {
    private final long twepoch = 1651722037880L;
    private final long workerIdBits = 5L;
    private final long datacenterIdBits = 5L;
    private final long maxWorkerId = 31L;
    private final long maxDatacenterId = 31L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long datacenterIdShift = 17L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 4095L;
    private long workerId;
    private long datacenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private static IdWorker idWorker = new IdWorker();

    public IdWorker() {
        this.datacenterId = IdWorker.getDatacenterId((long)31L);
        this.workerId = IdWorker.getMaxWorkerId((long)this.datacenterId, (long)31L);
    }

    private IdWorker(long workerId, long datacenterId) {
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 31L));
        }
        if (datacenterId > 31L || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 31L));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
    }

    private synchronized long nextId() {
        long timestamp = this.timeGen();
        timestamp = this.generateId(timestamp);
        return timestamp - 1651722037880L << 22 | this.datacenterId << 17 | this.workerId << 12 | this.sequence;
    }

    private long generateId(long timestamp) {
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp;
    }

    private synchronized String generateNextId() {
        long timestamp = this.timeGen();
        timestamp = this.generateId(timestamp);
        return String.valueOf(timestamp - 1651722037880L << 22 | this.datacenterId << 17 | this.workerId << 12 | this.sequence);
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    protected static long getMaxWorkerId(long datacenterId, long maxWorkerId) {
        StringBuffer mpid = new StringBuffer();
        mpid.append(datacenterId);
        String name = ManagementFactory.getRuntimeMXBean().getName();
        if (!name.isEmpty()) {
            mpid.append(name.split("@")[0]);
        }
        return (long)(mpid.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
    }

    protected static long getDatacenterId(long maxDatacenterId) {
        long id = 0L;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network == null) {
                id = 1L;
            } else {
                byte[] mac = network.getHardwareAddress();
                id = (0xFFL & (long)mac[mac.length - 1] | 0xFF00L & (long)mac[mac.length - 2] << 8) >> 6;
                id %= maxDatacenterId + 1L;
            }
        }
        catch (Exception e) {
            System.out.println(" getDatacenterId: " + e.getMessage());
        }
        return id;
    }

    public static String createPrefix(Integer num) {
        String randomPrefix = "";
        for (int i = 0; i < num; ++i) {
            char c = (char)(Math.random() * 26.0 + 65.0);
            randomPrefix = randomPrefix + c;
        }
        return randomPrefix;
    }

    public static String lowerCreatePrefix(Integer num) {
        String randomPrefix = "";
        for (int i = 0; i < num; ++i) {
            char c = (char)(Math.random() * 26.0 + 97.0);
            randomPrefix = randomPrefix + c;
        }
        return randomPrefix;
    }

    public static Integer randomNumber(int length) {
        return new Double(Math.random() * (Math.pow(10.0, length) - Math.pow(10.0, length - 1)) + Math.pow(10.0, length - 1)).intValue();
    }

    public static String getOrderNo(Integer num) {
        return IdWorker.createPrefix((Integer)num) + idWorker.nextId();
    }

    public static String getNextId() {
        return Long.toString(idWorker.nextId());
    }

    public static void main(String[] args) {
        System.out.println("ID:" + IdWorker.getNextId());
    }
}

