/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.utils;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class IPUtils {
    private static Logger logger = LoggerFactory.getLogger(IPUtils.class);
    private static final String IP_UTILS_FLAG = ",";
    private static final String UNKNOWN = "unknown";
    private static final String LOCALHOST_IP = "0:0:0:0:0:0:0:1";
    private static final String LOCALHOST_IP1 = "127.0.0.1";

    public static String getIpAddr(HttpServletRequest request) {
        String ip;
        block11: {
            ip = null;
            try {
                ip = request.getHeader("X-Original-Forwarded-For");
                if (StringUtils.isEmpty((Object)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("X-Forwarded-For");
                }
                if (StringUtils.isEmpty((Object)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("x-forwarded-for");
                }
                if (StringUtils.isEmpty((Object)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("Proxy-Client-IP");
                }
                if (StringUtils.isEmpty((Object)ip) || ip.length() == 0 || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("WL-Proxy-Client-IP");
                }
                if (StringUtils.isEmpty((Object)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_CLIENT_IP");
                }
                if (StringUtils.isEmpty((Object)ip) || UNKNOWN.equalsIgnoreCase(ip)) {
                    ip = request.getHeader("HTTP_X_FORWARDED_FOR");
                }
                if (!StringUtils.isEmpty((Object)ip) && !UNKNOWN.equalsIgnoreCase(ip) || !LOCALHOST_IP1.equalsIgnoreCase(ip = request.getRemoteAddr()) && !LOCALHOST_IP.equalsIgnoreCase(ip)) break block11;
                InetAddress iNet = null;
                try {
                    iNet = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    logger.error("getClientIp error: {}", (Throwable)e);
                }
                ip = iNet.getHostAddress();
            }
            catch (Exception e) {
                logger.error("IPUtils ERROR ", (Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((Object)ip) && ip.indexOf(IP_UTILS_FLAG) > 0) {
            ip = ip.substring(0, ip.indexOf(IP_UTILS_FLAG));
        }
        return ip;
    }
}

