/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.subsystem;

import com.ruoyi.rearend.domain.po.InterfaceSendPO;
import com.ruoyi.rearend.domain.po.subsystem.UserAddPO;
import com.ruoyi.rearend.domain.po.subsystem.UserDeletePO;
import com.ruoyi.rearend.domain.po.subsystem.UserPasswordResetPO;
import com.ruoyi.rearend.domain.po.subsystem.UserUpdatePO;
import com.ruoyi.rearend.domain.vo.InterfaceSendVO;
import com.ruoyi.rearend.domain.vo.subsystem.ProjectUrlVO;
import com.ruoyi.rearend.enums.subsystem.CallReturnEnums;
import com.ruoyi.rearend.enums.subsystem.ProjectUrlEnums;
import com.ruoyi.rearend.service.impl.subsystem.IProjectDistinguishServiceImpl;
import com.ruoyi.rearend.service.subsystem.IProjectUserService;
import com.ruoyi.rearend.utils.SubsystemSyncUtils;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IProjectUserServiceImpl
implements IProjectUserService {
    @Autowired
    private SubsystemSyncUtils subsystemSyncUtils;
    @Autowired
    private IProjectDistinguishServiceImpl iProjectDistinguishServiceImpl;
    private final String port = ":9201";
    private static final Logger log = LoggerFactory.getLogger(IProjectUserServiceImpl.class);

    public Boolean userAdd(UserAddPO userAddPO) {
        List projectUrlVOList = this.iProjectDistinguishServiceImpl.serverProjectUrl();
        for (ProjectUrlVO projectUrlVO : projectUrlVOList) {
            if (!projectUrlVO.getUrlMark().equals(ProjectUrlEnums.ASSEMBLE.getUrlMark())) continue;
            this.userAddCall(userAddPO, projectUrlVO.getWithinUrlAddress());
        }
        return true;
    }

    public Boolean userUpdate(UserUpdatePO userUpdatePO) {
        List projectUrlVOList = this.iProjectDistinguishServiceImpl.serverProjectUrl();
        for (ProjectUrlVO projectUrlVO : projectUrlVOList) {
            if (!projectUrlVO.getUrlMark().equals(ProjectUrlEnums.ASSEMBLE.getUrlMark())) continue;
            this.userUpdateCall(userUpdatePO, projectUrlVO.getWithinUrlAddress());
        }
        return true;
    }

    public Boolean userPasswordReset(UserPasswordResetPO userPasswordResetPO) {
        List projectUrlVOList = this.iProjectDistinguishServiceImpl.serverProjectUrl();
        for (ProjectUrlVO projectUrlVO : projectUrlVOList) {
            if (!projectUrlVO.getUrlMark().equals(ProjectUrlEnums.ASSEMBLE.getUrlMark())) continue;
            this.userPasswordResetCall(userPasswordResetPO, projectUrlVO.getWithinUrlAddress());
        }
        return true;
    }

    public Boolean userDelete(UserDeletePO userDeletePO) {
        List projectUrlVOList = this.iProjectDistinguishServiceImpl.serverProjectUrl();
        for (ProjectUrlVO projectUrlVO : projectUrlVOList) {
            if (!projectUrlVO.getUrlMark().equals(ProjectUrlEnums.ASSEMBLE.getUrlMark())) continue;
            this.userDeleteCall(userDeletePO, projectUrlVO.getWithinUrlAddress());
        }
        return true;
    }

    public Boolean userAddCall(UserAddPO userAddPO, String projectUrl) {
        String visitUrl = "http://" + projectUrl + ":9201" + "/userForeign/userAdd";
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        interfaceSendPO.setVisitUrl(visitUrl);
        interfaceSendPO.setInterfaceDescribe("\u5404\u9879\u76ee\u7528\u6237\u65b0\u589e");
        HashMap<String, Object> suppliedMap = new HashMap<String, Object>();
        suppliedMap.put("nickName", userAddPO.getNickName());
        suppliedMap.put("password", userAddPO.getPassword());
        suppliedMap.put("status", userAddPO.getStatus());
        suppliedMap.put("userName", userAddPO.getUserName());
        suppliedMap.put("email", userAddPO.getEmail());
        suppliedMap.put("phonenumber", userAddPO.getPhonenumber());
        suppliedMap.put("remark", userAddPO.getRemark());
        suppliedMap.put("roleIds", userAddPO.getRoleIds());
        suppliedMap.put("syncSwitch", false);
        suppliedMap.put("projectMark", ProjectUrlEnums.XIU_XIAN.getUrlMark());
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, Object> printMap = new HashMap<String, Object>();
        printMap.put("password", userAddPO.getPassword());
        printMap.put("status", userAddPO.getStatus());
        printMap.put("userName", userAddPO.getUserName());
        printMap.put("syncSwitch", false);
        printMap.put("projectMark", ProjectUrlEnums.XIU_XIAN.getUrlMark());
        interfaceSendPO.setPrintMap(printMap);
        InterfaceSendVO interfaceSendVO = this.subsystemSyncUtils.interfaceSend(interfaceSendPO);
        if (interfaceSendVO != null && !interfaceSendVO.getCode().equals(CallReturnEnums.SUCCESS.getValue())) {
            log.error("\u9879\u76ee\u7528\u6237\u65b0\u589e\u5931\u8d25: userAddPO={},url={}", (Object)userAddPO, (Object)visitUrl);
        }
        return true;
    }

    public Boolean userUpdateCall(UserUpdatePO userUpdatePO, String projectUrl) {
        String visitUrl = "http://" + projectUrl + ":9201" + "/userForeign/userUpdate";
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        interfaceSendPO.setVisitUrl(visitUrl);
        interfaceSendPO.setInterfaceDescribe("\u5404\u9879\u76ee\u7528\u6237\u4fee\u6539");
        HashMap<String, Object> suppliedMap = new HashMap<String, Object>();
        suppliedMap.put("nickName", userUpdatePO.getNickName());
        suppliedMap.put("password", userUpdatePO.getPassword());
        suppliedMap.put("status", userUpdatePO.getStatus());
        suppliedMap.put("userName", userUpdatePO.getUserName());
        suppliedMap.put("email", userUpdatePO.getEmail());
        suppliedMap.put("phonenumber", userUpdatePO.getPhonenumber());
        suppliedMap.put("remark", userUpdatePO.getRemark());
        suppliedMap.put("roleIds", userUpdatePO.getRoleIds());
        suppliedMap.put("syncSwitch", false);
        suppliedMap.put("projectMark", ProjectUrlEnums.XIU_XIAN.getUrlMark());
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, Object> printMap = new HashMap<String, Object>();
        printMap.put("password", userUpdatePO.getPassword());
        printMap.put("status", userUpdatePO.getStatus());
        printMap.put("userName", userUpdatePO.getUserName());
        printMap.put("syncSwitch", false);
        printMap.put("projectMark", ProjectUrlEnums.XIU_XIAN.getUrlMark());
        interfaceSendPO.setPrintMap(printMap);
        InterfaceSendVO interfaceSendVO = this.subsystemSyncUtils.interfaceSend(interfaceSendPO);
        if (interfaceSendVO != null && !interfaceSendVO.getCode().equals(CallReturnEnums.SUCCESS.getValue())) {
            log.error("\u9879\u76ee\u7528\u6237\u4fee\u6539\u5931\u8d25: userUpdatePO={}", (Object)userUpdatePO);
        }
        return true;
    }

    public Boolean userPasswordResetCall(UserPasswordResetPO userPasswordResetPO, String projectUrl) {
        String visitUrl = "http://" + projectUrl + ":9201" + "/userForeign/userPasswordReset";
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        interfaceSendPO.setVisitUrl(visitUrl);
        interfaceSendPO.setInterfaceDescribe("\u5404\u9879\u76ee\u7528\u6237\u5bc6\u7801\u91cd\u7f6e");
        HashMap<String, Object> suppliedMap = new HashMap<String, Object>();
        suppliedMap.put("nickName", userPasswordResetPO.getNickName());
        suppliedMap.put("password", userPasswordResetPO.getPassword());
        suppliedMap.put("status", userPasswordResetPO.getStatus());
        suppliedMap.put("userName", userPasswordResetPO.getUserName());
        suppliedMap.put("syncSwitch", false);
        suppliedMap.put("projectMark", ProjectUrlEnums.XIU_XIAN.getUrlMark());
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, Object> printMap = new HashMap<String, Object>();
        printMap.put("nickName", userPasswordResetPO.getNickName());
        printMap.put("password", userPasswordResetPO.getPassword());
        printMap.put("status", userPasswordResetPO.getStatus());
        printMap.put("userName", userPasswordResetPO.getUserName());
        printMap.put("syncSwitch", false);
        printMap.put("projectMark", ProjectUrlEnums.XIU_XIAN.getUrlMark());
        interfaceSendPO.setPrintMap(printMap);
        InterfaceSendVO interfaceSendVO = this.subsystemSyncUtils.interfaceSend(interfaceSendPO);
        if (interfaceSendVO != null && !interfaceSendVO.getCode().equals(CallReturnEnums.SUCCESS.getValue())) {
            log.error("\u9879\u76ee\u7528\u6237\u5bc6\u7801\u91cd\u7f6e\u5931\u8d25: userPasswordResetPO={}", (Object)userPasswordResetPO);
        }
        return true;
    }

    public Boolean userDeleteCall(UserDeletePO userDeletePO, String projectUrl) {
        String visitUrl = "http://" + projectUrl + ":9201" + "/userForeign/userDelete";
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        interfaceSendPO.setVisitUrl(visitUrl);
        interfaceSendPO.setInterfaceDescribe("\u5404\u9879\u76ee\u7528\u6237\u5220\u9664");
        HashMap<String, Object> suppliedMap = new HashMap<String, Object>();
        suppliedMap.put("nickName", userDeletePO.getNickName());
        suppliedMap.put("password", userDeletePO.getPassword());
        suppliedMap.put("status", userDeletePO.getStatus());
        suppliedMap.put("userName", userDeletePO.getUserName());
        suppliedMap.put("syncSwitch", false);
        suppliedMap.put("projectMark", ProjectUrlEnums.XIU_XIAN.getUrlMark());
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, Object> printMap = new HashMap<String, Object>();
        printMap.put("nickName", userDeletePO.getNickName());
        printMap.put("password", userDeletePO.getPassword());
        printMap.put("status", userDeletePO.getStatus());
        printMap.put("userName", userDeletePO.getUserName());
        printMap.put("syncSwitch", false);
        printMap.put("projectMark", ProjectUrlEnums.XIU_XIAN.getUrlMark());
        interfaceSendPO.setPrintMap(printMap);
        InterfaceSendVO interfaceSendVO = this.subsystemSyncUtils.interfaceSend(interfaceSendPO);
        if (interfaceSendVO != null && !interfaceSendVO.getCode().equals(CallReturnEnums.SUCCESS.getValue())) {
            log.error("\u9879\u76ee\u7528\u6237\u5220\u9664\u5931\u8d25: userDeletePO={}", (Object)userDeletePO);
        }
        return true;
    }
}

