/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.subsystem;

import com.alibaba.fastjson.JSON;
import com.ruoyi.common.redis.service.RedisService;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.po.InterfaceSendPO;
import com.ruoyi.rearend.domain.vo.InterfaceSendVO;
import com.ruoyi.rearend.domain.vo.subsystem.ProjectLogOnVO;
import com.ruoyi.rearend.domain.vo.subsystem.ProjectUrlVO;
import com.ruoyi.rearend.enums.subsystem.CallReturnEnums;
import com.ruoyi.rearend.enums.subsystem.ProjectUrlEnums;
import com.ruoyi.rearend.service.subsystem.IProjectDistinguishService;
import com.ruoyi.rearend.utils.SubsystemSyncUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class IProjectDistinguishServiceImpl
implements IProjectDistinguishService {
    @Value(value="${meta.data.primary-service-url}")
    private String primaryServiceUrl;
    @Autowired
    private RedisService redisService;
    @Autowired
    private SubsystemSyncUtils subsystemSyncUtils;
    private static final Logger log = LoggerFactory.getLogger(IProjectDistinguishServiceImpl.class);

    public List<ProjectUrlVO> serverProjectUrl() {
        String visitUrl = this.primaryServiceUrl + "/userForeign/projectUrl";
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        interfaceSendPO.setVisitUrl(visitUrl);
        interfaceSendPO.setInterfaceDescribe("\u8bf7\u6c42\u6240\u6709\u9879\u76ee\u5730\u5740");
        HashMap suppliedMap = new HashMap();
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap printMap = new HashMap();
        interfaceSendPO.setPrintMap(printMap);
        InterfaceSendVO interfaceSendVO = this.subsystemSyncUtils.interfaceSend(interfaceSendPO);
        if (interfaceSendVO != null && !interfaceSendVO.getCode().equals(CallReturnEnums.SUCCESS.getValue())) {
            log.error("\u8bf7\u6c42\u6240\u6709\u9879\u76ee\u5730\u5740\u5931\u8d25: interfaceSendVO={}", (Object)interfaceSendVO);
        }
        String jsonString = JSON.toJSONString((Object)interfaceSendVO.getData());
        List projectUrlVOList = new ArrayList();
        projectUrlVOList = JSON.parseArray((String)jsonString, ProjectUrlVO.class);
        ArrayList<ProjectUrlVO> projectUrlVOSortList = new ArrayList<ProjectUrlVO>();
        ArrayList<ProjectUrlVO> projectUrlVOResidueList = new ArrayList<ProjectUrlVO>();
        for (ProjectUrlVO projectUrlVO : projectUrlVOList) {
            if (projectUrlVO.getProjectUrl().equals(ProjectUrlEnums.XIU_XIAN.getOutsideUrlAddress())) {
                projectUrlVOSortList.add(projectUrlVO);
                continue;
            }
            projectUrlVOResidueList.add(projectUrlVO);
        }
        projectUrlVOSortList.addAll(projectUrlVOResidueList);
        return projectUrlVOSortList;
    }

    public List<ProjectUrlVO> serverProjectScreenUrl() {
        String visitUrl = this.primaryServiceUrl + "/userForeign/projectScreenUrl";
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        interfaceSendPO.setVisitUrl(visitUrl);
        interfaceSendPO.setInterfaceDescribe("\u8bf7\u6c42\u7b5b\u9009\u9879\u76ee\u5730\u5740");
        HashMap<String, String> suppliedMap = new HashMap<String, String>();
        suppliedMap.put("userName", SecurityUtils.getUsername());
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, String> printMap = new HashMap<String, String>();
        printMap.put("userName", SecurityUtils.getUsername());
        interfaceSendPO.setPrintMap(printMap);
        InterfaceSendVO interfaceSendVO = this.subsystemSyncUtils.interfaceSend(interfaceSendPO);
        if (interfaceSendVO != null && !interfaceSendVO.getCode().equals(CallReturnEnums.SUCCESS.getValue())) {
            log.error("\u8bf7\u6c42\u7b5b\u9009\u9879\u76ee\u5730\u5740\u5931\u8d25: interfaceSendVO={}", (Object)interfaceSendVO);
        }
        String jsonString = JSON.toJSONString((Object)interfaceSendVO.getData());
        List projectUrlVOList = new ArrayList();
        projectUrlVOList = JSON.parseArray((String)jsonString, ProjectUrlVO.class);
        ArrayList<ProjectUrlVO> projectUrlVOSortList = new ArrayList<ProjectUrlVO>();
        ArrayList<ProjectUrlVO> projectUrlVOResidueList = new ArrayList<ProjectUrlVO>();
        for (ProjectUrlVO projectUrlVO : projectUrlVOList) {
            if (projectUrlVO.getProjectUrl().equals(ProjectUrlEnums.XIU_XIAN.getOutsideUrlAddress())) {
                projectUrlVOSortList.add(projectUrlVO);
                continue;
            }
            projectUrlVOResidueList.add(projectUrlVO);
        }
        projectUrlVOSortList.addAll(projectUrlVOResidueList);
        return projectUrlVOSortList;
    }

    public ProjectLogOnVO serverProjectLogOn(String projectUrl) {
        ProjectLogOnVO projectLogOnVO = new ProjectLogOnVO();
        String operName = SecurityUtils.getUsername();
        String password = (String)this.redisService.getCacheObject(operName);
        String urlHandle = "http://" + projectUrl + "/login?account=" + operName + "&password=" + password;
        projectLogOnVO.setAccount(operName);
        projectLogOnVO.setPassword(password);
        projectLogOnVO.setProjectUrl(urlHandle);
        String visitUrl = this.primaryServiceUrl + "/userForeign/serverProjectLogOn";
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        interfaceSendPO.setVisitUrl(visitUrl);
        interfaceSendPO.setInterfaceDescribe("\u8bf7\u6c42\u603b\u540e\u7aef\u8bb0\u5f55\u8df3\u8f6c");
        HashMap<String, String> suppliedMap = new HashMap<String, String>();
        suppliedMap.put("projectUrl", projectUrl);
        suppliedMap.put("userName", operName);
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, String> printMap = new HashMap<String, String>();
        printMap.put("projectUrl", projectUrl);
        printMap.put("userName", operName);
        interfaceSendPO.setPrintMap(printMap);
        InterfaceSendVO interfaceSendVO = this.subsystemSyncUtils.interfaceSend(interfaceSendPO);
        return projectLogOnVO;
    }
}

