/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.statistics;

import com.alibaba.nacos.shaded.com.google.gson.Gson;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.rearend.domain.GameUserDuration;
import com.ruoyi.rearend.domain.po.statistics.DistributionDetailsPO;
import com.ruoyi.rearend.domain.po.statistics.HomePageSqlPO;
import com.ruoyi.rearend.domain.po.statistics.UserRoleDurationPO;
import com.ruoyi.rearend.domain.vo.statistics.UserRoleDurationVO;
import com.ruoyi.rearend.mapper.statistics.GameUserDurationMapper;
import com.ruoyi.rearend.mapper.statistics.HomePageMapper;
import com.ruoyi.rearend.service.impl.statistics.HomePageUtils;
import com.ruoyi.rearend.service.statistics.IUserRoleDurationService;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserRoleDurationServiceImpl
implements IUserRoleDurationService {
    @Autowired
    private HomePageUtils homePageUtils;
    @Autowired
    private HomePageMapper homePageMapper;
    @Autowired
    private GameUserDurationMapper gameUserDurationMapper;
    private static ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 12, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(1000), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());

    public List<UserRoleDurationVO> distribution(UserRoleDurationPO userRoleDurationPO) {
        ArrayList<UserRoleDurationVO> userRoleDurationVOList = new ArrayList<UserRoleDurationVO>();
        List timeList = this.homePageUtils.timeHandle(userRoleDurationPO.getTimeHead(), userRoleDurationPO.getTimeTail());
        Collections.reverse(timeList);
        try {
            for (int i = 0; i < timeList.size(); ++i) {
                HomePageSqlPO homePageSqlPO = new HomePageSqlPO();
                BeanUtils.copyProperties((Object)userRoleDurationPO, (Object)homePageSqlPO);
                homePageSqlPO.setSpecificDate((String)timeList.get(i));
                homePageSqlPO.setTimeHead((String)timeList.get(i) + " 00:00:00");
                homePageSqlPO.setTimeTail((String)timeList.get(i) + " 23:59:59");
                HashMap<String, Integer> recordMap = new HashMap<String, Integer>();
                recordMap.put("0-6", 0);
                recordMap.put("6-10", 0);
                recordMap.put("10-15", 0);
                recordMap.put("15-30", 0);
                recordMap.put("30-45", 0);
                recordMap.put("45-60", 0);
                recordMap.put("60-90", 0);
                recordMap.put("90-120", 0);
                recordMap.put("120-180", 0);
                recordMap.put("180-240", 0);
                recordMap.put("240-1441", 0);
                HashMap<String, String> markMap = new HashMap<String, String>();
                markMap.put("date1", "0-6");
                markMap.put("date2", "6-10");
                markMap.put("date3", "10-15");
                markMap.put("date4", "15-30");
                markMap.put("date5", "30-45");
                markMap.put("date6", "45-60");
                markMap.put("date7", "60-90");
                markMap.put("date8", "90-120");
                markMap.put("date9", "120-180");
                markMap.put("date10", "180-240");
                markMap.put("date11", "240-1441");
                UserRoleDurationVO userRoleDurationVO = new UserRoleDurationVO();
                userRoleDurationVO = (UserRoleDurationVO)this.distributionFactory(recordMap, markMap, homePageSqlPO, userRoleDurationPO.getOperationType()).get();
                userRoleDurationVOList.add(userRoleDurationVO);
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u65b0\u589e\u89d2\u8272\u5728\u7ebf\u65f6\u957f\u5206\u5e03\u7edf\u8ba1\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        return userRoleDurationVOList;
    }

    public Future<UserRoleDurationVO> distributionFactory(Map<String, Integer> recordMap, Map<String, String> markMap, HomePageSqlPO homePageSqlPO, Boolean operationType) {
        return executorService.submit(() -> {
            UserRoleDurationVO userRoleDurationVO = new UserRoleDurationVO();
            userRoleDurationVO.setSpecificDate(homePageSqlPO.getSpecificDate());
            DecimalFormat df = new DecimalFormat("######0.00");
            try {
                List gameUserDurationList;
                Integer queryRoleNumber = 0;
                if (operationType.booleanValue()) {
                    List userRoleIdList = this.homePageMapper.queryUserRoleId(homePageSqlPO);
                    queryRoleNumber = userRoleIdList.size();
                    homePageSqlPO.setUserRoleIdList(userRoleIdList);
                    if (queryRoleNumber == null || queryRoleNumber == 0) {
                        return userRoleDurationVO;
                    }
                }
                if ((gameUserDurationList = this.gameUserDurationMapper.queryUserRoleIdDurationList(homePageSqlPO)) == null || gameUserDurationList.size() == 0) {
                    return userRoleDurationVO;
                }
                if (!operationType.booleanValue()) {
                    queryRoleNumber = gameUserDurationList.size();
                }
                Date newDate = new Date();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                for (Object gameUserDuration : gameUserDurationList) {
                    long l = 0L;
                    if (gameUserDuration.getLogOnTime() != null && gameUserDuration.getExitTime() == null) {
                        if (sdf.format(new Date()).equals(gameUserDuration.getDurationTime())) {
                            gameUserDuration.setExitTime(newDate);
                            long diffInMillies = Math.abs(gameUserDuration.getExitTime().getTime() - gameUserDuration.getLogOnTime().getTime());
                            l += TimeUnit.MINUTES.convert(diffInMillies, TimeUnit.MILLISECONDS);
                        } else {
                            l += 1440L;
                        }
                    } else {
                        long diffInMillies = Math.abs(gameUserDuration.getExitTime().getTime() - gameUserDuration.getLogOnTime().getTime());
                        l += TimeUnit.MINUTES.convert(diffInMillies, TimeUnit.MILLISECONDS);
                    }
                    String key = null;
                    Integer keyEnd = 0;
                    Integer keyIndex = 0;
                    for (Map.Entry entry : recordMap.entrySet()) {
                        key = (String)entry.getKey();
                        keyIndex = key.indexOf("-");
                        Integer keyHead = Integer.valueOf(key.substring(0, key.lastIndexOf("-")));
                        keyEnd = Integer.valueOf(key.substring(keyIndex + 1));
                        if (l < (long)keyHead.intValue() || l >= (long)keyEnd.intValue()) continue;
                        entry.setValue((Integer)entry.getValue() + 1);
                    }
                }
                HashMap tableMap = new HashMap();
                for (Map.Entry entry : markMap.entrySet()) {
                    double rateDouble = (double)((Integer)recordMap.get(entry.getValue())).intValue() / (double)queryRoleNumber.intValue() * 100.0;
                    String montage = (Integer)recordMap.get(entry.getValue()) + " / " + df.format(rateDouble) + "%";
                    tableMap.put(entry.getKey(), montage);
                }
                Gson gson = new Gson();
                String string = gson.toJson(tableMap);
                userRoleDurationVO = (UserRoleDurationVO)gson.fromJson(string, UserRoleDurationVO.class);
                userRoleDurationVO.setSpecificDate(homePageSqlPO.getSpecificDate());
                userRoleDurationVO.setRoleNumber(queryRoleNumber);
            }
            catch (Exception e) {
                throw new ServiceException("\u7ebf\u7a0b\u6c60\u5f02\u5e38: \u67e5\u8be2\u65b0\u589e\u89d2\u8272\u5728\u7ebf\u65f6\u957f\u5206\u5e03\u5f02\u5e38!");
            }
            return userRoleDurationVO;
        });
    }

    public TableDataInfo distributionDetails(DistributionDetailsPO distributionDetailsPO) {
        List gameUserDurationList;
        TableDataInfo tableDataInfo = new TableDataInfo();
        tableDataInfo.setRows(new ArrayList());
        HomePageSqlPO homePageSqlPO = new HomePageSqlPO();
        BeanUtils.copyProperties((Object)distributionDetailsPO, (Object)homePageSqlPO);
        if (distributionDetailsPO.getOperationType().booleanValue()) {
            List userRoleIdList = this.homePageMapper.queryUserRoleId(homePageSqlPO);
            Integer queryRoleNumber = userRoleIdList.size();
            homePageSqlPO.setUserRoleIdList(userRoleIdList);
            if (queryRoleNumber == null || queryRoleNumber == 0) {
                return tableDataInfo;
            }
        }
        if ((gameUserDurationList = this.gameUserDurationMapper.queryUserRoleIdDurationList(homePageSqlPO)) == null || gameUserDurationList.size() == 0) {
            return tableDataInfo;
        }
        ArrayList<GameUserDuration> gameUserDurationFilterList = new ArrayList<GameUserDuration>();
        Date newDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (GameUserDuration gameUserDuration : gameUserDurationList) {
            long playtime = 0L;
            if (gameUserDuration.getLogOnTime() != null && gameUserDuration.getExitTime() == null) {
                if (sdf.format(new Date()).equals(gameUserDuration.getDurationTime())) {
                    gameUserDuration.setExitTime(newDate);
                    long diffInMillies = Math.abs(gameUserDuration.getExitTime().getTime() - gameUserDuration.getLogOnTime().getTime());
                    playtime += TimeUnit.MINUTES.convert(diffInMillies, TimeUnit.MILLISECONDS);
                } else {
                    playtime += 1440L;
                }
            } else {
                long diffInMillies = Math.abs(gameUserDuration.getExitTime().getTime() - gameUserDuration.getLogOnTime().getTime());
                playtime += TimeUnit.MINUTES.convert(diffInMillies, TimeUnit.MILLISECONDS);
            }
            String key = null;
            Integer keyEnd = 0;
            Integer keyIndex = 0;
            key = distributionDetailsPO.getSelectedDate();
            keyIndex = key.indexOf("-");
            Integer keyHead = Integer.valueOf(key.substring(0, key.lastIndexOf("-")));
            keyEnd = Integer.valueOf(key.substring(keyIndex + 1));
            if (playtime < (long)keyHead.intValue() || playtime >= (long)keyEnd.intValue()) continue;
            gameUserDurationFilterList.add(gameUserDuration);
        }
        int startIndex = (distributionDetailsPO.getPageNum() - 1) * distributionDetailsPO.getPageSize();
        int endIndex = Math.min(startIndex + distributionDetailsPO.getPageSize(), gameUserDurationFilterList.size());
        List currentPageList = gameUserDurationFilterList.subList(startIndex, endIndex);
        tableDataInfo.setRows(currentPageList);
        tableDataInfo.setTotal((long)gameUserDurationFilterList.size());
        tableDataInfo.setCode(200);
        return tableDataInfo;
    }
}

