/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.statistics;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.rearend.domain.po.statistics.HomePageSqlPO;
import com.ruoyi.rearend.domain.po.statistics.RegisterRetainedUserPO;
import com.ruoyi.rearend.domain.po.statistics.RetainLossPO;
import com.ruoyi.rearend.domain.vo.statistics.RetainLossVO;
import com.ruoyi.rearend.enums.statistics.RegisterRetainedTypeEnums;
import com.ruoyi.rearend.mapper.statistics.HomePageMapper;
import com.ruoyi.rearend.mapper.statistics.RetainLossMapper;
import com.ruoyi.rearend.service.impl.statistics.HomePageUtils;
import com.ruoyi.rearend.service.statistics.IRetainLossService;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RetainLossServiceImpl
implements IRetainLossService {
    @Autowired
    private HomePageMapper homePageMapper;
    @Autowired
    private RetainLossMapper retainLossMapper;
    @Autowired
    private HomePageUtils homePageUtils;
    private static ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 12, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(1000), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());

    public List<RetainLossVO> registerRetained(RetainLossPO retainLossPO) {
        ArrayList<RetainLossVO> retainLossVOList = new ArrayList<RetainLossVO>();
        List timeList = this.homePageUtils.timeHandle(retainLossPO.getTimeHead(), retainLossPO.getTimeTail());
        Collections.reverse(timeList);
        Integer type = retainLossPO.getRetainedType();
        try {
            for (int i = 0; i < timeList.size(); ++i) {
                HomePageSqlPO homePageSqlPO = new HomePageSqlPO();
                BeanUtils.copyProperties((Object)retainLossPO, (Object)homePageSqlPO);
                retainLossPO.setRetainedType(type);
                homePageSqlPO.setSpecificDate((String)timeList.get(i));
                homePageSqlPO.setTimeHead((String)timeList.get(i) + " 00:00:00");
                homePageSqlPO.setTimeTail((String)timeList.get(i) + " 23:59:59");
                RetainLossVO retainLossVO = new RetainLossVO();
                retainLossVO = (RetainLossVO)this.registerRetainedDataFactory(retainLossPO, homePageSqlPO).get();
                retainLossVOList.add(retainLossVO);
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u6ce8\u518c\u7559\u5b58\u7edf\u8ba1\u8ba1\u7b97\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        return retainLossVOList;
    }

    public Future<RetainLossVO> registerRetainedDataFactory(RetainLossPO retainLossPO, HomePageSqlPO homePageSqlPO) {
        return executorService.submit(() -> {
            RetainLossVO retainLossVO = new RetainLossVO();
            DecimalFormat df = new DecimalFormat("######0.00");
            try {
                LocalDate startDate;
                List userAccountList = this.homePageMapper.queryUserAccount(homePageSqlPO);
                Integer queryRoleNumber = userAccountList.size();
                homePageSqlPO.setUserAccountIdList(userAccountList);
                if (queryRoleNumber == null || queryRoleNumber == 0) {
                    retainLossVO.setSpecificDate(homePageSqlPO.getSpecificDate());
                    retainLossVO.setDeviceNumber(queryRoleNumber);
                    return retainLossVO;
                }
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                Date specificDate = fmt.parse(homePageSqlPO.getSpecificDate());
                String[] dateHeadString = new SimpleDateFormat("yyyy-MM-dd").format(specificDate).toString().split("-");
                LocalDate currentDate = startDate = LocalDate.of((int)Integer.valueOf(dateHeadString[0]), Integer.valueOf(dateHeadString[1]), (int)Integer.valueOf(dateHeadString[2]));
                String day = "date";
                HashMap<String, String> dayMap = new HashMap<String, String>();
                for (int i = 0; i < retainLossPO.getRegisterRetainDay(); ++i) {
                    currentDate = startDate;
                    currentDate = currentDate.plusDays(i);
                    homePageSqlPO.setTimeHead(currentDate + " 00:00:00");
                    homePageSqlPO.setTimeTail(currentDate + " 23:59:59");
                    int number = this.retainLossMapper.queryUserFootprintHistoryNumber(homePageSqlPO).size();
                    String retained = "0 / 0.00%";
                    if (RegisterRetainedTypeEnums.RETAIN.getValue() == retainLossPO.getRetainedType()) {
                        if (number != 0) {
                            double rateDouble = (double)number / (double)queryRoleNumber.intValue() * 100.0;
                            retained = number + " / " + df.format(rateDouble) + "%";
                        }
                    } else if (number != 0) {
                        Integer lossNumber = queryRoleNumber - number;
                        double rateDouble = (double)lossNumber.intValue() / (double)queryRoleNumber.intValue() * 100.0;
                        retained = lossNumber + " / " + df.format(rateDouble) + "%";
                    } else {
                        retained = "0 / 100%";
                    }
                    dayMap.put(day + (i + 1), retained);
                }
                ObjectMapper objectMapper = new ObjectMapper();
                RetainLossVO registerRetainedCount = (RetainLossVO)objectMapper.convertValue(dayMap, RetainLossVO.class);
                BeanUtils.copyProperties((Object)registerRetainedCount, (Object)retainLossVO);
                retainLossVO.setSpecificDate(homePageSqlPO.getSpecificDate());
                retainLossVO.setDeviceNumber(queryRoleNumber);
            }
            catch (Exception e) {
                throw new ServiceException("\u7ebf\u7a0b\u6c60\u5f02\u5e38: \u6ce8\u518c\u7559\u5b58\u8ba1\u7b97\u51fa\u73b0\u5f02\u5e38!");
            }
            return retainLossVO;
        });
    }

    public TableDataInfo queryRegisterRetainedUser(RegisterRetainedUserPO registerRetainedUserPO) {
        TableDataInfo tableDataInfo = new TableDataInfo();
        tableDataInfo.setRows(new ArrayList());
        int pageNum = (registerRetainedUserPO.getPageNum() - 1) * registerRetainedUserPO.getPageSize();
        registerRetainedUserPO.setPageNum(Integer.valueOf(pageNum));
        HomePageSqlPO homePageSqlPO = new HomePageSqlPO();
        BeanUtils.copyProperties((Object)registerRetainedUserPO, (Object)homePageSqlPO);
        homePageSqlPO.setSpecificDate(registerRetainedUserPO.getSpecificDate());
        homePageSqlPO.setTimeHead(registerRetainedUserPO.getSpecificDate() + " 00:00:00");
        homePageSqlPO.setTimeTail(registerRetainedUserPO.getSpecificDate() + " 23:59:59");
        List userAccountList = this.homePageMapper.queryUserAccount(homePageSqlPO);
        if (userAccountList == null || userAccountList.size() == 0) {
            return tableDataInfo;
        }
        List userList = new ArrayList();
        try {
            LocalDate startDate;
            String selectedDate = registerRetainedUserPO.getSelectedDate();
            Integer number = Integer.valueOf(selectedDate.replace("date", ""));
            HomePageSqlPO homePageSqlAppoint = new HomePageSqlPO();
            BeanUtils.copyProperties((Object)registerRetainedUserPO, (Object)homePageSqlAppoint);
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
            Date specificDate = fmt.parse(registerRetainedUserPO.getSpecificDate());
            String[] dateHeadString = new SimpleDateFormat("yyyy-MM-dd").format(specificDate).toString().split("-");
            LocalDate currentDate = startDate = LocalDate.of((int)Integer.valueOf(dateHeadString[0]), Integer.valueOf(dateHeadString[1]), (int)Integer.valueOf(dateHeadString[2]));
            currentDate = currentDate.plusDays(number - 1);
            homePageSqlAppoint.setTimeHead(currentDate + " 00:00:00");
            homePageSqlAppoint.setTimeTail(currentDate + " 23:59:59");
            homePageSqlAppoint.setUserAccountIdList(userAccountList);
            userList = this.retainLossMapper.queryUserFootprintHistoryNumber(homePageSqlAppoint);
        }
        catch (Exception e) {
            throw new ServiceException("\u6ce8\u518c\u7559\u5b58\u67e5\u770b\u7528\u6237\u4fe1\u606f,\u65f6\u95f4\u89e3\u6790\u51fa\u73b0\u95ee\u9898,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        if (userList == null || userList.size() == 0) {
            return tableDataInfo;
        }
        List userContentVOList = new ArrayList();
        int userContentNumber = 0;
        if (RegisterRetainedTypeEnums.RETAIN.getValue() == registerRetainedUserPO.getRetainedType()) {
            userContentVOList = this.retainLossMapper.queryUserIdListUserContent(userList, registerRetainedUserPO.getPageNum(), registerRetainedUserPO.getPageSize());
            userContentNumber = this.retainLossMapper.queryUserIdListUserContentNumber(userList);
        } else {
            if (userAccountList.size() == userList.size()) {
                return tableDataInfo;
            }
            ArrayList lossUserIdList = new ArrayList();
            for (int i = 0; i < userAccountList.size(); ++i) {
                if (userList.contains(userAccountList.get(i))) continue;
                lossUserIdList.add(userAccountList.get(i));
            }
            userContentVOList = this.retainLossMapper.queryUserIdListUserContent(lossUserIdList, registerRetainedUserPO.getPageNum(), registerRetainedUserPO.getPageSize());
            userContentNumber = this.retainLossMapper.queryUserIdListUserContentNumber(lossUserIdList);
        }
        tableDataInfo.setRows(userContentVOList);
        tableDataInfo.setTotal((long)userContentNumber);
        tableDataInfo.setCode(200);
        return tableDataInfo;
    }

    public List<RetainLossVO> payRetained(RetainLossPO retainLossPO) {
        ArrayList<RetainLossVO> retainLossVOList = new ArrayList<RetainLossVO>();
        List timeList = this.homePageUtils.timeHandle(retainLossPO.getTimeHead(), retainLossPO.getTimeTail());
        Collections.reverse(timeList);
        Integer type = retainLossPO.getRetainedType();
        try {
            for (int i = 0; i < timeList.size(); ++i) {
                HomePageSqlPO homePageSqlPO = new HomePageSqlPO();
                BeanUtils.copyProperties((Object)retainLossPO, (Object)homePageSqlPO);
                retainLossPO.setRetainedType(type);
                homePageSqlPO.setSpecificDate((String)timeList.get(i));
                homePageSqlPO.setTimeHead((String)timeList.get(i) + " 00:00:00");
                homePageSqlPO.setTimeTail((String)timeList.get(i) + " 23:59:59");
                RetainLossVO retainLossVO = new RetainLossVO();
                retainLossVO = (RetainLossVO)this.payRetainedFactory(retainLossPO, homePageSqlPO).get();
                retainLossVOList.add(retainLossVO);
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u4ed8\u8d39\u7559\u5b58\u7edf\u8ba1\u8ba1\u7b97\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        return retainLossVOList;
    }

    public Future<RetainLossVO> payRetainedFactory(RetainLossPO retainLossPO, HomePageSqlPO homePageSqlPO) {
        return executorService.submit(() -> {
            RetainLossVO retainLossVO = new RetainLossVO();
            DecimalFormat df = new DecimalFormat("######0.00");
            try {
                LocalDate startDate;
                List userAccountList = this.retainLossMapper.queryOrderUserNumber(homePageSqlPO);
                Integer queryRoleNumber = userAccountList.size();
                homePageSqlPO.setUserAccountIdList(userAccountList);
                if (queryRoleNumber == null || queryRoleNumber == 0) {
                    retainLossVO.setSpecificDate(homePageSqlPO.getSpecificDate());
                    retainLossVO.setDeviceNumber(queryRoleNumber);
                    return retainLossVO;
                }
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                Date specificDate = fmt.parse(homePageSqlPO.getSpecificDate());
                String[] dateHeadString = new SimpleDateFormat("yyyy-MM-dd").format(specificDate).toString().split("-");
                LocalDate currentDate = startDate = LocalDate.of((int)Integer.valueOf(dateHeadString[0]), Integer.valueOf(dateHeadString[1]), (int)Integer.valueOf(dateHeadString[2]));
                String day = "date";
                HashMap<String, String> dayMap = new HashMap<String, String>();
                for (int i = 0; i < retainLossPO.getRegisterRetainDay(); ++i) {
                    currentDate = startDate;
                    currentDate = currentDate.plusDays(i);
                    homePageSqlPO.setTimeHead(currentDate + " 00:00:00");
                    homePageSqlPO.setTimeTail(currentDate + " 23:59:59");
                    int number = this.retainLossMapper.queryOrderUserNumber(homePageSqlPO).size();
                    String retained = "0 / 0.00%";
                    if (RegisterRetainedTypeEnums.RETAIN.getValue() == retainLossPO.getRetainedType()) {
                        if (number != 0) {
                            double rateDouble = (double)number / (double)queryRoleNumber.intValue() * 100.0;
                            retained = number + " / " + df.format(rateDouble) + "%";
                        }
                    } else if (number != 0) {
                        Integer lossNumber = queryRoleNumber - number;
                        double rateDouble = (double)lossNumber.intValue() / (double)queryRoleNumber.intValue() * 100.0;
                        retained = lossNumber + " / " + df.format(rateDouble) + "%";
                    } else {
                        retained = "0 / 100%";
                    }
                    dayMap.put(day + (i + 1), retained);
                }
                ObjectMapper objectMapper = new ObjectMapper();
                RetainLossVO registerRetainedCount = (RetainLossVO)objectMapper.convertValue(dayMap, RetainLossVO.class);
                BeanUtils.copyProperties((Object)registerRetainedCount, (Object)retainLossVO);
                retainLossVO.setSpecificDate(homePageSqlPO.getSpecificDate());
                retainLossVO.setDeviceNumber(queryRoleNumber);
            }
            catch (Exception e) {
                throw new ServiceException("\u7ebf\u7a0b\u6c60\u5f02\u5e38: \u4ed8\u8d39\u7559\u5b58\u8ba1\u7b97\u51fa\u73b0\u5f02\u5e38!");
            }
            return retainLossVO;
        });
    }

    public TableDataInfo queryPayRetainedUser(RegisterRetainedUserPO registerRetainedUserPO) {
        TableDataInfo tableDataInfo = new TableDataInfo();
        tableDataInfo.setRows(new ArrayList());
        int pageNum = (registerRetainedUserPO.getPageNum() - 1) * registerRetainedUserPO.getPageSize();
        registerRetainedUserPO.setPageNum(Integer.valueOf(pageNum));
        HomePageSqlPO homePageSqlPO = new HomePageSqlPO();
        BeanUtils.copyProperties((Object)registerRetainedUserPO, (Object)homePageSqlPO);
        homePageSqlPO.setSpecificDate(registerRetainedUserPO.getSpecificDate());
        homePageSqlPO.setTimeHead(registerRetainedUserPO.getSpecificDate() + " 00:00:00");
        homePageSqlPO.setTimeTail(registerRetainedUserPO.getSpecificDate() + " 23:59:59");
        List userAccountList = this.retainLossMapper.queryOrderUserNumber(homePageSqlPO);
        if (userAccountList == null || userAccountList.size() == 0) {
            return tableDataInfo;
        }
        List userList = new ArrayList();
        try {
            LocalDate startDate;
            String selectedDate = registerRetainedUserPO.getSelectedDate();
            Integer number = Integer.valueOf(selectedDate.replace("date", ""));
            HomePageSqlPO homePageSqlAppoint = new HomePageSqlPO();
            BeanUtils.copyProperties((Object)registerRetainedUserPO, (Object)homePageSqlAppoint);
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
            Date specificDate = fmt.parse(registerRetainedUserPO.getSpecificDate());
            String[] dateHeadString = new SimpleDateFormat("yyyy-MM-dd").format(specificDate).toString().split("-");
            LocalDate currentDate = startDate = LocalDate.of((int)Integer.valueOf(dateHeadString[0]), Integer.valueOf(dateHeadString[1]), (int)Integer.valueOf(dateHeadString[2]));
            currentDate = currentDate.plusDays(number - 1);
            homePageSqlAppoint.setTimeHead(currentDate + " 00:00:00");
            homePageSqlAppoint.setTimeTail(currentDate + " 23:59:59");
            homePageSqlAppoint.setUserAccountIdList(userAccountList);
            userList = this.retainLossMapper.queryOrderUserNumber(homePageSqlAppoint);
        }
        catch (Exception e) {
            throw new ServiceException("\u4ed8\u8d39\u7559\u5b58\u67e5\u770b\u7528\u6237\u4fe1\u606f,\u65f6\u95f4\u89e3\u6790\u51fa\u73b0\u95ee\u9898,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        if (userList == null || userList.size() == 0) {
            return tableDataInfo;
        }
        List userContentVOList = new ArrayList();
        int userContentNumber = 0;
        if (RegisterRetainedTypeEnums.RETAIN.getValue() == registerRetainedUserPO.getRetainedType()) {
            userContentVOList = this.retainLossMapper.queryUserIdListUserContent(userList, registerRetainedUserPO.getPageNum(), registerRetainedUserPO.getPageSize());
            userContentNumber = this.retainLossMapper.queryUserIdListUserContentNumber(userList);
        } else {
            if (userAccountList.size() == userList.size()) {
                return tableDataInfo;
            }
            ArrayList lossUserIdList = new ArrayList();
            for (int i = 0; i < userAccountList.size(); ++i) {
                if (userList.contains(userAccountList.get(i))) continue;
                lossUserIdList.add(userAccountList.get(i));
            }
            userContentVOList = this.retainLossMapper.queryUserIdListUserContent(lossUserIdList, registerRetainedUserPO.getPageNum(), registerRetainedUserPO.getPageSize());
            userContentNumber = this.retainLossMapper.queryUserIdListUserContentNumber(lossUserIdList);
        }
        tableDataInfo.setRows(userContentVOList);
        tableDataInfo.setTotal((long)userContentNumber);
        tableDataInfo.setCode(200);
        return tableDataInfo;
    }
}

