/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.statistics;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.rearend.domain.po.statistics.HomePageSqlPO;
import com.ruoyi.rearend.domain.po.statistics.LtvReportPO;
import com.ruoyi.rearend.domain.vo.statistics.LtvReportVO;
import com.ruoyi.rearend.domain.vo.statistics.RetainLossVO;
import com.ruoyi.rearend.enums.statistics.RegisterRetainedTypeEnums;
import com.ruoyi.rearend.mapper.statistics.RetainLossMapper;
import com.ruoyi.rearend.service.impl.statistics.HomePageUtils;
import com.ruoyi.rearend.service.statistics.ILtvReportService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LtvReportServiceImpl
implements ILtvReportService {
    @Autowired
    private HomePageUtils homePageUtils;
    @Autowired
    private RetainLossMapper retainLossMapper;
    private static ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 12, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(1000), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());

    public List<LtvReportVO> queryLtvReport(LtvReportPO ltvReportPO) {
        ArrayList<LtvReportVO> ltvReportVOList = new ArrayList<LtvReportVO>();
        List timeList = this.homePageUtils.timeHandle(ltvReportPO.getTimeHead(), ltvReportPO.getTimeTail());
        Collections.reverse(timeList);
        Integer type = ltvReportPO.getRetainedType();
        try {
            for (int i = 0; i < timeList.size(); ++i) {
                HomePageSqlPO homePageSqlPO = new HomePageSqlPO();
                BeanUtils.copyProperties((Object)ltvReportPO, (Object)homePageSqlPO);
                ltvReportPO.setRetainedType(type);
                homePageSqlPO.setSpecificDate((String)timeList.get(i));
                homePageSqlPO.setTimeHead((String)timeList.get(i) + " 00:00:00");
                homePageSqlPO.setTimeTail((String)timeList.get(i) + " 23:59:59");
                LtvReportVO ltvReportVO = new LtvReportVO();
                ltvReportVO = (LtvReportVO)this.queryLtvReportFactory(ltvReportPO, homePageSqlPO).get();
                ltvReportVOList.add(ltvReportVO);
            }
        }
        catch (Exception e) {
            throw new ServiceException("LTV\u62a5\u8868\u8ba1\u7b97\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        return ltvReportVOList;
    }

    public Future<LtvReportVO> queryLtvReportFactory(LtvReportPO ltvReportPO, HomePageSqlPO homePageSqlPO) {
        return executorService.submit(() -> {
            LtvReportVO ltvReportVO = new LtvReportVO();
            try {
                LocalDate startDate;
                List userAccountList = this.retainLossMapper.queryOrderUserNumber(homePageSqlPO);
                Integer queryRoleNumber = userAccountList.size();
                homePageSqlPO.setUserAccountIdList(userAccountList);
                if (queryRoleNumber == null || queryRoleNumber == 0) {
                    ltvReportVO.setSpecificDate(homePageSqlPO.getSpecificDate());
                    ltvReportVO.setDeviceNumber(queryRoleNumber);
                    return ltvReportVO;
                }
                Double moneyTotal = this.retainLossMapper.queryOrderSumMoney(homePageSqlPO);
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                Date specificDate = fmt.parse(homePageSqlPO.getSpecificDate());
                String[] dateHeadString = new SimpleDateFormat("yyyy-MM-dd").format(specificDate).toString().split("-");
                LocalDate currentDate = startDate = LocalDate.of((int)Integer.valueOf(dateHeadString[0]), Integer.valueOf(dateHeadString[1]), (int)Integer.valueOf(dateHeadString[2]));
                String day = "date";
                HashMap<String, String> dayMap = new HashMap<String, String>();
                Double accumulateMoney = 0.0;
                for (int i = 0; i < ltvReportPO.getRegisterRetainDay(); ++i) {
                    currentDate = startDate;
                    currentDate = currentDate.plusDays(i);
                    homePageSqlPO.setTimeHead(currentDate + " 00:00:00");
                    homePageSqlPO.setTimeTail(currentDate + " 23:59:59");
                    Double atThatTimeMoney = this.retainLossMapper.queryOrderSumMoney(homePageSqlPO);
                    if (atThatTimeMoney != null) {
                        accumulateMoney = accumulateMoney + atThatTimeMoney;
                    }
                    String retained = "-";
                    double ltvData = 0.0;
                    double ltvTotalData = 0.0;
                    if (RegisterRetainedTypeEnums.RETAIN.getValue() == ltvReportPO.getRetainedType() && atThatTimeMoney != null) {
                        ltvData = atThatTimeMoney / moneyTotal;
                        ltvTotalData = accumulateMoney / moneyTotal;
                        BigDecimal bigDecimal1 = new BigDecimal(ltvData);
                        double ltvTrend = bigDecimal1.setScale(3, 4).doubleValue();
                        BigDecimal bigDecimal2 = new BigDecimal(ltvTotalData);
                        double ltvAccumulate = bigDecimal2.setScale(3, 4).doubleValue();
                        BigDecimal bigDecimal3 = new BigDecimal(atThatTimeMoney);
                        double ltvAtThatTimeMoney = bigDecimal3.setScale(3, 4).doubleValue();
                        retained = "LTV\u8d8b\u52bf: " + ltvTrend + " \n LTV\u7d2f\u8ba1: " + ltvAccumulate + " \n \u6bcf\u65e5\u4ed8\u8d39: " + ltvAtThatTimeMoney;
                    }
                    dayMap.put(day + (i + 1), retained);
                }
                ObjectMapper objectMapper = new ObjectMapper();
                RetainLossVO registerRetainedCount = (RetainLossVO)objectMapper.convertValue(dayMap, RetainLossVO.class);
                BeanUtils.copyProperties((Object)registerRetainedCount, (Object)ltvReportVO);
                ltvReportVO.setSpecificDate(homePageSqlPO.getSpecificDate());
                ltvReportVO.setDeviceNumber(queryRoleNumber);
            }
            catch (Exception e) {
                throw new ServiceException("\u7ebf\u7a0b\u6c60\u5f02\u5e38: \u4ed8\u8d39\u7559\u5b58\u8ba1\u7b97\u51fa\u73b0\u5f02\u5e38!");
            }
            return ltvReportVO;
        });
    }
}

