/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.statistics;

import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.rearend.domain.po.statistics.HomePageSqlPO;
import com.ruoyi.rearend.domain.po.statistics.OperateDailyAddPO;
import com.ruoyi.rearend.domain.po.statistics.UserContentPO;
import com.ruoyi.rearend.domain.vo.statistics.OperateDailyAddVO;
import com.ruoyi.rearend.domain.vo.statistics.ServerIntervalVO;
import com.ruoyi.rearend.mapper.statistics.HomePageMapper;
import com.ruoyi.rearend.service.impl.statistics.HomePageUtils;
import com.ruoyi.rearend.service.statistics.IHomePageService;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HomePageServiceImpl
implements IHomePageService {
    @Autowired
    private HomePageMapper homePageMapper;
    @Autowired
    private HomePageUtils homePageUtils;
    private static ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 12, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(1000), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());

    public ServerIntervalVO querySearchCriteria() {
        ServerIntervalVO serverIntervalVO = new ServerIntervalVO();
        List queryServerFormalList = this.homePageMapper.queryServerFormalList();
        if (queryServerFormalList == null || queryServerFormalList.size() == 0) {
            throw new ServiceException("\u6682\u65e0\u6b63\u5f0f\u7248\u670d\u52a1\u5668\u5217\u8868,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        serverIntervalVO.setServerSmall((Integer)Collections.min(queryServerFormalList));
        serverIntervalVO.setServerBig((Integer)Collections.max(queryServerFormalList));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(5, -7);
        Date previousDate = calendar.getTime();
        String startTime = previousDate.getYear() + 1900 + "-" + (previousDate.getMonth() + 1) + "-" + previousDate.getDate() + " 00:00:00";
        serverIntervalVO.setStartTime(startTime);
        Date currentDate = new Date();
        String endTime = currentDate.getYear() + 1900 + "-" + (currentDate.getMonth() + 1) + "-" + currentDate.getDate() + " 23:59:59";
        serverIntervalVO.setEndTime(endTime);
        ArrayList<String> queryTime = new ArrayList<String>();
        queryTime.add(startTime);
        queryTime.add(endTime);
        serverIntervalVO.setQueryTime(queryTime);
        return serverIntervalVO;
    }

    public List<OperateDailyAddVO> operateDailyAdd(OperateDailyAddPO operateDailyAddPO) {
        ArrayList<OperateDailyAddVO> operateDailyAddVOList = new ArrayList<OperateDailyAddVO>();
        List timeList = this.homePageUtils.timeHandle(operateDailyAddPO.getTimeHead(), operateDailyAddPO.getTimeTail());
        Collections.reverse(timeList);
        try {
            for (int i = 0; i < timeList.size(); ++i) {
                HomePageSqlPO homePageSqlPO = new HomePageSqlPO();
                BeanUtils.copyProperties((Object)operateDailyAddPO, (Object)homePageSqlPO);
                homePageSqlPO.setSpecificDate((String)timeList.get(i));
                homePageSqlPO.setTimeHead((String)timeList.get(i) + " 00:00:00");
                homePageSqlPO.setTimeTail((String)timeList.get(i) + " 23:59:59");
                OperateDailyAddVO operateDailyAddVO = new OperateDailyAddVO();
                operateDailyAddVO = (OperateDailyAddVO)this.statistics37DataFactory(homePageSqlPO).get();
                operateDailyAddVOList.add(operateDailyAddVO);
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u8fd0\u8425\u65e5\u62a5(\u65b0\u589e)\u7edf\u8ba1\u8ba1\u7b97\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        return operateDailyAddVOList;
    }

    public Future<OperateDailyAddVO> statistics37DataFactory(HomePageSqlPO homePageSqlPO) {
        return executorService.submit(() -> {
            OperateDailyAddVO operateDailyAddVO = new OperateDailyAddVO();
            operateDailyAddVO.setSpecificDate(homePageSqlPO.getSpecificDate());
            DecimalFormat df = new DecimalFormat("######0.00");
            try {
                List userAccountList = this.homePageMapper.queryUserAccount(homePageSqlPO);
                Integer queryRoleNumber = userAccountList.size();
                homePageSqlPO.setUserAccountIdList(userAccountList);
                Double query37OrderMoney = null;
                Integer query37OrderNumber = 0;
                Integer queryOrderPeople37Number = 0;
                if (userAccountList != null && userAccountList.size() > 0) {
                    query37OrderMoney = this.homePageMapper.query37OrderMoney(homePageSqlPO);
                    query37OrderNumber = this.homePageMapper.query37OrderNumber(homePageSqlPO);
                    queryOrderPeople37Number = this.homePageMapper.queryOrderPeople37Number(homePageSqlPO);
                }
                operateDailyAddVO.setDeviceNumber("\u6682\u65e0");
                operateDailyAddVO.setRoleAverageDuration("\u6682\u65e0");
                operateDailyAddVO.setAveragePosterNumber("\u6682\u65e0");
                operateDailyAddVO.setPosterCompleteNumber("\u6682\u65e0");
                operateDailyAddVO.setRoleNumber(String.valueOf(queryRoleNumber));
                operateDailyAddVO.setInternalRoleNumber(String.valueOf(queryOrderPeople37Number));
                if (query37OrderMoney != null && query37OrderMoney != 0.0) {
                    BigDecimal internalIncomeBigDecimal = new BigDecimal(query37OrderMoney);
                    double internalIncome = internalIncomeBigDecimal.setScale(3, 4).doubleValue();
                    operateDailyAddVO.setInternalIncome(String.valueOf(internalIncome));
                } else {
                    operateDailyAddVO.setInternalIncome("0");
                }
                if (query37OrderMoney != null && query37OrderMoney != 0.0 && queryRoleNumber != null && queryRoleNumber != 0) {
                    Double arpu = query37OrderMoney / (double)queryRoleNumber.intValue();
                    BigDecimal bigDecimal = new BigDecimal(arpu);
                    double arpuNumber = bigDecimal.setScale(3, 4).doubleValue();
                    operateDailyAddVO.setArpuNumber(String.valueOf(arpuNumber));
                } else {
                    operateDailyAddVO.setArpuNumber("0");
                }
                if (query37OrderMoney != null && query37OrderMoney != 0.0 && queryOrderPeople37Number != null && queryOrderPeople37Number != 0) {
                    Double arppu = query37OrderMoney / (double)queryOrderPeople37Number.intValue();
                    BigDecimal bigDecimal = new BigDecimal(arppu);
                    double arppuNumber = bigDecimal.setScale(3, 4).doubleValue();
                    operateDailyAddVO.setArppuNumber(String.valueOf(arppuNumber));
                } else {
                    operateDailyAddVO.setArppuNumber("0");
                }
                if (queryOrderPeople37Number != null && queryOrderPeople37Number != 0 && queryRoleNumber != null && queryRoleNumber != 0) {
                    double rateDouble = (double)queryOrderPeople37Number.intValue() / (double)queryRoleNumber.intValue() * 100.0;
                    operateDailyAddVO.setRate(df.format(rateDouble) + "%");
                } else {
                    operateDailyAddVO.setRate("0");
                }
                if (query37OrderNumber != null && query37OrderNumber != 0 && queryOrderPeople37Number != null && queryOrderPeople37Number != 0) {
                    double rateRoleNumberDouble = (double)query37OrderNumber.intValue() / (double)queryOrderPeople37Number.intValue();
                    operateDailyAddVO.setRateRoleNumber(df.format(rateRoleNumberDouble));
                } else {
                    operateDailyAddVO.setRateRoleNumber("0");
                }
            }
            catch (Exception e) {
                throw new ServiceException("\u7ebf\u7a0b\u6c60\u5f02\u5e38: \u8fd0\u8425\u65e5\u62a5(\u65b0\u589e)37\u8ba1\u7b97\u51fa\u73b0\u5f02\u5e38!");
            }
            return operateDailyAddVO;
        });
    }

    public Future<OperateDailyAddVO> statisticsDataFactory(HomePageSqlPO homePageSqlPO) {
        return executorService.submit(() -> {
            OperateDailyAddVO operateDailyAddVO = new OperateDailyAddVO();
            operateDailyAddVO.setSpecificDate(homePageSqlPO.getSpecificDate());
            DecimalFormat df = new DecimalFormat("######0.00");
            try {
                List userAccountList = this.homePageMapper.queryUserAccount(homePageSqlPO);
                Integer queryRoleNumber = userAccountList.size();
                homePageSqlPO.setUserAccountIdList(userAccountList);
                Double queryOrderMoney = this.homePageMapper.queryOrderMoney(homePageSqlPO);
                Integer queryOrderNumber = this.homePageMapper.queryOrderNumber(homePageSqlPO);
                Integer queryOrderPeopleNumber = this.homePageMapper.queryOrderPeopleNumber(homePageSqlPO);
                operateDailyAddVO.setDeviceNumber("\u6682\u65e0");
                operateDailyAddVO.setRoleAverageDuration("\u6682\u65e0");
                operateDailyAddVO.setAveragePosterNumber("\u6682\u65e0");
                operateDailyAddVO.setPosterCompleteNumber("\u6682\u65e0");
                operateDailyAddVO.setRoleNumber(String.valueOf(queryRoleNumber));
                operateDailyAddVO.setInternalRoleNumber(String.valueOf(queryOrderPeopleNumber));
                if (queryOrderMoney != null && queryOrderMoney != 0.0) {
                    BigDecimal internalIncomeBigDecimal = new BigDecimal(queryOrderMoney);
                    double internalIncome = internalIncomeBigDecimal.setScale(3, 4).doubleValue();
                    operateDailyAddVO.setInternalIncome(String.valueOf(internalIncome));
                } else {
                    operateDailyAddVO.setInternalIncome("0");
                }
                if (queryOrderMoney != null && queryOrderMoney != 0.0 && queryRoleNumber != null && queryRoleNumber != 0) {
                    Double arpu = queryOrderMoney / (double)queryRoleNumber.intValue();
                    BigDecimal bigDecimal = new BigDecimal(arpu);
                    double arpuNumber = bigDecimal.setScale(3, 4).doubleValue();
                    operateDailyAddVO.setArpuNumber(String.valueOf(arpuNumber));
                } else {
                    operateDailyAddVO.setArpuNumber("0");
                }
                if (queryOrderMoney != null && queryOrderMoney != 0.0 && queryOrderPeopleNumber != null && queryOrderPeopleNumber != 0) {
                    Double arppu = queryOrderMoney / (double)queryOrderPeopleNumber.intValue();
                    BigDecimal bigDecimal = new BigDecimal(arppu);
                    double arppuNumber = bigDecimal.setScale(3, 4).doubleValue();
                    operateDailyAddVO.setArppuNumber(String.valueOf(arppuNumber));
                } else {
                    operateDailyAddVO.setArppuNumber("0");
                }
                if (queryOrderPeopleNumber != null && queryOrderPeopleNumber != 0 && queryRoleNumber != null && queryRoleNumber != 0) {
                    double rateDouble = (double)queryOrderPeopleNumber.intValue() / (double)queryRoleNumber.intValue() * 100.0;
                    operateDailyAddVO.setRate(df.format(rateDouble) + "%");
                } else {
                    operateDailyAddVO.setRate("0");
                }
                if (queryOrderNumber != null && queryOrderNumber != 0 && queryOrderPeopleNumber != null && queryOrderPeopleNumber != 0) {
                    double rateRoleNumberDouble = (double)queryOrderNumber.intValue() / (double)queryOrderPeopleNumber.intValue();
                    operateDailyAddVO.setRateRoleNumber(df.format(rateRoleNumberDouble));
                } else {
                    operateDailyAddVO.setRateRoleNumber("0");
                }
            }
            catch (Exception e) {
                throw new ServiceException("\u7ebf\u7a0b\u6c60\u5f02\u5e38: \u8fd0\u8425\u65e5\u62a5(\u65b0\u589e)\u8ba1\u7b97\u51fa\u73b0\u5f02\u5e38!");
            }
            return operateDailyAddVO;
        });
    }

    public Future<OperateDailyAddVO> serverDataFactory(OperateDailyAddPO operateDailyAddPO) {
        return executorService.submit(() -> {
            OperateDailyAddVO operateDailyAddVO = new OperateDailyAddVO();
            return operateDailyAddVO;
        });
    }

    public TableDataInfo queryUserContent(UserContentPO userContentPO) {
        TableDataInfo tableDataInfo = new TableDataInfo();
        int pageNumPast = userContentPO.getPageNum();
        int pageNum = (userContentPO.getPageNum() - 1) * userContentPO.getPageSize();
        userContentPO.setPageNum(Integer.valueOf(pageNum));
        List userContentVOList = this.homePageMapper.queryUserContent(userContentPO);
        int total = this.homePageMapper.queryUserContentNumber(userContentPO);
        tableDataInfo.setRows(userContentVOList);
        tableDataInfo.setTotal((long)total);
        tableDataInfo.setCode(200);
        return tableDataInfo;
    }
}

