/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.statistics;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.rearend.api.AnalysisServerApi;
import com.ruoyi.rearend.domain.GameUserDuration;
import com.ruoyi.rearend.domain.RearServerConfig;
import com.ruoyi.rearend.domain.po.statistics.DoubtfulDataPO;
import com.ruoyi.rearend.domain.po.statistics.FoundationOnAnalysisPO;
import com.ruoyi.rearend.domain.po.statistics.HomePageSqlPO;
import com.ruoyi.rearend.domain.po.statistics.LogRetrievalPO;
import com.ruoyi.rearend.domain.po.statistics.RegisterRetainedUserPO;
import com.ruoyi.rearend.domain.po.statistics.UserDurationUpdatePO;
import com.ruoyi.rearend.domain.po.statistics.UserFootprintSqlPO;
import com.ruoyi.rearend.domain.po.statistics.UserOnlineDurationPO;
import com.ruoyi.rearend.domain.vo.statistics.FoundationOnAnalysisVO;
import com.ruoyi.rearend.domain.vo.statistics.UserOnlineDurationVO;
import com.ruoyi.rearend.enums.statistics.RegisterRetainedTypeEnums;
import com.ruoyi.rearend.enums.statistics.UserDurationMarkEnums;
import com.ruoyi.rearend.mapper.server.RearServerMapper;
import com.ruoyi.rearend.mapper.statistics.GameUserDurationMapper;
import com.ruoyi.rearend.mapper.statistics.UserFootprintHistoryMapper;
import com.ruoyi.rearend.service.impl.statistics.HomePageUtils;
import com.ruoyi.rearend.service.statistics.IAnalysisService;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AnalysisServiceImpl
implements IAnalysisService {
    @Autowired
    private AnalysisServerApi analysisServerApi;
    @Autowired
    private UserFootprintHistoryMapper userFootprintHistoryMapper;
    @Autowired
    private HomePageUtils homePageUtils;
    @Autowired
    private RearServerMapper rearServerMapper;
    @Autowired
    private GameUserDurationMapper gameUserDurationMapper;
    private static final Logger log = LoggerFactory.getLogger(AnalysisServiceImpl.class);
    private static ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 12, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(1000), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());

    public TableDataInfo logRetrieval(LogRetrievalPO logRetrievalPO) {
        TableDataInfo tableDataInfo = new TableDataInfo();
        RearServerConfig rearServerConfig = this.rearServerMapper.serverIdQuery(logRetrievalPO.getServerId());
        if (rearServerConfig == null) {
            throw new ServiceException("\u6b64\u533a\u670dID\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        logRetrievalPO.setServerIp(rearServerConfig.getServerIp());
        logRetrievalPO.setServerPort(rearServerConfig.getServerPort());
        tableDataInfo = this.analysisServerApi.logRetrieval(logRetrievalPO);
        return tableDataInfo;
    }

    public FoundationOnAnalysisVO foundationOnAnalysis(FoundationOnAnalysisPO foundationOnAnalysisPO) {
        FoundationOnAnalysisVO foundationOnAnalysisVO = new FoundationOnAnalysisVO();
        Date date = new Date();
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
        DecimalFormat df = new DecimalFormat("######0.00");
        UserFootprintSqlPO userFootprintSqlPO = new UserFootprintSqlPO();
        userFootprintSqlPO.setServerHead(foundationOnAnalysisPO.getServerHead());
        userFootprintSqlPO.setServerTail(foundationOnAnalysisPO.getServerTail());
        String dayDate = fmt.format(date);
        userFootprintSqlPO.setTimeHead(dayDate + " 00:00:00");
        userFootprintSqlPO.setTimeTail(dayDate + " 23:59:59");
        Integer todayNumber = this.userFootprintHistoryMapper.querySpecifyDateNumber(userFootprintSqlPO);
        foundationOnAnalysisVO.setTodayNumber(todayNumber);
        LocalDate yesterday = LocalDate.now().minusDays(1L);
        userFootprintSqlPO.setTimeHead(yesterday + " 00:00:00");
        userFootprintSqlPO.setTimeTail(yesterday + " 23:59:59");
        Integer yesterdayNumber = this.userFootprintHistoryMapper.queryHistorySpecifyDateNumber(userFootprintSqlPO);
        foundationOnAnalysisVO.setYesterdayNumber(yesterdayNumber);
        LocalDate today = LocalDate.now();
        LocalDate thisWeekMonday = today.with(DayOfWeek.MONDAY);
        LocalDate lastWeekMonday = thisWeekMonday.minusWeeks(1L);
        LocalDate lastSunday = lastWeekMonday.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
        userFootprintSqlPO.setTimeHead(lastWeekMonday + " 00:00:00");
        userFootprintSqlPO.setTimeTail(lastSunday + " 23:59:59");
        Integer lastWeekNumber = this.userFootprintHistoryMapper.queryHistorySpecifyDateNumber(userFootprintSqlPO);
        foundationOnAnalysisVO.setLastWeekNumber(lastWeekNumber);
        LocalDate monday = today.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY));
        LocalDate sunday = today.with(TemporalAdjusters.nextOrSame(DayOfWeek.SUNDAY));
        userFootprintSqlPO.setTimeHead(monday + " 00:00:00");
        userFootprintSqlPO.setTimeTail(sunday + " 23:59:59");
        Integer thisWeekNumber = this.userFootprintHistoryMapper.queryHistorySpecifyDateNumber(userFootprintSqlPO);
        foundationOnAnalysisVO.setThisWeekNumber(thisWeekNumber);
        LocalDate now = LocalDate.now();
        LocalDate firstDayOfLastMonth = now.with(TemporalAdjusters.firstDayOfMonth()).minusMonths(1L);
        LocalDate lastDayOfLastMonth = now.with(TemporalAdjusters.lastDayOfMonth()).minusMonths(1L);
        userFootprintSqlPO.setTimeHead(firstDayOfLastMonth + " 00:00:00");
        if (lastDayOfLastMonth.getMonthValue() < 10) {
            userFootprintSqlPO.setTimeTail(lastDayOfLastMonth.getYear() + "-0" + lastDayOfLastMonth.getMonthValue() + "-31 23:59:59");
        } else {
            userFootprintSqlPO.setTimeTail(lastDayOfLastMonth.getYear() + "-" + lastDayOfLastMonth.getMonthValue() + "-31 23:59:59");
        }
        Integer lastMonthNumber = this.userFootprintHistoryMapper.queryHistorySpecifyDateNumber(userFootprintSqlPO);
        foundationOnAnalysisVO.setLastMonthNumber(lastMonthNumber);
        LocalDate firstDayOfMonth = now.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate lastDayOfMonth = now.with(TemporalAdjusters.lastDayOfMonth());
        userFootprintSqlPO.setTimeHead(firstDayOfMonth + " 00:00:00");
        if (lastDayOfMonth.getMonthValue() < 10) {
            userFootprintSqlPO.setTimeTail(lastDayOfMonth.getYear() + "-0" + lastDayOfMonth.getMonthValue() + "-31 23:59:59");
        } else {
            userFootprintSqlPO.setTimeTail(lastDayOfMonth.getYear() + "-" + lastDayOfMonth.getMonthValue() + "-31 23:59:59");
        }
        Integer thisMonthNumber = this.userFootprintHistoryMapper.queryHistorySpecifyDateNumber(userFootprintSqlPO);
        foundationOnAnalysisVO.setThisMonthNumber(thisMonthNumber);
        if (todayNumber == 0 || thisMonthNumber == 0) {
            foundationOnAnalysisVO.setThisMonthDauMau("0.00%");
        } else {
            double thisMonthDauMau = (double)todayNumber.intValue() / (double)thisMonthNumber.intValue() * 100.0;
            foundationOnAnalysisVO.setThisMonthDauMau(df.format(thisMonthDauMau) + "%");
        }
        if (yesterdayNumber == 0 || lastMonthNumber == 0) {
            foundationOnAnalysisVO.setLastMonthDauMau("0.00%");
        } else {
            double lastMonthDauMau = (double)yesterdayNumber.intValue() / (double)lastMonthNumber.intValue() * 100.0;
            foundationOnAnalysisVO.setLastMonthDauMau(df.format(lastMonthDauMau) + "%");
        }
        return foundationOnAnalysisVO;
    }

    public List<UserOnlineDurationVO> userOnlineDuration(UserOnlineDurationPO userOnlineDurationPO) {
        ArrayList<UserOnlineDurationVO> userOnlineDurationVOList = new ArrayList<UserOnlineDurationVO>();
        List timeList = this.homePageUtils.timeHandle(userOnlineDurationPO.getTimeHead(), userOnlineDurationPO.getTimeTail());
        Collections.reverse(timeList);
        Integer type = userOnlineDurationPO.getRetainedType();
        ArrayList<Future> futureList = new ArrayList<Future>();
        try {
            for (int i = 0; i < timeList.size(); ++i) {
                HomePageSqlPO homePageSqlPO = new HomePageSqlPO();
                BeanUtils.copyProperties((Object)userOnlineDurationPO, (Object)homePageSqlPO);
                userOnlineDurationPO.setRetainedType(type);
                homePageSqlPO.setSpecificDate((String)timeList.get(i));
                homePageSqlPO.setTimeHead((String)timeList.get(i));
                homePageSqlPO.setTimeTail((String)timeList.get(i));
                futureList.add(this.queryDurationFactory(userOnlineDurationPO, homePageSqlPO));
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u89d2\u8272\u5728\u7ebf\u65f6\u957f\u62a5\u8868\u8ba1\u7b97\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        int number = 0;
        while (number <= 20) {
            ++number;
            if (((Future)futureList.get(0)).isDone()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (Future future : futureList) {
            try {
                UserOnlineDurationVO userOnlineDurationVO = (UserOnlineDurationVO)future.get();
                userOnlineDurationVOList.add(userOnlineDurationVO);
            }
            catch (Exception e) {
                log.info("\u8ba1\u7b97\u89d2\u8272\u5728\u7ebf\u65f6\u957f,\u5b58\u5728\u5f02\u5e38");
            }
        }
        return userOnlineDurationVOList;
    }

    public Future<UserOnlineDurationVO> queryDurationFactory(UserOnlineDurationPO userOnlineDurationPO, HomePageSqlPO homePageSqlPO) {
        return executorService.submit(() -> {
            String queryTime = homePageSqlPO.getSpecificDate();
            UserOnlineDurationVO userOnlineDurationVO = new UserOnlineDurationVO();
            try {
                LocalDate startDate;
                List gameUserDurationList = this.gameUserDurationMapper.queryUserDurationList(homePageSqlPO);
                Integer queryRoleNumber = gameUserDurationList.size();
                if (queryRoleNumber == null || queryRoleNumber == 0) {
                    userOnlineDurationVO.setSpecificDate(homePageSqlPO.getSpecificDate());
                    userOnlineDurationVO.setDeviceNumber(queryRoleNumber);
                    return userOnlineDurationVO;
                }
                ArrayList<String> userRoleIdList = new ArrayList<String>();
                long playtime = 0L;
                Date newDate = new Date();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                for (GameUserDuration gameUserDuration : gameUserDurationList) {
                    long diffInMillies;
                    userRoleIdList.add(gameUserDuration.getUserRoleId());
                    if (gameUserDuration.getLogOnTime() != null && gameUserDuration.getExitTime() == null) {
                        if (sdf.format(new Date()).equals(gameUserDuration.getDurationTime())) {
                            gameUserDuration.setExitTime(newDate);
                            diffInMillies = Math.abs(gameUserDuration.getExitTime().getTime() - gameUserDuration.getLogOnTime().getTime());
                            playtime += TimeUnit.MINUTES.convert(diffInMillies, TimeUnit.MILLISECONDS);
                            continue;
                        }
                        playtime += 1440L;
                        continue;
                    }
                    diffInMillies = Math.abs(gameUserDuration.getExitTime().getTime() - gameUserDuration.getLogOnTime().getTime());
                    playtime += TimeUnit.MINUTES.convert(diffInMillies, TimeUnit.MILLISECONDS);
                }
                homePageSqlPO.setUserRoleIdList(userRoleIdList);
                SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                Date specificDate = fmt.parse(homePageSqlPO.getSpecificDate());
                String[] dateHeadString = new SimpleDateFormat("yyyy-MM-dd").format(specificDate).toString().split("-");
                LocalDate currentDate = startDate = LocalDate.of((int)Integer.valueOf(dateHeadString[0]), Integer.valueOf(dateHeadString[1]), (int)Integer.valueOf(dateHeadString[2]));
                String day = "date";
                HashMap<String, String> dayMap = new HashMap<String, String>();
                LocalDate newLocalDate = LocalDate.now();
                for (int i = 0; i < userOnlineDurationPO.getUserOnlineDurationDay(); ++i) {
                    currentDate = startDate;
                    currentDate = currentDate.plusDays(i);
                    homePageSqlPO.setSpecificDate(String.valueOf(currentDate));
                    if (currentDate.isAfter(newLocalDate)) {
                        dayMap.put(day + (i + 1), "-");
                        continue;
                    }
                    List gameUserDurationForList = this.gameUserDurationMapper.queryAppointUserDurationList(homePageSqlPO);
                    if (gameUserDurationForList == null || gameUserDurationForList.size() == 0) {
                        dayMap.put(day + (i + 1), "-");
                        continue;
                    }
                    long otherPlaytime = 0L;
                    for (GameUserDuration gameUserDuration : gameUserDurationForList) {
                        long diffInMillies;
                        String countTime = gameUserDuration.getDurationTime();
                        if (gameUserDuration.getLogOnTime() != null && gameUserDuration.getExitTime() == null) {
                            if (sdf.format(new Date()).equals(countTime)) {
                                gameUserDuration.setExitTime(newDate);
                                diffInMillies = Math.abs(gameUserDuration.getExitTime().getTime() - gameUserDuration.getLogOnTime().getTime());
                                otherPlaytime += TimeUnit.MINUTES.convert(diffInMillies, TimeUnit.MILLISECONDS);
                                continue;
                            }
                            otherPlaytime += 1440L;
                            continue;
                        }
                        diffInMillies = Math.abs(gameUserDuration.getExitTime().getTime() - gameUserDuration.getLogOnTime().getTime());
                        otherPlaytime += TimeUnit.MINUTES.convert(diffInMillies, TimeUnit.MILLISECONDS);
                    }
                    if (RegisterRetainedTypeEnums.RETAIN.getValue() == userOnlineDurationPO.getRetainedType()) {
                        dayMap.put(day + (i + 1), String.valueOf(otherPlaytime));
                        continue;
                    }
                    dayMap.put(day + (i + 1), String.valueOf(playtime - otherPlaytime));
                }
                ObjectMapper objectMapper = new ObjectMapper();
                UserOnlineDurationVO registerRetainedCount = (UserOnlineDurationVO)objectMapper.convertValue(dayMap, UserOnlineDurationVO.class);
                BeanUtils.copyProperties((Object)registerRetainedCount, (Object)userOnlineDurationVO);
                userOnlineDurationVO.setSpecificDate(queryTime);
                userOnlineDurationVO.setDeviceNumber(Integer.valueOf(gameUserDurationList.size()));
            }
            catch (Exception e) {
                throw new ServiceException("\u7ebf\u7a0b\u6c60\u5f02\u5e38: \u89d2\u8272\u5728\u7ebf\u65f6\u957f\u8ba1\u7b97\u51fa\u73b0\u5f02\u5e38!");
            }
            return userOnlineDurationVO;
        });
    }

    public TableDataInfo queryUserOnLineDetails(RegisterRetainedUserPO registerRetainedUserPO) {
        TableDataInfo tableDataInfo = new TableDataInfo();
        tableDataInfo.setRows(new ArrayList());
        HomePageSqlPO homePageSqlPO = new HomePageSqlPO();
        homePageSqlPO.setServerHead(registerRetainedUserPO.getServerHead());
        homePageSqlPO.setServerTail(registerRetainedUserPO.getServerTail());
        homePageSqlPO.setSpecificDate(registerRetainedUserPO.getSpecificDate());
        List gameUserDurationList = this.gameUserDurationMapper.queryUserDurationList(homePageSqlPO);
        if (gameUserDurationList == null || gameUserDurationList.size() == 0) {
            return tableDataInfo;
        }
        ArrayList<String> userRoleIdList = new ArrayList<String>();
        for (GameUserDuration gameUserDuration : gameUserDurationList) {
            userRoleIdList.add(gameUserDuration.getUserRoleId());
        }
        LocalDate newLocalDate = LocalDate.now();
        List userList = new ArrayList();
        try {
            LocalDate startDate;
            String selectedDate = registerRetainedUserPO.getSelectedDate();
            Integer number = Integer.valueOf(selectedDate.replace("date", ""));
            HomePageSqlPO homePageSqlAppoint = new HomePageSqlPO();
            BeanUtils.copyProperties((Object)registerRetainedUserPO, (Object)homePageSqlAppoint);
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
            Date specificDate = fmt.parse(registerRetainedUserPO.getSpecificDate());
            String[] dateHeadString = new SimpleDateFormat("yyyy-MM-dd").format(specificDate).toString().split("-");
            LocalDate currentDate = startDate = LocalDate.of((int)Integer.valueOf(dateHeadString[0]), Integer.valueOf(dateHeadString[1]), (int)Integer.valueOf(dateHeadString[2]));
            currentDate = currentDate.plusDays(number - 1);
            if (currentDate.isAfter(newLocalDate)) {
                return tableDataInfo;
            }
            homePageSqlAppoint.setSpecificDate(String.valueOf(currentDate));
            homePageSqlAppoint.setUserRoleIdList(userRoleIdList);
            userList = this.gameUserDurationMapper.queryUserRoleIdDurationList(homePageSqlAppoint);
        }
        catch (Exception e) {
            throw new ServiceException("\u89d2\u8272\u5728\u7ebf\u65f6\u957f\u5206\u5929\u67e5\u8be2\u7528\u6237\u4fe1\u606f,\u65f6\u95f4\u89e3\u6790\u51fa\u73b0\u95ee\u9898,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        if (userList == null || userList.size() == 0) {
            return tableDataInfo;
        }
        List<Object> gameUserDurationCountList = new ArrayList();
        int userContentNumber = 0;
        if (RegisterRetainedTypeEnums.RETAIN.getValue() == registerRetainedUserPO.getRetainedType()) {
            gameUserDurationCountList.addAll(userList);
            userContentNumber = userList.size();
        } else {
            List gameUserDurationRetainedList = userList;
            gameUserDurationCountList = gameUserDurationList.stream().filter(gameUserDuration1 -> gameUserDurationRetainedList.stream().noneMatch(gameUserDuration2 -> gameUserDuration2.getUserRoleId() == gameUserDuration1.getUserRoleId())).collect(Collectors.toList());
        }
        int startIndex = (registerRetainedUserPO.getPageNum() - 1) * registerRetainedUserPO.getPageSize();
        int endIndex = Math.min(startIndex + registerRetainedUserPO.getPageSize(), gameUserDurationCountList.size());
        List<Object> currentPageList = gameUserDurationCountList.subList(startIndex, endIndex);
        tableDataInfo.setRows(currentPageList);
        tableDataInfo.setTotal((long)userContentNumber);
        tableDataInfo.setCode(200);
        return tableDataInfo;
    }

    public TableDataInfo selectGameUserDurationList(DoubtfulDataPO doubtfulDataPO) {
        TableDataInfo tableDataInfo = new TableDataInfo();
        int pageNum = (doubtfulDataPO.getPageNum() - 1) * doubtfulDataPO.getPageSize();
        doubtfulDataPO.setPageNum(Integer.valueOf(pageNum));
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = sf.format(new Date());
        doubtfulDataPO.setTodayTime(dateStr);
        List gameUserDurationList = this.gameUserDurationMapper.selectDoubtfulDataList(doubtfulDataPO);
        Integer gameUserDurationNumber = this.gameUserDurationMapper.selectDoubtfulDataNumber(doubtfulDataPO);
        tableDataInfo.setRows(gameUserDurationList);
        tableDataInfo.setTotal((long)gameUserDurationNumber.intValue());
        tableDataInfo.setCode(200);
        return tableDataInfo;
    }

    public Boolean userDurationUpdate(UserDurationUpdatePO userDurationUpdatePO) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DateTimeFormatter formatterSpecific = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdfTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        GameUserDuration gameUserDuration = this.gameUserDurationMapper.queryIdUserDuration(userDurationUpdatePO.getId());
        LocalDate startDate = LocalDate.parse(userDurationUpdatePO.getLogOnTime(), formatter);
        LocalDate endDate = LocalDate.parse(userDurationUpdatePO.getExitTime(), formatter);
        ArrayList<String> timeSlotList = new ArrayList<String>();
        while (startDate.isBefore(endDate) || startDate.isEqual(endDate)) {
            String add = startDate.format(formatterSpecific);
            timeSlotList.add(add);
            startDate = startDate.plusDays(1L);
        }
        try {
            ArrayList<GameUserDuration> gameUserDurationList = new ArrayList<GameUserDuration>();
            for (int i = 0; i < timeSlotList.size(); ++i) {
                GameUserDuration gameUserDurationUpdate;
                GameUserDuration gameUserDurationAdd = new GameUserDuration();
                BeanUtils.copyProperties((Object)gameUserDuration, (Object)gameUserDurationAdd);
                gameUserDurationAdd.setDurationTime((String)timeSlotList.get(i));
                gameUserDurationAdd.setCreateTime(new Date());
                if (sdf.format(sdfTime.parse(userDurationUpdatePO.getLogOnTime())).equals(timeSlotList.get(i)) && sdf.format(sdfTime.parse(userDurationUpdatePO.getExitTime())).equals(timeSlotList.get(i))) {
                    gameUserDurationUpdate = new GameUserDuration();
                    BeanUtils.copyProperties((Object)gameUserDuration, (Object)gameUserDurationUpdate);
                    gameUserDurationUpdate.setExitTime(sdfTime.parse(userDurationUpdatePO.getExitTime()));
                    gameUserDurationUpdate.setOperateMark(UserDurationMarkEnums.ARTIFICIAL_REPAIR_LOG_ON_TIME.getValue());
                    gameUserDurationUpdate.setUpdateTime(new Date());
                    this.gameUserDurationMapper.updateUserDuration(gameUserDurationUpdate);
                    continue;
                }
                if (sdf.format(sdfTime.parse(userDurationUpdatePO.getLogOnTime())).equals(timeSlotList.get(i))) {
                    gameUserDurationUpdate = new GameUserDuration();
                    BeanUtils.copyProperties((Object)gameUserDuration, (Object)gameUserDurationUpdate);
                    gameUserDurationUpdate.setExitTime(sdfTime.parse((String)timeSlotList.get(i) + " 23:59:59"));
                    gameUserDurationUpdate.setOperateMark(UserDurationMarkEnums.ARTIFICIAL_REPAIR_LOG_ON_TIME.getValue());
                    gameUserDurationUpdate.setUpdateTime(new Date());
                    this.gameUserDurationMapper.updateUserDuration(gameUserDurationUpdate);
                    continue;
                }
                if (sdf.format(sdfTime.parse(userDurationUpdatePO.getExitTime())).equals(timeSlotList.get(i))) {
                    gameUserDurationAdd.setLogOnTime(sdfTime.parse((String)timeSlotList.get(i) + " 00:00:00"));
                    gameUserDurationAdd.setExitTime(sdfTime.parse(userDurationUpdatePO.getExitTime()));
                    gameUserDurationAdd.setOperateMark(UserDurationMarkEnums.ARTIFICIAL_REPAIR_EXIT_TIME.getValue());
                } else {
                    gameUserDurationAdd.setLogOnTime(sdfTime.parse((String)timeSlotList.get(i) + " 00:00:00"));
                    gameUserDurationAdd.setExitTime(sdfTime.parse((String)timeSlotList.get(i) + " 23:59:59"));
                    gameUserDurationAdd.setOperateMark(UserDurationMarkEnums.ARTIFICIAL_LOG_ON_AND_EXIT_TIME.getValue());
                }
                gameUserDurationList.add(gameUserDurationAdd);
            }
            if (gameUserDurationList != null && gameUserDurationList.size() > 0) {
                this.gameUserDurationMapper.insertBatchUserDuration(gameUserDurationList);
            }
        }
        catch (Exception e) {
            log.error("\u624b\u52a8\u4fee\u6539\u5b58\u7591\u6570\u636e\u5f02\u5e38={}", (Throwable)e);
            throw new ServiceException("\u5b58\u7591\u6570\u636e\u4fee\u6539,\u65f6\u95f4\u89e3\u6790\u51fa\u73b0\u95ee\u9898,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        return true;
    }

    public Boolean userDurationDelete(Long id) {
        this.gameUserDurationMapper.deleteUserDuration(id);
        return true;
    }
}

