/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.statistics;

import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.rearend.domain.po.statistics.HomePageSqlPO;
import com.ruoyi.rearend.domain.po.statistics.OperateDailyAddPO;
import com.ruoyi.rearend.domain.vo.statistics.OperateDailyAddVO;
import com.ruoyi.rearend.mapper.statistics.HomePageMapper;
import com.ruoyi.rearend.service.statistics.IActiveDailyService;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActiveDailyServiceImpl
implements IActiveDailyService {
    @Autowired
    private HomePageMapper homePageMapper;
    private static ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 12, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(1000), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());

    public List<OperateDailyAddVO> operateDailyActive(OperateDailyAddPO operateDailyAddPO) {
        ArrayList<OperateDailyAddVO> operateDailyAddVOList = new ArrayList<OperateDailyAddVO>();
        List timeList = this.timeHandle(operateDailyAddPO.getTimeHead(), operateDailyAddPO.getTimeTail());
        Collections.reverse(timeList);
        try {
            for (int i = 0; i < timeList.size(); ++i) {
                HomePageSqlPO homePageSqlPO = new HomePageSqlPO();
                BeanUtils.copyProperties((Object)operateDailyAddPO, (Object)homePageSqlPO);
                homePageSqlPO.setSpecificDate((String)timeList.get(i));
                homePageSqlPO.setTimeHead((String)timeList.get(i) + " 00:00:00");
                homePageSqlPO.setTimeTail((String)timeList.get(i) + " 23:59:59");
                OperateDailyAddVO operateDailyAddVO = new OperateDailyAddVO();
                operateDailyAddVO = (OperateDailyAddVO)this.statistics37DataFactory(homePageSqlPO).get();
                operateDailyAddVOList.add(operateDailyAddVO);
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u8fd0\u8425\u65e5\u62a5(\u6d3b\u8dc3)\u8ba1\u7b97\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        return operateDailyAddVOList;
    }

    public List<String> timeHandle(String timeHead, String timeTail) {
        ArrayList<String> timeList = new ArrayList<String>();
        ArrayList<LocalDate> dateList = new ArrayList<LocalDate>();
        try {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
            Date dateHead = fmt.parse(timeHead);
            Date dateTail = fmt.parse(timeTail);
            String[] dateHeadString = new SimpleDateFormat("yyyy-MM-dd").format(dateHead).toString().split("-");
            String[] dateTailString = new SimpleDateFormat("yyyy-MM-dd").format(dateTail).toString().split("-");
            LocalDate startDate = LocalDate.of((int)Integer.valueOf(dateHeadString[0]), Integer.valueOf(dateHeadString[1]), (int)Integer.valueOf(dateHeadString[2]));
            LocalDate endDate = LocalDate.of((int)Integer.valueOf(dateTailString[0]), Integer.valueOf(dateTailString[1]), (int)Integer.valueOf(dateTailString[2]));
            LocalDate currentDate = startDate;
            while (currentDate.isBefore(endDate) || currentDate.equals(endDate)) {
                dateList.add(currentDate);
                currentDate = currentDate.plusDays(1L);
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u8fd0\u8425\u65e5\u62a5(\u6d3b\u8dc3)\u7edf\u8ba1\u65f6\u95f4\u51fa\u73b0\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        for (LocalDate date : dateList) {
            timeList.add(date + "");
        }
        return timeList;
    }

    public Future<OperateDailyAddVO> statistics37DataFactory(HomePageSqlPO homePageSqlPO) {
        return executorService.submit(() -> {
            OperateDailyAddVO operateDailyAddVO = new OperateDailyAddVO();
            operateDailyAddVO.setSpecificDate(homePageSqlPO.getSpecificDate());
            DecimalFormat df = new DecimalFormat("######0.00");
            try {
                List userAccountList = this.homePageMapper.queryActiveUserAccount(homePageSqlPO);
                Integer queryRoleNumber = userAccountList.size();
                homePageSqlPO.setUserAccountIdList(userAccountList);
                Double query37OrderMoney = null;
                Integer query37OrderNumber = 0;
                Integer queryOrderPeople37Number = 0;
                if (userAccountList != null && userAccountList.size() > 0) {
                    query37OrderMoney = this.homePageMapper.query37OrderMoney(homePageSqlPO);
                    query37OrderNumber = this.homePageMapper.query37OrderNumber(homePageSqlPO);
                    queryOrderPeople37Number = this.homePageMapper.queryOrderPeople37Number(homePageSqlPO);
                }
                operateDailyAddVO.setDeviceNumber("\u6682\u65e0");
                operateDailyAddVO.setRoleAverageDuration("\u6682\u65e0");
                operateDailyAddVO.setAveragePosterNumber("\u6682\u65e0");
                operateDailyAddVO.setPosterCompleteNumber("\u6682\u65e0");
                operateDailyAddVO.setRoleNumber(String.valueOf(queryRoleNumber));
                operateDailyAddVO.setInternalRoleNumber(String.valueOf(queryOrderPeople37Number));
                if (query37OrderMoney != null && query37OrderMoney != 0.0) {
                    BigDecimal internalIncomeBigDecimal = new BigDecimal(query37OrderMoney);
                    double internalIncome = internalIncomeBigDecimal.setScale(3, 4).doubleValue();
                    operateDailyAddVO.setInternalIncome(String.valueOf(internalIncome));
                } else {
                    operateDailyAddVO.setInternalIncome("0");
                }
                if (query37OrderMoney != null && query37OrderMoney != 0.0 && queryRoleNumber != null && queryRoleNumber != 0) {
                    Double arpu = query37OrderMoney / (double)queryRoleNumber.intValue();
                    BigDecimal bigDecimal = new BigDecimal(arpu);
                    double arpuNumber = bigDecimal.setScale(3, 4).doubleValue();
                    operateDailyAddVO.setArpuNumber(String.valueOf(arpuNumber));
                } else {
                    operateDailyAddVO.setArpuNumber("0");
                }
                if (query37OrderMoney != null && query37OrderMoney != 0.0 && queryOrderPeople37Number != null && queryOrderPeople37Number != 0) {
                    Double arppu = query37OrderMoney / (double)queryOrderPeople37Number.intValue();
                    BigDecimal bigDecimal = new BigDecimal(arppu);
                    double arppuNumber = bigDecimal.setScale(3, 4).doubleValue();
                    operateDailyAddVO.setArppuNumber(String.valueOf(arppuNumber));
                } else {
                    operateDailyAddVO.setArppuNumber("0");
                }
                if (queryOrderPeople37Number != null && queryOrderPeople37Number != 0 && queryRoleNumber != null && queryRoleNumber != 0) {
                    double rateDouble = (double)queryOrderPeople37Number.intValue() / (double)queryRoleNumber.intValue() * 100.0;
                    operateDailyAddVO.setRate(df.format(rateDouble) + "%");
                } else {
                    operateDailyAddVO.setRate("0");
                }
                if (query37OrderNumber != null && query37OrderNumber != 0 && queryOrderPeople37Number != null && queryOrderPeople37Number != 0) {
                    double rateRoleNumberDouble = (double)query37OrderNumber.intValue() / (double)queryOrderPeople37Number.intValue();
                    operateDailyAddVO.setRateRoleNumber(df.format(rateRoleNumberDouble));
                } else {
                    operateDailyAddVO.setRateRoleNumber("0");
                }
            }
            catch (Exception e) {
                throw new ServiceException("\u7ebf\u7a0b\u6c60\u5f02\u5e38: \u8fd0\u8425\u65e5\u62a5(\u6d3b\u8dc3)37\u8ba1\u7b97\u51fa\u73b0\u5f02\u5e38!");
            }
            return operateDailyAddVO;
        });
    }

    public Future<OperateDailyAddVO> statisticsDataFactory(HomePageSqlPO homePageSqlPO) {
        return executorService.submit(() -> {
            OperateDailyAddVO operateDailyAddVO = new OperateDailyAddVO();
            operateDailyAddVO.setSpecificDate(homePageSqlPO.getSpecificDate());
            DecimalFormat df = new DecimalFormat("######0.00");
            try {
                List userAccountList = this.homePageMapper.queryUserAccount(homePageSqlPO);
                Integer queryRoleNumber = userAccountList.size();
                homePageSqlPO.setUserAccountIdList(userAccountList);
                Double queryOrderMoney = this.homePageMapper.queryOrderMoney(homePageSqlPO);
                Integer queryOrderNumber = this.homePageMapper.queryOrderNumber(homePageSqlPO);
                Integer queryOrderPeopleNumber = this.homePageMapper.queryOrderPeopleNumber(homePageSqlPO);
                operateDailyAddVO.setDeviceNumber("\u6682\u65e0");
                operateDailyAddVO.setRoleAverageDuration("\u6682\u65e0");
                operateDailyAddVO.setAveragePosterNumber("\u6682\u65e0");
                operateDailyAddVO.setPosterCompleteNumber("\u6682\u65e0");
                operateDailyAddVO.setRoleNumber(String.valueOf(queryRoleNumber));
                operateDailyAddVO.setInternalRoleNumber(String.valueOf(queryOrderPeopleNumber));
                if (queryOrderMoney != null && queryOrderMoney != 0.0) {
                    BigDecimal internalIncomeBigDecimal = new BigDecimal(queryOrderMoney);
                    double internalIncome = internalIncomeBigDecimal.setScale(3, 4).doubleValue();
                    operateDailyAddVO.setInternalIncome(String.valueOf(internalIncome));
                } else {
                    operateDailyAddVO.setInternalIncome("0");
                }
                if (queryOrderMoney != null && queryOrderMoney != 0.0 && queryRoleNumber != null && queryRoleNumber != 0) {
                    Double arpu = queryOrderMoney / (double)queryRoleNumber.intValue();
                    BigDecimal bigDecimal = new BigDecimal(arpu);
                    double arpuNumber = bigDecimal.setScale(3, 4).doubleValue();
                    operateDailyAddVO.setArpuNumber(String.valueOf(arpuNumber));
                } else {
                    operateDailyAddVO.setArpuNumber("0");
                }
                if (queryOrderMoney != null && queryOrderMoney != 0.0 && queryOrderPeopleNumber != null && queryOrderPeopleNumber != 0) {
                    Double arppu = queryOrderMoney / (double)queryOrderPeopleNumber.intValue();
                    BigDecimal bigDecimal = new BigDecimal(arppu);
                    double arppuNumber = bigDecimal.setScale(3, 4).doubleValue();
                    operateDailyAddVO.setArppuNumber(String.valueOf(arppuNumber));
                } else {
                    operateDailyAddVO.setArppuNumber("0");
                }
                if (queryOrderPeopleNumber != null && queryOrderPeopleNumber != 0 && queryRoleNumber != null && queryRoleNumber != 0) {
                    double rateDouble = (double)queryOrderPeopleNumber.intValue() / (double)queryRoleNumber.intValue() * 100.0;
                    operateDailyAddVO.setRate(df.format(rateDouble) + "%");
                } else {
                    operateDailyAddVO.setRate("0");
                }
                if (queryOrderNumber != null && queryOrderNumber != 0 && queryOrderPeopleNumber != null && queryOrderPeopleNumber != 0) {
                    double rateRoleNumberDouble = (double)queryOrderNumber.intValue() / (double)queryOrderPeopleNumber.intValue();
                    operateDailyAddVO.setRateRoleNumber(df.format(rateRoleNumberDouble));
                } else {
                    operateDailyAddVO.setRateRoleNumber("0");
                }
            }
            catch (Exception e) {
                throw new ServiceException("\u7ebf\u7a0b\u6c60\u5f02\u5e38: \u8fd0\u8425\u65e5\u62a5(\u6d3b\u8dc3)\u8ba1\u7b97\u51fa\u73b0\u5f02\u5e38!");
            }
            return operateDailyAddVO;
        });
    }

    public Future<OperateDailyAddVO> serverDataFactory(OperateDailyAddPO operateDailyAddPO) {
        return executorService.submit(() -> {
            OperateDailyAddVO operateDailyAddVO = new OperateDailyAddVO();
            return operateDailyAddVO;
        });
    }
}

