/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.server;

import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.core.utils.PageUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.RearClientSwitch;
import com.ruoyi.rearend.domain.RearServer;
import com.ruoyi.rearend.domain.RearServerConfig;
import com.ruoyi.rearend.domain.RearServerMiddle;
import com.ruoyi.rearend.domain.RearServerStateSetUp;
import com.ruoyi.rearend.domain.RearServerSync;
import com.ruoyi.rearend.domain.RearServerVersion;
import com.ruoyi.rearend.domain.ServerDisposeSqlPO;
import com.ruoyi.rearend.domain.po.server.MiddleInsertPO;
import com.ruoyi.rearend.domain.po.server.MiddleUpdatePO;
import com.ruoyi.rearend.domain.po.server.RearServerListPO;
import com.ruoyi.rearend.domain.po.server.ServerInsertPO;
import com.ruoyi.rearend.domain.po.server.ServerUpdatePO;
import com.ruoyi.rearend.domain.vo.server.ClientSwitchVO;
import com.ruoyi.rearend.domain.vo.server.GameSelectVO;
import com.ruoyi.rearend.domain.vo.server.RearChannelSelectVO;
import com.ruoyi.rearend.domain.vo.server.RearRegionSelectVO;
import com.ruoyi.rearend.domain.vo.server.RearServerListVO;
import com.ruoyi.rearend.domain.vo.server.RegionSelectorVO;
import com.ruoyi.rearend.domain.vo.server.ServerMiddleTreeVO;
import com.ruoyi.rearend.domain.vo.server.ServerRegisterVO;
import com.ruoyi.rearend.domain.vo.server.ServerSelectorVO;
import com.ruoyi.rearend.domain.vo.server.ServerStateSelectVO;
import com.ruoyi.rearend.domain.vo.server.ServerVO;
import com.ruoyi.rearend.enums.SwitchEnums;
import com.ruoyi.rearend.enums.server.ClientSwitchTypeEnums;
import com.ruoyi.rearend.enums.server.OpenServerEnums;
import com.ruoyi.rearend.enums.server.ServerMergeTallyEnums;
import com.ruoyi.rearend.enums.server.ServerOpenMarkEnums;
import com.ruoyi.rearend.enums.server.ServerRunStateEnums;
import com.ruoyi.rearend.enums.server.ServerStateEnums;
import com.ruoyi.rearend.enums.server.ServerSuggestEnums;
import com.ruoyi.rearend.enums.server.ServerSyncEnums;
import com.ruoyi.rearend.enums.server.ServerTestMarkEnums;
import com.ruoyi.rearend.enums.server.ServerTestRegionEnums;
import com.ruoyi.rearend.mapper.palyer.GameUserContentMapper;
import com.ruoyi.rearend.mapper.server.RearServerDisposeMapper;
import com.ruoyi.rearend.mapper.server.RearServerMapper;
import com.ruoyi.rearend.service.impl.server.RearChannelServiceImpl;
import com.ruoyi.rearend.service.impl.server.RearClientSwitchServiceImpl;
import com.ruoyi.rearend.service.impl.server.RearGameWrapServiceImpl;
import com.ruoyi.rearend.service.impl.server.RearRegionServiceImpl;
import com.ruoyi.rearend.service.impl.server.RearServerMiddleServiceImpl;
import com.ruoyi.rearend.service.impl.server.RearServerStateSetUpServiceImpl;
import com.ruoyi.rearend.service.impl.server.RearServerVersionServiceImpl;
import com.ruoyi.rearend.service.server.IRearServerService;
import com.ruoyi.rearend.service.server.IRearServerSyncService;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RearServerServiceImpl
implements IRearServerService {
    @Autowired
    private RearServerMapper rearServerMapper;
    @Autowired
    private RearServerDisposeMapper rearServerDisposeMapper;
    @Autowired
    private RearChannelServiceImpl rearChannelServiceImpl;
    @Autowired
    private RearGameWrapServiceImpl rearGameWrapServiceImpl;
    @Autowired
    private RearServerMiddleServiceImpl rearServerMiddleServiceImpl;
    @Autowired
    private RearRegionServiceImpl rearRegionServiceImpl;
    @Autowired
    private RearServerStateSetUpServiceImpl rearServerStateSetUpServiceImpl;
    @Autowired
    private RearServerVersionServiceImpl rearServerVersionServiceImpl;
    @Autowired
    private RearClientSwitchServiceImpl rearClientSwitchServiceImpl;
    @Autowired
    private IRearServerSyncService iRearServerSyncService;
    @Autowired
    private GameUserContentMapper gameUserContentMapper;

    public List<RearServerListVO> queryServerList(RearServerListPO rearServerListPO) {
        ArrayList<RearServerListVO> rearServerListVOList = new ArrayList();
        if (rearServerListPO.getChannelId() != null) {
            List serverIdList = this.rearServerMiddleServiceImpl.selectServerList(rearServerListPO.getChannelId());
            if (serverIdList == null || serverIdList.size() <= 0) {
                return rearServerListVOList;
            }
            rearServerListPO.setServerIdList(serverIdList);
        }
        PageUtils.startPage();
        rearServerListVOList = this.rearServerMapper.queryServerList(rearServerListPO);
        if (rearServerListVOList != null && rearServerListVOList.size() > 0) {
            this.serverListHandle(rearServerListVOList);
        }
        return rearServerListVOList;
    }

    public ServerVO selectRearServerById(Long Id) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ServerVO serverVO = new ServerVO();
        RearServer rearServer = this.rearServerMapper.selectRearServerById(Id);
        BeanUtils.copyProperties((Object)rearServer, (Object)serverVO);
        if (rearServer.getOpenServerTime() != null) {
            serverVO.setOpenServerTimeString(sdf.format(rearServer.getOpenServerTime()));
        }
        List rearServerVersionList = this.rearServerVersionServiceImpl.queryServerVersion(serverVO.getServerId());
        List serverVersionList = rearServerVersionList.stream().map(RearServerVersion::getServerVersion).collect(Collectors.toList());
        serverVO.setServerVersionList(serverVersionList);
        return serverVO;
    }

    public void serverListHandle(List<RearServerListVO> rearServerListVOList) {
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List serverIdList = rearServerListVOList.stream().map(RearServerListVO::getServerId).collect(Collectors.toList());
        Map<String, Integer> serverEnrollmenMap = null;
        if (serverIdList != null && serverIdList.size() > 0) {
            List serverRegisterVOList = this.rearServerMapper.serverEnrollmentNumber(serverIdList);
            serverEnrollmenMap = serverRegisterVOList.stream().collect(Collectors.toMap(ServerRegisterVO::getServerId, ServerRegisterVO::getRegisterNumber));
        }
        RearServerStateSetUp rearServerStateSetUp = this.rearServerStateSetUpServiceImpl.selectRearServerStateSetUpList();
        Date newDate = new Date();
        Calendar rightNow = Calendar.getInstance();
        LocalDateTime currentTime = LocalDateTime.now();
        for (RearServerListVO rearServerListVO : rearServerListVOList) {
            LocalDateTime openServerTime = rearServerListVO.getOpenServerTime();
            Duration duration = Duration.between(openServerTime, currentTime);
            rearServerListVO.setOpenServerDays(duration.toDays() + 1L);
            if (rearServerStateSetUp.getNewServerTime() != 0) {
                ZonedDateTime zonedDateTime = openServerTime.atZone(ZoneId.systemDefault());
                Instant instant2 = zonedDateTime.toInstant();
                rightNow.setTime(Date.from(instant2));
                rightNow.add(10, rearServerStateSetUp.getNewServerTime());
                if (newDate.compareTo(rightNow.getTime()) == -1) {
                    rearServerListVO.setOpenServerState(OpenServerEnums.NEW.getDesc());
                } else {
                    rearServerListVO.setOpenServerState(OpenServerEnums.PAST.getDesc());
                }
            } else {
                rearServerListVO.setOpenServerState(OpenServerEnums.NEW.getDesc());
            }
            rearServerListVO.setServerStatus(ServerStateEnums.getDescByValue((String)rearServerListVO.getServerStatus()));
            rearServerListVO.setServerRunStateName(ServerRunStateEnums.getDescByValue((Integer)rearServerListVO.getServerRunState()));
            rearServerListVO.setServerRealTimeRunStateName(ServerRunStateEnums.getDescByValue((Integer)rearServerListVO.getServerRealTimeRunState()));
            rearServerListVO.setServerTestMarkDescribe(ServerTestMarkEnums.getDescByValue((Integer)rearServerListVO.getServerTestMark()));
            if (serverEnrollmenMap != null && serverEnrollmenMap.get(rearServerListVO.getServerId()) != null) {
                rearServerListVO.setRegisterNumber(serverEnrollmenMap.get(rearServerListVO.getServerId()));
                continue;
            }
            rearServerListVO.setRegisterNumber(Integer.valueOf(0));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public int insertRearServer(ServerInsertPO serverInsertPO) {
        RearServer rearServer = new RearServer();
        BeanUtils.copyProperties((Object)serverInsertPO, (Object)rearServer);
        rearServer.setCreateTime(DateUtils.getNowDate());
        rearServer = this.insertServerHandle(rearServer);
        int insertState = this.rearServerMapper.insertRearServer(rearServer);
        List middleTreeList = serverInsertPO.getMiddleTreeList();
        List middleInsertPOList = new ArrayList();
        middleInsertPOList = this.treeHandle(serverInsertPO.getServerId(), middleTreeList);
        if (middleInsertPOList.size() > 0) {
            this.rearServerMiddleServiceImpl.insertBatchMiddle(middleInsertPOList);
        }
        if (serverInsertPO.getServerVersionList() != null && serverInsertPO.getServerVersionList().size() > 0) {
            ArrayList<RearServerVersion> rearServerVersionList = new ArrayList<RearServerVersion>();
            for (int i = 0; i < serverInsertPO.getServerVersionList().size(); ++i) {
                RearServerVersion rearServerVersion = new RearServerVersion();
                rearServerVersion.setServerId(serverInsertPO.getServerId());
                rearServerVersion.setServerVersion((String)serverInsertPO.getServerVersionList().get(i));
                rearServerVersion.setCreateBy(SecurityUtils.getUsername());
                rearServerVersion.setCreateTime(new Date());
                rearServerVersionList.add(rearServerVersion);
            }
            this.rearServerVersionServiceImpl.insertBatchMiddleDispose(rearServerVersionList);
        }
        ServerDisposeSqlPO serverDisposeSqlPO = new ServerDisposeSqlPO();
        ArrayList<String> syncServerIdList = new ArrayList<String>();
        syncServerIdList.add(serverInsertPO.getServerId());
        serverDisposeSqlPO.setSyncServerIdList(syncServerIdList);
        serverDisposeSqlPO.setOpenServerMark(ServerOpenMarkEnums.OPEN_SERVER.getValue());
        serverDisposeSqlPO.setUpdateBy("\u670d\u52a1\u5668\u5217\u8868\u65b0\u589e");
        serverDisposeSqlPO.setEscalationOperServerTime(new Date());
        serverDisposeSqlPO.setUpdateTime(new Date());
        this.rearServerDisposeMapper.updateRearServerDispose(serverDisposeSqlPO);
        return insertState;
    }

    public RearServer insertServerHandle(RearServer rearServer) {
        ArrayList<String> serverIdList = new ArrayList<String>();
        serverIdList.add(rearServer.getServerId());
        List serverIdExistList = this.rearServerMapper.serverIdExistList(serverIdList);
        if (serverIdExistList != null && serverIdExistList.size() > 0) {
            throw new ServiceException("\u670d\u52a1\u5668ID: " + rearServer.getServerId() + " \u5df2\u5b58\u5728,\u8bf7\u786e\u8ba4\u6570\u636e\u540e\u63d0\u4ea4!");
        }
        Integer serverIdNumber = this.rearServerMapper.serverIdConfigExist(rearServer.getServerId());
        if (serverIdNumber == 0) {
            rearServer.setServerStatus(ServerStateEnums.HIDE.getValue());
            rearServer.setServerRunState(ServerRunStateEnums.MAINTENANCE.getValue());
            rearServer.setServerSuggest(ServerSuggestEnums.NO_RECOMMEND.getValue());
        }
        return rearServer;
    }

    public List<MiddleInsertPO> treeHandle(String serverId, List<String> middleTreeList) {
        String operName = SecurityUtils.getUsername();
        ArrayList<MiddleInsertPO> middleInsertPOList = new ArrayList<MiddleInsertPO>();
        String channelId = "";
        String gameWrapId = "";
        for (int i = 0; i < middleTreeList.size(); ++i) {
            Boolean flag = middleTreeList.get(i).contains(ServerMergeTallyEnums.TALLYONE.getValue());
            if (!flag.booleanValue()) continue;
            MiddleInsertPO middleInsertPO = new MiddleInsertPO();
            channelId = middleTreeList.get(i).substring(0, middleTreeList.get(i).indexOf(ServerMergeTallyEnums.TALLYONE.getValue()));
            middleInsertPO.setChannelId(channelId);
            gameWrapId = middleTreeList.get(i).substring(channelId.length() + 1, middleTreeList.get(i).length());
            middleInsertPO.setGameWrapId(gameWrapId);
            middleInsertPO.setServerId(serverId);
            middleInsertPO.setDelFlag("0");
            middleInsertPO.setCreateBy(operName);
            middleInsertPO.setCreateTime(DateUtils.getNowDate());
            middleInsertPOList.add(middleInsertPO);
        }
        return middleInsertPOList;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateRearServer(ServerUpdatePO serverUpdatePO) {
        Integer serverIdNumber = this.rearServerMapper.serverIdConfigExist(serverUpdatePO.getServerId());
        if (serverIdNumber == 0) {
            throw new ServiceException("\u670d\u52a1\u5668ID: " + serverUpdatePO.getServerId() + " ,\u65e0\u7533\u62a5\u7684IP\u7aef\u53e3,\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539");
        }
        RearServer rearServerQuery = this.rearServerMapper.selectRearServerById(serverUpdatePO.getId());
        if (!rearServerQuery.getServerName().equals(serverUpdatePO.getServerName())) {
            RearServerSync rearServerSync = new RearServerSync();
            rearServerSync.setSyncState(ServerSyncEnums.SYNC.getValue());
            this.iRearServerSyncService.insertRearServerSync(rearServerSync);
        }
        RearServer rearServer = new RearServer();
        BeanUtils.copyProperties((Object)serverUpdatePO, (Object)rearServer);
        rearServer.setUpdateTime(DateUtils.getNowDate());
        int updateState = this.rearServerMapper.updateRearServer(rearServer);
        List middleTreeList = serverUpdatePO.getMiddleTreeList();
        List middleInsertPOList = new ArrayList();
        middleInsertPOList = this.treeHandle(serverUpdatePO.getServerId(), middleTreeList);
        MiddleUpdatePO middleUpdatePO = new MiddleUpdatePO();
        middleUpdatePO.setServerId(serverUpdatePO.getServerId());
        middleUpdatePO.setMiddleInsertPOList(middleInsertPOList);
        this.rearServerMiddleServiceImpl.updateBatchMiddle(middleUpdatePO);
        this.rearServerVersionServiceImpl.updateServerVersion(serverUpdatePO.getServerId(), serverUpdatePO.getServerVersionList());
        return updateState;
    }

    public int deleteRearServerByIds(Long[] Ids) {
        return this.rearServerMapper.deleteRearServerByIds(Ids);
    }

    public int deleteRearServerById(Long Id) {
        return this.rearServerMapper.deleteRearServerById(Id);
    }

    public List<ServerStateSelectVO> serverStateSelect() {
        ArrayList<ServerStateSelectVO> serverStateSelectVOList = new ArrayList<ServerStateSelectVO>();
        for (ServerStateEnums warehouseTypeEnum : EnumSet.allOf(ServerStateEnums.class)) {
            ServerStateSelectVO serverStateSelectVO = new ServerStateSelectVO();
            serverStateSelectVO.setStateCode(warehouseTypeEnum.getValue());
            serverStateSelectVO.setStateName(warehouseTypeEnum.getDesc());
            serverStateSelectVOList.add(serverStateSelectVO);
        }
        return serverStateSelectVOList;
    }

    public List<ServerMiddleTreeVO> middleTree() {
        List rearChannelSelectVOList = this.rearChannelServiceImpl.channelSelect();
        List gameSelectVOList = this.rearGameWrapServiceImpl.gameWrapSelect();
        ArrayList<ServerMiddleTreeVO> serverMiddleTreeVOList = new ArrayList<ServerMiddleTreeVO>();
        for (RearChannelSelectVO rearChannelSelectVO : rearChannelSelectVOList) {
            ServerMiddleTreeVO serverMiddleTreeVOFather = new ServerMiddleTreeVO();
            serverMiddleTreeVOFather.setId(rearChannelSelectVO.getChannelId());
            serverMiddleTreeVOFather.setLabel(rearChannelSelectVO.getChannelName());
            ArrayList childrenFather = new ArrayList();
            for (GameSelectVO gameSelectVO : gameSelectVOList) {
                ServerMiddleTreeVO serverMiddleTreeVOSon = new ServerMiddleTreeVO();
                serverMiddleTreeVOSon.setId(rearChannelSelectVO.getChannelId() + ServerMergeTallyEnums.TALLYONE.getValue() + gameSelectVO.getGameWrapId());
                serverMiddleTreeVOSon.setLabel(gameSelectVO.getGameWrapName());
                serverMiddleTreeVOFather.getChildren().add(serverMiddleTreeVOSon);
            }
            serverMiddleTreeVOList.add(serverMiddleTreeVOFather);
        }
        return serverMiddleTreeVOList;
    }

    public List<String> selectedTree(String serverId) {
        ArrayList<String> selectedList = new ArrayList<String>();
        List rearServerMiddleList = this.rearServerMiddleServiceImpl.selectedTree(serverId);
        for (RearServerMiddle rearServerMiddle : rearServerMiddleList) {
            selectedList.add(rearServerMiddle.getchannelId() + ServerMergeTallyEnums.TALLYONE.getValue() + rearServerMiddle.getgameWrapId());
        }
        return selectedList;
    }

    public List<RegionSelectorVO> regionSelector() {
        ArrayList<RegionSelectorVO> regionSelectorVOList = new ArrayList<RegionSelectorVO>();
        List rearRegionSelectVOList = this.rearRegionServiceImpl.regionSelect();
        List serverSelectorVOList = this.rearServerMapper.serverSelectorList();
        Map<Object, Object> rearRegionSelectMap = new HashMap();
        rearRegionSelectMap = rearRegionSelectVOList.stream().collect(Collectors.toMap(k -> k.getRegionId(), a -> a, (k1, k2) -> k1));
        Map<Object, Object> ServerSelectorMap = new HashMap();
        ServerSelectorMap = serverSelectorVOList.stream().collect(Collectors.groupingBy(ServerSelectorVO::getRegionId));
        for (Map.Entry<Object, Object> entry : rearRegionSelectMap.entrySet()) {
            RegionSelectorVO regionSelectorVO = new RegionSelectorVO();
            regionSelectorVO.setValue((String)entry.getKey());
            regionSelectorVO.setLabel(((RearRegionSelectVO)entry.getValue()).getRegionName());
            List serverSelectorVOListMark = (List)ServerSelectorMap.get(entry.getKey());
            if (serverSelectorVOListMark != null && serverSelectorVOListMark.size() > 0) {
                regionSelectorVO.setChildren(serverSelectorVOListMark);
            } else {
                ArrayList newServerSelectorVOList = new ArrayList();
                regionSelectorVO.setChildren(newServerSelectorVOList);
            }
            regionSelectorVOList.add(regionSelectorVO);
        }
        return regionSelectorVOList;
    }

    public List<Map<String, String>> serverNameList(List<String> serverIdList) {
        return this.rearServerMapper.serverNameList(serverIdList);
    }

    public RearServerConfig serverIdQuery(String serverId) {
        RearServerConfig rearServerConfig = this.rearServerMapper.serverIdQuery(serverId);
        return rearServerConfig;
    }

    public List<RearServerConfig> serverIdQueryList(List<String> serverIdList) {
        return this.rearServerMapper.serverIdQueryList(serverIdList);
    }

    @Transactional(rollbackFor={Exception.class})
    public int insertBatchServer(List<RearServer> rearServerList) {
        ArrayList<String> serverIdList = new ArrayList<String>();
        for (RearServer rearServer : rearServerList) {
            serverIdList.add(rearServer.getServerId());
        }
        List serverIdExist = this.rearServerMapper.serverIdExistList(serverIdList);
        if (serverIdExist.size() > 0) {
            throw new ServiceException("\u5f00\u670d\u5931\u8d25,\u670d\u52a1\u5668ID: " + serverIdExist + ",\u5df2\u5728\u670d\u52a1\u5668\u5217\u8868\u5b58\u5728");
        }
        return this.rearServerMapper.insertBatchServer(rearServerList);
    }

    public List<String> noPrepareServer(List<String> serverIdList) {
        return this.rearServerMapper.noPrepareServerList(serverIdList);
    }

    public ClientSwitchVO clientSwitchQuery() {
        ClientSwitchVO clientSwitchVO = new ClientSwitchVO();
        RearClientSwitch rearClientSwitch = new RearClientSwitch();
        List rearClientSwitchList = this.rearClientSwitchServiceImpl.selectRearClientSwitchList(rearClientSwitch);
        for (RearClientSwitch rearClientSwitchFor : rearClientSwitchList) {
            if (rearClientSwitchFor.getSwitchType().equals(ClientSwitchTypeEnums.ERROR_UPLOAD.getValue())) {
                clientSwitchVO.setErrorUpload(Boolean.valueOf(SwitchEnums.getDescByType((String)rearClientSwitchFor.getSwitchState())));
                continue;
            }
            if (!rearClientSwitchFor.getSwitchType().equals(ClientSwitchTypeEnums.EXT_FLAG.getValue())) continue;
            clientSwitchVO.setExtFlag(Boolean.valueOf(SwitchEnums.getDescByType((String)rearClientSwitchFor.getSwitchState())));
        }
        return clientSwitchVO;
    }

    public Boolean clientSwitchUpdate(RearClientSwitch rearClientSwitch) {
        return this.rearClientSwitchServiceImpl.switchHandle(rearClientSwitch);
    }

    public int serverStateBatchUpdate(String serverRunState, List<String> serverIdList) {
        return this.rearServerMapper.serverStateBatchUpdate(serverRunState, serverIdList);
    }

    public RearServerConfig queryServerConfig(String serverId) {
        RearServerConfig rearServerConfig = this.rearServerMapper.serverIdQuery(serverId);
        return rearServerConfig;
    }

    public Boolean serverSync() {
        RearServerSync rearServerSync = this.iRearServerSyncService.latestArticle();
        RearServerSync rearServerSyncUpdate = new RearServerSync();
        rearServerSyncUpdate.setId(rearServerSync.getId());
        rearServerSyncUpdate.setSyncState(ServerSyncEnums.NO_SYNC.getValue());
        this.iRearServerSyncService.updateRearServerSync(rearServerSyncUpdate);
        return true;
    }

    public Integer serverSyncQuery() {
        RearServerSync rearServerSync = this.iRearServerSyncService.latestArticle();
        if (rearServerSync == null || rearServerSync.getSyncState() == ServerSyncEnums.NO_SYNC.getValue()) {
            return 0;
        }
        return 1;
    }

    public Boolean testServerUserClear(String serverId) {
        RearServer rearServer = this.rearServerMapper.serverIdQueryDetails(serverId);
        if (!rearServer.getRegionId().equals(ServerTestRegionEnums.TEST_REGION.getValue())) {
            throw new ServiceException("\u53ea\u80fd\u6e05\u9664\u5927\u533aID\u4e3a '99' \u7684\u670d\u52a1\u5668");
        }
        this.gameUserContentMapper.deleteServerIdUserContent(serverId);
        return true;
    }
}

