/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.server;

import com.ruoyi.rearend.domain.RearServerOpenLog;
import com.ruoyi.rearend.domain.vo.server.ServerOpenLogListVO;
import com.ruoyi.rearend.mapper.server.RearServerOpenLogMapper;
import com.ruoyi.rearend.service.server.IRearServerOpenLogService;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RearServerOpenLogServiceImpl
implements IRearServerOpenLogService {
    @Autowired
    private RearServerOpenLogMapper rearServerOpenLogMapper;

    public RearServerOpenLog selectRearServerOpenLogById(Long Id) {
        return this.rearServerOpenLogMapper.selectRearServerOpenLogById(Id);
    }

    public List<ServerOpenLogListVO> selectRearServerOpenLogList(RearServerOpenLog rearServerOpenLog) {
        List rearServerOpenLogList = this.rearServerOpenLogMapper.selectRearServerOpenLogList(rearServerOpenLog);
        ArrayList<ServerOpenLogListVO> serverOpenLogListVOList = new ArrayList<ServerOpenLogListVO>();
        LocalDateTime currentTime = LocalDateTime.now();
        for (RearServerOpenLog rearServerOpenLogFor : rearServerOpenLogList) {
            ServerOpenLogListVO serverOpenLogListVO = new ServerOpenLogListVO();
            serverOpenLogListVO.setServerId(rearServerOpenLogFor.getServerId());
            serverOpenLogListVO.setServerName(rearServerOpenLogFor.getServerName());
            serverOpenLogListVO.setOpenServerTime(rearServerOpenLogFor.getOpenServerTime());
            LocalDateTime openServerTime = LocalDateTime.ofInstant(rearServerOpenLogFor.getOpenServerTime().toInstant(), ZoneId.systemDefault());
            Duration duration = Duration.between(openServerTime, currentTime);
            serverOpenLogListVO.setOpenServerDays(duration.toDays() + 1L);
            serverOpenLogListVOList.add(serverOpenLogListVO);
        }
        return serverOpenLogListVOList;
    }
}

