/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.server;

import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.RearServerMiddle;
import com.ruoyi.rearend.domain.po.server.MiddleInsertPO;
import com.ruoyi.rearend.domain.po.server.MiddleUpdatePO;
import com.ruoyi.rearend.mapper.server.RearServerMiddleMapper;
import com.ruoyi.rearend.service.server.IRearServerMiddleService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RearServerMiddleServiceImpl
implements IRearServerMiddleService {
    @Autowired
    private RearServerMiddleMapper rearServerMiddleMapper;

    public RearServerMiddle selectRearServerMiddleById(Long Id) {
        return this.rearServerMiddleMapper.selectRearServerMiddleById(Id);
    }

    public List<RearServerMiddle> selectRearServerMiddleList(RearServerMiddle rearServerMiddle) {
        return this.rearServerMiddleMapper.selectRearServerMiddleList(rearServerMiddle);
    }

    public void insertBatchMiddle(List<MiddleInsertPO> middleInsertPOList) {
        this.rearServerMiddleMapper.insertBatchMiddle(middleInsertPOList);
    }

    public void changeInsertBatchMiddle(List<RearServerMiddle> rearServerMiddleList) {
        this.deleteMultipleConditions(rearServerMiddleList);
        List middleInsertPOList = new ArrayList();
        middleInsertPOList = Lists.transform(rearServerMiddleList, entity -> {
            MiddleInsertPO middleInsertPO = new MiddleInsertPO();
            middleInsertPO.setServerId(entity.getserverId());
            middleInsertPO.setChannelId(entity.getchannelId());
            middleInsertPO.setGameWrapId(entity.getgameWrapId());
            middleInsertPO.setCreateBy(SecurityUtils.getUsername());
            middleInsertPO.setCreateTime(new Date());
            middleInsertPO.setDelFlag("0");
            return middleInsertPO;
        });
        this.insertBatchMiddle(middleInsertPOList);
    }

    public int deleteMultipleConditions(List<RearServerMiddle> rearServerMiddleList) {
        return this.rearServerMiddleMapper.deleteMultipleConditions(rearServerMiddleList);
    }

    public void updateBatchMiddle(MiddleUpdatePO middleUpdatePO) {
        String serverId = middleUpdatePO.getServerId();
        this.deleteBatchMiddle(serverId);
        List middleInsertPOList = middleUpdatePO.getMiddleInsertPOList();
        if (middleInsertPOList != null && middleInsertPOList.size() > 0) {
            this.insertBatchMiddle(middleInsertPOList);
        }
    }

    public int updateRearServerMiddle(RearServerMiddle rearServerMiddle) {
        rearServerMiddle.setUpdateTime(DateUtils.getNowDate());
        return this.rearServerMiddleMapper.updateRearServerMiddle(rearServerMiddle);
    }

    public int deleteRearServerMiddleByIds(Long[] Ids) {
        return this.rearServerMiddleMapper.deleteRearServerMiddleByIds(Ids);
    }

    public int deleteRearServerMiddleById(Long Id) {
        return this.rearServerMiddleMapper.deleteRearServerMiddleById(Id);
    }

    public List<RearServerMiddle> selectedTree(String serverId) {
        return this.rearServerMiddleMapper.selectedTree(serverId);
    }

    public List<String> selectServerList(String channelId) {
        return this.rearServerMiddleMapper.selectServerList(channelId);
    }

    public int deleteBatchMiddle(String serverId) {
        return this.rearServerMiddleMapper.deleteBatchMiddle(serverId);
    }
}

