/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.server;

import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.RearServer;
import com.ruoyi.rearend.domain.RearServerDispose;
import com.ruoyi.rearend.domain.RearServerMiddleDispose;
import com.ruoyi.rearend.domain.RearServerVersion;
import com.ruoyi.rearend.domain.ServerDisposeSqlPO;
import com.ruoyi.rearend.domain.po.server.MiddleDisposeInsertPO;
import com.ruoyi.rearend.domain.po.server.MiddleDisposeUpdatePO;
import com.ruoyi.rearend.domain.po.server.MiddleInsertPO;
import com.ruoyi.rearend.domain.po.server.ServerDisposeInsertPO;
import com.ruoyi.rearend.domain.po.server.ServerDisposeUpdatePO;
import com.ruoyi.rearend.domain.vo.server.DisposeServerIdSelectVO;
import com.ruoyi.rearend.domain.vo.server.RearServerDisposeVO;
import com.ruoyi.rearend.enums.server.ServerMergeTallyEnums;
import com.ruoyi.rearend.enums.server.ServerOpenMarkEnums;
import com.ruoyi.rearend.enums.server.ServerSyncMarkEnums;
import com.ruoyi.rearend.mapper.server.RearServerDisposeMapper;
import com.ruoyi.rearend.service.impl.server.RearServerMiddleDisposeServiceImpl;
import com.ruoyi.rearend.service.impl.server.RearServerMiddleServiceImpl;
import com.ruoyi.rearend.service.impl.server.RearServerServiceImpl;
import com.ruoyi.rearend.service.impl.server.RearServerVersionServiceImpl;
import com.ruoyi.rearend.service.server.IRearServerDisposeService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RearServerDisposeServiceImpl
implements IRearServerDisposeService {
    @Autowired
    private RearServerDisposeMapper rearServerDisposeMapper;
    @Autowired
    private RearServerServiceImpl rearServerServiceImpl;
    @Autowired
    private RearServerMiddleDisposeServiceImpl serverMiddleDisposeServiceImpl;
    @Autowired
    private RearServerMiddleServiceImpl rearServerMiddleServiceImpl;
    @Autowired
    private RearServerVersionServiceImpl rearServerVersionServiceImpl;

    public RearServerDisposeVO selectRearServerDisposeById(Long Id) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        RearServerDisposeVO rearServerDisposeVO = new RearServerDisposeVO();
        RearServerDispose rearServerDispose = this.rearServerDisposeMapper.selectRearServerDisposeById(Id);
        BeanUtils.copyProperties((Object)rearServerDispose, (Object)rearServerDisposeVO);
        if (rearServerDispose.getOpenServerTime() != null) {
            rearServerDisposeVO.setOpenServerTimeString(sdf.format(rearServerDispose.getOpenServerTime()));
        }
        return rearServerDisposeVO;
    }

    public List<RearServerDisposeVO> selectRearServerDisposeList(RearServerDispose rearServerDispose) {
        return this.rearServerDisposeMapper.selectRearServerDisposeList(rearServerDispose);
    }

    @Transactional(rollbackFor={Exception.class})
    public int insertRearServerDispose(ServerDisposeInsertPO serverDisposeInsertPO) {
        RearServerDispose rearServerDispose = new RearServerDispose();
        BeanUtils.copyProperties((Object)serverDisposeInsertPO, (Object)rearServerDispose);
        rearServerDispose.setCreateTime(DateUtils.getNowDate());
        int insertState = this.rearServerDisposeMapper.insertRearServerDispose(rearServerDispose);
        List middleTreeList = serverDisposeInsertPO.getMiddleTreeList();
        List middleDisposeInsertPOList = new ArrayList();
        middleDisposeInsertPOList = this.treeHandle(serverDisposeInsertPO.getServerId(), middleTreeList);
        this.serverMiddleDisposeServiceImpl.insertBatchMiddleDispose(middleDisposeInsertPOList);
        return insertState;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateRearServerDispose(ServerDisposeUpdatePO serverDisposeUpdatePO) {
        if (serverDisposeUpdatePO.getServerVersionList() != null && serverDisposeUpdatePO.getServerVersionList().size() > 1 && serverDisposeUpdatePO.getServerVersionList().contains(null)) {
            throw new ServiceException("\u7248\u672c\u9009\u62e9\u5b58\u5728\u95ee\u9898,\u8bf7\u91cd\u65b0\u9009\u62e9\u540e\u91cd\u8bd5!");
        }
        List syncServerIdList = this.updateServerDisposeHandle(serverDisposeUpdatePO);
        List middleTreeList = serverDisposeUpdatePO.getMiddleTreeList();
        List middleDisposeInsertPOList = new ArrayList();
        middleDisposeInsertPOList = this.treeHandle(serverDisposeUpdatePO.getServerId(), middleTreeList);
        ArrayList middleDisposeSumList = new ArrayList();
        for (int i = 0; i < syncServerIdList.size(); ++i) {
            String serverId = (String)syncServerIdList.get(i);
            List sonMiddleList = new ArrayList();
            sonMiddleList = Lists.transform(middleDisposeInsertPOList, entity -> {
                MiddleDisposeInsertPO middleDisposeInsertPO = new MiddleDisposeInsertPO();
                middleDisposeInsertPO.setServerId(serverId);
                middleDisposeInsertPO.setChannelId(entity.getChannelId());
                middleDisposeInsertPO.setGameWrapId(entity.getGameWrapId());
                return middleDisposeInsertPO;
            });
            middleDisposeSumList.addAll(sonMiddleList);
        }
        MiddleDisposeUpdatePO middleDisposeUpdatePO = new MiddleDisposeUpdatePO();
        middleDisposeUpdatePO.setServerId(serverDisposeUpdatePO.getServerId());
        middleDisposeUpdatePO.setServerIdList(syncServerIdList);
        middleDisposeUpdatePO.setMiddleDisposeInsertPOList(middleDisposeSumList);
        this.serverMiddleDisposeServiceImpl.updateBatchMiddle(middleDisposeUpdatePO);
        int updateState = 0;
        if (syncServerIdList != null && syncServerIdList.size() > 0) {
            Long[] Ids = this.disposeServerServerIdList(syncServerIdList);
            this.batchOpenServer(Ids, serverDisposeUpdatePO.getServerVersionList());
            updateState = 1;
        }
        return updateState;
    }

    public List<String> updateServerDisposeHandle(ServerDisposeUpdatePO serverDisposeUpdatePO) {
        ArrayList<ServerDisposeSqlPO> serverDisposeSqlPOList = new ArrayList<ServerDisposeSqlPO>();
        ArrayList<String> syncServerIdList = new ArrayList<String>();
        syncServerIdList.add(serverDisposeUpdatePO.getServerId());
        if (serverDisposeUpdatePO.getSyncServerIdList() != null) {
            syncServerIdList.addAll(serverDisposeUpdatePO.getSyncServerIdList());
        }
        this.updateDisposeJudge(syncServerIdList);
        Boolean nameMark = false;
        if (serverDisposeUpdatePO.getSyncServerIdList() != null && serverDisposeUpdatePO.getSyncServerIdList().size() > 0) {
            nameMark = true;
        }
        String serverNameHead = null;
        Integer serverNameIn = null;
        String serverNameTail = null;
        if (nameMark.booleanValue()) {
            try {
                String serverName = serverDisposeUpdatePO.getServerName();
                List<String> serverNameList = Arrays.asList(serverName.split("-"));
                serverNameHead = serverNameList.get(0);
                serverNameIn = Integer.valueOf(serverNameList.get(1)) - 1;
                serverNameTail = serverNameList.get(2);
            }
            catch (Exception e) {
                throw new ServiceException("\u4fee\u6539\u6570\u636e\u5b58\u5728\u5f02\u5e38,\u8bf7\u68c0\u67e5\u5f55\u5165\u683c\u5f0f\u662f\u5426\u6b63\u786e");
            }
        }
        for (int i = 0; i < syncServerIdList.size(); ++i) {
            String serverNameSql = null;
            serverNameSql = nameMark != false ? serverNameHead + (serverNameIn + 1 + i) + serverNameTail : serverDisposeUpdatePO.getServerName();
            ServerDisposeSqlPO serverDisposeSqlPO = new ServerDisposeSqlPO();
            BeanUtils.copyProperties((Object)serverDisposeUpdatePO, (Object)serverDisposeSqlPO);
            serverDisposeSqlPO.setServerId((String)syncServerIdList.get(i));
            serverDisposeSqlPO.setServerName(serverNameSql);
            serverDisposeSqlPO.setUpdateBy(SecurityUtils.getUsername());
            serverDisposeSqlPO.setUpdateTime(DateUtils.getNowDate());
            serverDisposeSqlPO.setSyncMark(ServerSyncMarkEnums.SYNC.getValue());
            serverDisposeSqlPO.setSyncServerId(serverDisposeUpdatePO.getServerId());
            serverDisposeSqlPO.setSyncServerName(serverDisposeUpdatePO.getServerName());
            serverDisposeSqlPO.setExpectTime(serverDisposeUpdatePO.getExpectTime());
            serverDisposeSqlPOList.add(serverDisposeSqlPO);
        }
        this.rearServerDisposeMapper.updateBatchServerDispose(serverDisposeSqlPOList);
        return syncServerIdList;
    }

    public void updateDisposeJudge(List<String> syncServerIdList) {
        List queryOpenServerList = this.rearServerDisposeMapper.queryOpenServerList(syncServerIdList);
        if (queryOpenServerList.contains(ServerOpenMarkEnums.OPEN_SERVER.getValue())) {
            throw new ServiceException("\u4fee\u6539\u6570\u636e\u4e2d,\u5b58\u5728\u5df2\u5f00\u670d\u7684\u6570\u636e,\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteRearServerDisposeByIds(Long[] Ids) {
        List idList = Arrays.stream(Ids).collect(Collectors.toList());
        List serverIdList = this.rearServerDisposeMapper.queryServerIdList(idList);
        int deleteState = this.rearServerDisposeMapper.deleteRearServerDisposeByIds(Ids);
        this.serverMiddleDisposeServiceImpl.deleteBatchServerId(serverIdList);
        return deleteState;
    }

    public int deleteRearServerDisposeById(Long Id) {
        return this.rearServerDisposeMapper.deleteRearServerDisposeById(Id);
    }

    public List<MiddleDisposeInsertPO> treeHandle(String serverId, List<String> middleTreeList) {
        String operName = SecurityUtils.getUsername();
        ArrayList<MiddleDisposeInsertPO> middleDisposeInsertPOList = new ArrayList<MiddleDisposeInsertPO>();
        String channelId = "";
        String gameWrapId = "";
        for (int i = 0; i < middleTreeList.size(); ++i) {
            Boolean flag = middleTreeList.get(i).contains(ServerMergeTallyEnums.TALLYONE.getValue());
            if (!flag.booleanValue()) continue;
            MiddleDisposeInsertPO middleDisposeInsertPO = new MiddleDisposeInsertPO();
            channelId = middleTreeList.get(i).substring(0, middleTreeList.get(i).indexOf(ServerMergeTallyEnums.TALLYONE.getValue()));
            middleDisposeInsertPO.setChannelId(channelId);
            gameWrapId = middleTreeList.get(i).substring(channelId.length() + 1, middleTreeList.get(i).length());
            middleDisposeInsertPO.setGameWrapId(gameWrapId);
            middleDisposeInsertPO.setServerId(serverId);
            middleDisposeInsertPO.setDelFlag("0");
            middleDisposeInsertPO.setCreateBy(operName);
            middleDisposeInsertPO.setCreateTime(DateUtils.getNowDate());
            middleDisposeInsertPOList.add(middleDisposeInsertPO);
        }
        return middleDisposeInsertPOList;
    }

    public List<String> selectedTree(String serverId) {
        ArrayList<String> selectedList = new ArrayList<String>();
        List serverMiddleDisposeList = this.serverMiddleDisposeServiceImpl.selectedTree(serverId);
        for (RearServerMiddleDispose serverMiddleDispose : serverMiddleDisposeList) {
            selectedList.add(serverMiddleDispose.getChannelId() + ServerMergeTallyEnums.TALLYONE.getValue() + serverMiddleDispose.getGameWrapId());
        }
        return selectedList;
    }

    public List<DisposeServerIdSelectVO> serverIdSelect(String serverId) {
        ArrayList<DisposeServerIdSelectVO> disposeServerIdSelectVOList = new ArrayList<DisposeServerIdSelectVO>();
        List serverIdSelect = this.rearServerDisposeMapper.serverIdSelect();
        for (int i = 0; i < serverIdSelect.size(); ++i) {
            if (((String)serverIdSelect.get(i)).equals(serverId)) continue;
            DisposeServerIdSelectVO disposeServerIdSelectVO = new DisposeServerIdSelectVO();
            disposeServerIdSelectVO.setServerId((String)serverIdSelect.get(i));
            disposeServerIdSelectVO.setServerName("\u670d\u52a1\u5668ID:   " + (String)serverIdSelect.get(i));
            disposeServerIdSelectVOList.add(disposeServerIdSelectVO);
        }
        return disposeServerIdSelectVOList;
    }

    @Transactional(rollbackFor={Exception.class})
    public int batchOpenServer(Long[] Ids, List<String> serverVersionList) {
        List rearServerMiddleDisposeList;
        List idList = Arrays.stream(Ids).collect(Collectors.toList());
        List rearServerDisposeList = this.rearServerDisposeMapper.disposeServerIdList(idList);
        List rearServerList = new ArrayList();
        rearServerList = Lists.transform((List)rearServerDisposeList, entity -> {
            this.serverValueCheck(entity);
            RearServer rearServer = new RearServer();
            rearServer.setServerId(entity.getServerId());
            rearServer.setServerName(entity.getServerName());
            rearServer.setRegionId(entity.getRegionId());
            rearServer.setServerStatus(entity.getServerStatus());
            rearServer.setServerMark(entity.getServerMark());
            rearServer.setOpenServerTime(entity.getOpenServerTime());
            rearServer.setServerSuggest(entity.getServerSuggest().toString());
            rearServer.setServerRunState(entity.getServerRunState());
            rearServer.setExpectTime(entity.getExpectTime());
            rearServer.setCreateBy(SecurityUtils.getUsername());
            rearServer.setCreateTime(new Date());
            return rearServer;
        });
        ArrayList<String> serverIdAllList = new ArrayList<String>();
        for (RearServer rearServer : rearServerList) {
            serverIdAllList.add(rearServer.getServerId());
        }
        List queryOpenServerList = this.rearServerDisposeMapper.queryOpenServerList(serverIdAllList);
        if (queryOpenServerList.contains(ServerOpenMarkEnums.OPEN_SERVER.getValue())) {
            throw new ServiceException("\u5b58\u5728\u5df2\u5f00\u670d\u7684\u6570\u636e,\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        ArrayList<ServerDisposeSqlPO> serverDisposeSqlPOList = new ArrayList<ServerDisposeSqlPO>();
        for (int i = 0; i < idList.size(); ++i) {
            ServerDisposeSqlPO serverDisposeSqlPO = new ServerDisposeSqlPO();
            serverDisposeSqlPO.setId((Long)idList.get(i));
            serverDisposeSqlPO.setOpenServerMark(ServerOpenMarkEnums.OPEN_SERVER.getValue());
            serverDisposeSqlPO.setEscalationOperServerTime(new Date());
            serverDisposeSqlPO.setUpdateBy(SecurityUtils.getUsername());
            serverDisposeSqlPO.setUpdateTime(new Date());
            serverDisposeSqlPOList.add(serverDisposeSqlPO);
        }
        if (serverDisposeSqlPOList.size() > 0) {
            this.rearServerDisposeMapper.updateBatchDisposeOpen(serverDisposeSqlPOList);
        }
        int addState = this.rearServerServiceImpl.insertBatchServer(rearServerList);
        ArrayList<RearServerVersion> rearServerVersionList = new ArrayList<RearServerVersion>();
        if (serverVersionList != null && serverVersionList.size() > 0 && !serverVersionList.contains(null)) {
            for (RearServerDispose rearServerDispose : rearServerDisposeList) {
                for (int i = 0; i < serverVersionList.size(); ++i) {
                    RearServerVersion rearServerVersion = new RearServerVersion();
                    rearServerVersion.setServerId(rearServerDispose.getServerId());
                    rearServerVersion.setServerVersion(serverVersionList.get(i));
                    rearServerVersion.setCreateBy(SecurityUtils.getUsername());
                    rearServerVersion.setCreateTime(new Date());
                    rearServerVersionList.add(rearServerVersion);
                }
            }
            this.rearServerVersionServiceImpl.insertBatchMiddleDispose(rearServerVersionList);
        }
        if ((rearServerMiddleDisposeList = this.serverMiddleDisposeServiceImpl.queryServerIdList(serverIdAllList)).size() <= 0) {
            return addState;
        }
        List middleInsertPOList = new ArrayList();
        middleInsertPOList = Lists.transform((List)rearServerMiddleDisposeList, entity -> {
            MiddleInsertPO middleInsertPO = new MiddleInsertPO();
            middleInsertPO.setServerId(entity.getServerId());
            middleInsertPO.setChannelId(entity.getChannelId());
            middleInsertPO.setGameWrapId(entity.getGameWrapId());
            middleInsertPO.setCreateBy(SecurityUtils.getUsername());
            middleInsertPO.setCreateTime(new Date());
            middleInsertPO.setDelFlag("0");
            return middleInsertPO;
        });
        this.rearServerMiddleServiceImpl.insertBatchMiddle(middleInsertPOList);
        return addState;
    }

    public void serverValueCheck(RearServerDispose rearServerDispose) {
        String serverId = rearServerDispose.getServerId();
        if (serverId == null) {
            throw new ServiceException("\u7533\u62a5\u5f00\u670d\u4e2d,\u6709\u6570\u636eserverId\u4e0d\u5b58\u5728,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (StringUtils.isEmpty((String)rearServerDispose.getServerName())) {
            throw new ServiceException("\u670d\u52a1\u5668ID: " + serverId + " ; \u670d\u52a1\u5668\u540d\u79f0\u4e3a\u7a7a,\u8bf7\u586b\u5199\u540e\u91cd\u65b0\u7533\u62a5");
        }
        if (StringUtils.isEmpty((String)rearServerDispose.getRegionId())) {
            throw new ServiceException("\u670d\u52a1\u5668ID: " + serverId + " ; \u5927\u533a\u4e3a\u7a7a,\u8bf7\u586b\u5199\u540e\u91cd\u65b0\u7533\u62a5");
        }
        if (StringUtils.isEmpty((String)rearServerDispose.getServerStatus())) {
            throw new ServiceException("\u670d\u52a1\u5668ID: " + serverId + " ; \u670d\u52a1\u5668\u72b6\u6001\u4e3a\u7a7a,\u8bf7\u586b\u5199\u540e\u91cd\u65b0\u7533\u62a5");
        }
        if (rearServerDispose.getOpenServerTime() == null) {
            throw new ServiceException("\u670d\u52a1\u5668ID: " + serverId + " ; \u670d\u52a1\u5668\u5f00\u670d\u65f6\u95f4\u4e3a\u7a7a,\u8bf7\u586b\u5199\u540e\u91cd\u65b0\u7533\u62a5");
        }
        if (rearServerDispose.getServerSuggest() == null) {
            throw new ServiceException("\u670d\u52a1\u5668ID: " + serverId + " ; \u670d\u52a1\u5668\u662f\u5426\u63a8\u8350\u4e3a\u7a7a,\u8bf7\u586b\u5199\u540e\u91cd\u65b0\u7533\u62a5");
        }
    }

    public Long[] disposeServerServerIdList(List<String> serverIdList) {
        return this.rearServerDisposeMapper.disposeServerServerIdList(serverIdList);
    }
}

