/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.server;

import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.RearServerChange;
import com.ruoyi.rearend.domain.RearServerMiddle;
import com.ruoyi.rearend.domain.po.server.ServerStateBatchUpPO;
import com.ruoyi.rearend.enums.server.ServerChangeWayEnums;
import com.ruoyi.rearend.mapper.server.RearServerChangeMapper;
import com.ruoyi.rearend.service.IRearServerChangeService;
import com.ruoyi.rearend.service.impl.server.RearServerMiddleServiceImpl;
import com.ruoyi.rearend.service.impl.server.RearServerServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RearServerChangeServiceImpl
implements IRearServerChangeService {
    @Autowired
    private RearServerChangeMapper rearServerChangeMapper;
    @Autowired
    private RearServerMiddleServiceImpl rearServerMiddleServiceImpl;
    @Autowired
    private RearServerServiceImpl rearServerServiceImpl;

    @Transactional(rollbackFor={Exception.class})
    public int insertRearServerChange(RearServerChange rearServerChange) {
        String channelJson = rearServerChange.getChannelJson();
        List<String> serverPidGidList = Arrays.asList(channelJson.split("\n"));
        List rearServerMiddleList = this.serverPidGidHandle(serverPidGidList);
        if (rearServerChange.getChangeWay().equals(ServerChangeWayEnums.ADD.getValue())) {
            this.rearServerMiddleServiceImpl.changeInsertBatchMiddle(rearServerMiddleList);
        } else {
            this.rearServerMiddleServiceImpl.deleteMultipleConditions(rearServerMiddleList);
        }
        rearServerChange.setCreateBy(SecurityUtils.getUsername());
        rearServerChange.setCreateTime(DateUtils.getNowDate());
        return this.rearServerChangeMapper.insertRearServerChange(rearServerChange);
    }

    public List<RearServerMiddle> serverPidGidHandle(List<String> serverPidGidList) {
        ArrayList<RearServerMiddle> rearServerMiddleList = new ArrayList<RearServerMiddle>();
        try {
            String intercept = "|";
            for (int i = 0; i < serverPidGidList.size(); ++i) {
                String serverPidGidString = serverPidGidList.get(i);
                int index = serverPidGidString.indexOf(",");
                String serverId = serverPidGidString.substring(0, index);
                String interceptAfter = serverPidGidString.substring(index + 1);
                List<String> pidGidSemicolonList = Arrays.asList(interceptAfter.split(";"));
                for (int j = 0; j < pidGidSemicolonList.size(); ++j) {
                    if (!pidGidSemicolonList.get(j).contains(intercept)) {
                        throw new ServiceException("\u7b2c " + (i + 1) + " \u884c\u6570\u636e\u683c\u5f0f\u6709\u8bef,\u8bf7\u91cd\u65b0\u8f93\u5165\u540e\u518d\u8bd5");
                    }
                    String pid = pidGidSemicolonList.get(j).substring(0, pidGidSemicolonList.get(j).indexOf(intercept));
                    String gidString = pidGidSemicolonList.get(j).substring(pid.length() + 1, pidGidSemicolonList.get(j).length());
                    List<String> gidList = Arrays.asList(gidString.split(","));
                    for (int z = 0; z < gidList.size(); ++z) {
                        RearServerMiddle rearServerMiddle = new RearServerMiddle();
                        rearServerMiddle.setserverId(serverId);
                        rearServerMiddle.setchannelId(pid);
                        rearServerMiddle.setgameWrapId(gidList.get(z));
                        rearServerMiddleList.add(rearServerMiddle);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u8bf7\u6309\u683c\u5f0f\u586b\u5165\u6570\u636e !");
        }
        return rearServerMiddleList;
    }

    public Boolean serverStateBatchUpdate(ServerStateBatchUpPO serverStateBatchUpPO) {
        ArrayList serverIdList = new ArrayList();
        String serverContent = serverStateBatchUpPO.getServerContent();
        List<String> serverUntreatedIdList = Arrays.asList(serverContent.split("\n"));
        for (int i = 0; i < serverUntreatedIdList.size(); ++i) {
            String forContent = serverUntreatedIdList.get(i);
            if (forContent.contains(",")) {
                serverIdList.addAll(this.serverCommaHandle(forContent));
                continue;
            }
            serverIdList.addAll(this.serverBarHandle(forContent));
        }
        this.rearServerServiceImpl.serverStateBatchUpdate(serverStateBatchUpPO.getServerRunState(), serverIdList);
        return true;
    }

    public List<String> serverCommaHandle(String serverContent) {
        ArrayList<String> serverCommaList = new ArrayList();
        serverCommaList = Arrays.asList(serverContent.split(","));
        return serverCommaList;
    }

    public List<String> serverBarHandle(String serverContent) {
        ArrayList<String> serverCommaList = new ArrayList<String>();
        String[] stringList = serverContent.split("-");
        Integer startServerId = Integer.valueOf(stringList[0]);
        Integer endServerId = Integer.valueOf(stringList[1]);
        Integer intervalNumber = endServerId - startServerId;
        serverCommaList.add(String.valueOf(startServerId));
        for (int i = 1; i < intervalNumber + 1; ++i) {
            serverCommaList.add(String.valueOf(startServerId + i));
        }
        serverCommaList.add(String.valueOf(endServerId));
        return serverCommaList;
    }
}

