/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.server;

import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.RearServerAutomaticOpen;
import com.ruoyi.rearend.domain.RearServerConfig;
import com.ruoyi.rearend.domain.ServerMiddleAutomaticOpen;
import com.ruoyi.rearend.domain.po.ServerCountPO;
import com.ruoyi.rearend.domain.vo.ServerCountVO;
import com.ruoyi.rearend.enums.OperateMarkEnums;
import com.ruoyi.rearend.mapper.server.RearServerAutomaticOpenMapper;
import com.ruoyi.rearend.service.impl.server.RearServerServiceImpl;
import com.ruoyi.rearend.service.impl.server.ServerMiddleAutomaticOpenServiceImpl;
import com.ruoyi.rearend.service.server.IRearServerAutomaticOpenService;
import com.ruoyi.rearend.utils.InterfaceSendUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RearServerAutomaticOpenServiceImpl
implements IRearServerAutomaticOpenService {
    @Autowired
    private RearServerAutomaticOpenMapper rearServerAutomaticOpenMapper;
    @Autowired
    private InterfaceSendUtils interfaceSendUtils;
    @Autowired
    private RearServerServiceImpl rearServerServiceImpl;
    @Autowired
    private ServerMiddleAutomaticOpenServiceImpl serverMiddleAutomaticOpenServiceImpl;

    public RearServerAutomaticOpen selectRearServerAutomaticOpenById(Long Id) {
        return this.rearServerAutomaticOpenMapper.selectRearServerAutomaticOpenById(Id);
    }

    public List<RearServerAutomaticOpen> selectRearServerAutomaticOpenList(RearServerAutomaticOpen rearServerAutomaticOpen) {
        return this.rearServerAutomaticOpenMapper.selectRearServerAutomaticOpenList(rearServerAutomaticOpen);
    }

    @Transactional(rollbackFor={Exception.class})
    public int insertRearServerAutomaticOpen(RearServerAutomaticOpen rearServerAutomaticOpen) {
        rearServerAutomaticOpen.setCreateBy(SecurityUtils.getUsername());
        rearServerAutomaticOpen.setCreateTime(DateUtils.getNowDate());
        this.rearServerAutomaticOpenMapper.insertRearServerAutomaticOpen(rearServerAutomaticOpen);
        ArrayList<ServerMiddleAutomaticOpen> serverMiddleAutomaticOpenList = new ArrayList<ServerMiddleAutomaticOpen>();
        Date date = new Date();
        this.interfaceSendUtils.serverSlicing(rearServerAutomaticOpen.getDistrictServer());
        List<String> PlayerIdStringList = Arrays.asList(rearServerAutomaticOpen.getDistrictServer().split(","));
        for (int i = 0; i < PlayerIdStringList.size(); ++i) {
            Date dateNew = new Date();
            long time = date.getTime();
            dateNew.setTime(time + (long)(1000 * i));
            ServerMiddleAutomaticOpen serverMiddleAutomaticOpen = new ServerMiddleAutomaticOpen();
            serverMiddleAutomaticOpen.setServerAutomaticOpenId(rearServerAutomaticOpen.getId());
            serverMiddleAutomaticOpen.setServerId(PlayerIdStringList.get(i));
            serverMiddleAutomaticOpen.setAngleThreshold(rearServerAutomaticOpen.getAngleThreshold());
            serverMiddleAutomaticOpen.setCreateBy(SecurityUtils.getUsername());
            serverMiddleAutomaticOpen.setCreateTime(dateNew);
            serverMiddleAutomaticOpenList.add(serverMiddleAutomaticOpen);
        }
        return this.serverMiddleAutomaticOpenServiceImpl.insertBatchMiddle(serverMiddleAutomaticOpenList);
    }

    public int updateRearServerAutomaticOpen(RearServerAutomaticOpen rearServerAutomaticOpen) {
        rearServerAutomaticOpen.setUpdateBy(SecurityUtils.getUsername());
        rearServerAutomaticOpen.setUpdateTime(DateUtils.getNowDate());
        this.rearServerAutomaticOpenMapper.updateRearServerAutomaticOpen(rearServerAutomaticOpen);
        this.serverMiddleAutomaticOpenServiceImpl.deleteBatchMiddle(String.valueOf(rearServerAutomaticOpen.getId()));
        ArrayList<ServerMiddleAutomaticOpen> serverMiddleAutomaticOpenList = new ArrayList<ServerMiddleAutomaticOpen>();
        Date date = new Date();
        this.interfaceSendUtils.serverSlicing(rearServerAutomaticOpen.getDistrictServer());
        List<String> PlayerIdStringList = Arrays.asList(rearServerAutomaticOpen.getDistrictServer().split(","));
        for (int i = 0; i < PlayerIdStringList.size(); ++i) {
            Date dateNew = new Date();
            long time = date.getTime();
            dateNew.setTime(time + (long)(1000 * i));
            ServerMiddleAutomaticOpen serverMiddleAutomaticOpen = new ServerMiddleAutomaticOpen();
            serverMiddleAutomaticOpen.setServerAutomaticOpenId(rearServerAutomaticOpen.getId());
            serverMiddleAutomaticOpen.setServerId(PlayerIdStringList.get(i));
            serverMiddleAutomaticOpen.setAngleThreshold(rearServerAutomaticOpen.getAngleThreshold());
            serverMiddleAutomaticOpen.setCreateBy(SecurityUtils.getUsername());
            serverMiddleAutomaticOpen.setCreateTime(dateNew);
            serverMiddleAutomaticOpenList.add(serverMiddleAutomaticOpen);
        }
        return this.serverMiddleAutomaticOpenServiceImpl.insertBatchMiddle(serverMiddleAutomaticOpenList);
    }

    public int deleteRearServerAutomaticOpenByIds(Long[] Ids) {
        this.rearServerAutomaticOpenMapper.deleteRearServerAutomaticOpenByIds(Ids);
        return this.serverMiddleAutomaticOpenServiceImpl.deleteBatchMiddle(String.valueOf(Ids[0]));
    }

    public int deleteRearServerAutomaticOpenById(Long Id) {
        return this.rearServerAutomaticOpenMapper.deleteRearServerAutomaticOpenById(Id);
    }

    public ServerCountVO serverCount(ServerCountPO serverCountPO) {
        ServerCountVO serverCountVO = new ServerCountVO();
        List rearServerConfigList = this.interfaceSendUtils.serverSlicing(serverCountPO.getDistrictServer());
        List serverIdAllList = rearServerConfigList.stream().map(RearServerConfig::getServerId).collect(Collectors.toList());
        List serverOpenIdList = this.serverMiddleAutomaticOpenServiceImpl.serverAutomaticOpenList(serverIdAllList);
        if (serverCountPO.getOperateMark().equals(OperateMarkEnums.INSERT.getValue()) && serverOpenIdList != null && serverOpenIdList.size() > 0) {
            serverCountVO.setState(Boolean.valueOf(false));
            serverCountVO.setMsg("\u6b64\u670d\u52a1\u5668: " + serverOpenIdList + " \u5df2\u5728\u5217\u8868\u4e2d\u5b58\u5728,\u8bf7\u91cd\u65b0\u8f93\u5165!");
            return serverCountVO;
        }
        serverCountVO.setState(Boolean.valueOf(true));
        serverCountVO.setMsg("\u68c0\u6d4b\u6b63\u5e38,\u53ef\u4ee5\u6b63\u5e38\u81ea\u52a8\u5f00\u670d!");
        return serverCountVO;
    }
}

