/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.server;

import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.rearend.domain.RearGameWrap;
import com.ruoyi.rearend.domain.vo.server.GameSelectVO;
import com.ruoyi.rearend.domain.vo.server.GameWarpListVO;
import com.ruoyi.rearend.domain.vo.server.GameWrapStateVO;
import com.ruoyi.rearend.enums.server.GameWrapStateEnums;
import com.ruoyi.rearend.mapper.server.RearGameWrapMapper;
import com.ruoyi.rearend.service.server.IRearGameWrapService;
import com.ruoyi.rearend.utils.ClassSwitchUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RearGameWrapServiceImpl
implements IRearGameWrapService {
    @Autowired
    private RearGameWrapMapper rearGameWrapMapper;

    public RearGameWrap selectRearGameWrapById(Long Id) {
        return this.rearGameWrapMapper.selectRearGameWrapById(Id);
    }

    public List<RearGameWrap> selectRearGameWrapList(RearGameWrap rearGameWrap) {
        return this.rearGameWrapMapper.selectRearGameWrapList(rearGameWrap);
    }

    public List<GameWarpListVO> gameWarpList(RearGameWrap rearGameWrap) {
        List selectRearGameWrapList = this.rearGameWrapMapper.selectRearGameWrapList(rearGameWrap);
        List gameWarpListVOList = ClassSwitchUtil.copyList((List)selectRearGameWrapList, GameWarpListVO.class);
        for (GameWarpListVO gameWarpListVO : gameWarpListVOList) {
            gameWarpListVO.setGameWrapStatusName(GameWrapStateEnums.getDescByValue((String)gameWarpListVO.getGameWrapStatus()));
        }
        return gameWarpListVOList;
    }

    public int insertRearGameWrap(RearGameWrap rearGameWrap) {
        Integer number = this.rearGameWrapMapper.queryGameWrapNumber(rearGameWrap.getgameWrapId());
        if (number != null && number != 0) {
            throw new ServiceException("\u6b64\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165", Integer.valueOf(500));
        }
        rearGameWrap.setCreateTime(DateUtils.getNowDate());
        return this.rearGameWrapMapper.insertRearGameWrap(rearGameWrap);
    }

    public int updateRearGameWrap(RearGameWrap rearGameWrap) {
        rearGameWrap.setUpdateTime(DateUtils.getNowDate());
        return this.rearGameWrapMapper.updateRearGameWrap(rearGameWrap);
    }

    public int deleteRearGameWrapByIds(Long[] Ids) {
        return this.rearGameWrapMapper.deleteRearGameWrapByIds(Ids);
    }

    public int deleteRearGameWrapById(Long Id) {
        return this.rearGameWrapMapper.deleteRearGameWrapById(Id);
    }

    public List<GameWrapStateVO> gameWrapStateSelect() {
        ArrayList<GameWrapStateVO> gameWrapStateVOList = new ArrayList<GameWrapStateVO>();
        for (GameWrapStateEnums warehouseTypeEnum : EnumSet.allOf(GameWrapStateEnums.class)) {
            GameWrapStateVO gameWrapStateVO = new GameWrapStateVO();
            gameWrapStateVO.setStateCode(warehouseTypeEnum.getValue());
            gameWrapStateVO.setStateName(warehouseTypeEnum.getDesc());
            gameWrapStateVOList.add(gameWrapStateVO);
        }
        return gameWrapStateVOList;
    }

    public List<GameSelectVO> gameWrapSelect() {
        return this.rearGameWrapMapper.gameWrapSelect();
    }

    public List<String> gameWrapAllList() {
        return this.rearGameWrapMapper.gameWrapAllList();
    }
}

