/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.server;

import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.RearServerConfig;
import com.ruoyi.rearend.domain.RearServerLimitationLog;
import com.ruoyi.rearend.domain.po.InterfaceSendPO;
import com.ruoyi.rearend.domain.po.server.CruxButtonPO;
import com.ruoyi.rearend.domain.vo.InterfaceSendVO;
import com.ruoyi.rearend.enums.BaseSuccessFailEnums;
import com.ruoyi.rearend.enums.server.ServerLimitationEnums;
import com.ruoyi.rearend.enums.subsystem.CallReturnEnums;
import com.ruoyi.rearend.service.impl.server.RearServerLimitationLogServiceImpl;
import com.ruoyi.rearend.service.impl.server.RearServerServiceImpl;
import com.ruoyi.rearend.service.server.ICruxButtonService;
import com.ruoyi.rearend.utils.InterfaceSendUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CruxButtonServiceImpl
implements ICruxButtonService {
    @Autowired
    private RearServerServiceImpl rearServerServiceImpl;
    @Autowired
    private InterfaceSendUtils interfaceSendUtils;
    @Autowired
    private RearServerLimitationLogServiceImpl rearServerLimitationLogServiceImpl;

    public String messageLimitationQuery(CruxButtonPO cruxButtonPO) {
        String serviceIdList = this.crossBarHandle(cruxButtonPO.getServiceIdList());
        cruxButtonPO.setServiceIdList(serviceIdList);
        List rearServerConfigList = new ArrayList();
        if (cruxButtonPO.getServiceIdList().contains("*")) {
            rearServerConfigList = this.rearServerServiceImpl.serverIdQueryList(null);
        } else {
            List<String> joinInList = Arrays.asList(cruxButtonPO.getServiceIdList().split(","));
            rearServerConfigList = this.rearServerServiceImpl.serverIdQueryList(joinInList);
        }
        String data = "";
        for (RearServerConfig rearServerConfig : rearServerConfigList) {
            String visitUrl = "http://" + rearServerConfig.getServerIp() + ":" + rearServerConfig.getServerPort() + "/showBlockPacketIds";
            InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
            interfaceSendPO.setVisitUrl(visitUrl);
            interfaceSendPO.setInterfaceDescribe("\u67e5\u770b\u6d88\u606f\u53f7\u9650\u5236");
            HashMap<String, String> suppliedMap = new HashMap<String, String>();
            suppliedMap.put("serviceId", rearServerConfig.getServerId());
            interfaceSendPO.setSuppliedMap(suppliedMap);
            HashMap<String, String> printMap = new HashMap<String, String>();
            printMap.put("serviceId", rearServerConfig.getServerId());
            interfaceSendPO.setPrintMap(printMap);
            InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
            if (interfaceSendVO == null || interfaceSendVO.getCode().equals(CallReturnEnums.SUCCESS.getValue())) continue;
            data = data + "\u670d\u52a1\u5668id: " + rearServerConfig.getServerId() + ", \u9650\u5236: " + interfaceSendVO.getData() + "\n";
        }
        return data;
    }

    public Boolean messageLimitationSetUp(CruxButtonPO cruxButtonPO) {
        String serviceIdList = this.crossBarHandle(cruxButtonPO.getServiceIdList());
        cruxButtonPO.setServiceIdList(serviceIdList);
        List rearServerConfigList = new ArrayList();
        if (cruxButtonPO.getServiceIdList().contains("*")) {
            rearServerConfigList = this.rearServerServiceImpl.serverIdQueryList(null);
        } else {
            List<String> joinInList = Arrays.asList(cruxButtonPO.getServiceIdList().split(","));
            rearServerConfigList = this.rearServerServiceImpl.serverIdQueryList(joinInList);
        }
        List packetIdList = Arrays.stream(cruxButtonPO.getPacketIds().split(",")).collect(Collectors.toList());
        if (rearServerConfigList == null || rearServerConfigList.size() == 0) {
            throw new ServiceException("\u67e5\u8be2\u4e0d\u5230\u8be5\u670d\u52a1\u5668,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        for (RearServerConfig rearServerConfig : rearServerConfigList) {
            String visitUrl = "http://" + rearServerConfig.getServerIp() + ":" + rearServerConfig.getServerPort() + "/setBlockPacketIds";
            InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
            interfaceSendPO.setVisitUrl(visitUrl);
            interfaceSendPO.setInterfaceDescribe("\u8bbe\u7f6e\u6d88\u606f\u53f7\u9650\u5236");
            HashMap<String, Object> suppliedMap = new HashMap<String, Object>();
            suppliedMap.put("serviceId", rearServerConfig.getServerId());
            suppliedMap.put("packetIds", packetIdList);
            interfaceSendPO.setSuppliedMap(suppliedMap);
            HashMap<String, Object> printMap = new HashMap<String, Object>();
            printMap.put("serviceId", rearServerConfig.getServerId());
            printMap.put("packetIds", packetIdList);
            interfaceSendPO.setPrintMap(printMap);
            InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
            if (interfaceSendVO == null || interfaceSendVO.getCode().equals(BaseSuccessFailEnums.SUCCESS.getValue())) continue;
            return false;
        }
        this.serverLimitationLog(cruxButtonPO, ServerLimitationEnums.SET_UP.getValue());
        return true;
    }

    public Boolean messageLimitationSecure(CruxButtonPO cruxButtonPO) {
        String serviceIdList = this.crossBarHandle(cruxButtonPO.getServiceIdList());
        cruxButtonPO.setServiceIdList(serviceIdList);
        List rearServerConfigList = new ArrayList();
        if (cruxButtonPO.getServiceIdList().contains("*")) {
            rearServerConfigList = this.rearServerServiceImpl.serverIdQueryList(null);
        } else {
            List<String> joinInList = Arrays.asList(cruxButtonPO.getServiceIdList().split(","));
            rearServerConfigList = this.rearServerServiceImpl.serverIdQueryList(joinInList);
        }
        List<String> packetIdList = Arrays.asList(cruxButtonPO.getPacketIds());
        if (rearServerConfigList == null || rearServerConfigList.size() == 0) {
            throw new ServiceException("\u67e5\u8be2\u4e0d\u5230\u8be5\u670d\u52a1\u5668,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
        }
        for (RearServerConfig rearServerConfig : rearServerConfigList) {
            String visitUrl = "http://" + rearServerConfig.getServerIp() + ":" + rearServerConfig.getServerPort() + "/clearBlockPacketIds";
            InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
            interfaceSendPO.setVisitUrl(visitUrl);
            interfaceSendPO.setInterfaceDescribe("\u89e3\u9664\u6d88\u606f\u53f7\u9650\u5236");
            HashMap<String, String> suppliedMap = new HashMap<String, String>();
            suppliedMap.put("serviceId", rearServerConfig.getServerId());
            interfaceSendPO.setSuppliedMap(suppliedMap);
            HashMap<String, String> printMap = new HashMap<String, String>();
            printMap.put("serviceId", rearServerConfig.getServerId());
            interfaceSendPO.setPrintMap(printMap);
            InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
            if (interfaceSendVO == null || interfaceSendVO.getCode().equals(BaseSuccessFailEnums.SUCCESS.getValue())) continue;
            return false;
        }
        this.serverLimitationLog(cruxButtonPO, ServerLimitationEnums.SECURE.getValue());
        return true;
    }

    public String crossBarHandle(String serviceId) {
        List<String> joinInList = Arrays.asList(serviceId.split(","));
        String districtServer = "";
        for (int i = 0; i < joinInList.size(); ++i) {
            if (joinInList.get(i).contains("-")) {
                String poleHead = joinInList.get(i).substring(0, joinInList.get(i).indexOf("-"));
                String poleTail = joinInList.get(i).substring(poleHead.length() + 1, joinInList.get(i).length());
                for (int j = Integer.valueOf(poleHead).intValue(); j < Integer.valueOf(poleTail); ++j) {
                    districtServer = districtServer + j + ",";
                }
                continue;
            }
            districtServer = districtServer + joinInList.get(i) + ",";
        }
        String districtServerRemove = districtServer.substring(0, districtServer.length() - 1);
        return districtServerRemove;
    }

    public void serverLimitationLog(CruxButtonPO cruxButtonPO, String operateType) {
        String operName = SecurityUtils.getUsername();
        RearServerLimitationLog rearServerLimitationLog = new RearServerLimitationLog();
        rearServerLimitationLog.setDistrictServer(cruxButtonPO.getServiceIdList());
        rearServerLimitationLog.setLimitationData(cruxButtonPO.getPacketIds());
        rearServerLimitationLog.setOperateType(operateType);
        rearServerLimitationLog.setCreateBy(operName);
        rearServerLimitationLog.setCreateTime(new Date());
        this.rearServerLimitationLogServiceImpl.insertRearServerLimitationLog(rearServerLimitationLog);
    }
}

