/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.player;

import com.alibaba.fastjson.JSON;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.rearend.domain.GameUserContent;
import com.ruoyi.rearend.domain.InternalPlayer;
import com.ruoyi.rearend.domain.RearServerConfig;
import com.ruoyi.rearend.domain.po.InterfaceSendPO;
import com.ruoyi.rearend.domain.po.player.BatchPlayerQueryPO;
import com.ruoyi.rearend.domain.po.player.MessageSwitchPO;
import com.ruoyi.rearend.domain.po.player.PlayerBatchApiPO;
import com.ruoyi.rearend.domain.po.player.PlayerQueryPO;
import com.ruoyi.rearend.domain.po.player.PlayerRoleCheckPO;
import com.ruoyi.rearend.domain.po.player.ValidateLogonPO;
import com.ruoyi.rearend.domain.vo.InterfaceSendVO;
import com.ruoyi.rearend.domain.vo.player.BatchPlayerQueryVO;
import com.ruoyi.rearend.domain.vo.player.PlayerBatchApiVO;
import com.ruoyi.rearend.domain.vo.player.PlayerForbidTimeVO;
import com.ruoyi.rearend.domain.vo.player.PlayerForbidVO;
import com.ruoyi.rearend.domain.vo.player.PlayerQueryApiVO;
import com.ruoyi.rearend.domain.vo.player.PlayerQueryVO;
import com.ruoyi.rearend.domain.vo.player.PlayerRoleCheckVO;
import com.ruoyi.rearend.domain.vo.player.UserDetectionVO;
import com.ruoyi.rearend.domain.vo.server.RegionSelectorVO;
import com.ruoyi.rearend.enums.BaseSuccessFailEnums;
import com.ruoyi.rearend.enums.game.InternalPlayerTypeEnums;
import com.ruoyi.rearend.enums.operate.MailMarkEnums;
import com.ruoyi.rearend.enums.palyer.SendingTypeEnums;
import com.ruoyi.rearend.enums.palyer.UserBanRangeTypeEnums;
import com.ruoyi.rearend.enums.palyer.UserDetectionTypeEnums;
import com.ruoyi.rearend.mapper.game.internalplayer.InternalPlayerMapper;
import com.ruoyi.rearend.mapper.palyer.GameUserContentMapper;
import com.ruoyi.rearend.service.impl.game.footprint.GameUserFootprintServiceImpl;
import com.ruoyi.rearend.service.impl.player.GameUserBanServiceImpl;
import com.ruoyi.rearend.service.impl.server.RearServerServiceImpl;
import com.ruoyi.rearend.service.player.IRearPlayerService;
import com.ruoyi.rearend.utils.InterfaceSendUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class RearPlayerServiceImpl
implements IRearPlayerService {
    @Autowired
    private RearServerServiceImpl rearServerServiceImpl;
    @Autowired
    private InterfaceSendUtils interfaceSendUtils;
    @Autowired
    private GameUserBanServiceImpl gameUserBanServiceImpl;
    @Autowired
    private GameUserFootprintServiceImpl gameUserFootprintService;
    @Autowired
    private InternalPlayerMapper internalPlayerMapper;
    @Autowired
    private GameUserContentMapper gameUserContentMapper;
    private static final Logger log = LoggerFactory.getLogger(RearPlayerServiceImpl.class);

    public PlayerQueryVO selectRearPlayerList(PlayerQueryPO playerQueryPO) {
        PlayerQueryVO playerQueryVO = new PlayerQueryVO();
        PlayerQueryApiVO playerQueryApiVO = new PlayerQueryApiVO();
        Integer serviceId = playerQueryPO.getServiceId();
        RearServerConfig RearServerConfig2 = this.rearServerServiceImpl.serverIdQuery(String.valueOf(serviceId));
        if (RearServerConfig2 == null || StringUtils.isEmpty((String)RearServerConfig2.getServerIp())) {
            throw new ServiceException("\u6b64\u670d\u52a1\u5668\u65e0ip\u4e0a\u62a5\u4fe1\u606f,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String serverIp = RearServerConfig2.getServerIp();
        Integer serverPort = RearServerConfig2.getServerPort();
        String visitUrl = "http://" + serverIp + ":" + serverPort + "/queryPlayer";
        try {
            log.info("\u8c03\u7528\u73a9\u5bb6\u4fe1\u606f\u63a5\u53e3: \u5165\u53c2={}", (Object)playerQueryPO);
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity formEntity = new HttpEntity((Object)playerQueryPO, (MultiValueMap)headers);
            playerQueryApiVO = (PlayerQueryApiVO)restTemplate.postForObject(visitUrl, (Object)formEntity, PlayerQueryApiVO.class, new Object[0]);
            log.info("\u8c03\u7528\u73a9\u5bb6\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de: \u51fa\u53c2={}", (Object)playerQueryApiVO);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u73a9\u5bb6\u5931\u8d25\u8c03\u7528\u670d\u52a1\u7aef\u67e5\u8be2\u73a9\u5bb6\u63a5\u53e3 e\u5f02\u5e38: e={}", (Throwable)e);
            log.error("\u67e5\u8be2\u73a9\u5bb6\u5931\u8d25\u8c03\u7528\u670d\u52a1\u7aef\u67e5\u8be2\u73a9\u5bb6\u63a5\u53e3\u5f02\u5e38: \u5165\u53c2={}", (Object)playerQueryPO);
            throw new ServiceException("\u8c03\u7528\u670d\u52a1\u7aef\u67e5\u8be2\u73a9\u5bb6\u63a5\u53e3\u5f02\u5e38,\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        if (playerQueryApiVO == null || playerQueryApiVO.getCode() != BaseSuccessFailEnums.SUCCESS.getValue() || playerQueryApiVO.getData() == null) {
            log.error("\u67e5\u8be2\u73a9\u5bb6\u5931\u8d25: \u5165\u53c2={},\u51fa\u53c2={}", (Object)playerQueryPO, (Object)playerQueryApiVO);
            throw new ServiceException("\u67e5\u8be2\u73a9\u5bb6\u4fe1\u606f\u5931\u8d25,\u8bf7\u786e\u8ba4\u8d26\u53f7\u4fe1\u606f");
        }
        playerQueryVO = playerQueryApiVO.getData();
        this.playerDetailsHandle(playerQueryVO);
        return playerQueryVO;
    }

    public void playerDetailsHandle(PlayerQueryVO playerQueryVO) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        playerQueryVO.setQueryTime(sdf.format(new Date()));
        this.databaseHandle(playerQueryVO);
        if (playerQueryVO.getPayMode2Money() != null) {
            playerQueryVO.setInternalVoucher((String)playerQueryVO.getPayMode2Money().get("internalVoucher"));
            playerQueryVO.setPublicVoucher((String)playerQueryVO.getPayMode2Money().get("publicVoucher"));
            playerQueryVO.setCash((String)playerQueryVO.getPayMode2Money().get("cash"));
        }
        if (playerQueryVO.getLastOfflineTime() != null && playerQueryVO.getLastOfflineTime() != 0L) {
            playerQueryVO.setLastOfflineTimeShow(sdf.format(playerQueryVO.getLastOfflineTime()));
        } else {
            playerQueryVO.setLastOfflineTimeShow("\u73a9\u5bb6\u5728\u7ebf\u4e2d...");
        }
        if (playerQueryVO.getLastLoginTime() != null && playerQueryVO.getLastLoginTime() != 0L) {
            playerQueryVO.setLastLoginTimeShow(sdf.format(playerQueryVO.getLastLoginTime()));
        }
        PlayerForbidVO forbidData = playerQueryVO.getForbidData();
        PlayerForbidTimeVO playerForbidTimeVO = new PlayerForbidTimeVO();
        playerForbidTimeVO.setEndTimeShow("");
        playerForbidTimeVO.setReason("");
        playerForbidTimeVO.setEndTime(null);
        if (forbidData.getChat_account() != null && forbidData.getChat_account().getEndTime() != null) {
            forbidData.getChat_account().setEndTimeShow(sdf.format(new Date(forbidData.getChat_account().getEndTime() * 1000L)));
        } else {
            forbidData.setChat_account(playerForbidTimeVO);
        }
        if (forbidData.getChat_playerId() != null && forbidData.getChat_playerId().getEndTime() != null) {
            forbidData.getChat_playerId().setEndTimeShow(sdf.format(new Date(forbidData.getChat_playerId().getEndTime() * 1000L)));
        } else {
            forbidData.setChat_playerId(playerForbidTimeVO);
        }
        if (forbidData.getChat_ip() != null && forbidData.getChat_ip().getEndTime() != null) {
            forbidData.getChat_ip().setEndTimeShow(sdf.format(new Date(forbidData.getChat_ip().getEndTime() * 1000L)));
        } else {
            forbidData.setChat_ip(playerForbidTimeVO);
        }
        if (forbidData.getLogin_account() != null && forbidData.getLogin_account().getEndTime() != null) {
            forbidData.getLogin_account().setEndTimeShow(sdf.format(new Date(forbidData.getLogin_account().getEndTime() * 1000L)));
        } else {
            forbidData.setLogin_account(playerForbidTimeVO);
        }
        if (forbidData.getLogin_playerId() != null && forbidData.getLogin_playerId().getEndTime() != null) {
            forbidData.getLogin_playerId().setEndTimeShow(sdf.format(new Date(forbidData.getLogin_playerId().getEndTime() * 1000L)));
        } else {
            forbidData.setLogin_playerId(playerForbidTimeVO);
        }
        if (forbidData.getLogin_ip() != null && forbidData.getLogin_ip().getEndTime() != null) {
            forbidData.getLogin_ip().setEndTimeShow(sdf.format(new Date(forbidData.getLogin_ip().getEndTime() * 1000L)));
        } else {
            forbidData.setLogin_ip(playerForbidTimeVO);
        }
    }

    public void databaseHandle(PlayerQueryVO playerQueryVO) {
        Integer playerId = playerQueryVO.getPlayerId();
        InternalPlayer internalPlayer = this.internalPlayerMapper.internalPlayerDetails(String.valueOf(playerId));
        if (internalPlayer != null) {
            playerQueryVO.setInternalPlayer(InternalPlayerTypeEnums.getDescByValue((String)internalPlayer.getUserPlayerType()));
        } else {
            playerQueryVO.setInternalPlayer(InternalPlayerTypeEnums.DENY.getDesc());
        }
        Integer userBanId = this.gameUserBanServiceImpl.upToDateBanId(playerQueryVO.getServiceId(), playerQueryVO.getPlayerId());
        if (userBanId != null && userBanId != 0) {
            playerQueryVO.setUserBanId(userBanId.intValue());
        } else {
            playerQueryVO.setUserBanId(0);
        }
    }

    public List<RegionSelectorVO> regionSelectorSelect() {
        List regionSelectorVOList = this.rearServerServiceImpl.regionSelector();
        return regionSelectorVOList;
    }

    public PlayerRoleCheckVO playerRoleCheck(PlayerRoleCheckPO playerRoleCheckPO) {
        PlayerQueryPO playerQueryPO = new PlayerQueryPO();
        PlayerQueryVO playerQueryVO = new PlayerQueryVO();
        PlayerRoleCheckVO playerRoleCheckVO = new PlayerRoleCheckVO();
        if (playerRoleCheckPO.getTarget().equals(MailMarkEnums.FULL_SERVICE.getType())) {
            playerRoleCheckVO.setUserAccount(MailMarkEnums.FULL_SERVICE.getDesc());
            playerRoleCheckVO.setUserName(MailMarkEnums.FULL_SERVICE.getDesc());
            playerRoleCheckVO.setState(true);
            return playerRoleCheckVO;
        }
        playerRoleCheckPO.setType(UserBanRangeTypeEnums.BAN_ROLE.getType());
        BeanUtils.copyProperties((Object)playerRoleCheckPO, (Object)playerQueryPO);
        try {
            playerQueryVO = this.selectRearPlayerList(playerQueryPO);
            if (playerQueryVO != null && playerQueryVO.getAccount() != null) {
                playerRoleCheckVO.setUserAccount(playerQueryVO.getAccount());
                playerRoleCheckVO.setUserName(playerQueryVO.getPlayerName());
                playerRoleCheckVO.setUserLevel(playerQueryVO.getPlayerLevel());
                playerRoleCheckVO.setState(true);
            } else {
                playerRoleCheckVO.setUserAccount("\u67e5\u8be2\u5931\u8d25");
                playerRoleCheckVO.setUserName("\u67e5\u8be2\u5931\u8d25");
                playerRoleCheckVO.setState(false);
            }
        }
        catch (Exception e) {
            playerRoleCheckVO.setUserAccount("\u67e5\u8be2\u5931\u8d25");
            playerRoleCheckVO.setUserName("\u67e5\u8be2\u5931\u8d25");
            playerRoleCheckVO.setState(false);
        }
        return playerRoleCheckVO;
    }

    public BatchPlayerQueryVO batchPlayerQuery(BatchPlayerQueryPO batchPlayerQueryPO) {
        BatchPlayerQueryVO batchPlayerQueryVO = this.manyServerBatchPlayerHandle(batchPlayerQueryPO);
        return batchPlayerQueryVO;
    }

    public PlayerBatchApiVO batchPlayerApi(PlayerBatchApiPO playerBatchApiPO) {
        PlayerBatchApiVO playerQueryApiVO = new PlayerBatchApiVO();
        Integer serviceId = playerBatchApiPO.getServiceId();
        RearServerConfig RearServerConfig2 = this.rearServerServiceImpl.serverIdQuery(String.valueOf(serviceId));
        if (RearServerConfig2 == null || StringUtils.isEmpty((String)RearServerConfig2.getServerIp())) {
            throw new ServiceException("\u6b64\u670d\u52a1\u5668\u65e0ip\u4e0a\u62a5\u4fe1\u606f,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String serverIp = RearServerConfig2.getServerIp();
        Integer serverPort = RearServerConfig2.getServerPort();
        String visitUrl = "http://" + serverIp + ":" + serverPort + "/";
        try {
            log.info("\u8c03\u7528\u6279\u91cf\u73a9\u5bb6\u4fe1\u606f\u63a5\u53e3: \u5165\u53c2={}", (Object)playerBatchApiPO);
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity formEntity = new HttpEntity((Object)playerBatchApiPO, (MultiValueMap)headers);
            playerQueryApiVO = (PlayerBatchApiVO)restTemplate.postForObject(visitUrl, (Object)formEntity, PlayerBatchApiVO.class, new Object[0]);
            log.info("\u8c03\u7528\u73a9\u5bb6\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de: \u51fa\u53c2={}", (Object)playerQueryApiVO);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u670d\u52a1\u7aef\u6279\u91cf\u67e5\u8be2\u73a9\u5bb6\u63a5\u53e3\u5f02\u5e38: \u5165\u53c2={}", (Object)playerBatchApiPO);
            throw new ServiceException("\u8c03\u7528\u670d\u52a1\u7aef\u6279\u91cf\u67e5\u8be2\u73a9\u5bb6\u63a5\u53e3\u5f02\u5e38,\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        if (playerQueryApiVO == null || playerQueryApiVO.getCode() != BaseSuccessFailEnums.SUCCESS.getValue() || playerQueryApiVO.getData() == null) {
            log.error("\u6279\u91cf\u67e5\u8be2\u73a9\u5bb6\u5931\u8d25: \u5165\u53c2={},\u51fa\u53c2={}", (Object)playerBatchApiPO, (Object)playerQueryApiVO);
            throw new ServiceException("\u6279\u91cf\u67e5\u8be2\u73a9\u5bb6\u5931\u8d25,\u8bf7\u786e\u8ba4\u8d26\u53f7\u4fe1\u606f");
        }
        return playerQueryApiVO;
    }

    public BatchPlayerQueryVO manyServerBatchPlayer(BatchPlayerQueryPO batchPlayerQueryPO) {
        BatchPlayerQueryVO batchPlayerQueryVO = new BatchPlayerQueryVO();
        batchPlayerQueryVO.setSuccessNumber(Integer.valueOf(0));
        batchPlayerQueryVO.setFailNumber(Integer.valueOf(0));
        batchPlayerQueryVO.setContent("");
        batchPlayerQueryVO.setTextareaContent("");
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        if (SendingTypeEnums.CUSTOM_AND_USER_PLAYER_ID.getValue() == batchPlayerQueryPO.getMailSendingType() || SendingTypeEnums.CUSTOM_AND_USER_ACCOUNT.getValue() == batchPlayerQueryPO.getMailSendingType()) {
            List<String> serverList = Arrays.asList(batchPlayerQueryPO.getUserPlayerId().split("\n"));
            String head = "";
            int appointIndex = 0;
            for (int i = 0; i < serverList.size(); ++i) {
                appointIndex = serverList.get(i).indexOf(",[");
                head = head + serverList.get(i).substring(0, appointIndex) + "\n";
                List<String> dataList = Arrays.asList(serverList.get(i).split(","));
                String roleId = dataList.get(1).replace("|*", "");
                jsonMap.put(dataList.get(0) + "-" + roleId, "," + serverList.get(i).substring(serverList.get(i).lastIndexOf(",[") + 1));
            }
            batchPlayerQueryPO.setUserPlayerId(head);
        }
        List batchPlayerQueryPOList = this.interfaceSendUtils.manyServerPlayerHandle(batchPlayerQueryPO.getUserPlayerId());
        for (BatchPlayerQueryPO batchPlayerQueryPOFor : batchPlayerQueryPOList) {
            batchPlayerQueryPOFor.setMailSendingType(batchPlayerQueryPO.getMailSendingType());
            batchPlayerQueryPOFor.setMailSendingTypeName(SendingTypeEnums.getDescByType((Integer)batchPlayerQueryPO.getMailSendingType()));
            BatchPlayerQueryVO batchPlayerQueryVOFor = this.manyServerBatchPlayerHandle(batchPlayerQueryPOFor);
            batchPlayerQueryVO.setSuccessNumber(Integer.valueOf(batchPlayerQueryVO.getSuccessNumber() + batchPlayerQueryVOFor.getSuccessNumber()));
            batchPlayerQueryVO.setFailNumber(Integer.valueOf(batchPlayerQueryVO.getFailNumber() + batchPlayerQueryVOFor.getFailNumber()));
            batchPlayerQueryVO.setContent(batchPlayerQueryVO.getContent() + batchPlayerQueryVOFor.getContent() + "<p>\n</p>");
            String roleId = batchPlayerQueryPOFor.getUserPlayerId().replace("|*", "");
            String roleIdHandle = roleId.replace("\n", "");
            String montage = batchPlayerQueryPOFor.getServerId() + "-" + roleIdHandle;
            if (jsonMap.get(montage) != null) {
                batchPlayerQueryVO.setTextareaContent(batchPlayerQueryVO.getTextareaContent() + batchPlayerQueryVOFor.getTextareaContent() + jsonMap.get(montage) + "\n");
                continue;
            }
            batchPlayerQueryVO.setTextareaContent(batchPlayerQueryVO.getTextareaContent() + batchPlayerQueryVOFor.getTextareaContent() + "\n");
        }
        return batchPlayerQueryVO;
    }

    public BatchPlayerQueryVO manyServerBatchPlayerHandle(BatchPlayerQueryPO batchPlayerQueryPO) {
        String fullService;
        BatchPlayerQueryVO batchPlayerQueryVO = new BatchPlayerQueryVO();
        List<Object> playerIdStringList = new ArrayList();
        if (!StringUtils.isEmpty((String)batchPlayerQueryPO.getUserPlayerId())) {
            playerIdStringList = Arrays.asList(batchPlayerQueryPO.getUserPlayerId().split("\n"));
        }
        if (playerIdStringList.contains(fullService = MailMarkEnums.FULL_SERVICE.getType() + "|" + MailMarkEnums.FULL_SERVICE.getType()) && playerIdStringList.size() > 1) {
            batchPlayerQueryVO.setSuccessNumber(Integer.valueOf(0));
            batchPlayerQueryVO.setFailNumber(Integer.valueOf(playerIdStringList.size()));
            batchPlayerQueryVO.setContent("\u533a\u670dID: " + batchPlayerQueryPO.getServerId() + ", \u63cf\u8ff0: \u53d1\u9001\u5168\u670d\u65f6,\u8bf7\u4e0d\u8981\u586b\u5199\u5176\u4ed6 \u89d2\u8272id/\u6635\u79f0 \u5185\u5bb9");
            batchPlayerQueryVO.setTextareaContent(batchPlayerQueryPO.getServerId() + "," + (String)playerIdStringList.get(0));
            return batchPlayerQueryVO;
        }
        if (playerIdStringList.contains(fullService) && playerIdStringList.size() == 1) {
            batchPlayerQueryVO.setSuccessNumber(Integer.valueOf(1));
            batchPlayerQueryVO.setFailNumber(Integer.valueOf(0));
            batchPlayerQueryVO.setContent("\u533a\u670dID: " + batchPlayerQueryPO.getServerId() + ", \u63cf\u8ff0: \u53d1\u9001\u5168\u670d\u73a9\u5bb6");
            batchPlayerQueryVO.setTextareaContent(batchPlayerQueryPO.getServerId() + "," + (String)playerIdStringList.get(0));
            return batchPlayerQueryVO;
        }
        String intercept = "|";
        String roleId = "";
        ArrayList<String> playerList = new ArrayList<String>();
        try {
            for (int i = 0; i < playerIdStringList.size(); ++i) {
                roleId = ((String)playerIdStringList.get(i)).substring(0, ((String)playerIdStringList.get(i)).indexOf(intercept));
                playerList.add(roleId);
            }
        }
        catch (Exception e) {
            throw new ServiceException("\u73a9\u5bb6\u89d2\u8272id\u586b\u5199\u6709\u8bef!");
        }
        List userDetectionVOList = this.userDetectionHandle(batchPlayerQueryPO.getServerId(), playerList);
        String content = "";
        String textareaContent = "";
        Integer successNumber = 0;
        Integer failNumber = 0;
        for (UserDetectionVO userDetectionVO : userDetectionVOList) {
            if (userDetectionVO.getExist().booleanValue()) {
                successNumber = successNumber + 1;
                textareaContent = textareaContent + userDetectionVO.getPlayerId() + "|" + userDetectionVO.getPlayerName() + ",";
                content = content + "<p>\u533a\u670dID: " + batchPlayerQueryPO.getServerId() + ",\u89d2\u8272ID: " + userDetectionVO.getPlayerId() + ",\u6635\u79f0: " + userDetectionVO.getPlayerName() + ",\u8d26\u53f7: " + userDetectionVO.getAccount() + ",\u662f\u5426\u6b63\u5e38: " + userDetectionVO.getExist() + "</p>";
                continue;
            }
            failNumber = failNumber + 1;
            content = content + "<p><span style=\"color: rgb(230, 0, 0);\">\u533a\u670dID: " + batchPlayerQueryPO.getServerId() + ",\u89d2\u8272ID: " + userDetectionVO.getPlayerId() + ",\u6635\u79f0: " + userDetectionVO.getPlayerName() + ",\u8d26\u53f7: " + userDetectionVO.getAccount() + ",\u662f\u5426\u6b63\u5e38: " + userDetectionVO.getExist() + "</span></p>";
        }
        textareaContent = batchPlayerQueryPO.getServerId() + "," + textareaContent;
        textareaContent = textareaContent.substring(0, textareaContent.length() - 1);
        batchPlayerQueryVO.setSuccessNumber(successNumber);
        batchPlayerQueryVO.setFailNumber(failNumber);
        batchPlayerQueryVO.setContent(content);
        batchPlayerQueryVO.setTextareaContent(textareaContent);
        return batchPlayerQueryVO;
    }

    public List<UserDetectionVO> userDetectionHandle(String serverId, List<String> playerList) {
        String visitUrl = this.interfaceSendUtils.serverUrlAddress(serverId, "queryPlayerSimple");
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        interfaceSendPO.setVisitUrl(visitUrl);
        interfaceSendPO.setInterfaceDescribe("\u73a9\u5bb6\u68c0\u6d4b");
        HashMap<String, Object> suppliedMap = new HashMap<String, Object>();
        suppliedMap.put("serviceId", serverId);
        suppliedMap.put("targets", playerList);
        suppliedMap.put("type", UserDetectionTypeEnums.PLAYER_ID.getValue());
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, Object> printMap = new HashMap<String, Object>();
        printMap.put("serviceId", serverId);
        printMap.put("targets", playerList);
        printMap.put("type", UserDetectionTypeEnums.PLAYER_ID.getValue());
        interfaceSendPO.setPrintMap(printMap);
        InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
        String jsonString = JSON.toJSONString((Object)interfaceSendVO.getData());
        if (!interfaceSendVO.getState().booleanValue()) {
            throw new ServiceException("\u73a9\u5bb6\u68c0\u6d4b\u5931\u8d25: " + interfaceSendVO.getMsg());
        }
        List<UserDetectionVO> userDetectionVOList = new ArrayList();
        userDetectionVOList = JSON.parseArray((String)jsonString, UserDetectionVO.class);
        for (UserDetectionVO userDetectionVO : userDetectionVOList) {
            if (userDetectionVO.getExist().booleanValue()) continue;
            userDetectionVO.setAccount("\u7528\u6237\u4e0d\u5b58\u5728");
            userDetectionVO.setPlayerName("\u7528\u6237\u4e0d\u5b58\u5728");
        }
        return userDetectionVOList;
    }

    public List<GameUserContent> userLogOnServer(PlayerQueryPO playerQueryPO) {
        GameUserContent gameUserContent = new GameUserContent();
        if (playerQueryPO.getType().equals(UserDetectionTypeEnums.PLAYER_ID.getValue())) {
            gameUserContent.setUserRoleId(playerQueryPO.getTarget());
            gameUserContent.setUserRoleName(null);
            gameUserContent.setUserAccount(null);
        } else if (playerQueryPO.getType().equals(UserDetectionTypeEnums.PLAYER_NAME.getValue())) {
            gameUserContent.setUserRoleId(null);
            gameUserContent.setUserRoleName(playerQueryPO.getTarget());
            gameUserContent.setUserAccount(null);
        } else if (playerQueryPO.getType().equals(UserDetectionTypeEnums.ACCOUNT.getValue())) {
            gameUserContent.setUserRoleId(null);
            gameUserContent.setUserRoleName(null);
            gameUserContent.setUserAccount(playerQueryPO.getTarget());
        }
        List gameUserContentList = this.gameUserContentMapper.queryUserContent(gameUserContent);
        return gameUserContentList;
    }

    public Boolean messageSwitch(MessageSwitchPO messageSwitchPO) {
        Boolean state = false;
        String visitUrl = this.interfaceSendUtils.serverUrlAddress(messageSwitchPO.getServiceId(), "packetDebug");
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        interfaceSendPO.setVisitUrl(visitUrl);
        interfaceSendPO.setInterfaceDescribe("\u6d88\u606fdebug\u5f00\u5173");
        HashMap<String, Object> suppliedMap = new HashMap<String, Object>();
        suppliedMap.put("serviceId", messageSwitchPO.getServiceId());
        suppliedMap.put("playerId", messageSwitchPO.getPlayerId());
        suppliedMap.put("open", messageSwitchPO.getOpen());
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, Object> printMap = new HashMap<String, Object>();
        printMap.put("serviceId", messageSwitchPO.getServiceId());
        printMap.put("playerId", messageSwitchPO.getPlayerId());
        printMap.put("open", messageSwitchPO.getOpen());
        interfaceSendPO.setPrintMap(printMap);
        InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
        if (!interfaceSendVO.getState().booleanValue()) {
            throw new ServiceException("\u6d88\u606fdebug\u5f00\u5173\u5931\u8d25: " + interfaceSendVO.getMsg());
        }
        if (interfaceSendVO.getCode() == BaseSuccessFailEnums.SUCCESS.getValue()) {
            state = true;
        }
        return state;
    }

    public Boolean validateLogon(ValidateLogonPO validateLogonPO) {
        Boolean state = false;
        String visitUrl = this.interfaceSendUtils.serverUrlAddress(validateLogonPO.getServiceId(), "accountLoginAuth");
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        interfaceSendPO.setVisitUrl(visitUrl);
        interfaceSendPO.setInterfaceDescribe("\u767b\u5f55\u9a8c\u8bc1\u5f00\u5173");
        HashMap<String, Object> suppliedMap = new HashMap<String, Object>();
        suppliedMap.put("serviceId", validateLogonPO.getServiceId());
        suppliedMap.put("account", validateLogonPO.getAccount());
        suppliedMap.put("skip", validateLogonPO.getSkip());
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, Object> printMap = new HashMap<String, Object>();
        printMap.put("serviceId", validateLogonPO.getServiceId());
        printMap.put("account", validateLogonPO.getAccount());
        printMap.put("skip", validateLogonPO.getSkip());
        interfaceSendPO.setPrintMap(printMap);
        InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
        if (!interfaceSendVO.getState().booleanValue()) {
            throw new ServiceException("\u767b\u5f55\u9a8c\u8bc1\u5f00\u5173\u5931\u8d25: " + interfaceSendVO.getMsg());
        }
        if (interfaceSendVO.getCode() == BaseSuccessFailEnums.SUCCESS.getValue()) {
            state = true;
        }
        return state;
    }
}

