/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.player;

import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.core.utils.PageUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.GameUserBan;
import com.ruoyi.rearend.domain.GameUserBanLog;
import com.ruoyi.rearend.domain.RearServerConfig;
import com.ruoyi.rearend.domain.po.player.userban.GameUserBanAddPO;
import com.ruoyi.rearend.domain.po.player.userban.GameUserBanAddSqlPO;
import com.ruoyi.rearend.domain.po.player.userban.GameUserBanDeletePO;
import com.ruoyi.rearend.domain.po.player.userban.GameUserBanLogAddPO;
import com.ruoyi.rearend.domain.po.player.userban.PlayerBanPO;
import com.ruoyi.rearend.domain.vo.player.GameUserBanQueryVO;
import com.ruoyi.rearend.domain.vo.player.PlayerForbidApiVO;
import com.ruoyi.rearend.enums.BaseSuccessFailEnums;
import com.ruoyi.rearend.enums.DelFlagEnums;
import com.ruoyi.rearend.enums.palyer.BanMarkEnums;
import com.ruoyi.rearend.enums.palyer.UserBanRangeTypeEnums;
import com.ruoyi.rearend.enums.palyer.UserBanTypeEnums;
import com.ruoyi.rearend.mapper.palyer.GameUserBanMapper;
import com.ruoyi.rearend.service.impl.player.GameUserBanLogServiceImpl;
import com.ruoyi.rearend.service.impl.player.RearPlayerServiceImpl;
import com.ruoyi.rearend.service.impl.server.RearServerServiceImpl;
import com.ruoyi.rearend.service.player.IGameUserBanService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class GameUserBanServiceImpl
implements IGameUserBanService {
    @Autowired
    private GameUserBanMapper gameUserBanMapper;
    @Autowired
    private GameUserBanLogServiceImpl gameUserBanLogServiceImpl;
    @Autowired
    private RearServerServiceImpl rearServerServiceImpl;
    private static final Logger log = LoggerFactory.getLogger(RearPlayerServiceImpl.class);

    public GameUserBan selectGameUserBanById(Long Id) {
        return this.gameUserBanMapper.selectGameUserBanById(Id);
    }

    public List<GameUserBanQueryVO> selectGameUserBanList(GameUserBan gameUserBan) {
        this.gameUserBanLogServiceImpl.expiredUserBan();
        List<Object> gameUserBanQueryVOList = new ArrayList<GameUserBanQueryVO>();
        PageUtils.startPage();
        List gameUserBanLogList = this.gameUserBanMapper.selectGameUserBanList(gameUserBan);
        if (gameUserBanLogList == null || gameUserBanLogList.size() <= 0) {
            return gameUserBanQueryVOList;
        }
        ArrayList<String> serverIdList = new ArrayList<String>();
        for (GameUserBan gameUserBanFor : gameUserBanLogList) {
            serverIdList.add(gameUserBanFor.getServerId());
        }
        List serverIdMapList = this.rearServerServiceImpl.serverNameList(serverIdList);
        HashMap serverIdMap = new HashMap();
        for (int i = 0; i < serverIdMapList.size(); ++i) {
            serverIdMap.put(((Map)serverIdMapList.get(i)).get("server_id"), ((Map)serverIdMapList.get(i)).get("server_name"));
        }
        gameUserBanQueryVOList = Lists.transform((List)gameUserBanLogList, entity -> {
            GameUserBanQueryVO gameUserBanQueryVO = new GameUserBanQueryVO();
            gameUserBanQueryVO.setId(entity.getId());
            gameUserBanQueryVO.setServerId(entity.getServerId());
            gameUserBanQueryVO.setServerName((String)serverIdMap.get(entity.getServerId()));
            gameUserBanQueryVO.setBanType(entity.getBanType());
            gameUserBanQueryVO.setBanTypeDescribe(UserBanTypeEnums.getDescByValue((Integer)Integer.valueOf(entity.getBanType())));
            gameUserBanQueryVO.setBanRangeType(entity.getBanRangeType());
            gameUserBanQueryVO.setBanRangeTypeDescribe(UserBanRangeTypeEnums.getDescByValue((Integer)Integer.valueOf(entity.getBanRangeType())));
            gameUserBanQueryVO.setBanName(entity.getBanName());
            gameUserBanQueryVO.setBanTime(entity.getBanTime());
            gameUserBanQueryVO.setBanReason(entity.getBanReason());
            gameUserBanQueryVO.setCreateTime(entity.getCreateTime());
            return gameUserBanQueryVO;
        });
        return gameUserBanQueryVOList;
    }

    @Transactional(rollbackFor={Exception.class})
    public int insertGameUserBan(GameUserBanAddPO gameUserBanAddPO) {
        String operName = SecurityUtils.getUsername();
        Long second = gameUserBanAddPO.getBanTime() * 60L;
        String banName = gameUserBanAddPO.getBanName();
        List<String> banNameList = Arrays.asList(banName.split("\n"));
        PlayerBanPO playerBanPO = new PlayerBanPO();
        playerBanPO.setServiceId(Integer.valueOf(gameUserBanAddPO.getServerId()));
        playerBanPO.setType(UserBanTypeEnums.getDescByType((Integer)Integer.valueOf(gameUserBanAddPO.getBanType())));
        playerBanPO.setTarget(UserBanRangeTypeEnums.getDescByType((Integer)Integer.valueOf(gameUserBanAddPO.getBanRangeType())));
        playerBanPO.setList(banNameList);
        playerBanPO.setForbid(Boolean.valueOf(true));
        playerBanPO.setForbidSecs(String.valueOf(second));
        playerBanPO.setReason(gameUserBanAddPO.getBanReason());
        PlayerForbidApiVO playerForbidApiVO = new PlayerForbidApiVO();
        Integer serviceId = Integer.valueOf(gameUserBanAddPO.getServerId());
        RearServerConfig RearServerConfig2 = this.rearServerServiceImpl.serverIdQuery(String.valueOf(serviceId));
        if (RearServerConfig2 == null || StringUtils.isEmpty((String)RearServerConfig2.getServerIp())) {
            throw new ServiceException("\u6b64\u670d\u52a1\u5668\u65e0ip\u4e0a\u62a5\u4fe1\u606f,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String serverIp = RearServerConfig2.getServerIp();
        Integer serverPort = RearServerConfig2.getServerPort();
        String visitUrl = "http://" + serverIp + ":" + serverPort + "/forbid";
        try {
            log.info("\u8c03\u7528\u5c01\u7981\u73a9\u5bb6: \u5165\u53c2={}", (Object)playerBanPO);
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity formEntity = new HttpEntity((Object)playerBanPO, (MultiValueMap)headers);
            playerForbidApiVO = (PlayerForbidApiVO)restTemplate.postForObject(visitUrl, (Object)formEntity, PlayerForbidApiVO.class, new Object[0]);
            log.info("\u8c03\u7528\u5c01\u7981\u73a9\u5bb6\u8fd4\u56de: \u51fa\u53c2={}", (Object)playerForbidApiVO);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5c01\u7981\u73a9\u5bb6\u63a5\u53e3\u5f02\u5e38: \u5165\u53c2={}", (Object)gameUserBanAddPO);
            throw new ServiceException("\u8c03\u7528\u5c01\u7981\u73a9\u5bb6\u63a5\u53e3\u5f02\u5e38,\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        if (playerForbidApiVO == null || playerForbidApiVO.getCode() != BaseSuccessFailEnums.SUCCESS.getValue()) {
            log.error("\u5c01\u7981\u73a9\u5bb6\u5931\u8d25: \u5165\u53c2={},\u51fa\u53c2={}", (Object)gameUserBanAddPO, (Object)playerForbidApiVO);
            throw new ServiceException("\u5c01\u7981\u73a9\u5bb6\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        this.gameUserBanDelete(banNameList, operName, gameUserBanAddPO);
        int state = this.gameUserBanAdd(banNameList, operName, gameUserBanAddPO);
        return state;
    }

    public Integer gameUserBanAdd(List<String> banNameList, String operName, GameUserBanAddPO gameUserBanAddPO) {
        Date newDate = new Date();
        Long banTime = gameUserBanAddPO.getBanTime() * 60L * 1000L;
        Date banTimeDate = new Date(newDate.getTime() + banTime);
        ArrayList<GameUserBanAddSqlPO> gameUserBanAddSqlPOList = new ArrayList<GameUserBanAddSqlPO>();
        for (int i = 0; i < banNameList.size(); ++i) {
            GameUserBanAddSqlPO gameUserBanAddSqlPO = new GameUserBanAddSqlPO();
            gameUserBanAddSqlPO.setServerId(gameUserBanAddPO.getServerId());
            gameUserBanAddSqlPO.setBanType(gameUserBanAddPO.getBanType());
            gameUserBanAddSqlPO.setBanRangeType(gameUserBanAddPO.getBanRangeType());
            gameUserBanAddSqlPO.setBanName(banNameList.get(i));
            gameUserBanAddSqlPO.setBanTime(banTimeDate);
            gameUserBanAddSqlPO.setBanReason(gameUserBanAddPO.getBanReason());
            gameUserBanAddSqlPO.setCreateTime(new Date());
            gameUserBanAddSqlPO.setCreateBy(operName);
            gameUserBanAddSqlPOList.add(gameUserBanAddSqlPO);
        }
        int state = this.gameUserBanMapper.insertBatchMiddle(gameUserBanAddSqlPOList);
        if (state == 1) {
            this.userBanLogRecord(BaseSuccessFailEnums.SUCCESS.getValue().intValue(), "\u5c01\u7981\u73a9\u5bb6\u6210\u529f", gameUserBanAddPO);
        } else {
            this.userBanLogRecord(BaseSuccessFailEnums.FAIL.getValue().intValue(), "SQL\u5c01\u7981\u73a9\u5bb6\u5931\u8d25,\u6e38\u620f\u7aef\u89e3\u5c01\u6210\u529f", gameUserBanAddPO);
        }
        return state;
    }

    public Integer gameUserBanFalseDeletion(List<String> banNameList, String operName, GameUserBanAddPO gameUserBanAddPO) {
        GameUserBanDeletePO gameUserBanDeletePO = new GameUserBanDeletePO();
        gameUserBanDeletePO.setBanNameList(banNameList);
        gameUserBanDeletePO.setBanType(gameUserBanAddPO.getBanType());
        gameUserBanDeletePO.setBanRangeType(gameUserBanAddPO.getBanRangeType());
        gameUserBanDeletePO.setUpdateBy(operName);
        gameUserBanDeletePO.setUpdateTime(new Date());
        gameUserBanDeletePO.setDelFlag(DelFlagEnums.DELETE.getValue());
        Integer state = this.gameUserBanMapper.banNameFalseDeletion(gameUserBanDeletePO);
        return state;
    }

    public Integer gameUserBanDelete(List<String> banNameList, String operName, GameUserBanAddPO gameUserBanAddPO) {
        GameUserBanDeletePO gameUserBanDeletePO = new GameUserBanDeletePO();
        gameUserBanDeletePO.setBanNameList(banNameList);
        gameUserBanDeletePO.setBanType(gameUserBanAddPO.getBanType());
        gameUserBanDeletePO.setBanRangeType(gameUserBanAddPO.getBanRangeType());
        gameUserBanDeletePO.setUpdateBy(operName);
        gameUserBanDeletePO.setUpdateTime(new Date());
        gameUserBanDeletePO.setDelFlag(DelFlagEnums.DELETE.getValue());
        Integer state = this.gameUserBanMapper.banNameDelete(gameUserBanDeletePO);
        return state;
    }

    public void userBanLogRecord(int code, String msg, GameUserBanAddPO gameUserBanAddPO) {
        String operName = SecurityUtils.getUsername();
        Date newDate = new Date();
        Long banTime = gameUserBanAddPO.getBanTime() * 60L * 1000L;
        Date banTimeDate = new Date(newDate.getTime() + banTime);
        ArrayList<GameUserBanLogAddPO> gameUserBanLogAddPOList = new ArrayList<GameUserBanLogAddPO>();
        List<String> banNameList = Arrays.asList(gameUserBanAddPO.getBanName().split("\n"));
        for (int i = 0; i < banNameList.size(); ++i) {
            GameUserBanLogAddPO gameUserBanLogAddPO = new GameUserBanLogAddPO();
            gameUserBanLogAddPO.setServerId(gameUserBanAddPO.getServerId());
            gameUserBanLogAddPO.setBanType(gameUserBanAddPO.getBanType());
            gameUserBanLogAddPO.setBanRangeType(gameUserBanAddPO.getBanRangeType());
            gameUserBanLogAddPO.setBanName(banNameList.get(i));
            gameUserBanLogAddPO.setBanTime(banTimeDate);
            gameUserBanLogAddPO.setBanReason(gameUserBanAddPO.getBanReason());
            gameUserBanLogAddPO.setBanState(String.valueOf(code));
            gameUserBanLogAddPO.setBanStateDescribe(msg);
            gameUserBanLogAddPO.setCreateTime(new Date());
            gameUserBanLogAddPO.setCreateBy(operName);
            gameUserBanLogAddPO.setBanMark(BanMarkEnums.BAN.getValue());
            gameUserBanLogAddPOList.add(gameUserBanLogAddPO);
        }
        this.gameUserBanLogServiceImpl.insertBatchMiddle(gameUserBanLogAddPOList);
    }

    public int updateGameUserBan(GameUserBan gameUserBan) {
        gameUserBan.setUpdateTime(DateUtils.getNowDate());
        return this.gameUserBanMapper.updateGameUserBan(gameUserBan);
    }

    public int deleteGameUserBanByIds(Long[] Ids) {
        String operName = SecurityUtils.getUsername();
        GameUserBan gameUserBan = this.gameUserBanMapper.selectGameUserBanById(Ids[0]);
        ArrayList<String> banNameList = new ArrayList<String>();
        banNameList.add(gameUserBan.getBanName());
        PlayerBanPO playerBanPO = new PlayerBanPO();
        playerBanPO.setServiceId(Integer.valueOf(gameUserBan.getServerId()));
        playerBanPO.setType(UserBanTypeEnums.getDescByType((Integer)Integer.valueOf(gameUserBan.getBanType())));
        playerBanPO.setTarget(UserBanRangeTypeEnums.getDescByType((Integer)Integer.valueOf(gameUserBan.getBanRangeType())));
        playerBanPO.setList(banNameList);
        playerBanPO.setForbid(BanMarkEnums.LIFTING_BAN.getType());
        playerBanPO.setForbidSecs("");
        playerBanPO.setReason("");
        PlayerForbidApiVO playerForbidApiVO = new PlayerForbidApiVO();
        Integer serviceId = (int)playerBanPO.getServiceId();
        RearServerConfig RearServerConfig2 = this.rearServerServiceImpl.serverIdQuery(String.valueOf(serviceId));
        if (RearServerConfig2 == null || StringUtils.isEmpty((String)RearServerConfig2.getServerIp())) {
            throw new ServiceException("\u6b64\u670d\u52a1\u5668\u65e0ip\u4e0a\u62a5\u4fe1\u606f,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        String serverIp = RearServerConfig2.getServerIp();
        Integer serverPort = RearServerConfig2.getServerPort();
        String visitUrl = "http://" + serverIp + ":" + serverPort + "/forbid";
        try {
            log.info("\u8c03\u7528\u89e3\u5c01\u73a9\u5bb6\u63a5\u53e3: \u5165\u53c2={}", (Object)playerBanPO);
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity formEntity = new HttpEntity((Object)playerBanPO, (MultiValueMap)headers);
            playerForbidApiVO = (PlayerForbidApiVO)restTemplate.postForObject(visitUrl, (Object)formEntity, PlayerForbidApiVO.class, new Object[0]);
            log.info("\u8c03\u7528\u89e3\u5c01\u73a9\u5bb6\u63a5\u53e3\u8fd4\u56de: \u51fa\u53c2={}", (Object)playerForbidApiVO);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u89e3\u5c01\u73a9\u5bb6\u63a5\u53e3\u5f02\u5e38: \u5165\u53c2={}", (Object[])Ids);
            throw new ServiceException("\u8c03\u7528\u89e3\u5c01\u73a9\u5bb6\u63a5\u53e3\u5f02\u5e38,\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        if (playerForbidApiVO == null || playerForbidApiVO.getCode() != BaseSuccessFailEnums.SUCCESS.getValue()) {
            log.error("\u89e3\u5c01\u73a9\u5bb6\u5931\u8d25: \u5165\u53c2={},\u51fa\u53c2={}", (Object)Ids, (Object)playerForbidApiVO);
            throw new ServiceException("\u89e3\u5c01\u73a9\u5bb6\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        gameUserBan.setUpdateTime(new Date());
        gameUserBan.setUpdateBy(operName);
        gameUserBan.setDelFlag("0");
        int state = this.gameUserBanMapper.deleteGameUserBanById(Ids[0]);
        if (state == 1) {
            this.gameUserBanLogAdd(BaseSuccessFailEnums.SUCCESS.getValue().intValue(), "\u89e3\u5c01\u6210\u529f", gameUserBan);
        } else {
            this.gameUserBanLogAdd(BaseSuccessFailEnums.FAIL.getValue().intValue(), "SQL\u89e3\u5c01\u5931\u8d25,\u6e38\u620f\u7aef\u89e3\u5c01\u6210\u529f", gameUserBan);
        }
        return state;
    }

    public void gameUserBanLogAdd(int code, String msg, GameUserBan gameUserBan) {
        String operName = SecurityUtils.getUsername();
        String describe = "\u64cd\u4f5c\u5458: " + operName + " " + msg;
        GameUserBanLog gameUserBanLog = new GameUserBanLog();
        gameUserBanLog.setServerId(gameUserBan.getServerId());
        gameUserBanLog.setBanType(gameUserBan.getBanType());
        gameUserBanLog.setBanRangeType(gameUserBan.getBanRangeType());
        gameUserBanLog.setBanName(gameUserBan.getBanName());
        gameUserBanLog.setBanTime(gameUserBan.getBanTime());
        gameUserBanLog.setBanState(String.valueOf(code));
        gameUserBanLog.setBanStateDescribe(describe);
        gameUserBanLog.setBanReason(describe);
        gameUserBanLog.setCreateTime(new Date());
        gameUserBanLog.setCreateBy(operName);
        gameUserBanLog.setBanMark(BanMarkEnums.LIFTING_BAN.getValue());
        this.gameUserBanLogServiceImpl.insertGameUserBanLog(gameUserBanLog);
    }

    public int deleteGameUserBanById(Long Id) {
        return this.gameUserBanMapper.deleteGameUserBanById(Id);
    }

    public Integer upToDateBanId(Integer serverId, Integer banName) {
        return this.gameUserBanMapper.upToDateBanId(serverId, banName);
    }
}

