/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.player;

import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.core.utils.PageUtils;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.GameUserBanLog;
import com.ruoyi.rearend.domain.po.player.userban.GameUserBanLogAddPO;
import com.ruoyi.rearend.domain.vo.player.GameUserBanLogVO;
import com.ruoyi.rearend.enums.palyer.BanMarkEnums;
import com.ruoyi.rearend.enums.palyer.UserBanRangeTypeEnums;
import com.ruoyi.rearend.enums.palyer.UserBanTypeEnums;
import com.ruoyi.rearend.mapper.palyer.GameUserBanLogMapper;
import com.ruoyi.rearend.service.impl.server.RearServerServiceImpl;
import com.ruoyi.rearend.service.player.IGameUserBanLogService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GameUserBanLogServiceImpl
implements IGameUserBanLogService {
    @Autowired
    private GameUserBanLogMapper gameUserBanLogMapper;
    @Autowired
    private RearServerServiceImpl rearServerServiceImpl;
    private static final Logger log = LoggerFactory.getLogger(GameUserBanLogServiceImpl.class);

    @Transactional(rollbackFor={Exception.class})
    public TableDataInfo selectGameUserBanLogList(GameUserBanLog gameUserBanLog) {
        this.expiredUserBan();
        TableDataInfo tableDataInfo = new TableDataInfo();
        List gameUserBanLogVOList = new ArrayList();
        PageUtils.startPage();
        List gameUserBanLogList = this.gameUserBanLogMapper.selectGameUserBanLogList(gameUserBanLog);
        if (gameUserBanLogList == null || gameUserBanLogList.size() <= 0) {
            return tableDataInfo;
        }
        Integer total = this.gameUserBanLogMapper.totalCount(gameUserBanLog);
        ArrayList<String> serverIdList = new ArrayList<String>();
        for (GameUserBanLog gameUserBanLogFor : gameUserBanLogList) {
            serverIdList.add(gameUserBanLogFor.getServerId());
        }
        List serverIdMapList = this.rearServerServiceImpl.serverNameList(serverIdList);
        HashMap serverIdMap = new HashMap();
        for (int i = 0; i < serverIdMapList.size(); ++i) {
            serverIdMap.put(((Map)serverIdMapList.get(i)).get("server_id"), ((Map)serverIdMapList.get(i)).get("server_name"));
        }
        gameUserBanLogVOList = Lists.transform((List)gameUserBanLogList, entity -> {
            GameUserBanLogVO gameUserBanLogVO = new GameUserBanLogVO();
            gameUserBanLogVO.setServerId(entity.getServerId());
            gameUserBanLogVO.setServerName((String)serverIdMap.get(entity.getServerId()));
            gameUserBanLogVO.setBanState(entity.getBanState());
            gameUserBanLogVO.setBanMark(entity.getBanMark());
            gameUserBanLogVO.setBanType(entity.getBanType());
            gameUserBanLogVO.setBanTypeDescribe(UserBanTypeEnums.getDescByValue((Integer)Integer.valueOf(entity.getBanType())));
            gameUserBanLogVO.setBanRangeType(entity.getBanRangeType());
            gameUserBanLogVO.setBanRangeTypeDescribe(UserBanRangeTypeEnums.getDescByValue((Integer)Integer.valueOf(entity.getBanRangeType())));
            gameUserBanLogVO.setBanName(entity.getBanName());
            gameUserBanLogVO.setBanTime(entity.getBanTime());
            gameUserBanLogVO.setBanReason(entity.getBanReason());
            gameUserBanLogVO.setCreateTime(entity.getCreateTime());
            return gameUserBanLogVO;
        });
        tableDataInfo.setRows(gameUserBanLogVOList);
        tableDataInfo.setTotal((long)total.intValue());
        return tableDataInfo;
    }

    public int insertGameUserBanLog(GameUserBanLog gameUserBanLog) {
        gameUserBanLog.setCreateTime(DateUtils.getNowDate());
        return this.gameUserBanLogMapper.insertGameUserBanLog(gameUserBanLog);
    }

    public int insertBatchMiddle(List<GameUserBanLogAddPO> gameUserBanLogAddPOList) {
        return this.gameUserBanLogMapper.insertBatchMiddle(gameUserBanLogAddPOList);
    }

    @Transactional(rollbackFor={Exception.class})
    public Integer expiredUserBan() {
        long startTime = System.currentTimeMillis();
        String operName = SecurityUtils.getUsername();
        int state = 1;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formattedDate = sdf.format(new Date());
        List gameUserBanList = this.gameUserBanLogMapper.expiredUserBan(formattedDate);
        if (gameUserBanList == null || gameUserBanList.size() <= 0) {
            return state;
        }
        ArrayList idList = new ArrayList();
        List gameUserBanLogAddPOList = new ArrayList();
        gameUserBanLogAddPOList = Lists.transform((List)gameUserBanList, entity -> {
            GameUserBanLogAddPO gameUserBanLogAddPO = new GameUserBanLogAddPO();
            idList.add(entity.getId());
            gameUserBanLogAddPO.setServerId(entity.getServerId());
            gameUserBanLogAddPO.setBanType(entity.getBanType());
            gameUserBanLogAddPO.setBanRangeType(entity.getBanRangeType());
            gameUserBanLogAddPO.setBanName(entity.getBanName());
            gameUserBanLogAddPO.setBanTime(entity.getBanTime());
            gameUserBanLogAddPO.setBanMark(BanMarkEnums.LIFTING_BAN.getValue());
            gameUserBanLogAddPO.setBanReason(BanMarkEnums.EXPIRED_LIFTING_BAN.getDesc());
            gameUserBanLogAddPO.setCreateTime(new Date());
            gameUserBanLogAddPO.setCreateBy(operName);
            return gameUserBanLogAddPO;
        });
        this.insertBatchMiddle(gameUserBanLogAddPOList);
        state = this.gameUserBanLogMapper.idListDelete(idList);
        long endTime = System.currentTimeMillis();
        log.info("\u6e05\u7406\u5df2\u8fc7\u671f\u5c01\u7981\u6570\u636e\u65f6\u95f4:{}s", (Object)((endTime - startTime) / 1000L));
        return state;
    }
}

