/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.player;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.GameRoleKnapsack;
import com.ruoyi.rearend.domain.GameRoleKnapsackLog;
import com.ruoyi.rearend.domain.po.InterfaceSendPO;
import com.ruoyi.rearend.domain.po.player.roleknapsack.RoleKnapsackOperatePO;
import com.ruoyi.rearend.domain.vo.InterfaceSendVO;
import com.ruoyi.rearend.domain.vo.player.RoleKnapsackExportVO;
import com.ruoyi.rearend.enums.palyer.KnapsackStateEnums;
import com.ruoyi.rearend.enums.palyer.OperateStateEnums;
import com.ruoyi.rearend.enums.palyer.PropStateEnums;
import com.ruoyi.rearend.service.impl.player.GameRoleKnapsackLogServiceImpl;
import com.ruoyi.rearend.service.player.IGameRoleKnapsackService;
import com.ruoyi.rearend.utils.InterfaceSendUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GameRoleKnapsackServiceImpl
implements IGameRoleKnapsackService {
    @Autowired
    private InterfaceSendUtils interfaceSendUtils;
    @Autowired
    private GameRoleKnapsackLogServiceImpl roleKnapsackLogServiceImpl;

    public TableDataInfo selectGameRoleKnapsackList(GameRoleKnapsack gameRoleKnapsack) {
        TableDataInfo tableDataInfo = new TableDataInfo();
        List gameRoleKnapsackList = new ArrayList();
        InterfaceSendPO interfaceSendPO = this.interfaceValueHandle(gameRoleKnapsack);
        Object data = this.imitateData();
        Map tableMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)data), Map.class);
        tableDataInfo.setTotal((long)Integer.valueOf(tableMap.get("total").toString()).intValue());
        gameRoleKnapsackList = (List)JSON.parseObject((String)JSON.toJSONString(tableMap.get("roleKnapsackList")), List.class);
        tableDataInfo.setRows(gameRoleKnapsackList);
        return tableDataInfo;
    }

    public List<RoleKnapsackExportVO> exportGameRoleKnapsackList(GameRoleKnapsack gameRoleKnapsack) {
        TableDataInfo tableDataInfo = new TableDataInfo();
        List gameRoleKnapsackList = new ArrayList();
        InterfaceSendPO interfaceSendPO = this.interfaceValueHandle(gameRoleKnapsack);
        Object data = this.imitateData();
        Map tableMap = (Map)JSON.parseObject((String)JSON.toJSONString((Object)data), Map.class);
        tableDataInfo.setTotal((long)Integer.valueOf(tableMap.get("total").toString()).intValue());
        gameRoleKnapsackList = (List)tableMap.get("roleKnapsackList");
        String listJSONString = JSON.toJSONString(gameRoleKnapsackList);
        List<RoleKnapsackExportVO> roleKnapsackExportVOList = new ArrayList();
        roleKnapsackExportVOList = JSONArray.parseArray((String)listJSONString, RoleKnapsackExportVO.class);
        for (int i = 0; i < roleKnapsackExportVOList.size(); ++i) {
            roleKnapsackExportVOList.get(i).setPropState(PropStateEnums.getDescByValue((Integer)Integer.valueOf(roleKnapsackExportVOList.get(i).getPropState())));
        }
        return roleKnapsackExportVOList;
    }

    public InterfaceSendPO interfaceValueHandle(GameRoleKnapsack gameRoleKnapsack) {
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        if (StringUtils.isEmpty((String)gameRoleKnapsack.getServerId())) {
            return interfaceSendPO;
        }
        String visitUrl = this.interfaceSendUtils.serverUrlAddress(gameRoleKnapsack.getServerId(), "\u89d2\u8272\u80cc\u5305\u67e5\u8be2");
        interfaceSendPO.setVisitUrl(visitUrl);
        interfaceSendPO.setInterfaceDescribe("\u89d2\u8272\u80cc\u5305");
        HashMap<String, Object> suppliedMap = new HashMap<String, Object>();
        suppliedMap.put("serverId", gameRoleKnapsack.getServerId());
        suppliedMap.put("actorId", gameRoleKnapsack.getActorId());
        suppliedMap.put("knapsackId", gameRoleKnapsack.getKnapsackId());
        suppliedMap.put("propId", gameRoleKnapsack.getPropId());
        suppliedMap.put("propOnlyId", gameRoleKnapsack.getPropOnlyId());
        suppliedMap.put("propName", gameRoleKnapsack.getPropName());
        suppliedMap.put("pageNum", gameRoleKnapsack.getPageNum());
        suppliedMap.put("pageSize", gameRoleKnapsack.getPageSize());
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, Object> printMap = new HashMap<String, Object>();
        printMap.put("serverId", gameRoleKnapsack.getServerId());
        printMap.put("actorId", gameRoleKnapsack.getActorId());
        printMap.put("knapsackId", gameRoleKnapsack.getKnapsackId());
        interfaceSendPO.setPrintMap(printMap);
        return interfaceSendPO;
    }

    public Object imitateData() {
        HashMap<String, Serializable> tableMap = new HashMap<String, Serializable>();
        ArrayList imitateList = new ArrayList();
        for (int i = 1; i < 10; ++i) {
            HashMap<String, Object> imitateMa3 = new HashMap<String, Object>();
            imitateMa3.put("serverId", "3");
            imitateMa3.put("actorId", "99");
            imitateMa3.put("knapsackId", 1);
            imitateMa3.put("knapsackName", "\u8d85\u7ea7\u80cc\u5305");
            imitateMa3.put("propId", "00" + i);
            imitateMa3.put("propOnlyId", i);
            imitateMa3.put("propName", "\u7b2c" + i + "\u53f7\u8d85\u7ea7\u795e\u4ed9\u4e39");
            imitateMa3.put("propNumber", 10 * i);
            imitateMa3.put("propState", "0");
            if (i % 2 == 0) {
                imitateMa3.put("propState", "0");
            } else {
                imitateMa3.put("propState", "1");
            }
            imitateList.add(imitateMa3);
        }
        tableMap.put("roleKnapsackList", imitateList);
        tableMap.put("total", Integer.valueOf(50));
        return tableMap;
    }

    public GameRoleKnapsack selectGameRoleKnapsackById(Long Id) {
        return null;
    }

    public int updateGameRoleKnapsack(List<RoleKnapsackOperatePO> roleKnapsackOperatePOList) {
        InterfaceSendPO interfaceSendPO = this.updateGameRoleKnapsackHandle(roleKnapsackOperatePOList);
        InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
        if (!interfaceSendVO.getState().booleanValue()) {
            this.knapsackLogAdd(roleKnapsackOperatePOList, KnapsackStateEnums.FAIL.getValue());
            throw new ServiceException(interfaceSendVO.getMsg());
        }
        this.knapsackLogAdd(roleKnapsackOperatePOList, KnapsackStateEnums.SUCCESS.getValue());
        return 1;
    }

    public InterfaceSendPO updateGameRoleKnapsackHandle(List<RoleKnapsackOperatePO> roleKnapsackOperatePOList) {
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        RoleKnapsackOperatePO roleKnapsackOperatePO = roleKnapsackOperatePOList.get(0);
        String visitUrl = this.interfaceSendUtils.serverUrlAddress(roleKnapsackOperatePO.getServerId(), "\u9053\u5177\u4fee\u6539");
        interfaceSendPO.setVisitUrl(visitUrl);
        interfaceSendPO.setInterfaceDescribe("\u89d2\u8272\u80cc\u5305\u4fee\u6539");
        String propIdString = "";
        ArrayList dataList = new ArrayList();
        for (RoleKnapsackOperatePO roleKnapsackOperatePOFor : roleKnapsackOperatePOList) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            propIdString = propIdString + roleKnapsackOperatePOFor.getPropId() + ",";
            dataMap.put("knapsackId", roleKnapsackOperatePOFor.getKnapsackId());
            dataMap.put("propId", roleKnapsackOperatePOFor.getPropId());
            dataMap.put("propOnlyId", roleKnapsackOperatePOFor.getPropOnlyId());
            dataMap.put("propChangeNumber", roleKnapsackOperatePOFor.getPropChangeNumber());
            dataMap.put("operateState", OperateStateEnums.UPDATE.getValue());
            dataMap.put("propChangeState", roleKnapsackOperatePOFor.getPropChangeState());
            dataList.add(dataMap);
        }
        HashMap<String, Object> suppliedMap = new HashMap<String, Object>();
        suppliedMap.put("propList", dataList);
        suppliedMap.put("serverId", roleKnapsackOperatePO.getServerId());
        suppliedMap.put("actorId", roleKnapsackOperatePO.getActorId());
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, Object> printMap = new HashMap<String, Object>();
        printMap.put("serverId", roleKnapsackOperatePO.getServerId());
        printMap.put("actorId", roleKnapsackOperatePO.getActorId());
        printMap.put("propIdList", propIdString);
        printMap.put("operateState", OperateStateEnums.UPDATE.getValue());
        interfaceSendPO.setPrintMap(printMap);
        return interfaceSendPO;
    }

    public int lockUnlockRoleKnapsack(List<RoleKnapsackOperatePO> roleKnapsackOperatePOList) {
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        RoleKnapsackOperatePO roleKnapsackOperatePO = roleKnapsackOperatePOList.get(0);
        String visitUrl = this.interfaceSendUtils.serverUrlAddress(roleKnapsackOperatePO.getServerId(), "\u9053\u5177\u9501\u5b9a/\u89e3\u9501");
        interfaceSendPO.setVisitUrl(visitUrl);
        interfaceSendPO.setInterfaceDescribe("\u89d2\u8272\u80cc\u5305" + OperateStateEnums.getDescByValue((Integer)roleKnapsackOperatePO.getOperateState()));
        ArrayList<Integer> propOnlyIdList = new ArrayList<Integer>();
        for (RoleKnapsackOperatePO roleKnapsackOperatePOFro : roleKnapsackOperatePOList) {
            propOnlyIdList.add(Integer.valueOf(roleKnapsackOperatePOFro.getPropOnlyId()));
        }
        HashMap<String, Serializable> suppliedMap = new HashMap<String, Serializable>();
        suppliedMap.put("propOnlyIdList", propOnlyIdList);
        suppliedMap.put("operateState", roleKnapsackOperatePO.getOperateState());
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, Serializable> printMap = new HashMap<String, Serializable>();
        printMap.put("propOnlyIdList", propOnlyIdList);
        printMap.put("operateState", roleKnapsackOperatePO.getOperateState());
        interfaceSendPO.setPrintMap(printMap);
        InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
        if (!interfaceSendVO.getState().booleanValue()) {
            this.knapsackLogAdd(roleKnapsackOperatePOList, KnapsackStateEnums.FAIL.getValue());
            throw new ServiceException(interfaceSendVO.getMsg());
        }
        this.knapsackLogAdd(roleKnapsackOperatePOList, KnapsackStateEnums.SUCCESS.getValue());
        return 1;
    }

    public int deleteRoleKnapsack(List<RoleKnapsackOperatePO> roleKnapsackOperatePOList) {
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        RoleKnapsackOperatePO roleKnapsackOperatePO = roleKnapsackOperatePOList.get(0);
        String visitUrl = this.interfaceSendUtils.serverUrlAddress(roleKnapsackOperatePO.getServerId(), "\u9053\u5177\u5220\u9664");
        interfaceSendPO.setVisitUrl(visitUrl);
        interfaceSendPO.setInterfaceDescribe("\u89d2\u8272\u80cc\u5305" + OperateStateEnums.getDescByValue((Integer)roleKnapsackOperatePO.getOperateState()));
        ArrayList<Integer> propOnlyIdList = new ArrayList<Integer>();
        for (RoleKnapsackOperatePO roleKnapsackOperatePOFro : roleKnapsackOperatePOList) {
            propOnlyIdList.add(Integer.valueOf(roleKnapsackOperatePOFro.getPropOnlyId()));
        }
        HashMap<String, Serializable> suppliedMap = new HashMap<String, Serializable>();
        suppliedMap.put("propOnlyIdList", propOnlyIdList);
        suppliedMap.put("operateState", roleKnapsackOperatePO.getOperateState());
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, Serializable> printMap = new HashMap<String, Serializable>();
        printMap.put("propOnlyIdList", propOnlyIdList);
        printMap.put("operateState", roleKnapsackOperatePO.getOperateState());
        interfaceSendPO.setPrintMap(printMap);
        InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
        if (!interfaceSendVO.getState().booleanValue()) {
            this.knapsackLogAdd(roleKnapsackOperatePOList, KnapsackStateEnums.FAIL.getValue());
            throw new ServiceException(interfaceSendVO.getMsg());
        }
        this.knapsackLogAdd(roleKnapsackOperatePOList, KnapsackStateEnums.SUCCESS.getValue());
        return 1;
    }

    public void knapsackLogAdd(List<RoleKnapsackOperatePO> roleKnapsackOperatePOList, Integer knapsackState) {
        List gameRoleKnapsackLogList = new ArrayList();
        gameRoleKnapsackLogList = Lists.transform(roleKnapsackOperatePOList, entity -> {
            GameRoleKnapsackLog gameRoleKnapsackLog = new GameRoleKnapsackLog();
            BeanUtils.copyProperties((Object)entity, (Object)gameRoleKnapsackLog);
            if (entity.getPropChangeState() != null) {
                gameRoleKnapsackLog.setPropChangeState(entity.getPropChangeState().toString());
            }
            if (entity.getPropChangeNumber() != null) {
                gameRoleKnapsackLog.setPropChangeNumber(Long.valueOf(entity.getPropChangeNumber().intValue()));
            }
            gameRoleKnapsackLog.setKnapsackState(knapsackState);
            gameRoleKnapsackLog.setOperateState(entity.getOperateState().toString());
            gameRoleKnapsackLog.setCreateBy(SecurityUtils.getUsername());
            gameRoleKnapsackLog.setCreateTime(DateUtils.getNowDate());
            return gameRoleKnapsackLog;
        });
        this.roleKnapsackLogServiceImpl.insertBatchGameRoleKnapsackLog(gameRoleKnapsackLogList);
    }
}

