/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.operate.vipguestservice;

import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.GameVipGuestService;
import com.ruoyi.rearend.domain.RearServerConfig;
import com.ruoyi.rearend.domain.po.operate.vipguestservice.VipGuestServiceApiPO;
import com.ruoyi.rearend.domain.po.operate.vipguestservice.VipGuestServiceSqlPO;
import com.ruoyi.rearend.domain.vo.operate.vipguestservice.VipGuestServiceAddVO;
import com.ruoyi.rearend.domain.vo.operate.vipguestservice.VipGuestServiceApiVO;
import com.ruoyi.rearend.domain.vo.operate.vipguestservice.VipGuestServiceDetailsVO;
import com.ruoyi.rearend.enums.BaseDelFlagEnums;
import com.ruoyi.rearend.enums.BaseYesNoEnums;
import com.ruoyi.rearend.enums.operate.QuestionnaireRequestEnums;
import com.ruoyi.rearend.enums.operate.VipFormatSignEnums;
import com.ruoyi.rearend.mapper.operate.vipguestservice.GameVipGuestServiceMapper;
import com.ruoyi.rearend.service.impl.operate.questionnaire.RearQuestionnaireServiceImpl;
import com.ruoyi.rearend.service.operate.vipguestservice.IGameVipGuestServiceService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GameVipGuestServiceServiceImpl
implements IGameVipGuestServiceService {
    @Autowired
    private GameVipGuestServiceMapper gameVipGuestServiceMapper;
    @Autowired
    private RearQuestionnaireServiceImpl questionnaireServiceImpl;
    private static final Logger log = LoggerFactory.getLogger(GameVipGuestServiceServiceImpl.class);

    public VipGuestServiceDetailsVO selectGameVipGuestServiceById(Long Id) {
        VipGuestServiceDetailsVO vipGuestServiceDetailsVO = new VipGuestServiceDetailsVO();
        GameVipGuestService gameVipGuestService = this.gameVipGuestServiceMapper.selectGameVipGuestServiceById(Id);
        BeanUtils.copyProperties((Object)gameVipGuestService, (Object)vipGuestServiceDetailsVO);
        if (gameVipGuestService.getFormatSign().equals(VipFormatSignEnums.JSON.getValue())) {
            vipGuestServiceDetailsVO.setFormatBecomeContentJson(gameVipGuestService.getFormatBecomeContent());
            vipGuestServiceDetailsVO.setFormatWelfareContentJson(gameVipGuestService.getFormatWelfareContent());
            vipGuestServiceDetailsVO.setFormatBecomeContent(null);
            vipGuestServiceDetailsVO.setFormatWelfareContent(null);
        }
        return vipGuestServiceDetailsVO;
    }

    public List<GameVipGuestService> selectGameVipGuestServiceList(GameVipGuestService gameVipGuestService) {
        return this.gameVipGuestServiceMapper.selectGameVipGuestServiceList(gameVipGuestService);
    }

    public VipGuestServiceAddVO insertGameVipGuestService(GameVipGuestService gameVipGuestService) {
        VipGuestServiceAddVO vipGuestServiceAddVO = new VipGuestServiceAddVO();
        gameVipGuestService.setCreateBy(SecurityUtils.getUsername());
        gameVipGuestService.setCreateTime(DateUtils.getNowDate());
        this.gameVipGuestServiceMapper.insertGameVipGuestService(gameVipGuestService);
        Map pidGidMap = new HashMap();
        pidGidMap = this.questionnaireServiceImpl.pidGidIntercept(gameVipGuestService.getChannelGame());
        List rearServerConfigList = this.questionnaireServiceImpl.serverIntercept(gameVipGuestService.getDistrictServer());
        ArrayList<String> errorMarkList = new ArrayList<String>();
        String successMark = "";
        ArrayList<VipGuestServiceApiVO> vipGuestServiceApiVOList = new ArrayList<VipGuestServiceApiVO>();
        for (RearServerConfig rearServerConfig : rearServerConfigList) {
            VipGuestServiceApiVO vipGuestServiceApiVO = new VipGuestServiceApiVO();
            vipGuestServiceApiVO = this.sendingVipGuestService(QuestionnaireRequestEnums.ADD.getValue(), rearServerConfig, pidGidMap, gameVipGuestService);
            vipGuestServiceApiVO.setServerId(rearServerConfig.getServerId());
            if (vipGuestServiceApiVO.getState().booleanValue()) {
                successMark = successMark + "," + vipGuestServiceApiVO.getServerId();
            } else {
                errorMarkList.add(rearServerConfig.getServerId());
            }
            vipGuestServiceApiVOList.add(vipGuestServiceApiVO);
        }
        vipGuestServiceAddVO = this.insertGameVipGuestServiceHandle(errorMarkList, successMark, rearServerConfigList, gameVipGuestService, vipGuestServiceApiVOList);
        return vipGuestServiceAddVO;
    }

    public VipGuestServiceApiVO sendingVipGuestService(Integer state, RearServerConfig rearServerConfig, Map<String, List<String>> pidGidMap, GameVipGuestService gameVipGuestService) {
        VipGuestServiceApiVO vipGuestServiceApiVO = new VipGuestServiceApiVO();
        vipGuestServiceApiVO.setServerId(rearServerConfig.getServerId());
        String serverIp = rearServerConfig.getServerIp();
        Integer serverPort = rearServerConfig.getServerPort();
        String visitUrl = "http://" + serverIp + ":" + serverPort + "/123";
        VipGuestServiceApiPO vipGuestServiceApiPO = new VipGuestServiceApiPO();
        vipGuestServiceApiPO.setServiceId(Integer.valueOf(rearServerConfig.getServerId()));
        vipGuestServiceApiPO.setVipGuestServiceId(new Integer(gameVipGuestService.getId().intValue()));
        vipGuestServiceApiPO.setOperation(state);
        vipGuestServiceApiPO.setPid2Gid(pidGidMap);
        try {
            log.info("\u8c03\u7528vip\u5ba2\u670d\u63a5\u53e3: serverId={},vipGuestServiceId={}", (Object)rearServerConfig.getServerId(), (Object)gameVipGuestService.getId());
            throw new ServiceException("\u6545\u610f\u62a5\u9519");
        }
        catch (Exception e) {
            log.error("\u8c03\u7528vip\u63a5\u53e3\u5f02\u5e38: \u5165\u53c2={}", (Object)vipGuestServiceApiPO);
            vipGuestServiceApiVO.setState(Boolean.valueOf(BaseYesNoEnums.NO.getValue()));
            vipGuestServiceApiVO.setMsg("\u8c03\u7528vip\u5ba2\u670d\u63a5\u53e3\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return vipGuestServiceApiVO;
        }
    }

    public VipGuestServiceAddVO insertGameVipGuestServiceHandle(List<String> errorMarkList, String successMark, List<RearServerConfig> rearServerConfigList, GameVipGuestService gameVipGuestService, List<VipGuestServiceApiVO> vipGuestServiceApiVOList) {
        VipGuestServiceAddVO vipGuestServiceAddVO = new VipGuestServiceAddVO();
        if (errorMarkList.size() == 0) {
            vipGuestServiceAddVO = this.valueVOHandle(Integer.valueOf(rearServerConfigList.size()), Integer.valueOf(errorMarkList.size()), vipGuestServiceApiVOList);
            return vipGuestServiceAddVO;
        }
        Integer successNumber = rearServerConfigList.size() - errorMarkList.size();
        if (rearServerConfigList.size() == errorMarkList.size()) {
            vipGuestServiceAddVO = this.valueVOHandle(successNumber, Integer.valueOf(errorMarkList.size()), vipGuestServiceApiVOList);
            this.deleteGameVipGuestServiceById(gameVipGuestService.getId());
        } else {
            vipGuestServiceAddVO = this.valueVOHandle(successNumber, Integer.valueOf(errorMarkList.size()), vipGuestServiceApiVOList);
            gameVipGuestService.setDistrictServer(successMark);
            this.updateGameVipGuestService(gameVipGuestService);
        }
        return vipGuestServiceAddVO;
    }

    public VipGuestServiceAddVO valueVOHandle(Integer successNumber, Integer errorNumber, List<VipGuestServiceApiVO> vipGuestServiceApiVOList) {
        VipGuestServiceAddVO vipGuestServiceAddVO = new VipGuestServiceAddVO();
        vipGuestServiceAddVO.setSuccessNumber(successNumber);
        vipGuestServiceAddVO.setFailNumber(errorNumber);
        String describe = "";
        for (VipGuestServiceApiVO vipGuestServiceApiVO : vipGuestServiceApiVOList) {
            describe = describe + "\u670d\u52a1\u5668id: " + vipGuestServiceApiVO.getServerId() + "; \u662f\u5426\u6210\u529f: " + vipGuestServiceApiVO.getState() + "; \u63cf\u8ff0: " + vipGuestServiceApiVO.getMsg() + ";\n";
        }
        vipGuestServiceAddVO.setDescribe(describe);
        return vipGuestServiceAddVO;
    }

    public int updateGameVipGuestService(GameVipGuestService gameVipGuestService) {
        gameVipGuestService.setUpdateTime(DateUtils.getNowDate());
        return this.gameVipGuestServiceMapper.updateGameVipGuestService(gameVipGuestService);
    }

    public int deleteGameVipGuestServiceByIds(Long[] Ids) {
        VipGuestServiceSqlPO vipGuestServiceSqlPO = new VipGuestServiceSqlPO();
        vipGuestServiceSqlPO.setIds(Ids);
        vipGuestServiceSqlPO.setDelFlag(BaseDelFlagEnums.DELETED.getValue());
        vipGuestServiceSqlPO.setUpdateBy(SecurityUtils.getUsername());
        vipGuestServiceSqlPO.setUpdateTime(new Date());
        return this.gameVipGuestServiceMapper.updateBatchVipGuestService(vipGuestServiceSqlPO);
    }

    public int deleteGameVipGuestServiceById(Long Id) {
        return this.gameVipGuestServiceMapper.deleteGameVipGuestServiceById(Id);
    }
}

