/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.operate.trailer;

import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.GameVersionTrailer;
import com.ruoyi.rearend.domain.RearServerConfig;
import com.ruoyi.rearend.domain.po.InterfaceSendPO;
import com.ruoyi.rearend.domain.po.operate.trailer.TrailerGroundingPO;
import com.ruoyi.rearend.domain.vo.InterfaceSendVO;
import com.ruoyi.rearend.enums.BaseSuccessFailEnums;
import com.ruoyi.rearend.enums.UpBelowFrameEnums;
import com.ruoyi.rearend.mapper.operate.trailer.GameVersionTrailerMapper;
import com.ruoyi.rearend.mapper.server.RearServerMapper;
import com.ruoyi.rearend.service.operate.trailer.IGameVersionTrailerService;
import com.ruoyi.rearend.utils.InterfaceSendUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GameVersionTrailerServiceImpl
implements IGameVersionTrailerService {
    @Autowired
    private GameVersionTrailerMapper gameVersionTrailerMapper;
    @Autowired
    private RearServerMapper rearServerMapper;
    @Autowired
    private InterfaceSendUtils interfaceSendUtils;
    private static ThreadPoolExecutor executorService = new ThreadPoolExecutor(10, 12, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(1000), Executors.defaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());

    public GameVersionTrailer selectGameVersionTrailerById(Long Id) {
        return this.gameVersionTrailerMapper.selectGameVersionTrailerById(Id);
    }

    public List<GameVersionTrailer> selectGameVersionTrailerList(GameVersionTrailer gameVersionTrailer) {
        return this.gameVersionTrailerMapper.selectGameVersionTrailerList(gameVersionTrailer);
    }

    public int insertGameVersionTrailer(TrailerGroundingPO trailerGroundingPO) {
        Integer number = this.queryGroundingNumber();
        if (number != null && number > 0) {
            throw new ServiceException("\u7248\u672c\u9884\u544a\u53ea\u80fd\u5b58\u5728\u4e00\u6761\u5df2\u4e0a\u67b6\u7684\u6570\u636e,\u8bf7\u5148\u8fdb\u884c\u5220\u9664\u540e\u518d\u65b0\u589e.");
        }
        List normalPictureList = trailerGroundingPO.getNormalPictureList();
        List abnormalPictureList = trailerGroundingPO.getAbnormalPictureList();
        List pictureList = new ArrayList();
        if (normalPictureList != null && normalPictureList.size() > 0 && abnormalPictureList != null && abnormalPictureList.size() > 0) {
            for (int i = 0; i < normalPictureList.size(); ++i) {
                if (abnormalPictureList.contains(normalPictureList.get(i))) continue;
                pictureList.add(normalPictureList.get(i));
            }
        } else if (normalPictureList != null && normalPictureList.size() > 0 && (abnormalPictureList == null || abnormalPictureList.size() <= 0)) {
            pictureList = normalPictureList;
        } else {
            throw new ServiceException("\u7248\u672c\u9884\u544a\u591a\u56fe\u4e3a\u7a7a,\u8bf7\u4e0a\u4f20\u56fe\u7247\u540e\u91cd\u8bd5!");
        }
        List serverConfigList = this.rearServerMapper.serverConfigAll();
        for (RearServerConfig rearServerConfig : serverConfigList) {
            this.groundingTrailerExport(rearServerConfig.getServerId(), pictureList, trailerGroundingPO);
        }
        GameVersionTrailer gameVersionTrailer = new GameVersionTrailer();
        BeanUtils.copyProperties((Object)trailerGroundingPO, (Object)gameVersionTrailer);
        gameVersionTrailer.setTrailerPictureUrl(StringUtils.join(pictureList, (String)","));
        gameVersionTrailer.setCreateTime(DateUtils.getNowDate());
        gameVersionTrailer.setCreateBy(SecurityUtils.getUsername());
        this.gameVersionTrailerMapper.insertGameVersionTrailer(gameVersionTrailer);
        return 1;
    }

    public int updateGameVersionTrailer(GameVersionTrailer gameVersionTrailer) {
        gameVersionTrailer.setUpdateTime(DateUtils.getNowDate());
        return this.gameVersionTrailerMapper.updateGameVersionTrailer(gameVersionTrailer);
    }

    public int offShelf(Long[] Ids) {
        List serverConfigList = this.rearServerMapper.serverConfigAll();
        for (RearServerConfig rearServerConfig : serverConfigList) {
            this.groundingOffShelfExport(rearServerConfig.getServerId());
        }
        GameVersionTrailer gameVersionTrailer = new GameVersionTrailer();
        gameVersionTrailer.setId(Ids[0]);
        gameVersionTrailer.setTrailerState(UpBelowFrameEnums.OFF_SHELF.getValue());
        return this.gameVersionTrailerMapper.updateGameVersionTrailer(gameVersionTrailer);
    }

    public Integer queryGroundingNumber() {
        return this.gameVersionTrailerMapper.queryGroundingNumber();
    }

    public int deleteGameVersionTrailerById(Long Id) {
        List serverConfigList = this.rearServerMapper.serverConfigAll();
        for (RearServerConfig rearServerConfig : serverConfigList) {
            this.groundingOffShelfExport(rearServerConfig.getServerId());
        }
        GameVersionTrailer gameVersionTrailer = new GameVersionTrailer();
        gameVersionTrailer.setId(Id);
        gameVersionTrailer.setTrailerState(UpBelowFrameEnums.OFF_SHELF.getValue());
        return this.gameVersionTrailerMapper.updateGameVersionTrailer(gameVersionTrailer);
    }

    public Future<Boolean> groundingTrailerExport(String serviceId, List<String> pictureList, TrailerGroundingPO trailerGroundingPO) {
        return executorService.submit(() -> {
            try {
                this.groundingTrailer(serviceId, pictureList, trailerGroundingPO);
            }
            catch (Exception e) {
                throw new ServiceException("\u5f02\u5e38\u7ebf\u7a0b\u6c60: \u67e5\u8be2\u4e0a\u6b21\u767b\u5f55\u670d\u5931\u8d25");
            }
            return true;
        });
    }

    public Boolean groundingTrailer(String serviceId, List<String> pictureList, TrailerGroundingPO trailerGroundingPO) {
        Boolean state = false;
        String visitUrl = this.interfaceSendUtils.serverUrlAddress(serviceId, "foreShowOpen");
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        interfaceSendPO.setVisitUrl(visitUrl);
        interfaceSendPO.setInterfaceDescribe("\u7248\u672c\u9884\u544a\u4e0a\u67b6");
        HashMap<String, Object> suppliedMap = new HashMap<String, Object>();
        suppliedMap.put("serviceId", serviceId);
        suppliedMap.put("titleUrl", trailerGroundingPO.getTrailerTitleUrl());
        suppliedMap.put("titleDesc", trailerGroundingPO.getTrailerDesc());
        suppliedMap.put("time", trailerGroundingPO.getTrailerTime().getTime());
        suppliedMap.put("rewardJson", trailerGroundingPO.getTrailerReward());
        suppliedMap.put("postponeRewardJson", trailerGroundingPO.getTrailerDelayReward());
        suppliedMap.put("contentUrl", pictureList);
        suppliedMap.put("iconUrl", trailerGroundingPO.getTrailerIconUrl());
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, Object> printMap = new HashMap<String, Object>();
        printMap.put("serviceId", serviceId);
        printMap.put("time", trailerGroundingPO.getTrailerTime());
        printMap.put("titleDesc", trailerGroundingPO.getTrailerDesc());
        interfaceSendPO.setPrintMap(printMap);
        InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
        if (!interfaceSendVO.getState().booleanValue()) {
            throw new ServiceException("\u53d1\u9001\u7248\u672c\u9884\u544a\u4e0a\u67b6\u5931\u8d25: " + interfaceSendVO.getMsg());
        }
        if (interfaceSendVO.getCode() == BaseSuccessFailEnums.SUCCESS.getValue()) {
            state = true;
        }
        return state;
    }

    public Future<Boolean> groundingOffShelfExport(String serviceId) {
        return executorService.submit(() -> {
            try {
                this.groundingOffShelf(serviceId);
            }
            catch (Exception e) {
                throw new ServiceException("\u5f02\u5e38\u7ebf\u7a0b\u6c60: \u67e5\u8be2\u4e0a\u6b21\u767b\u5f55\u670d\u5931\u8d25");
            }
            return true;
        });
    }

    public Boolean groundingOffShelf(String serviceId) {
        Boolean state = false;
        String visitUrl = this.interfaceSendUtils.serverUrlAddress(serviceId, "foreShowClose");
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        interfaceSendPO.setVisitUrl(visitUrl);
        interfaceSendPO.setInterfaceDescribe("\u7248\u672c\u9884\u544a\u529f\u80fd\u4e0b\u67b6");
        HashMap<String, String> suppliedMap = new HashMap<String, String>();
        suppliedMap.put("serviceId", serviceId);
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, String> printMap = new HashMap<String, String>();
        printMap.put("serviceId", serviceId);
        interfaceSendPO.setPrintMap(printMap);
        InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
        if (!interfaceSendVO.getState().booleanValue()) {
            throw new ServiceException("\u7248\u672c\u9884\u544a\u529f\u80fd\u4e0b\u67b6\u5931\u8d25: " + interfaceSendVO.getMsg());
        }
        if (interfaceSendVO.getCode() == BaseSuccessFailEnums.SUCCESS.getValue()) {
            state = true;
        }
        return state;
    }
}

