/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.operate.questionnaire;

import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.RearGiftPack;
import com.ruoyi.rearend.domain.RearQuestionnaire;
import com.ruoyi.rearend.domain.RearServerConfig;
import com.ruoyi.rearend.domain.po.ServerCountPO;
import com.ruoyi.rearend.domain.po.operate.questionnaire.QuestionnaireAddPO;
import com.ruoyi.rearend.domain.po.operate.questionnaire.QuestionnaireApiPO;
import com.ruoyi.rearend.domain.vo.ServerCountVO;
import com.ruoyi.rearend.domain.vo.operate.questionnaire.QuestionnaireAddVO;
import com.ruoyi.rearend.domain.vo.operate.questionnaire.QuestionnaireApiVO;
import com.ruoyi.rearend.domain.vo.operate.questionnaire.QuestionnaireDelVO;
import com.ruoyi.rearend.domain.vo.operate.questionnaire.RearQuestionnaireVO;
import com.ruoyi.rearend.enums.BaseNumberOfTimesEnums;
import com.ruoyi.rearend.enums.BaseYesNoEnums;
import com.ruoyi.rearend.enums.OperateMarkEnums;
import com.ruoyi.rearend.enums.operate.NoticeStateEnums;
import com.ruoyi.rearend.enums.operate.QuestionnaireRequestEnums;
import com.ruoyi.rearend.mapper.operate.questionnaire.RearQuestionnaireMapper;
import com.ruoyi.rearend.service.impl.server.RearServerServiceImpl;
import com.ruoyi.rearend.service.operate.giftpack.IRearGiftPackService;
import com.ruoyi.rearend.service.operate.questionnaire.IRearQuestionnaireService;
import com.ruoyi.rearend.utils.IdWorker;
import com.ruoyi.rearend.utils.InterfaceSendUtils;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.DigestUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class RearQuestionnaireServiceImpl
implements IRearQuestionnaireService {
    @Autowired
    private RearQuestionnaireMapper rearQuestionnaireMapper;
    @Autowired
    private RearServerServiceImpl rearServerServiceImpl;
    @Autowired
    private InterfaceSendUtils interfaceSendUtils;
    @Autowired
    private IRearGiftPackService iRearGiftPackService;
    private static final Logger log = LoggerFactory.getLogger(RearQuestionnaireServiceImpl.class);

    public RearQuestionnaire selectRearQuestionnaireById(Long Id) {
        return this.rearQuestionnaireMapper.selectRearQuestionnaireById(Id);
    }

    public List<RearQuestionnaireVO> selectRearQuestionnaireList(RearQuestionnaire rearQuestionnaire) {
        Date newDate = new Date();
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ArrayList<RearQuestionnaireVO> rearQuestionnaireVOList = new ArrayList();
        List rearQuestionnaireList = this.rearQuestionnaireMapper.selectRearQuestionnaireList(rearQuestionnaire);
        rearQuestionnaireVOList = Lists.transform((List)rearQuestionnaireList, entity -> {
            RearQuestionnaireVO rearQuestionnaireVO = new RearQuestionnaireVO();
            rearQuestionnaireVO.setId(entity.getId());
            rearQuestionnaireVO.setQuestionnaireKey(entity.getQuestionnaireKey());
            rearQuestionnaireVO.setDistrictServer(entity.getDistrictServer());
            rearQuestionnaireVO.setPrizeId(entity.getPrizeId());
            rearQuestionnaireVO.setQuestionnaireUrl(entity.getQuestionnaireUrl());
            rearQuestionnaireVO.setChannelGame(entity.getChannelGame());
            rearQuestionnaireVO.setGrade(entity.getGradeMinimum() + "-" + entity.getGradeHighest());
            rearQuestionnaireVO.setMoney(entity.getMoneyMinimum() + "-" + entity.getMoneyHighest());
            rearQuestionnaireVO.setCreateTime(entity.getCreateTime());
            rearQuestionnaireVO.setCreateBy(entity.getCreateBy());
            rearQuestionnaireVO.setLaunchTime(ft.format(entity.getLaunchStartTime()) + "-" + ft.format(entity.getLaunchFinishTime()));
            int startTime = newDate.compareTo(entity.getLaunchStartTime());
            int endTime = entity.getLaunchFinishTime().compareTo(newDate);
            if (startTime == -1) {
                rearQuestionnaireVO.setLaunchTimeMark("\u672a\u5f00\u59cb");
            } else if (endTime == -1) {
                rearQuestionnaireVO.setLaunchTimeMark("\u5df2\u8fc7\u671f");
            } else {
                rearQuestionnaireVO.setLaunchTimeMark("\u8fdb\u884c\u4e2d");
            }
            return rearQuestionnaireVO;
        });
        return rearQuestionnaireVOList;
    }

    public List<RearQuestionnaire> selectRearQuestionnaireExport(RearQuestionnaire rearQuestionnaire) {
        return this.rearQuestionnaireMapper.selectRearQuestionnaireList(rearQuestionnaire);
    }

    @Transactional(rollbackFor={Exception.class})
    public QuestionnaireAddVO insertRearQuestionnaire(QuestionnaireAddPO questionnaireAddPO) {
        RearQuestionnaire rearQuestionnaire = new RearQuestionnaire();
        BeanUtils.copyProperties((Object)questionnaireAddPO, (Object)rearQuestionnaire);
        rearQuestionnaire.setQuestionnaireKey(questionnaireAddPO.getGiftPackCode());
        QuestionnaireAddVO questionnaireAddVO = new QuestionnaireAddVO();
        rearQuestionnaire.setPrizeId(NoticeStateEnums.GROUNDING.getValue().toString());
        rearQuestionnaire.setCreateBy(SecurityUtils.getUsername());
        rearQuestionnaire.setCreateTime(DateUtils.getNowDate());
        this.rearQuestionnaireMapper.insertRearQuestionnaire(rearQuestionnaire);
        Map pidGidMap = new HashMap();
        pidGidMap = this.pidGidIntercept(rearQuestionnaire.getChannelGame());
        List rearServerConfigList = this.serverIntercept(rearQuestionnaire.getDistrictServer());
        ArrayList<String> errorMarkList = new ArrayList<String>();
        String successMark = "";
        ArrayList<QuestionnaireApiVO> questionnaireApiVOList = new ArrayList<QuestionnaireApiVO>();
        for (RearServerConfig rearServerConfig : rearServerConfigList) {
            QuestionnaireApiVO questionnaireApiVO = new QuestionnaireApiVO();
            questionnaireApiVO = this.sendingQuestionnaire(QuestionnaireRequestEnums.ADD.getValue(), rearServerConfig, pidGidMap, rearQuestionnaire);
            questionnaireApiVO.setServerId(rearServerConfig.getServerId());
            if (questionnaireApiVO.getState().booleanValue()) {
                successMark = successMark + "," + questionnaireApiVO.getServerId();
            } else {
                errorMarkList.add(rearServerConfig.getServerId());
            }
            questionnaireApiVOList.add(questionnaireApiVO);
        }
        questionnaireAddVO = this.insertRearQuestionnaireHandle(errorMarkList, successMark, rearServerConfigList, rearQuestionnaire, questionnaireApiVOList);
        this.giftPackHandle(questionnaireAddPO);
        return questionnaireAddVO;
    }

    public void giftPackHandle(QuestionnaireAddPO questionnaireAddPO) {
        RearGiftPack rearGiftPack = new RearGiftPack();
        rearGiftPack.setGiftPackState(NoticeStateEnums.GROUNDING.getValue().toString());
        rearGiftPack.setApplyFrequency(BaseNumberOfTimesEnums.ZERO.getValue());
        rearGiftPack.setGiftPackName(questionnaireAddPO.getGiftPackTitle());
        rearGiftPack.setGiftPackTitle(questionnaireAddPO.getGiftPackTitle());
        rearGiftPack.setGiftPackCode(questionnaireAddPO.getGiftPackCode());
        rearGiftPack.setDistrictServer(questionnaireAddPO.getDistrictServer());
        rearGiftPack.setGiftPackContent(questionnaireAddPO.getGiftPackContent());
        rearGiftPack.setGiftPackRewardJson(questionnaireAddPO.getGiftPackRewardJson());
        this.iRearGiftPackService.insertRearGiftPack(rearGiftPack);
    }

    public Map<String, List<String>> pidGidIntercept(String channelGame) {
        HashMap<String, List<String>> pidGidList = new HashMap<String, List<String>>();
        List<String> playerIdStringList = Arrays.asList(channelGame.split("\n"));
        String intercept = "|";
        for (int i = 0; i < playerIdStringList.size(); ++i) {
            String pid = "";
            if (!playerIdStringList.get(i).contains(intercept)) {
                throw new ServiceException("pid\u6709\u8bef,\u8bf7\u91cd\u65b0\u8f93\u5165\u540e\u518d\u8bd5");
            }
            pid = playerIdStringList.get(i).substring(0, playerIdStringList.get(i).indexOf(intercept));
            String gid = playerIdStringList.get(i).substring(pid.length() + 1, playerIdStringList.get(i).length());
            List<Object> gidList = new ArrayList();
            gidList = Arrays.asList(gid);
            pidGidList.put(pid, gidList);
        }
        return pidGidList;
    }

    public List<RearServerConfig> serverIntercept(String districtServer) {
        String poleTail;
        String poleHead;
        if (districtServer.contains("-") && districtServer.contains(",")) {
            poleHead = districtServer.substring(0, districtServer.indexOf("-"));
            poleTail = districtServer.substring(poleHead.length() + 1, districtServer.length());
            String commaHead = poleTail.substring(0, poleTail.indexOf(","));
            String commaTail = poleTail.substring(commaHead.length() + 1, poleTail.length());
            String serverIdString = "";
            for (int i = Integer.valueOf(poleHead).intValue(); i < Integer.valueOf(commaHead) + 1; ++i) {
                serverIdString = serverIdString + i + ",";
            }
            districtServer = serverIdString + commaTail;
        } else if (districtServer.contains("-")) {
            poleHead = districtServer.substring(0, districtServer.indexOf("-"));
            poleTail = districtServer.substring(poleHead.length() + 1, districtServer.length());
            String serverIdString = "";
            for (int i = Integer.valueOf(poleHead).intValue(); i < Integer.valueOf(poleTail) + 1; ++i) {
                serverIdString = serverIdString + i + ",";
            }
            districtServer = serverIdString.substring(0, serverIdString.length() - 1);
        }
        List<String> PlayerIdStringList = Arrays.asList(districtServer.split(","));
        List rearServerConfigList = this.rearServerServiceImpl.serverIdQueryList(PlayerIdStringList);
        List rearServerConfigIdList = rearServerConfigList.stream().map(RearServerConfig::getServerId).collect(Collectors.toList());
        ArrayList<String> undeclaredList = new ArrayList<String>();
        for (int i = 0; i < PlayerIdStringList.size(); ++i) {
            if (rearServerConfigIdList.contains(PlayerIdStringList.get(i))) continue;
            undeclaredList.add(PlayerIdStringList.get(i));
        }
        if (undeclaredList != null && undeclaredList.size() > 0) {
            throw new ServiceException("\u6b64\u670d\u52a1\u5668id: " + undeclaredList + " \u65e0ip\u4e0a\u62a5\u4fe1\u606f,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return rearServerConfigList;
    }

    public QuestionnaireApiVO sendingQuestionnaire(Integer state, RearServerConfig rearServerConfig, Map<String, List<String>> pidGidMap, RearQuestionnaire rearQuestionnaire) {
        QuestionnaireApiVO questionnaireApiVO = new QuestionnaireApiVO();
        questionnaireApiVO.setServerId(rearServerConfig.getServerId());
        String serverIp = rearServerConfig.getServerIp();
        Integer serverPort = rearServerConfig.getServerPort();
        String visitUrl = "http://" + serverIp + ":" + serverPort + "/addOrCloseQuestionnaire";
        QuestionnaireApiPO questionnaireApiPO = new QuestionnaireApiPO();
        questionnaireApiPO.setServiceId(Integer.valueOf(rearServerConfig.getServerId()));
        questionnaireApiPO.setQuestionnaireId(rearQuestionnaire.getId().toString());
        questionnaireApiPO.setOperation(state);
        questionnaireApiPO.setUrl(rearQuestionnaire.getQuestionnaireUrl());
        questionnaireApiPO.setRewardId(Integer.valueOf(rearQuestionnaire.getPrizeId()));
        questionnaireApiPO.setPid2Gid(pidGidMap);
        ArrayList<Integer> playerLvRangeList = new ArrayList<Integer>();
        playerLvRangeList.add(rearQuestionnaire.getGradeMinimum());
        playerLvRangeList.add(rearQuestionnaire.getGradeHighest());
        questionnaireApiPO.setPlayerLvRange(playerLvRangeList);
        ArrayList<Integer> rechargeRangeList = new ArrayList<Integer>();
        rechargeRangeList.add(rearQuestionnaire.getMoneyMinimum());
        rechargeRangeList.add(rearQuestionnaire.getMoneyHighest());
        questionnaireApiPO.setRechargeRange(rechargeRangeList);
        ArrayList<Long> timeRangeList = new ArrayList<Long>();
        timeRangeList.add(rearQuestionnaire.getLaunchStartTime().getTime());
        timeRangeList.add(rearQuestionnaire.getLaunchFinishTime().getTime());
        questionnaireApiPO.setTimeRange(timeRangeList);
        try {
            log.info("\u8c03\u7528\u8c03\u67e5\u95ee\u5377\u63a5\u53e3: \u5165\u53c2={}", (Object)questionnaireApiPO);
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity formEntity = new HttpEntity((Object)questionnaireApiPO, (MultiValueMap)headers);
            questionnaireApiVO = (QuestionnaireApiVO)restTemplate.postForObject(visitUrl, (Object)formEntity, QuestionnaireApiVO.class, new Object[0]);
            log.info("\u8c03\u7528\u8c03\u67e5\u95ee\u5377\u63a5\u53e3: \u51fa\u53c2={}", (Object)questionnaireApiVO);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u8c03\u67e5\u95ee\u5377\u63a5\u53e3\u5f02\u5e38: e\u51fa\u53c2={}", (Throwable)e);
            log.error("\u8c03\u7528\u8c03\u67e5\u95ee\u5377\u63a5\u53e3\u5f02\u5e38: \u5165\u53c2={}", (Object)questionnaireApiPO);
            questionnaireApiVO.setState(Boolean.valueOf(BaseYesNoEnums.NO.getValue()));
            questionnaireApiVO.setMsg("\u8c03\u7528\u8c03\u67e5\u95ee\u5377\u63a5\u53e3\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return questionnaireApiVO;
        }
        questionnaireApiVO.setState(Boolean.valueOf(BaseYesNoEnums.YES.getValue()));
        questionnaireApiVO.setMsg("\u8c03\u7528\u6210\u529f");
        return questionnaireApiVO;
    }

    public QuestionnaireAddVO insertRearQuestionnaireHandle(List<String> errorMarkList, String successMark, List<RearServerConfig> rearServerConfigList, RearQuestionnaire rearQuestionnaire, List<QuestionnaireApiVO> questionnaireApiVOList) {
        QuestionnaireAddVO questionnaireAddVO = new QuestionnaireAddVO();
        if (errorMarkList.size() == 0) {
            questionnaireAddVO = this.valueVOHandle(Integer.valueOf(rearServerConfigList.size()), Integer.valueOf(errorMarkList.size()), questionnaireApiVOList);
            return questionnaireAddVO;
        }
        Integer successNumber = rearServerConfigList.size() - errorMarkList.size();
        if (rearServerConfigList.size() == errorMarkList.size()) {
            questionnaireAddVO = this.valueVOHandle(successNumber, Integer.valueOf(errorMarkList.size()), questionnaireApiVOList);
            this.deleteRearQuestionnaireById(rearQuestionnaire.getId());
        } else {
            questionnaireAddVO = this.valueVOHandle(successNumber, Integer.valueOf(errorMarkList.size()), questionnaireApiVOList);
            rearQuestionnaire.setDistrictServer(successMark);
            this.updateRearQuestionnaire(rearQuestionnaire);
        }
        return questionnaireAddVO;
    }

    public QuestionnaireDelVO delRearQuestionnaireHandle(List<String> errorMarkList, String successMark, List<RearServerConfig> rearServerConfigList, RearQuestionnaire rearQuestionnaire, List<QuestionnaireApiVO> questionnaireApiVOList) {
        QuestionnaireDelVO questionnaireDelVO = new QuestionnaireDelVO();
        if (errorMarkList.size() == 0) {
            rearQuestionnaire.setUpdateBy(SecurityUtils.getUsername());
            rearQuestionnaire.setUpdateTime(new Date());
            rearQuestionnaire.setDelFlag(QuestionnaireRequestEnums.DELETE.getValue().toString());
            this.updateRearQuestionnaire(rearQuestionnaire);
            questionnaireDelVO = this.delValueVOHandle(Integer.valueOf(rearServerConfigList.size()), Integer.valueOf(errorMarkList.size()), questionnaireApiVOList);
            return questionnaireDelVO;
        }
        Integer successNumber = rearServerConfigList.size() - errorMarkList.size();
        if (rearServerConfigList.size() == errorMarkList.size()) {
            questionnaireDelVO = this.delValueVOHandle(successNumber, Integer.valueOf(errorMarkList.size()), questionnaireApiVOList);
        } else {
            questionnaireDelVO = this.delValueVOHandle(successNumber, Integer.valueOf(errorMarkList.size()), questionnaireApiVOList);
            rearQuestionnaire.setDistrictServer(successMark);
            this.updateRearQuestionnaire(rearQuestionnaire);
        }
        return questionnaireDelVO;
    }

    public QuestionnaireAddVO valueVOHandle(Integer successNumber, Integer errorNumber, List<QuestionnaireApiVO> questionnaireApiVOList) {
        QuestionnaireAddVO questionnaireAddVO = new QuestionnaireAddVO();
        questionnaireAddVO.setSuccessNumber(successNumber);
        questionnaireAddVO.setFailNumber(errorNumber);
        String describe = "";
        for (QuestionnaireApiVO questionnaireApiVO : questionnaireApiVOList) {
            describe = describe + "\u670d\u52a1\u5668id: " + questionnaireApiVO.getServerId() + "; \u662f\u5426\u6210\u529f: " + questionnaireApiVO.getState() + "; \u63cf\u8ff0: " + questionnaireApiVO.getMsg() + ";\n";
        }
        questionnaireAddVO.setDescribe(describe);
        return questionnaireAddVO;
    }

    public QuestionnaireDelVO delValueVOHandle(Integer successNumber, Integer errorNumber, List<QuestionnaireApiVO> questionnaireApiVOList) {
        QuestionnaireDelVO questionnaireDelVO = new QuestionnaireDelVO();
        questionnaireDelVO.setSuccessNumber(successNumber);
        questionnaireDelVO.setFailNumber(errorNumber);
        String describe = "";
        for (QuestionnaireApiVO questionnaireApiVO : questionnaireApiVOList) {
            describe = describe + "\u670d\u52a1\u5668id: " + questionnaireApiVO.getServerId() + "; \u662f\u5426\u6210\u529f: " + questionnaireApiVO.getState() + "; \u63cf\u8ff0: " + questionnaireApiVO.getMsg() + ";\n";
        }
        questionnaireDelVO.setDescribe(describe);
        return questionnaireDelVO;
    }

    public int updateRearQuestionnaire(RearQuestionnaire rearQuestionnaire) {
        rearQuestionnaire.setUpdateBy(SecurityUtils.getUsername());
        rearQuestionnaire.setUpdateTime(DateUtils.getNowDate());
        return this.rearQuestionnaireMapper.updateRearQuestionnaire(rearQuestionnaire);
    }

    public QuestionnaireDelVO deleteRearQuestionnaireByIds(Long[] Ids) {
        QuestionnaireDelVO questionnaireDelVO = new QuestionnaireDelVO();
        Long delId = Ids[0];
        RearQuestionnaire rearQuestionnaire = this.rearQuestionnaireMapper.selectRearQuestionnaireById(delId);
        Map pidGidMap = new HashMap();
        pidGidMap = this.pidGidIntercept(rearQuestionnaire.getChannelGame());
        List rearServerConfigList = this.serverIntercept(rearQuestionnaire.getDistrictServer());
        ArrayList<String> errorMarkList = new ArrayList<String>();
        String successMark = "";
        ArrayList<QuestionnaireApiVO> questionnaireApiVOList = new ArrayList<QuestionnaireApiVO>();
        for (RearServerConfig rearServerConfig : rearServerConfigList) {
            QuestionnaireApiVO questionnaireApiVO = new QuestionnaireApiVO();
            questionnaireApiVO = this.sendingQuestionnaire(QuestionnaireRequestEnums.DELETE.getValue(), rearServerConfig, pidGidMap, rearQuestionnaire);
            questionnaireApiVO.setServerId(rearServerConfig.getServerId());
            if (questionnaireApiVO.getState().booleanValue()) {
                successMark = successMark + "," + questionnaireApiVO.getServerId();
            } else {
                errorMarkList.add(rearServerConfig.getServerId());
            }
            questionnaireApiVOList.add(questionnaireApiVO);
        }
        questionnaireDelVO = this.delRearQuestionnaireHandle(errorMarkList, successMark, rearServerConfigList, rearQuestionnaire, questionnaireApiVOList);
        return questionnaireDelVO;
    }

    public int deleteRearQuestionnaireById(Long Id) {
        return this.rearQuestionnaireMapper.deleteRearQuestionnaireById(Id);
    }

    public ServerCountVO serverCount(ServerCountPO serverCountPO) {
        ServerCountVO serverCountVO = new ServerCountVO();
        List rearServerConfigList = this.interfaceSendUtils.serverSlicing(serverCountPO.getDistrictServer());
        List serverIdAllList = rearServerConfigList.stream().map(RearServerConfig::getServerId).collect(Collectors.toList());
        List serverOpenIdList = this.rearQuestionnaireMapper.districtServerAllList();
        String serverIdMontage = "";
        List<Object> serverIdHandleList = new ArrayList();
        for (int i = 0; i < serverOpenIdList.size(); ++i) {
            serverIdMontage = i == 0 ? (String)serverOpenIdList.get(i) : serverIdMontage + "," + (String)serverOpenIdList.get(i);
        }
        serverIdHandleList = Arrays.asList(serverIdMontage.split(","));
        List commonElements = serverIdAllList.stream().filter(serverIdHandleList::contains).collect(Collectors.toList());
        if (serverCountPO.getOperateMark().equals(OperateMarkEnums.INSERT.getValue()) && commonElements != null && commonElements.size() > 0) {
            serverCountVO.setState(Boolean.valueOf(false));
            serverCountVO.setMsg("\u6b64\u670d\u52a1\u5668: " + commonElements + " \u5df2\u5728\u5217\u8868\u4e2d\u5b58\u5728,\u8bf7\u91cd\u65b0\u8f93\u5165!");
            return serverCountVO;
        }
        serverCountVO.setState(Boolean.valueOf(true));
        serverCountVO.setMsg("\u68c0\u6d4b\u6b63\u5e38");
        return serverCountVO;
    }

    public String questionnaireKey() {
        String id = IdWorker.getNextId();
        String md5Key = DigestUtils.md5DigestAsHex((byte[])id.getBytes(StandardCharsets.UTF_8));
        return md5Key;
    }
}

