/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.operate.prop;

import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.RearProp;
import com.ruoyi.rearend.domain.po.InterfaceSendPO;
import com.ruoyi.rearend.domain.po.operate.prop.PropListPO;
import com.ruoyi.rearend.domain.po.operate.prop.PropMontagePO;
import com.ruoyi.rearend.domain.vo.InterfaceSendVO;
import com.ruoyi.rearend.domain.vo.operate.prop.PropApiVO;
import com.ruoyi.rearend.domain.vo.operate.prop.PropListVO;
import com.ruoyi.rearend.enums.operate.PropTypeEnums;
import com.ruoyi.rearend.mapper.operate.prop.RearPropMapper;
import com.ruoyi.rearend.service.operate.prop.IPropService;
import com.ruoyi.rearend.utils.InterfaceSendUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PropServiceImpl
implements IPropService {
    @Value(value="${meta.data.prop-url}")
    private String propUrl;
    @Autowired
    private InterfaceSendUtils interfaceSendUtils;
    @Autowired
    private RearPropMapper rearPropMapper;

    public List<PropListVO> propSelect(PropListPO propListPO) {
        List rearPropList;
        List<Object> propListVOList = new ArrayList<PropListVO>();
        RearProp rearProp = new RearProp();
        if (!propListPO.getPropType().equals(PropTypeEnums.INTERNAL_PROP.getDesc())) {
            rearProp.setPropType(propListPO.getPropType());
        }
        if ((rearPropList = this.rearPropMapper.selectRearPropList(rearProp)) == null || rearPropList.size() <= 0) {
            return propListVOList;
        }
        propListVOList = Lists.transform((List)rearPropList, entity -> {
            PropListVO propListVO = new PropListVO();
            propListVO.setRid(entity.getPropId());
            propListVO.setName(entity.getPropName());
            propListVO.setMontageName(entity.getPropId() + " - " + entity.getPropName());
            propListVO.setType(entity.getPropType());
            return propListVO;
        });
        return propListVOList;
    }

    public String propMontage(List<PropMontagePO> propMontagePOList) {
        if (propMontagePOList == null || propMontagePOList.size() <= 0) {
            return "";
        }
        for (PropMontagePO propMontagePO : propMontagePOList) {
            propMontagePO.setType("item");
        }
        String strJson = JSON.toJSONString(propMontagePOList);
        return strJson;
    }

    public Boolean propRenew() {
        String visitUrl = this.propUrl + "/itemResourceQuery";
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        interfaceSendPO.setVisitUrl(visitUrl);
        interfaceSendPO.setInterfaceDescribe("\u9053\u5177\u66f4\u65b0");
        HashMap<String, String> suppliedMap = new HashMap<String, String>();
        suppliedMap.put("serviceId", "99999");
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, String> printMap = new HashMap<String, String>();
        printMap.put("serviceId", "99999");
        interfaceSendPO.setPrintMap(printMap);
        InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
        if (!interfaceSendVO.getState().booleanValue()) {
            throw new ServiceException("\u66f4\u65b0\u5931\u8d25: " + interfaceSendVO.getMsg());
        }
        String jsonString = JSON.toJSONString((Object)interfaceSendVO.getData());
        List propApiVOList = new ArrayList();
        propApiVOList = JSON.parseArray((String)jsonString, PropApiVO.class);
        String createBy = SecurityUtils.getUsername();
        Date newDate = new Date();
        List rearPropList = new ArrayList();
        rearPropList = Lists.transform(propApiVOList, entity -> {
            RearProp rearProp = new RearProp();
            rearProp.setPropId(entity.getId());
            rearProp.setPropName(entity.getName());
            rearProp.setPropType(entity.getType());
            rearProp.setCreateBy(createBy);
            rearProp.setCreateTime(newDate);
            return rearProp;
        });
        this.rearPropMapper.wipeData();
        this.rearPropMapper.batchProp(rearPropList);
        return true;
    }
}

