/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.operate.notice;

import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.GameNotice;
import com.ruoyi.rearend.domain.po.operate.notice.NoticeAddUpdatePO;
import com.ruoyi.rearend.domain.po.operate.notice.NoticeOperatePO;
import com.ruoyi.rearend.domain.vo.operate.notice.NoticeDetailsVO;
import com.ruoyi.rearend.enums.operate.NoticeFormatEnums;
import com.ruoyi.rearend.enums.operate.NoticeMoveEnums;
import com.ruoyi.rearend.enums.operate.NoticeOffShelfSignEnums;
import com.ruoyi.rearend.enums.operate.NoticeStateEnums;
import com.ruoyi.rearend.mapper.operate.notice.GameNoticeMapper;
import com.ruoyi.rearend.service.impl.operate.notice.GameNoticeMiddleServiceImpl;
import com.ruoyi.rearend.service.operate.notice.IGameNoticeService;
import com.ruoyi.rearend.utils.InterfaceSendUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GameNoticeServiceImpl
implements IGameNoticeService {
    @Autowired
    private GameNoticeMapper gameNoticeMapper;
    @Autowired
    private InterfaceSendUtils interfaceSendUtils;
    @Autowired
    private GameNoticeMiddleServiceImpl gameNoticeMiddleServiceImpl;

    public NoticeDetailsVO selectGameNoticeById(Long Id) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        GameNotice gameNotice = this.gameNoticeMapper.selectGameNoticeById(Id);
        NoticeDetailsVO noticeDetailsVO = new NoticeDetailsVO();
        noticeDetailsVO.setId(gameNotice.getId());
        noticeDetailsVO.setNoticeLabel(gameNotice.getNoticeLabel());
        noticeDetailsVO.setNoticeTitle(gameNotice.getNoticeTitle());
        noticeDetailsVO.setChannelGame(gameNotice.getChannelGame());
        ArrayList<String> noticeTime = new ArrayList<String>();
        noticeTime.add(sdf.format(gameNotice.getNoticeStartTime()));
        noticeTime.add(sdf.format(gameNotice.getNoticeFinishTime()));
        noticeDetailsVO.setNoticeTime(noticeTime);
        if (gameNotice.getOffShelfSign() == NoticeOffShelfSignEnums.NO.getValue()) {
            noticeDetailsVO.setOffShelfSign(Boolean.valueOf(false));
        } else {
            noticeDetailsVO.setOffShelfSign(Boolean.valueOf(true));
        }
        noticeDetailsVO.setFormatSign(gameNotice.getFormatSign());
        if (NoticeFormatEnums.RICE_TEXT.getValue() == gameNotice.getFormatSign()) {
            noticeDetailsVO.setNoticeContent(gameNotice.getNoticeContent());
        } else {
            noticeDetailsVO.setNoticeContentJson(gameNotice.getNoticeContent());
        }
        return noticeDetailsVO;
    }

    public List<GameNotice> selectGameNoticeList(GameNotice gameNotice) {
        List gameNoticeList = this.gameNoticeMapper.selectGameNoticeList(gameNotice);
        Date newDate = new Date();
        for (GameNotice gameNoticeFor : gameNoticeList) {
            if (gameNoticeFor.getOffShelfSign() != NoticeOffShelfSignEnums.YES.getValue() || gameNoticeFor.getNoticeFinishTime().compareTo(newDate) != -1) continue;
            gameNoticeFor.setNoticeState(NoticeStateEnums.OFF_SHELF.getValue());
        }
        return gameNoticeList;
    }

    @Transactional(rollbackFor={Exception.class})
    public int insertGameNotice(NoticeAddUpdatePO noticeAddUpdatePO) {
        Map pidGidMap = new HashMap();
        pidGidMap = this.interfaceSendUtils.pidGidIntercept(noticeAddUpdatePO.getChannelGame());
        GameNotice gameNotice = this.insertGameNoticeHandle(noticeAddUpdatePO);
        gameNotice.setNoticeState(NoticeStateEnums.GROUNDING.getValue());
        Integer noticeSort = 1;
        GameNotice noticeMaximum = this.gameNoticeMapper.selectMaximumPosition();
        if (noticeMaximum != null) {
            noticeSort = noticeSort + noticeMaximum.getNoticeSort();
        }
        gameNotice.setNoticeSort(noticeSort);
        gameNotice.setCreateBy(SecurityUtils.getUsername());
        gameNotice.setCreateTime(new Date());
        this.gameNoticeMapper.insertGameNotice(gameNotice);
        return this.gameNoticeMiddleServiceImpl.insertBatchMiddle(pidGidMap, gameNotice.getId());
    }

    public GameNotice insertGameNoticeHandle(NoticeAddUpdatePO noticeAddUpdatePO) {
        GameNotice gameNotice = new GameNotice();
        gameNotice.setNoticeLabel(noticeAddUpdatePO.getNoticeLabel());
        gameNotice.setNoticeTitle(noticeAddUpdatePO.getNoticeTitle());
        gameNotice.setChannelGame(noticeAddUpdatePO.getChannelGame());
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            gameNotice.setNoticeStartTime(sdf.parse((String)noticeAddUpdatePO.getNoticeTime().get(0)));
            gameNotice.setNoticeFinishTime(sdf.parse((String)noticeAddUpdatePO.getNoticeTime().get(1)));
        }
        catch (ParseException e) {
            System.out.println("\u65e5\u671f\u683c\u5f0f\u89e3\u6790\u9519\u8bef");
            e.printStackTrace();
        }
        if (!noticeAddUpdatePO.getOffShelfSign().booleanValue()) {
            gameNotice.setOffShelfSign(NoticeOffShelfSignEnums.NO.getValue());
        } else {
            gameNotice.setOffShelfSign(NoticeOffShelfSignEnums.YES.getValue());
        }
        gameNotice.setFormatSign(noticeAddUpdatePO.getFormatSign());
        if (NoticeFormatEnums.RICE_TEXT.getValue() == noticeAddUpdatePO.getFormatSign()) {
            gameNotice.setNoticeContent(noticeAddUpdatePO.getNoticeContent());
        } else {
            gameNotice.setNoticeContent(noticeAddUpdatePO.getNoticeContentJson());
        }
        return gameNotice;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateGameNotice(NoticeAddUpdatePO noticeAddUpdatePO) {
        Map pidGidMap = new HashMap();
        pidGidMap = this.interfaceSendUtils.pidGidIntercept(noticeAddUpdatePO.getChannelGame());
        GameNotice gameNotice = this.insertGameNoticeHandle(noticeAddUpdatePO);
        gameNotice.setId(noticeAddUpdatePO.getId());
        gameNotice.setUpdateBy(SecurityUtils.getUsername());
        gameNotice.setUpdateTime(DateUtils.getNowDate());
        this.gameNoticeMapper.updateGameNotice(gameNotice);
        int operate = 0;
        this.gameNoticeMiddleServiceImpl.deleteNoticeId(String.valueOf(noticeAddUpdatePO.getId()));
        operate = this.gameNoticeMiddleServiceImpl.insertBatchMiddle(pidGidMap, gameNotice.getId());
        return operate;
    }

    public int deleteGameNoticeByIds(Long[] Ids) {
        return this.gameNoticeMapper.deleteGameNoticeByIds(Ids);
    }

    public int deleteGameNoticeById(Long Id) {
        return this.gameNoticeMapper.deleteGameNoticeById(Id);
    }

    @Transactional(rollbackFor={Exception.class})
    public int upperBelowFrame(NoticeOperatePO noticeOperatePO) {
        if (noticeOperatePO.getNoticeState() == NoticeStateEnums.GROUNDING.getValue()) {
            GameNotice gameNoticeDetails = this.gameNoticeMapper.selectGameNoticeById(noticeOperatePO.getId());
            gameNoticeDetails.setUpdateBy(SecurityUtils.getUsername());
            Date newDate = new Date();
            if (gameNoticeDetails.getOffShelfSign() == NoticeOffShelfSignEnums.YES.getValue() && gameNoticeDetails.getNoticeFinishTime().compareTo(newDate) == -1) {
                throw new ServiceException("\u5df2\u5230\u8fc7\u671f\u65f6\u95f4\u4e14\u81ea\u52a8\u4e0b\u67b6\u6309\u94ae\u6253\u5f00,\u8bf7\u4fee\u6539\u6570\u636e\u540e,\u91cd\u65b0\u4e0a\u67b6!");
            }
        }
        int operate = 0;
        GameNotice gameNotice = new GameNotice();
        gameNotice.setId(noticeOperatePO.getId());
        gameNotice.setNoticeState(noticeOperatePO.getNoticeState());
        gameNotice.setUpdateBy(SecurityUtils.getUsername());
        gameNotice.setUpdateTime(DateUtils.getNowDate());
        this.gameNoticeMapper.updateGameNotice(gameNotice);
        GameNotice gameNoticeDetails = this.gameNoticeMapper.selectGameNoticeById(noticeOperatePO.getId());
        if (noticeOperatePO.getNoticeState() == NoticeStateEnums.GROUNDING.getValue()) {
            Map pidGidMap = new HashMap();
            pidGidMap = this.interfaceSendUtils.pidGidIntercept(gameNoticeDetails.getChannelGame());
            operate = this.gameNoticeMiddleServiceImpl.insertBatchMiddle(pidGidMap, gameNotice.getId());
        } else {
            operate = this.gameNoticeMiddleServiceImpl.deleteNoticeId(String.valueOf(noticeOperatePO.getId()));
        }
        return operate;
    }

    @Transactional(rollbackFor={Exception.class})
    public int upperBelowMove(NoticeOperatePO noticeOperatePO) {
        GameNotice gameNoticeDetails = this.gameNoticeMapper.selectGameNoticeById(noticeOperatePO.getId());
        gameNoticeDetails.setUpdateBy(SecurityUtils.getUsername());
        GameNotice upAndDownNotice = new GameNotice();
        upAndDownNotice.setUpdateBy(SecurityUtils.getUsername());
        upAndDownNotice = NoticeMoveEnums.MOVE_UP.getValue() == noticeOperatePO.getMove() ? this.gameNoticeMapper.selectPreviousPosition(noticeOperatePO.getPosition()) : this.gameNoticeMapper.selectNextPosition(noticeOperatePO.getPosition());
        if (upAndDownNotice == null) {
            return 1;
        }
        gameNoticeDetails.setUpdateBy(SecurityUtils.getUsername());
        gameNoticeDetails.setUpdateTime(DateUtils.getNowDate());
        gameNoticeDetails.setNoticeSort(upAndDownNotice.getNoticeSort());
        this.gameNoticeMapper.updateGameNotice(gameNoticeDetails);
        upAndDownNotice.setUpdateBy(SecurityUtils.getUsername());
        upAndDownNotice.setUpdateTime(DateUtils.getNowDate());
        upAndDownNotice.setNoticeSort(noticeOperatePO.getPosition());
        return this.gameNoticeMapper.updateGameNotice(upAndDownNotice);
    }

    public int toppingMove(NoticeOperatePO noticeOperatePO) {
        GameNotice gameNoticeDetails = this.gameNoticeMapper.selectGameNoticeById(noticeOperatePO.getId());
        gameNoticeDetails.setUpdateBy(SecurityUtils.getUsername());
        GameNotice noticeMaximum = this.gameNoticeMapper.selectMaximumPosition();
        gameNoticeDetails.setUpdateBy(SecurityUtils.getUsername());
        gameNoticeDetails.setUpdateTime(DateUtils.getNowDate());
        gameNoticeDetails.setNoticeSort(Integer.valueOf(noticeMaximum.getNoticeSort() + 1));
        return this.gameNoticeMapper.updateGameNotice(gameNoticeDetails);
    }
}

