/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.operate.notice;

import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.GameNoticeMiddle;
import com.ruoyi.rearend.mapper.operate.notice.GameNoticeMiddleMapper;
import com.ruoyi.rearend.service.impl.server.RearChannelServiceImpl;
import com.ruoyi.rearend.service.impl.server.RearGameWrapServiceImpl;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GameNoticeMiddleServiceImpl {
    @Autowired
    private GameNoticeMiddleMapper gameNoticeMiddleMapper;
    @Autowired
    private RearChannelServiceImpl rearChannelServiceImpl;
    @Autowired
    private RearGameWrapServiceImpl rearGameWrapServiceImpl;

    public GameNoticeMiddle selectGameNoticeMiddleById(Long Id) {
        return this.gameNoticeMiddleMapper.selectGameNoticeMiddleById(Id);
    }

    public List<GameNoticeMiddle> selectGameNoticeMiddleList(GameNoticeMiddle gameNoticeMiddle) {
        return this.gameNoticeMiddleMapper.selectGameNoticeMiddleList(gameNoticeMiddle);
    }

    public int insertGameNoticeMiddle(GameNoticeMiddle gameNoticeMiddle) {
        gameNoticeMiddle.setCreateTime(DateUtils.getNowDate());
        return this.gameNoticeMiddleMapper.insertGameNoticeMiddle(gameNoticeMiddle);
    }

    public int updateGameNoticeMiddle(GameNoticeMiddle gameNoticeMiddle) {
        gameNoticeMiddle.setUpdateTime(DateUtils.getNowDate());
        return this.gameNoticeMiddleMapper.updateGameNoticeMiddle(gameNoticeMiddle);
    }

    public int deleteGameNoticeMiddleByIds(Long[] Ids) {
        return this.gameNoticeMiddleMapper.deleteGameNoticeMiddleByIds(Ids);
    }

    public int deleteGameNoticeMiddleById(Long Id) {
        return this.gameNoticeMiddleMapper.deleteGameNoticeMiddleById(Id);
    }

    public int deleteNoticeId(String noticeId) {
        return this.gameNoticeMiddleMapper.deleteNoticeId(noticeId);
    }

    public int insertBatchMiddle(Map<String, List<String>> pidGidMap, Long noticeId) {
        Map pidGidNewMap = this.insertBatchMiddleHandle(pidGidMap);
        ArrayList<GameNoticeMiddle> gameNoticeMiddleList = new ArrayList<GameNoticeMiddle>();
        for (Map.Entry entry : pidGidNewMap.entrySet()) {
            List pidGidList = (List)entry.getValue();
            for (int i = 0; i < pidGidList.size(); ++i) {
                GameNoticeMiddle gameNoticeMiddle = new GameNoticeMiddle();
                gameNoticeMiddle.setNoticeId(noticeId);
                gameNoticeMiddle.setChannelId((String)entry.getKey());
                gameNoticeMiddle.setGameWrapId((String)pidGidList.get(i));
                gameNoticeMiddle.setCreateBy(SecurityUtils.getUsername());
                gameNoticeMiddle.setCreateTime(new Date());
                gameNoticeMiddleList.add(gameNoticeMiddle);
            }
        }
        return this.gameNoticeMiddleMapper.insertBatchMiddle(gameNoticeMiddleList);
    }

    public Map<String, List<String>> insertBatchMiddleHandle(Map<String, List<String>> pidGidMap) {
        List channelAllList = this.rearChannelServiceImpl.channelAllList();
        List gameWrapAllList = this.rearGameWrapServiceImpl.gameWrapAllList();
        HashMap<String, List<String>> pidGidAllMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : pidGidMap.entrySet()) {
            if (entry.getKey().equals("*") && entry.getValue().size() == 1 && entry.getValue().get(0).equals("*")) {
                for (int i = 0; i < channelAllList.size(); ++i) {
                    pidGidAllMap.put((String)channelAllList.get(i), gameWrapAllList);
                }
                break;
            }
            if (entry.getKey().equals("*") && !entry.getValue().get(0).equals("*")) {
                for (int i = 0; i < channelAllList.size(); ++i) {
                    pidGidAllMap.put((String)channelAllList.get(i), entry.getValue());
                }
                break;
            }
            if (!entry.getKey().equals("*") && entry.getValue().get(0).equals("*")) {
                pidGidAllMap.put(entry.getKey(), gameWrapAllList);
                continue;
            }
            pidGidAllMap.put(entry.getKey(), entry.getValue());
        }
        return pidGidAllMap;
    }
}

