/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.operate.message;

import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.GameMessage;
import com.ruoyi.rearend.domain.GameMessageLog;
import com.ruoyi.rearend.domain.RearServerConfig;
import com.ruoyi.rearend.domain.po.InterfaceSendPO;
import com.ruoyi.rearend.domain.po.operate.InterfaceHandlePO;
import com.ruoyi.rearend.domain.po.operate.message.GameMessageListPO;
import com.ruoyi.rearend.domain.vo.InterfaceCallVO;
import com.ruoyi.rearend.domain.vo.InterfaceSendVO;
import com.ruoyi.rearend.domain.vo.operate.message.GameMessageDetailsVO;
import com.ruoyi.rearend.domain.vo.operate.message.GameMessageListVO;
import com.ruoyi.rearend.enums.BaseYesNoEnums;
import com.ruoyi.rearend.enums.OperateMarkEnums;
import com.ruoyi.rearend.enums.operate.MessageStateEnums;
import com.ruoyi.rearend.enums.operate.MessageTypeEnums;
import com.ruoyi.rearend.mapper.operate.message.GameMessageMapper;
import com.ruoyi.rearend.service.impl.operate.message.GameMessageLogServiceImpl;
import com.ruoyi.rearend.service.operate.message.IGameMessageService;
import com.ruoyi.rearend.utils.InterfaceSendUtils;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service
public class GameMessageServiceImpl
implements IGameMessageService {
    @Autowired
    private GameMessageMapper gameMessageMapper;
    @Autowired
    private InterfaceSendUtils interfaceSendUtils;
    @Autowired
    private GameMessageLogServiceImpl gameMessageLogServiceImpl;
    private static final Logger log = LoggerFactory.getLogger(GameMessageServiceImpl.class);

    public GameMessageDetailsVO selectGameMessageById(Long Id) {
        GameMessageDetailsVO gameMessageDetailsVO = new GameMessageDetailsVO();
        GameMessage gameMessage = this.gameMessageMapper.selectGameMessageById(Id);
        BeanUtils.copyProperties((Object)gameMessage, (Object)gameMessageDetailsVO);
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        gameMessageDetailsVO.setEffectiveStartTime(ft.format(gameMessage.getEffectiveStartTime()));
        gameMessageDetailsVO.setEffectiveFinishTime(ft.format(gameMessage.getEffectiveFinishTime()));
        return gameMessageDetailsVO;
    }

    public List<GameMessageListVO> selectGameMessageList(GameMessageListPO gameMessageListPO) {
        ArrayList<GameMessageListVO> gameMessageListVOList = new ArrayList();
        List gameMessageList = this.gameMessageMapper.selectGameMessageList(gameMessageListPO);
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        gameMessageListVOList = Lists.transform((List)gameMessageList, entity -> {
            GameMessageListVO gameMessageListVO = new GameMessageListVO();
            gameMessageListVO.setId(entity.getId());
            gameMessageListVO.setMessageId(entity.getMessageId());
            gameMessageListVO.setMessageType(entity.getMessageType());
            gameMessageListVO.setMessageTypeDescribe(MessageTypeEnums.getDescByValue((String)entity.getMessageType()));
            gameMessageListVO.setDistrictServer(entity.getDistrictServer());
            gameMessageListVO.setMessageCirculate(entity.getMessageCirculate());
            gameMessageListVO.setMessageCirculateDescribe(BaseYesNoEnums.getDescBy((String)entity.getMessageCirculate()));
            gameMessageListVO.setMessageContent(entity.getMessageContent());
            gameMessageListVO.setMessageState(entity.getMessageState());
            gameMessageListVO.setMessageStateDescribe(MessageStateEnums.getDescByValue((String)entity.getMessageState()));
            String effectiveTime = ft.format(entity.getEffectiveStartTime()) + " \u81f3 " + ft.format(entity.getEffectiveFinishTime());
            gameMessageListVO.setEffectiveTime(effectiveTime);
            gameMessageListVO.setCreateBy(entity.getCreateBy());
            gameMessageListVO.setCreateTime(entity.getCreateTime());
            gameMessageListVO.setUpdateBy(entity.getUpdateBy());
            gameMessageListVO.setUpdateTime(entity.getUpdateTime());
            return gameMessageListVO;
        });
        return gameMessageListVOList;
    }

    public InterfaceCallVO insertGameMessage(GameMessage gameMessage) {
        InterfaceCallVO interfaceCallVO = new InterfaceCallVO();
        Date newDate = new Date();
        String combination = SecurityUtils.getUsername() + newDate;
        String md5Key = DigestUtils.md5DigestAsHex((byte[])combination.getBytes(StandardCharsets.UTF_8));
        gameMessage.setMessageId(md5Key);
        gameMessage.setCreateTime(DateUtils.getNowDate());
        gameMessage.setCreateBy(SecurityUtils.getUsername());
        InterfaceHandlePO interfaceHandlePO = this.foreignInterface(gameMessage, OperateMarkEnums.INSERT.getValue());
        if (interfaceHandlePO.getErrorNumber() == 0) {
            log.info("\u65b0\u589e\u6e38\u620f\u6d88\u606f\u6210\u529f: \u6d88\u606fid={}", (Object)md5Key);
            interfaceCallVO = this.interfaceSendUtils.interfaceCall(interfaceHandlePO.getServerNumber(), interfaceHandlePO.getErrorNumber(), interfaceHandlePO.getInterfaceSendVOList());
            this.gameMessageMapper.insertGameMessage(gameMessage);
            this.messageLog(gameMessage, interfaceCallVO, OperateMarkEnums.INSERT.getValue(), MessageStateEnums.SUCCESS.getValue());
        } else if (interfaceHandlePO.getErrorNumber() != 0 && interfaceHandlePO.getErrorNumber() < interfaceHandlePO.getServerNumber()) {
            log.info("\u65b0\u589e\u6e38\u620f\u6d88\u606f\u90e8\u5206\u6210\u529f: \u6d88\u606fid={},\u5931\u8d25\u6570\u91cf={},\u5931\u8d25\u670d\u52a1\u5668={}", new Object[]{md5Key, interfaceHandlePO.getErrorNumber(), interfaceHandlePO.getErrorList()});
            Integer successNumber = interfaceHandlePO.getServerNumber() - interfaceHandlePO.getErrorNumber();
            interfaceCallVO = this.interfaceSendUtils.interfaceCall(successNumber, interfaceHandlePO.getErrorNumber(), interfaceHandlePO.getInterfaceSendVOList());
            gameMessage.setDistrictServer(interfaceHandlePO.getSuccessStrand());
            this.gameMessageMapper.insertGameMessage(gameMessage);
            this.messageLog(gameMessage, interfaceCallVO, OperateMarkEnums.INSERT.getValue(), MessageStateEnums.PART_SUCCESS.getValue());
        } else {
            log.info("\u65b0\u589e\u6e38\u620f\u6d88\u606f\u5931\u8d25: \u6d88\u606fid={}", (Object)md5Key);
            interfaceCallVO = this.interfaceSendUtils.interfaceCall(Integer.valueOf(0), interfaceHandlePO.getErrorNumber(), interfaceHandlePO.getInterfaceSendVOList());
            this.messageLog(gameMessage, interfaceCallVO, OperateMarkEnums.INSERT.getValue(), MessageStateEnums.FAIL.getValue());
        }
        return interfaceCallVO;
    }

    public int updateGameMessage(GameMessage gameMessage) {
        gameMessage.setUpdateBy(SecurityUtils.getUsername());
        gameMessage.setUpdateTime(DateUtils.getNowDate());
        return this.gameMessageMapper.updateGameMessage(gameMessage);
    }

    public InterfaceCallVO deleteGameMessageByIds(Long[] Ids) {
        InterfaceCallVO interfaceCallVO = new InterfaceCallVO();
        GameMessage gameMessage = this.gameMessageMapper.selectGameMessageById(Ids[0]);
        if (gameMessage == null) {
            throw new ServiceException("\u6b64\u6570\u636e\u4e0d\u5b58\u5728!");
        }
        InterfaceHandlePO interfaceHandlePO = this.foreignInterface(gameMessage, OperateMarkEnums.DELETE.getValue());
        if (interfaceHandlePO.getErrorNumber() == 0) {
            log.info("\u5220\u9664\u6e38\u620f\u6d88\u606f\u6210\u529f: \u6d88\u606fid={}", (Object)gameMessage.getMessageId());
            interfaceCallVO = this.interfaceSendUtils.interfaceCall(interfaceHandlePO.getServerNumber(), interfaceHandlePO.getErrorNumber(), interfaceHandlePO.getInterfaceSendVOList());
            this.gameMessageMapper.deleteGameMessageById(Ids[0]);
            this.messageLog(gameMessage, interfaceCallVO, OperateMarkEnums.DELETE.getValue(), MessageStateEnums.SUCCESS.getValue());
        } else if (interfaceHandlePO.getErrorNumber() != 0 && interfaceHandlePO.getErrorNumber() < interfaceHandlePO.getServerNumber()) {
            log.info("\u5220\u9664\u6e38\u620f\u6d88\u606f\u90e8\u5206\u6210\u529f: \u6d88\u606fid={},\u5931\u8d25\u6570\u91cf={},\u5931\u8d25\u670d\u52a1\u5668={}", new Object[]{gameMessage.getMessageId(), interfaceHandlePO.getErrorNumber(), interfaceHandlePO.getErrorList()});
            Integer successNumber = interfaceHandlePO.getServerNumber() - interfaceHandlePO.getErrorNumber();
            interfaceCallVO = this.interfaceSendUtils.interfaceCall(successNumber, interfaceHandlePO.getErrorNumber(), interfaceHandlePO.getInterfaceSendVOList());
            gameMessage.setDistrictServer(interfaceHandlePO.getSuccessStrand());
            this.updateGameMessage(gameMessage);
            this.messageLog(gameMessage, interfaceCallVO, OperateMarkEnums.DELETE.getValue(), MessageStateEnums.PART_SUCCESS.getValue());
        } else {
            log.info("\u5220\u9664\u6d88\u606f\u5931\u8d25: \u6d88\u606fid={}", (Object)gameMessage.getMessageId());
            interfaceCallVO = this.interfaceSendUtils.interfaceCall(Integer.valueOf(0), interfaceHandlePO.getErrorNumber(), interfaceHandlePO.getInterfaceSendVOList());
            this.messageLog(gameMessage, interfaceCallVO, OperateMarkEnums.DELETE.getValue(), MessageStateEnums.FAIL.getValue());
        }
        return interfaceCallVO;
    }

    public void messageLog(GameMessage gameMessage, InterfaceCallVO interfaceCallVO, String operateType, String messageState) {
        GameMessageLog gameMessageLog = new GameMessageLog();
        BeanUtils.copyProperties((Object)gameMessage, (Object)gameMessageLog);
        gameMessageLog.setId(null);
        gameMessageLog.setGameMessageId(gameMessage.getId());
        gameMessageLog.setOperateType(operateType);
        gameMessageLog.setSuccessNumber(interfaceCallVO.getSuccessNumber());
        gameMessageLog.setFailNumber(interfaceCallVO.getFailNumber());
        gameMessageLog.setOperateContent(interfaceCallVO.getDescribe());
        gameMessageLog.setMessageState(messageState);
        gameMessageLog.setUpdateBy(null);
        gameMessageLog.setUpdateTime(null);
        this.gameMessageLogServiceImpl.insertGameMessageLog(gameMessageLog);
    }

    public int deleteGameMessageById(Long Id) {
        return this.gameMessageMapper.deleteGameMessageById(Id);
    }

    public InterfaceHandlePO foreignInterface(GameMessage gameMessage, String operateMark) {
        List rearServerConfigList = this.interfaceSendUtils.serverSlicing(gameMessage.getDistrictServer());
        InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
        interfaceSendPO.setInterfaceDescribe("\u6e38\u620f\u6d88\u606f");
        HashMap<String, Object> suppliedMap = new HashMap<String, Object>();
        suppliedMap.put("messageId", gameMessage.getMessageId());
        suppliedMap.put("messageType", Integer.valueOf(gameMessage.getMessageType()));
        suppliedMap.put("messageCirculate", Integer.valueOf(gameMessage.getMessageCirculate()));
        suppliedMap.put("messageContent", gameMessage.getMessageContent());
        suppliedMap.put("effectiveStartTime", gameMessage.getEffectiveStartTime());
        suppliedMap.put("effectiveFinishTime", gameMessage.getEffectiveFinishTime());
        suppliedMap.put("operateMark", Integer.valueOf(operateMark));
        interfaceSendPO.setSuppliedMap(suppliedMap);
        HashMap<String, Object> printMap = new HashMap<String, Object>();
        printMap.put("messageId", gameMessage.getMessageId());
        printMap.put("messageType", Integer.valueOf(gameMessage.getMessageType()));
        printMap.put("operateMark", Integer.valueOf(operateMark));
        interfaceSendPO.setPrintMap(printMap);
        String successMark = "";
        Integer errorNumber = 0;
        ArrayList<String> errorList = new ArrayList<String>();
        ArrayList<InterfaceSendVO> interfaceSendVOList = new ArrayList<InterfaceSendVO>();
        for (RearServerConfig rearServerConfig : rearServerConfigList) {
            interfaceSendPO.getSuppliedMap().put("serverId", rearServerConfig.getServerId());
            interfaceSendPO.getPrintMap().put("serverId", rearServerConfig.getServerId());
            String visitUrl = "http://" + rearServerConfig.getServerIp() + ":" + rearServerConfig.getServerPort() + "/test";
            interfaceSendPO.setVisitUrl(visitUrl);
            InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
            interfaceSendVO.setServerId(rearServerConfig.getServerId());
            if (interfaceSendVO.getState().booleanValue()) {
                successMark = successMark + "," + interfaceSendVO.getServerId();
            } else {
                errorNumber = errorNumber + 1;
                errorList.add(rearServerConfig.getServerId());
            }
            interfaceSendVOList.add(interfaceSendVO);
        }
        InterfaceHandlePO interfaceHandlePO = new InterfaceHandlePO();
        interfaceHandlePO.setErrorNumber(errorNumber);
        interfaceHandlePO.setSuccessStrand(successMark);
        interfaceHandlePO.setServerNumber(Integer.valueOf(rearServerConfigList.size()));
        interfaceHandlePO.setInterfaceSendVOList(interfaceSendVOList);
        interfaceHandlePO.setErrorList(errorList);
        return interfaceHandlePO;
    }
}

