/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.operate.message;

import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.GameMessageLog;
import com.ruoyi.rearend.domain.vo.operate.message.GameMessageLogListVO;
import com.ruoyi.rearend.enums.BaseYesNoEnums;
import com.ruoyi.rearend.enums.OperateMarkEnums;
import com.ruoyi.rearend.enums.operate.MessageStateEnums;
import com.ruoyi.rearend.enums.operate.MessageTypeEnums;
import com.ruoyi.rearend.mapper.operate.message.GameMessageLogMapper;
import com.ruoyi.rearend.service.operate.message.IGameMessageLogService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GameMessageLogServiceImpl
implements IGameMessageLogService {
    @Autowired
    private GameMessageLogMapper gameMessageLogMapper;

    public GameMessageLog selectGameMessageLogById(Long Id) {
        GameMessageLog gameMessageLog = this.gameMessageLogMapper.selectGameMessageLogById(Id);
        gameMessageLog.setMessageState(MessageStateEnums.getDescByValue((String)gameMessageLog.getMessageState()));
        return gameMessageLog;
    }

    public List<GameMessageLogListVO> selectGameMessageLogList(GameMessageLog gameMessageLog) {
        ArrayList<GameMessageLogListVO> gameMessageLogListVOList = new ArrayList();
        List gameMessageLogList = this.gameMessageLogMapper.selectGameMessageLogList(gameMessageLog);
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        gameMessageLogListVOList = Lists.transform((List)gameMessageLogList, entity -> {
            GameMessageLogListVO gameMessageLogListVO = new GameMessageLogListVO();
            gameMessageLogListVO.setId(entity.getId());
            gameMessageLogListVO.setOperateTypeDescribe(OperateMarkEnums.getDescByValue((String)entity.getOperateType()));
            gameMessageLogListVO.setGameMessageId(entity.getGameMessageId());
            gameMessageLogListVO.setMessageId(entity.getMessageId());
            gameMessageLogListVO.setMessageTypeDescribe(MessageTypeEnums.getDescByValue((String)entity.getMessageType()));
            gameMessageLogListVO.setDistrictServer(entity.getDistrictServer());
            gameMessageLogListVO.setMessageCirculateDescribe(BaseYesNoEnums.getDescBy((String)entity.getMessageCirculate()));
            gameMessageLogListVO.setMessageState(entity.getMessageState());
            String effectiveTime = ft.format(entity.getEffectiveStartTime()) + " \u81f3 " + ft.format(entity.getEffectiveFinishTime());
            gameMessageLogListVO.setEffectiveTime(effectiveTime);
            gameMessageLogListVO.setCreateBy(entity.getCreateBy());
            gameMessageLogListVO.setCreateTime(entity.getCreateTime());
            return gameMessageLogListVO;
        });
        return gameMessageLogListVOList;
    }

    public int insertGameMessageLog(GameMessageLog gameMessageLog) {
        gameMessageLog.setCreateBy(SecurityUtils.getUsername());
        gameMessageLog.setCreateTime(DateUtils.getNowDate());
        return this.gameMessageLogMapper.insertGameMessageLog(gameMessageLog);
    }

    public int updateGameMessageLog(GameMessageLog gameMessageLog) {
        gameMessageLog.setUpdateTime(DateUtils.getNowDate());
        return this.gameMessageLogMapper.updateGameMessageLog(gameMessageLog);
    }

    public int deleteGameMessageLogByIds(Long[] Ids) {
        return this.gameMessageLogMapper.deleteGameMessageLogByIds(Ids);
    }

    public int deleteGameMessageLogById(Long Id) {
        return this.gameMessageLogMapper.deleteGameMessageLogById(Id);
    }
}

