/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.operate.mail;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.rearend.domain.GameMail;
import com.ruoyi.rearend.domain.GameMailSendLog;
import com.ruoyi.rearend.domain.RearServerConfig;
import com.ruoyi.rearend.domain.po.operate.mail.GameMailAddPO;
import com.ruoyi.rearend.domain.po.operate.mail.GameMailApiPO;
import com.ruoyi.rearend.domain.po.player.BatchPlayerQueryPO;
import com.ruoyi.rearend.domain.vo.operate.mail.GameMailApiVO;
import com.ruoyi.rearend.enums.BaseSuccessFailEnums;
import com.ruoyi.rearend.enums.BaseYesNoEnums;
import com.ruoyi.rearend.enums.operate.MailStateEnums;
import com.ruoyi.rearend.enums.operate.MailTypeEnums;
import com.ruoyi.rearend.enums.operate.mailSendTypeEnums;
import com.ruoyi.rearend.enums.palyer.SendingTypeEnums;
import com.ruoyi.rearend.mapper.operate.mail.GameMailExamineMapper;
import com.ruoyi.rearend.mapper.operate.mail.GameMailMapper;
import com.ruoyi.rearend.mapper.operate.mail.GameMailSendLogMapper;
import com.ruoyi.rearend.service.impl.operate.mail.GameMailSendLogServiceImpl;
import com.ruoyi.rearend.service.impl.server.RearServerServiceImpl;
import com.ruoyi.rearend.utils.InterfaceSendUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class MailTimerServiceImpl {
    @Autowired
    private GameMailMapper gameMailMapper;
    @Autowired
    private GameMailExamineMapper gameMailExamineMapper;
    @Autowired
    private GameMailSendLogMapper gameMailSendLogMapper;
    @Autowired
    private RearServerServiceImpl rearServerServiceImpl;
    @Autowired
    private GameMailSendLogServiceImpl gameMailSendLogServiceImpl;
    @Autowired
    private InterfaceSendUtils interfaceSendUtils;
    private static final Logger log = LoggerFactory.getLogger(MailTimerServiceImpl.class);

    @Scheduled(fixedDelay=10000L)
    public void mailTimingSend() {
        Date newDate = new Date();
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        List gameMailList = this.gameMailMapper.timingMailList(ft.format(newDate));
        List mailErrorLogList = this.gameMailSendLogMapper.mailErrorLogList(Integer.valueOf(3));
        if (gameMailList == null || gameMailList.size() == 0) {
            return;
        }
        String sendingState = "";
        ArrayList<GameMail> mailUpdateList = new ArrayList<GameMail>();
        for (GameMail gameMail : gameMailList) {
            if (mailErrorLogList.contains(gameMail.getId())) continue;
            this.crossBarHandle(gameMail);
            HashMap<String, String> jsonMap = new HashMap<String, String>();
            if (SendingTypeEnums.CUSTOM_AND_USER_PLAYER_ID.getValue() == gameMail.getMailSendingType() || SendingTypeEnums.CUSTOM_AND_USER_ACCOUNT.getValue() == gameMail.getMailSendingType()) {
                List<String> serverList = Arrays.asList(gameMail.getUserPlayerId().split("\n"));
                String head = "";
                int appointIndex = 0;
                for (int i = 0; i < serverList.size(); ++i) {
                    appointIndex = serverList.get(i).indexOf(",[");
                    head = head + serverList.get(i).substring(0, appointIndex) + "\n";
                    List<String> dataList = Arrays.asList(serverList.get(i).split(","));
                    jsonMap.put(dataList.get(0), serverList.get(i).substring(serverList.get(i).lastIndexOf(",[") + 1));
                }
                gameMail.setUserPlayerId(head);
            }
            List batchPlayerQueryPOList = this.interfaceSendUtils.manyServerPlayerHandle(gameMail.getUserPlayerId());
            GameMailAddPO gameMailAddPO = new GameMailAddPO();
            BeanUtils.copyProperties((Object)gameMail, (Object)gameMailAddPO);
            for (BatchPlayerQueryPO batchPlayerQueryPO : batchPlayerQueryPOList) {
                List PlayerIdStringList = this.serverIdHandle(batchPlayerQueryPO.getUserPlayerId());
                gameMailAddPO.setServerId(batchPlayerQueryPO.getServerId());
                gameMailAddPO.setUserPlayerIdList(PlayerIdStringList);
                if (jsonMap.isEmpty()) {
                    gameMailAddPO.setMailRewardJson(gameMail.getMailRewardJson());
                } else {
                    gameMailAddPO.setMailRewardJson((String)jsonMap.get(batchPlayerQueryPO.getServerId()));
                }
                sendingState = this.mailApiSending(gameMail.getId(), gameMailAddPO);
            }
            gameMail.setMailState(sendingState);
            mailUpdateList.add(gameMail);
        }
        for (GameMail gameMail : mailUpdateList) {
            gameMail.setUpdateBy("\u5b9a\u65f6\u5668\u63a5\u53e3");
            gameMail.setUpdateTime(DateUtils.getNowDate());
            this.gameMailMapper.updateGameMail(gameMail);
        }
    }

    public void crossBarHandle(GameMail gameMail) {
        String districtServer = "";
        List<String> serverList = Arrays.asList(gameMail.getUserPlayerId().split("\n"));
        for (int i = 0; i < serverList.size(); ++i) {
            if (serverList.get(i).contains("-")) {
                String poleHead = serverList.get(i).substring(0, serverList.get(i).indexOf("-"));
                String poleTail = serverList.get(i).substring(poleHead.length() + 1, serverList.get(i).length());
                String commaHead = poleTail.substring(0, poleTail.indexOf(","));
                String commaTail = poleTail.substring(commaHead.length() + 1, poleTail.length());
                String serverIdString = "";
                for (int z = Integer.valueOf(poleHead).intValue(); z < Integer.valueOf(commaHead) + 1; ++z) {
                    serverIdString = serverIdString + z + "," + commaTail + "\n";
                }
                districtServer = districtServer + serverIdString;
                continue;
            }
            districtServer = districtServer + serverList.get(i) + "\n";
        }
        gameMail.setUserPlayerId(districtServer);
    }

    public String mailApiSending(Long mailId, GameMailAddPO gameMailAddPO) {
        GameMailSendLog gameMailSendLog = new GameMailSendLog();
        gameMailSendLog.setMailId(mailId);
        gameMailSendLog.setMailServerId(gameMailAddPO.getMailServerId());
        gameMailSendLog.setSendType(mailSendTypeEnums.TIMING_SEND.getValue());
        gameMailSendLog.setMailInternalMark(String.valueOf(gameMailAddPO.getMailInternalMark()));
        GameMailApiPO gameMailApiPO = new GameMailApiPO();
        gameMailApiPO.setServiceId(Integer.valueOf(gameMailAddPO.getServerId()));
        gameMailApiPO.setTitle(gameMailAddPO.getMailTitle());
        gameMailApiPO.setContent(gameMailAddPO.getMailContent());
        gameMailApiPO.setCheckOnce(Boolean.valueOf(BaseYesNoEnums.getDescByType((String)gameMailAddPO.getMailCheckOnce())));
        gameMailApiPO.setExpireTime(Long.valueOf(gameMailAddPO.getMailExpireTime().getTime()));
        gameMailApiPO.setFilterAfterPostCreate(Boolean.valueOf(BaseYesNoEnums.getDescByType((String)gameMailAddPO.getMailFilterAfterPostCreate())));
        gameMailApiPO.setReceiveConditionJson(gameMailAddPO.getMailReceiveConditionJson());
        gameMailApiPO.setValidConditionJson(gameMailAddPO.getMailValidConditionJson());
        gameMailApiPO.setAppointedPlayerIds(gameMailAddPO.getUserPlayerIdList());
        gameMailApiPO.setMailBox(MailTypeEnums.getDescByValue((Integer)gameMailAddPO.getMailType()));
        gameMailApiPO.setBackStageMailId(gameMailAddPO.getMailServerId());
        if (StringUtils.isEmpty((String)gameMailAddPO.getMailRewardJson())) {
            gameMailApiPO.setRewardJson("");
        } else {
            gameMailApiPO.setRewardJson(gameMailAddPO.getMailRewardJson());
        }
        GameMailApiVO gameMailApiVO = new GameMailApiVO();
        Integer serviceId = Integer.valueOf(gameMailAddPO.getServerId());
        RearServerConfig RearServerConfig2 = this.rearServerServiceImpl.serverIdQuery(String.valueOf(serviceId));
        if (RearServerConfig2 == null || StringUtils.isEmpty((String)RearServerConfig2.getServerIp())) {
            gameMailSendLog.setEnteringGinseng(JSONObject.toJSONString((Object)gameMailAddPO, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
            gameMailSendLog.setExoticGinseng("\u5b9a\u65f6\u5668\u6b64\u670d\u52a1\u5668\u65e0ip\u4e0a\u62a5\u4fe1\u606f,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            gameMailSendLog.setMailState(MailStateEnums.FAIL.getValue());
            this.gameMailSendLogServiceImpl.insertGameMailSendLog(gameMailSendLog);
            return MailStateEnums.FAIL.getValue();
        }
        String serverIp = RearServerConfig2.getServerIp();
        Integer serverPort = RearServerConfig2.getServerPort();
        String visitUrl = "http://" + serverIp + ":" + serverPort + "/sendGroupMail";
        try {
            gameMailSendLog.setEnteringGinseng(JSONObject.toJSONString((Object)gameMailApiPO, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
            log.info("\u5b9a\u65f6\u5668\u8c03\u7528\u53d1\u9001\u90ae\u4ef6\u63a5\u53e3: url={},\u5165\u53c2={}", (Object)visitUrl, (Object)gameMailApiPO);
            RestTemplate restTemplate = new RestTemplate();
            HttpHeaders headers = new HttpHeaders();
            MediaType type = MediaType.parseMediaType((String)"application/json; charset=UTF-8");
            headers.setContentType(type);
            headers.add("Accept", MediaType.APPLICATION_JSON.toString());
            HttpEntity formEntity = new HttpEntity((Object)gameMailApiPO, (MultiValueMap)headers);
            gameMailApiVO = (GameMailApiVO)restTemplate.postForObject(visitUrl, (Object)formEntity, GameMailApiVO.class, new Object[0]);
            gameMailSendLog.setExoticGinseng(JSONObject.toJSONString((Object)gameMailApiVO, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
            log.info("\u5b9a\u65f6\u5668\u8c03\u7528\u53d1\u9001\u90ae\u4ef6\u63a5\u53e3: \u51fa\u53c2={}", (Object)gameMailApiVO);
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u5668\u8c03\u7528\u53d1\u9001\u90ae\u4ef6\u63a5\u53e3\u5f02\u5e38: e\u5f02\u5e38={}", (Throwable)e);
            log.error("\u5b9a\u65f6\u5668\u8c03\u7528\u53d1\u9001\u90ae\u4ef6\u63a5\u53e3\u5f02\u5e38: url={},\u5165\u53c2={}", (Object)visitUrl, (Object)gameMailAddPO);
            gameMailSendLog.setExoticGinseng("\u8c03\u7528\u53d1\u9001\u90ae\u4ef6\u63a5\u53e3\u5f02\u5e38,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            gameMailSendLog.setMailState(MailStateEnums.FAIL.getValue());
            this.gameMailSendLogServiceImpl.insertGameMailSendLog(gameMailSendLog);
            return MailStateEnums.FAIL.getValue();
        }
        if (gameMailApiVO == null || gameMailApiVO.getCode() != BaseSuccessFailEnums.SUCCESS.getValue()) {
            log.error("\u5b9a\u65f6\u5668\u53d1\u9001\u90ae\u4ef6\u5931\u8d25: url={},\u5165\u53c2={},\u51fa\u53c2={}", new Object[]{visitUrl, gameMailAddPO, gameMailApiVO});
            gameMailSendLog.setExoticGinseng(JSONObject.toJSONString((Object)gameMailApiVO, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
            gameMailSendLog.setMailState(MailStateEnums.FAIL.getValue());
            this.gameMailSendLogServiceImpl.insertGameMailSendLog(gameMailSendLog);
            return MailStateEnums.FAIL.getValue();
        }
        gameMailSendLog.setMailState(MailStateEnums.SUCCESS.getValue());
        this.gameMailSendLogServiceImpl.insertGameMailSendLog(gameMailSendLog);
        return MailStateEnums.SUCCESS.getValue();
    }

    @Scheduled(fixedDelay=300000L)
    public void mailExpire() {
        Date newDate = new Date();
        Calendar rightNow = Calendar.getInstance();
        rightNow.setTime(newDate);
        rightNow.add(12, -5);
        newDate = rightNow.getTime();
        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.gameMailMapper.expireMail(ft.format(newDate));
        this.gameMailExamineMapper.expireMailExamine(ft.format(newDate));
    }

    public List<String> serverIdHandle(String userPlayerId) {
        ArrayList<String> userPlayerIdList = new ArrayList<String>();
        List<Object> playerIdStringList = new ArrayList();
        if (!StringUtils.isEmpty((String)userPlayerId)) {
            playerIdStringList = Arrays.asList(userPlayerId.split("\n"));
        }
        String intercept = "|";
        String roleId = "";
        for (int i = 0; i < playerIdStringList.size(); ++i) {
            roleId = ((String)playerIdStringList.get(i)).substring(0, ((String)playerIdStringList.get(i)).indexOf(intercept));
            userPlayerIdList.add(roleId);
        }
        return userPlayerIdList;
    }
}

