/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.operate.mail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.core.utils.PageUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.GameMail;
import com.ruoyi.rearend.domain.GameMailExamine;
import com.ruoyi.rearend.domain.GameMailSendLog;
import com.ruoyi.rearend.domain.po.InterfaceSendPO;
import com.ruoyi.rearend.domain.po.operate.mail.GameMailAddPO;
import com.ruoyi.rearend.domain.po.operate.mail.GameMailReceivePO;
import com.ruoyi.rearend.domain.po.operate.mail.GameMailUpdatePO;
import com.ruoyi.rearend.domain.po.player.BatchPlayerQueryPO;
import com.ruoyi.rearend.domain.vo.InterfaceSendVO;
import com.ruoyi.rearend.domain.vo.operate.mail.GameMailVO;
import com.ruoyi.rearend.enums.ServerEnums;
import com.ruoyi.rearend.enums.operate.InternalPropEnums;
import com.ruoyi.rearend.enums.operate.MailExamineStateEnums;
import com.ruoyi.rearend.enums.operate.MailInternalMarkEnums;
import com.ruoyi.rearend.enums.operate.MailMarkEnums;
import com.ruoyi.rearend.enums.operate.MailStateEnums;
import com.ruoyi.rearend.enums.operate.mailSendTypeEnums;
import com.ruoyi.rearend.enums.palyer.SendingTypeEnums;
import com.ruoyi.rearend.mapper.operate.mail.GameMailExamineMapper;
import com.ruoyi.rearend.mapper.operate.mail.GameMailMapper;
import com.ruoyi.rearend.service.impl.game.internalplayer.InternalPlayerServiceImpl;
import com.ruoyi.rearend.service.impl.operate.mail.GameMailSendLogServiceImpl;
import com.ruoyi.rearend.service.operate.mail.IGameMailService;
import com.ruoyi.rearend.utils.IdWorker;
import com.ruoyi.rearend.utils.InterfaceSendUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GameMailServiceImpl
implements IGameMailService {
    @Autowired
    private GameMailMapper gameMailMapper;
    @Autowired
    private GameMailExamineMapper gameMailExamineMapper;
    @Autowired
    private GameMailSendLogServiceImpl gameMailSendLogServiceImpl;
    @Autowired
    private InternalPlayerServiceImpl internalPlayerService;
    @Autowired
    private InterfaceSendUtils interfaceSendUtils;
    private static final Logger log = LoggerFactory.getLogger(GameMailServiceImpl.class);

    public GameMailVO selectGameMailById(Long Id) {
        GameMailVO gameMailVO = this.gameMailMapper.selectGameMailById(Id);
        if (StringUtils.isEmpty((String)gameMailVO.getMailPropJson())) {
            return gameMailVO;
        }
        JSONArray list = JSON.parseArray((String)gameMailVO.getMailPropJson());
        ArrayList<Map> mailPropJsonList = new ArrayList<Map>();
        for (Object object : list) {
            Map ret = (Map)object;
            mailPropJsonList.add(ret);
        }
        gameMailVO.setMailPropJsonList(mailPropJsonList);
        return gameMailVO;
    }

    public List<GameMail> selectGameMailList(GameMail gameMail) {
        PageUtils.startPage();
        return this.gameMailMapper.selectGameMailList(gameMail);
    }

    @Transactional(rollbackFor={Exception.class})
    public int insertGameMail(GameMailAddPO gameMailAddPO) {
        this.mailInternalJudge(gameMailAddPO);
        long timeStamp = System.currentTimeMillis() / 100L;
        String mailServerId = String.valueOf(timeStamp + (long)gameMailAddPO.getMailInternalMark().intValue() + (long)IdWorker.randomNumber((int)5).intValue());
        Date newDate = new Date();
        if (newDate.compareTo(gameMailAddPO.getMailExpireTime()) != -1 || gameMailAddPO.getMailTimingSendTime() != null && newDate.compareTo(gameMailAddPO.getMailTimingSendTime()) != -1) {
            throw new ServiceException("\u9884\u671f\u53d1\u9001\u65f6\u95f4\u6216\u8fc7\u671f\u65f6\u95f4,\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4,\u8bf7\u91cd\u65b0\u8f93\u5165\uff01");
        }
        int state = 0;
        String operName = SecurityUtils.getUsername();
        if (!StringUtils.isEmpty((String)gameMailAddPO.getUserPlayerId())) {
            List<String> PlayerIdStringList = Arrays.asList(gameMailAddPO.getUserPlayerId().split("\n"));
            gameMailAddPO.setUserPlayerIdList(PlayerIdStringList);
        }
        List userPlayerIdList = gameMailAddPO.getUserPlayerIdList();
        GameMail gameMail = new GameMail();
        BeanUtils.copyProperties((Object)gameMailAddPO, (Object)gameMail);
        gameMail.setCreateTime(new Date());
        gameMail.setCreateBy(operName);
        gameMail.setMailPropJson(JSON.toJSONString((Object)gameMailAddPO.getMailPropJsonList()));
        gameMail.setMailState(MailStateEnums.AUDIT.getValue());
        gameMail.setMailServerId(mailServerId);
        if (userPlayerIdList != null && userPlayerIdList.size() == 1 && ((String)userPlayerIdList.get(0)).equals(MailMarkEnums.FULL_SERVICE.getType())) {
            gameMail.setMailMark(MailMarkEnums.FULL_SERVICE.getValue());
        } else {
            gameMail.setMailMark(MailMarkEnums.PERSONAL.getValue());
        }
        state = this.gameMailMapper.insertGameMail(gameMail);
        GameMailExamine gameMailExamine = new GameMailExamine();
        BeanUtils.copyProperties((Object)gameMail, (Object)gameMailExamine);
        gameMailExamine.setId(null);
        gameMailExamine.setMailId(gameMail.getId());
        gameMailExamine.setExamineState(MailExamineStateEnums.AUDIT.getValue());
        gameMailExamine.setCreateBy(operName);
        gameMailExamine.setCreateTime(DateUtils.getNowDate());
        this.gameMailExamineMapper.insertGameMailExamine(gameMailExamine);
        return state;
    }

    public void mailInternalJudge(GameMailAddPO gameMailAddPO) {
        if (gameMailAddPO.getMailInternalMark() == MailInternalMarkEnums.EXTERNAL_MAIL.getValue()) {
            if (gameMailAddPO.getMailRewardJson().contains(InternalPropEnums.VOUCHER.getValue())) {
                throw new ServiceException("\u5916\u90e8\u90ae\u4ef6\u7981\u6b62\u5305\u542b\u5185\u90e8\u9053\u5177!");
            }
            return;
        }
        String primaryUserPlayerId = gameMailAddPO.getUserPlayerId();
        if (SendingTypeEnums.CUSTOM_AND_USER_PLAYER_ID.getValue() == gameMailAddPO.getMailSendingType() || SendingTypeEnums.CUSTOM_AND_USER_ACCOUNT.getValue() == gameMailAddPO.getMailSendingType()) {
            List<String> serverList = Arrays.asList(gameMailAddPO.getUserPlayerId().split("\n"));
            String head = "";
            int appointIndex = 0;
            for (int i = 0; i < serverList.size(); ++i) {
                appointIndex = serverList.get(i).indexOf(",[");
                head = head + serverList.get(i).substring(0, appointIndex) + "\n";
            }
            gameMailAddPO.setUserPlayerId(head);
        }
        ArrayList<String> userPlayerIdList = new ArrayList<String>();
        List batchPlayerQueryPOList = this.interfaceSendUtils.manyServerPlayerHandle(gameMailAddPO.getUserPlayerId());
        for (BatchPlayerQueryPO batchPlayerQueryPO : batchPlayerQueryPOList) {
            List<Object> playerIdStringList = new ArrayList();
            if (!StringUtils.isEmpty((String)batchPlayerQueryPO.getUserPlayerId())) {
                playerIdStringList = Arrays.asList(batchPlayerQueryPO.getUserPlayerId().split("\n"));
            }
            String intercept = "|";
            String roleId = "";
            for (int i = 0; i < playerIdStringList.size(); ++i) {
                roleId = ((String)playerIdStringList.get(i)).substring(0, ((String)playerIdStringList.get(i)).indexOf(intercept));
                userPlayerIdList.add(roleId);
            }
        }
        if (userPlayerIdList.contains(ServerEnums.ALL.getDesc())) {
            throw new ServiceException("\u5185\u90e8\u90ae\u4ef6\u7981\u6b62\u53d1\u9001\u5168\u670d\u90ae\u4ef6!");
        }
        if (SendingTypeEnums.USER_ACCOUNT.getValue() == gameMailAddPO.getMailSendingType() || SendingTypeEnums.CUSTOM_AND_USER_ACCOUNT.getValue() == gameMailAddPO.getMailSendingType()) {
            throw new ServiceException("\u6682\u4e0d\u652f\u6301\u5185\u90e8\u73a9\u5bb6\u8d26\u53f7,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406!");
        }
        this.mailInternalPlayerIdJudge(userPlayerIdList);
        gameMailAddPO.setUserPlayerId(primaryUserPlayerId);
    }

    public void mailInternalPlayerIdJudge(List<String> userPlayerIdList) {
        List internalPlayerIdList = this.internalPlayerService.queryInternalPlayerIdList();
        ArrayList<String> errorPlayerIdList = new ArrayList<String>();
        for (int i = 0; i < userPlayerIdList.size(); ++i) {
            if (internalPlayerIdList.contains(userPlayerIdList.get(i))) continue;
            errorPlayerIdList.add(userPlayerIdList.get(i));
        }
        if (errorPlayerIdList != null && errorPlayerIdList.size() > 0) {
            throw new ServiceException("\u89d2\u8272ID: " + errorPlayerIdList + " \u4e0d\u4e3a\u5185\u90e8\u73a9\u5bb6,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406!");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateGameMail(GameMailUpdatePO gameMailUpdatePO) {
        GameMailVO gameMailDetails = this.gameMailMapper.selectGameMailById(gameMailUpdatePO.getId());
        if (!MailStateEnums.TO_BE_SENT.getValue().equals(gameMailDetails.getMailState())) {
            throw new ServiceException("\u53ea\u80fd\u4fee\u6539\u72b6\u6001\u4e3a \u5f85\u53d1\u9001 \u7684\u6570\u636e");
        }
        Date newDate = new Date();
        GameMail gameMail = new GameMail();
        gameMail.setId(gameMailUpdatePO.getId());
        gameMail.setUpdateBy(SecurityUtils.getUsername());
        gameMail.setUpdateTime(newDate);
        if (gameMailUpdatePO.getMailTimingSendTime() == null || newDate.compareTo(gameMailUpdatePO.getMailTimingSendTime()) == 0 || newDate.compareTo(gameMailUpdatePO.getMailTimingSendTime()) == 1) {
            String failContent = "\u624b\u52a8\u53d6\u6d88\u5b9a\u65f6\u53d1\u9001\u90ae\u4ef6,\u64cd\u4f5c\u5458: " + SecurityUtils.getUsername();
            gameMail.setMailTimingSendTime(null);
            gameMail.setMailState(MailStateEnums.FAIL.getValue());
            gameMail.setMailFailContent(failContent);
            GameMailSendLog gameMailSendLog = new GameMailSendLog();
            gameMailSendLog.setMailId(gameMailUpdatePO.getId());
            gameMailSendLog.setEnteringGinseng(JSONObject.toJSONString((Object)gameMailUpdatePO, (JSONWriter.Feature[])new JSONWriter.Feature[0]));
            gameMailSendLog.setExoticGinseng(failContent);
            gameMailSendLog.setMailState(MailStateEnums.FAIL.getValue());
            gameMailSendLog.setSendType(mailSendTypeEnums.TIMING_SEND.getValue());
            this.gameMailSendLogServiceImpl.insertGameMailSendLog(gameMailSendLog);
        } else {
            gameMail.setMailTimingSendTime(gameMailUpdatePO.getMailTimingSendTime());
        }
        return this.gameMailMapper.updateGameMail(gameMail);
    }

    public int examineUpdateMail(GameMail gameMail) {
        gameMail.setUpdateBy(SecurityUtils.getUsername());
        gameMail.setUpdateTime(new Date());
        return this.gameMailMapper.updateGameMail(gameMail);
    }

    public int insertBatchMiddle(List<GameMailAddPO> gameMailAddPOList) {
        return this.gameMailMapper.insertBatchMiddle(gameMailAddPOList);
    }

    public String timeDevelop(Integer days) {
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        Date nextDate = calendar.getTime();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeFormat = sdf.format(nextDate);
        return timeFormat;
    }

    public GameMail queryMailServerId(String mailServerId) {
        return this.gameMailMapper.queryMailServerId(mailServerId);
    }

    public String mailReceive(GameMailReceivePO gameMailReceivePO) {
        String gamePlayer = "";
        String userPlayerId = this.crossBarHandle(gameMailReceivePO.getUserPlayerId());
        gameMailReceivePO.setUserPlayerId(userPlayerId);
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        if (SendingTypeEnums.CUSTOM_AND_USER_PLAYER_ID.getValue() == gameMailReceivePO.getMailSendingType() || SendingTypeEnums.CUSTOM_AND_USER_ACCOUNT.getValue() == gameMailReceivePO.getMailSendingType()) {
            List<String> serverList = Arrays.asList(gameMailReceivePO.getUserPlayerId().split("\n"));
            String head = "";
            int appointIndex = 0;
            for (int i = 0; i < serverList.size(); ++i) {
                appointIndex = serverList.get(i).indexOf(",[");
                head = head + serverList.get(i).substring(0, appointIndex) + "\n";
                List<String> dataList = Arrays.asList(serverList.get(i).split(","));
                jsonMap.put(dataList.get(0), serverList.get(i).substring(serverList.get(i).lastIndexOf(",[") + 1));
            }
            gameMailReceivePO.setUserPlayerId(head);
        }
        List batchPlayerQueryPOList = this.interfaceSendUtils.manyServerPlayerHandle(gameMailReceivePO.getUserPlayerId());
        for (BatchPlayerQueryPO batchPlayerQueryPO : batchPlayerQueryPOList) {
            String visitUrl = this.interfaceSendUtils.serverUrlAddress(batchPlayerQueryPO.getServerId(), "queryGroupMailPlayer");
            InterfaceSendPO interfaceSendPO = new InterfaceSendPO();
            interfaceSendPO.setVisitUrl(visitUrl);
            interfaceSendPO.setInterfaceDescribe("\u7fa4\u53d1\u90ae\u4ef6\u5df2\u9886\u53d6\u73a9\u5bb6id\u540d\u5355");
            HashMap<String, String> suppliedMap = new HashMap<String, String>();
            suppliedMap.put("serviceId", batchPlayerQueryPO.getServerId());
            suppliedMap.put("backStageMailId", gameMailReceivePO.getMailServerId());
            interfaceSendPO.setSuppliedMap(suppliedMap);
            HashMap<String, String> printMap = new HashMap<String, String>();
            printMap.put("serviceId", batchPlayerQueryPO.getServerId());
            printMap.put("backStageMailId", gameMailReceivePO.getMailServerId());
            interfaceSendPO.setPrintMap(printMap);
            InterfaceSendVO interfaceSendVO = this.interfaceSendUtils.interfaceSend(interfaceSendPO);
            gamePlayer = gamePlayer + "\u670d\u52a1\u5668id: " + batchPlayerQueryPO.getServerId() + "\u670d\u52a1\u7aef\u8fd4\u56de: " + interfaceSendVO.getData() + "\n";
        }
        return gamePlayer;
    }

    public String crossBarHandle(String userPlayerId) {
        String districtServer = "";
        List<String> serverList = Arrays.asList(userPlayerId.split("\n"));
        for (int i = 0; i < serverList.size(); ++i) {
            if (serverList.get(i).contains("-")) {
                String poleHead = serverList.get(i).substring(0, serverList.get(i).indexOf("-"));
                String poleTail = serverList.get(i).substring(poleHead.length() + 1, serverList.get(i).length());
                String commaHead = poleTail.substring(0, poleTail.indexOf(","));
                String commaTail = poleTail.substring(commaHead.length() + 1, poleTail.length());
                String serverIdString = "";
                for (int z = Integer.valueOf(poleHead).intValue(); z < Integer.valueOf(commaHead) + 1; ++z) {
                    serverIdString = serverIdString + z + "," + commaTail + "\n";
                }
                districtServer = districtServer + serverIdString;
                continue;
            }
            districtServer = districtServer + serverList.get(i) + "\n";
        }
        return districtServer;
    }
}

