/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.rearend.service.impl.operate.mail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ruoyi.common.core.utils.DateUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.rearend.domain.GameMailExamine;
import com.ruoyi.rearend.domain.GameMailReduceProp;
import com.ruoyi.rearend.domain.po.operate.mail.MailReducePropPO;
import com.ruoyi.rearend.domain.vo.operate.mail.MailReducePropVO;
import com.ruoyi.rearend.enums.operate.MailExamineStateEnums;
import com.ruoyi.rearend.enums.operate.MailWayEnums;
import com.ruoyi.rearend.mapper.operate.mail.GameMailExamineMapper;
import com.ruoyi.rearend.mapper.operate.mail.GameMailReducePropMapper;
import com.ruoyi.rearend.service.operate.mail.IGameMailReducePropService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GameMailReducePropServiceImpl
implements IGameMailReducePropService {
    @Autowired
    private GameMailReducePropMapper gameMailReducePropMapper;
    @Autowired
    private GameMailExamineMapper gameMailExamineMapper;

    public MailReducePropVO selectGameMailReducePropById(Long Id) {
        MailReducePropVO mailReducePropVO = new MailReducePropVO();
        GameMailReduceProp gameMailReduceProp = this.gameMailReducePropMapper.selectGameMailReducePropById(Id);
        BeanUtils.copyProperties((Object)gameMailReduceProp, (Object)mailReducePropVO);
        if (StringUtils.isEmpty((String)gameMailReduceProp.getMailPropJson())) {
            return mailReducePropVO;
        }
        JSONArray list = JSON.parseArray((String)gameMailReduceProp.getMailPropJson());
        ArrayList<Map> mailPropJsonList = new ArrayList<Map>();
        for (Object object : list) {
            Map ret = (Map)object;
            mailPropJsonList.add(ret);
        }
        mailReducePropVO.setMailPropJsonList(mailPropJsonList);
        return mailReducePropVO;
    }

    public List<GameMailReduceProp> selectGameMailReducePropList(GameMailReduceProp gameMailReduceProp) {
        return this.gameMailReducePropMapper.selectGameMailReducePropList(gameMailReduceProp);
    }

    @Transactional(rollbackFor={Exception.class})
    public int insertGameMailReduceProp(MailReducePropPO mailReducePropPO) {
        String operName = SecurityUtils.getUsername();
        GameMailReduceProp gameMailReduceProp = new GameMailReduceProp();
        BeanUtils.copyProperties((Object)mailReducePropPO, (Object)gameMailReduceProp);
        gameMailReduceProp.setMailPropJson(JSON.toJSONString((Object)mailReducePropPO.getMailPropJsonList()));
        gameMailReduceProp.setCreateTime(DateUtils.getNowDate());
        this.gameMailReducePropMapper.insertGameMailReduceProp(gameMailReduceProp);
        GameMailExamine gameMailExamine = new GameMailExamine();
        BeanUtils.copyProperties((Object)mailReducePropPO, (Object)gameMailExamine);
        gameMailExamine.setId(null);
        gameMailExamine.setMailId(gameMailReduceProp.getId());
        gameMailExamine.setExamineState(MailExamineStateEnums.AUDIT.getValue());
        gameMailExamine.setCreateBy(operName);
        gameMailExamine.setCreateTime(DateUtils.getNowDate());
        gameMailExamine.setMailRewardJson(mailReducePropPO.getMailReduceJson());
        gameMailExamine.setMailPropJson(JSON.toJSONString((Object)mailReducePropPO.getMailPropJsonList()));
        gameMailExamine.setMailWay(Integer.valueOf(MailWayEnums.BUTTON_UP.getValue()));
        this.gameMailExamineMapper.insertGameMailExamine(gameMailExamine);
        return 1;
    }

    public int updateGameMailReduceProp(GameMailReduceProp gameMailReduceProp) {
        gameMailReduceProp.setUpdateTime(DateUtils.getNowDate());
        return this.gameMailReducePropMapper.updateGameMailReduceProp(gameMailReduceProp);
    }

    public int deleteGameMailReducePropByIds(Long[] Ids) {
        return this.gameMailReducePropMapper.deleteGameMailReducePropByIds(Ids);
    }

    public int deleteGameMailReducePropById(Long Id) {
        return this.gameMailReducePropMapper.deleteGameMailReducePropById(Id);
    }
}

